/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.idl.Optics.xFeatureUnsupported;
import cerent.cms.idl.OpticsTopology.VirtualLink;
import cerent.cms.idl.OpticsTopology.sLinkEnd;
import cerent.cms.idl.OpticsTopology.sVirtualLink;
import cerent.cms.idl.OpticsTopology.xDuplicateLocalVlinkId;
import cerent.cms.idl.OpticsTopology.xDuplicateRemoteVlinkId;
import cerent.cms.idl.OpticsTopology.xEndPointInUse;
import cerent.cms.idl.OpticsTopology.xNoSuchVirtualLink;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CmsCommFailException;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.DuplicateLocalVlinkId;
import cerent.cms.model.DuplicateRemoteVlinkId;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmPortModel;
import cerent.cms.model.EndPointInUse;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.HdGeLineModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOpticsChannelModel;
import cerent.cms.model.IOpticsPortModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ISideModel;
import cerent.cms.model.IVirtualLinkModel;
import cerent.cms.model.IVirtualLinksManager;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NoSuchVirtualLink;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OpticalPortType;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.RanSvcModuleModel;
import cerent.cms.model.VirtualLinkModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.XPL2Layer2LineModel;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.cms.ui.intpatch.IntPatchHelper;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import org.omg.CORBA.UserException;

public class VirtualLinksManager
extends Model
implements IVirtualLinksManager,
Observer {
    private VirtualLinkCreator virtualLinkCreator;
    private VirtualLinkDeletor virtualLinkDeletor;
    private VirtualLinkRetriever virtualLinkRetriever;
    private VirtualLinkEditor virtualLinkEditor;
    private ArrayList cache = new ArrayList();
    private NodeModelDelegate nmd;
    private EventDispatcher dispatcher;
    private VlinkDebug dumpDebug;
    private static NodeSingletonFactory<VirtualLinksManager> sfactory = new NodeSingletonFactory<VirtualLinksManager>(VirtualLinksManager.class);

    public static VirtualLinksManager getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    public void init() {
        super.init0();
        this.dispatcher = this.nmd.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectVirtualLinkList, this.getIndex(), (Observer)this);
        }
    }

    @Override
    public void dispose() {
        this.clearCache();
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectVirtualLinkList, this.getIndex(), (Observer)this);
        }
        this.virtualLinkCreator.dispose();
        this.virtualLinkDeletor.dispose();
        this.virtualLinkRetriever.dispose();
        this.virtualLinkEditor.dispose();
        super.dispose();
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public void update(Observable observable, Object object) {
        this.db.fine("update from " + observable + " regarding " + object);
        if (observable instanceof CmsObservable) {
            int n = ((IObjectMessageInfo)object).getUpdateType();
            switch (n) {
                case 2: {
                    this.db.fine("\tObjectAdded");
                    this.clearCache();
                    this.setChanged();
                    this.notifyObservers(ModelUpdateType.ADDED);
                    break;
                }
                case 0: {
                    this.db.fine("\tObjectDeleted");
                    this.cacheDelete((short)((IObjectMessageInfo)object).getIndex());
                }
                case 1: {
                    this.db.fine("\tObjectChanged");
                    this.clearCache();
                    this.setChanged();
                    this.notifyObservers(ModelUpdateType.CHANGED);
                    break;
                }
                default: {
                    this.db.warning("\tWARNING: Unknown eUpdateType (" + n + ")");
                }
            }
        }
    }

    public IVirtualLinkModel[] getVirtualLinks() {
        if (this.cache.isEmpty()) {
            this.db.fine("getVirtualLinks from node ...");
            this.updateCache();
        } else {
            this.db.fine("getVirtualLinks from cache ...");
        }
        return this.cache.toArray(new IVirtualLinkModel[0]);
    }

    public void deleteVirtualLink(short s) throws FeatureUnsupported, NoSuchVirtualLink {
        try {
            this.virtualLinkDeletor.set(new Short(s));
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureUnsupported((UserException)xFeatureUnsupported2);
        }
        catch (xNoSuchVirtualLink xNoSuchVirtualLink2) {
            throw new NoSuchVirtualLink((UserException)xNoSuchVirtualLink2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void createVirtualLink(IEntityModel iEntityModel, short s, IIpAddr iIpAddr, short s2, IIpAddr iIpAddr2) throws FeatureUnsupported, NoSuchInterface, EndPointInUse, DuplicateLocalVlinkId, DuplicateRemoteVlinkId, ProvisionError {
        try {
            sLinkEnd sLinkEnd2 = new sLinkEnd(IpAddrFactory.getIpAddr(iIpAddr), s);
            sLinkEnd sLinkEnd3 = new sLinkEnd(IpAddrFactory.getIpAddr(iIpAddr2), s2);
            this.virtualLinkCreator.set(new Object[]{new Integer(iEntityModel.getIndex()), sLinkEnd2, sLinkEnd3});
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureUnsupported((UserException)xFeatureUnsupported2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xEndPointInUse xEndPointInUse2) {
            throw new EndPointInUse((UserException)xEndPointInUse2);
        }
        catch (xDuplicateLocalVlinkId xDuplicateLocalVlinkId2) {
            throw new DuplicateLocalVlinkId((UserException)xDuplicateLocalVlinkId2);
        }
        catch (xDuplicateRemoteVlinkId xDuplicateRemoteVlinkId2) {
            throw new DuplicateRemoteVlinkId((UserException)xDuplicateRemoteVlinkId2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError((UserException)xProvisionError2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            throw new ProvisionError("Failure creating virtual link.");
        }
    }

    public void changeRemoteVlinkEnd(IIpAddr iIpAddr, short s, IIpAddr iIpAddr2, short s2) throws FeatureUnsupported, NoSuchVirtualLink, DuplicateRemoteVlinkId {
        try {
            sLinkEnd sLinkEnd2 = new sLinkEnd(IpAddrFactory.getIpAddr(iIpAddr), s);
            sLinkEnd sLinkEnd3 = new sLinkEnd(IpAddrFactory.getIpAddr(iIpAddr2), s2);
            this.virtualLinkEditor.set(new Object[]{sLinkEnd2, sLinkEnd3});
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureUnsupported((UserException)xFeatureUnsupported2);
        }
        catch (xNoSuchVirtualLink xNoSuchVirtualLink2) {
            throw new NoSuchVirtualLink((UserException)xNoSuchVirtualLink2);
        }
        catch (xDuplicateRemoteVlinkId xDuplicateRemoteVlinkId2) {
            throw new DuplicateRemoteVlinkId((UserException)xDuplicateRemoteVlinkId2);
        }
        catch (UserException userException) {
            NodeModelDelegate.doUnknown(this.db, "VirtualLink edit failed", userException);
        }
    }

    public IEntityModel[] getVirtualLinkCandidatesForL2() {
        Set<IEntityModel> set = this.getValidEntitiesForL2();
        this.filterOutExistingVlinks(set);
        this.filterOutExistingIntPatch(set);
        return set.toArray(new IEntityModel[0]);
    }

    public IEntityModel[] getVirtualLinkCandidatesForOTS(boolean bl) {
        IntPatchHelper.PortFilter portFilter = IntPatchHelper.getFilter(!bl);
        portFilter.porttype.add(eEqType.OTS_PORT);
        portFilter.porttype.add(eEqType.AOTS_PORT);
        portFilter.notOfOptype.add(OpticalPortType.OUT_OSC);
        portFilter.notOfOptype.add(OpticalPortType.IN_OSC);
        portFilter.notOfOptype.add(OpticalPortType.OUT_DC);
        portFilter.notOfOptype.add(OpticalPortType.IN_DC);
        portFilter.notOfEqtype.add(eEqType.PASSIVE_PP_4_SMR);
        portFilter.notOfEqtype.add(eEqType.PASSIVE_PP_MESH_4);
        portFilter.notOfEqtype.add(eEqType.PASSIVE_PP_MESH_8);
        return IntPatchHelper.getOtsPorts(this.nmd, portFilter);
    }

    public IEntityModel[] getVirtualLinkCandidates() {
        Set<IEntityModel> set = this.getValidEntities();
        this.filterOutExistingVlinks(set);
        this.filterOutNonTransparentCli(set);
        this.filterOutNonOCH(set);
        this.filterOutPpm(set);
        this.addSidePortsCandidates(set);
        return set.toArray(new IEntityModel[0]);
    }

    void addSidePortsCandidates(Set<IEntityModel> set) {
        if (this.nmd.pci.supportsDWDM()) {
            ISideModel[] iSideModelArray = this.nmd.getSideModels().getSides();
            for (int i = 0; i < iSideModelArray.length; ++i) {
                if (iSideModelArray[i].isDcnEnabled()) continue;
                IEntityModel iEntityModel = this.indexToEntity(iSideModelArray[i].getLineIn());
                IEntityModel iEntityModel2 = this.indexToEntity(iSideModelArray[i].getLineOut());
                if (iEntityModel == null || iEntityModel2 == null) continue;
                set.add(iEntityModel);
                set.add(iEntityModel2);
            }
        }
    }

    protected void filterOutExistingVlinks(Set<IEntityModel> set) {
        IVirtualLinkModel[] iVirtualLinkModelArray = this.getVirtualLinks();
        if (iVirtualLinkModelArray != null && iVirtualLinkModelArray.length > 0) {
            for (int i = 0; i < iVirtualLinkModelArray.length; ++i) {
                IEntityModel iEntityModel = iVirtualLinkModelArray[i].getOrigEntity();
                IEntityModel iEntityModel2 = iVirtualLinkModelArray[i].getTermEntity();
                set.remove(iEntityModel);
                set.remove(iEntityModel2);
            }
        }
    }

    protected void filterOutExistingIntPatch(Set set) {
        IEntityModel[] iEntityModelArray = set.toArray(new IEntityModel[0]);
        for (int i = 0; i < iEntityModelArray.length; ++i) {
            InterfaceModel interfaceModel;
            PortModel portModel = (PortModel)iEntityModelArray[i];
            InterfaceModel interfaceModel2 = (InterfaceModel)portModel.getInterfaceModel();
            if (interfaceModel2 == null || (interfaceModel = interfaceModel2.getLowerLayerModels()[0]) == null) continue;
            try {
                IPortModel iPortModel = interfaceModel.getPortModel();
                if (!IntPatchHelper.isPortAlreadyUsed((IEntityModel)iPortModel)) continue;
                set.remove(iEntityModelArray[i]);
                continue;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
    }

    protected void filterOutNonTransparentCli(Set<IEntityModel> set) {
        Iterator<IEntityModel> iterator = set.iterator();
        while (iterator.hasNext()) {
            DwdmPortModel dwdmPortModel;
            DwdmModuleModel dwdmModuleModel;
            IEntityModel iEntityModel = iterator.next();
            if (iEntityModel.getEqType() != 122 || (dwdmModuleModel = (DwdmModuleModel)(dwdmPortModel = (DwdmPortModel)iEntityModel).getModuleModel()).isTransparent()) continue;
            iterator.remove();
        }
    }

    protected void filterOutNonOCH(Set<IEntityModel> set) {
        Iterator<IEntityModel> iterator = set.iterator();
        while (iterator.hasNext()) {
            IEntityModel iEntityModel = iterator.next();
            if (iEntityModel.getEqType() == 28) {
                int n = iEntityModel.getModuleModel().getEqType();
                if (n != 127 && n != 128) continue;
                iterator.remove();
                continue;
            }
            if (iEntityModel instanceof IOpticsPortModel) {
                IOpticsPortModel iOpticsPortModel = (IOpticsPortModel)iEntityModel;
                if (iOpticsPortModel.isChannelPort() || iOpticsPortModel.isOchncAddPort() || iOpticsPortModel.isOchncDropPort()) continue;
                iterator.remove();
                continue;
            }
            if (!(iEntityModel instanceof OpticsPortModel)) continue;
            OpticsPortModel opticsPortModel = (OpticsPortModel)iEntityModel;
            try {
                if (!opticsPortModel.isChannelPort()) {
                    iterator.remove();
                    continue;
                }
                if (opticsPortModel.isOptPortTypePT()) {
                    iterator.remove();
                    continue;
                }
                if (!opticsPortModel.hasOpticsLineModel()) continue;
                IOpticsChannelModel iOpticsChannelModel = (IOpticsChannelModel)opticsPortModel.getInterfaceModel();
                int n = iOpticsChannelModel.getActualWaveLength();
                int n2 = iOpticsChannelModel.getExpectedWaveLength();
                if (n == 0 || n == n2) continue;
                if (this.db.on()) {
                    this.db.println("MEA found for port " + iEntityModel + ":\n" + n + " != " + n2);
                }
                iterator.remove();
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
    }

    protected void filterOutPpm(Set<IEntityModel> set) {
        Iterator<IEntityModel> iterator = set.iterator();
        while (iterator.hasNext()) {
            int n;
            IEntityModel iEntityModel = iterator.next();
            ModuleModel moduleModel = (ModuleModel)iEntityModel.getModuleModel();
            if (!(moduleModel instanceof DwdmModuleModel) || (n = iEntityModel.getEqType()) == 122 || n == 279 || n == 326 || n == 123) continue;
            if (this.db.on()) {
                this.db.println("Removed port " + iEntityModel + " from card " + moduleModel);
            }
            iterator.remove();
        }
    }

    private boolean isXPGEInL2Mode(ModuleModel moduleModel) {
        return (moduleModel.getEqType() == 271 || moduleModel.getEqType() == 272) && ((XPL2ModuleModel)moduleModel).isInL2Mode();
    }

    protected Set<IEntityModel> getValidEntities() {
        HashSet<IEntityModel> hashSet = new HashSet<IEntityModel>();
        EntityTableModel entityTableModel = this.nmd.getEntityTableModel();
        if (entityTableModel == null) {
            return hashSet;
        }
        List list = entityTableModel.getModuleEntities();
        for (EntityModel entityModel : list) {
            Model model;
            int n;
            ModuleModel moduleModel;
            if (!(entityModel instanceof ModuleModel) || (moduleModel = (ModuleModel)entityModel).isDeleted() || moduleModel instanceof RanSvcModuleModel) continue;
            PortModel[] portModelArray = null;
            if (moduleModel.getSlot() <= moduleModel.getChassis().getMaxPhysicalSlots()) {
                portModelArray = moduleModel.getPortModels();
            }
            if (moduleModel.getEqType() == 62) {
                for (n = 0; n < portModelArray.length; ++n) {
                    model = (HdGeLineModel)portModelArray[n].getInterfaceModel();
                    if (!((HdGeLineModel)model).isTransponder()) continue;
                    hashSet.add(portModelArray[n]);
                }
                continue;
            }
            if (portModelArray == null) continue;
            for (n = 0; n < portModelArray.length; ++n) {
                model = portModelArray[n];
                if (!(model instanceof OpticsPortModel) && ((EntityModel)model).getEqType() != 122 && ((EntityModel)model).getEqType() != 279 && ((EntityModel)model).getEqType() != 326 && ((EntityModel)model).getEqType() != 123 && ((EntityModel)model).getEqType() != 28 && ((EntityModel)model).getEqType() != 29 && ((EntityModel)model).getEqType() != 30 && ((EntityModel)model).getEqType() != 61) continue;
                hashSet.add((IEntityModel)model);
            }
        }
        return hashSet;
    }

    private Set<IEntityModel> getValidEntitiesForL2() {
        HashSet<IEntityModel> hashSet = new HashSet<IEntityModel>();
        EntityTableModel entityTableModel = this.nmd.getEntityTableModel();
        if (entityTableModel == null) {
            return hashSet;
        }
        List list = entityTableModel.getModuleEntities();
        for (EntityModel entityModel : list) {
            ModuleModel moduleModel;
            if (!(entityModel instanceof ModuleModel) || (moduleModel = (ModuleModel)entityModel).isDeleted()) continue;
            PortModel[] portModelArray = moduleModel.getPortModels();
            if (!this.isXPGEInL2Mode(moduleModel)) continue;
            for (int i = 0; i < portModelArray.length; ++i) {
                boolean bl;
                PortModel portModel;
                block6: {
                    portModel = portModelArray[i];
                    bl = false;
                    IInterfaceModel iInterfaceModel = portModel.getInterfaceModel();
                    if (iInterfaceModel instanceof XPL2LineModel) {
                        XPL2Layer2LineModel xPL2Layer2LineModel = ((XPL2LineModel)iInterfaceModel).getLayer2LineModel();
                        try {
                            bl = xPL2Layer2LineModel != null && xPL2Layer2LineModel.isNNI();
                        }
                        catch (Exception exception) {
                            if (!this.db.on()) break block6;
                            SDebug.printStackTrace((Throwable)exception);
                        }
                    }
                }
                if (!bl) continue;
                hashSet.add(portModel);
            }
        }
        return hashSet;
    }

    private IEntityModel indexToEntity(int n) {
        IEntityModel iEntityModel;
        block2: {
            iEntityModel = null;
            try {
                iEntityModel = this.nmd.getEntityTableModel().getEntityModelByIndex(n);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                this.db.fine("No entity model for " + Integer.toHexString(n));
                if (!this.db.on()) break block2;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return iEntityModel;
    }

    private void clearCache() {
        this.cache.clear();
    }

    private void cacheAdd(IVirtualLinkModel iVirtualLinkModel) {
        this.dispatcher.addObserver(ObjectType.ObjectVirtualLink, (int)iVirtualLinkModel.getOrigVLID(), (Observer)this);
        this.cache.add(iVirtualLinkModel);
    }

    private void cacheDelete(short s) {
        Iterator iterator = this.cache.iterator();
        while (iterator.hasNext()) {
            IVirtualLinkModel iVirtualLinkModel = (IVirtualLinkModel)iterator.next();
            if (iVirtualLinkModel.getOrigVLID() != s) continue;
            iterator.remove();
            this.dispatcher.deleteObserver(ObjectType.ObjectVirtualLink, (int)iVirtualLinkModel.getOrigVLID(), (Observer)this);
            break;
        }
    }

    private void updateCache() {
        try {
            sVirtualLink[] sVirtualLinkArray = (sVirtualLink[])this.virtualLinkRetriever.get();
            if (sVirtualLinkArray != null) {
                for (int i = 0; i < sVirtualLinkArray.length; ++i) {
                    VirtualLinkModel virtualLinkModel = new VirtualLinkModel(sVirtualLinkArray[i].localLinkEnd.vlinkId, IpAddrFactory.getIIpAddr(sVirtualLinkArray[i].localLinkEnd.ipAdd), this.indexToEntity(sVirtualLinkArray[i].localIndex), sVirtualLinkArray[i].remoteLinkEnd.vlinkId, IpAddrFactory.getIIpAddr(sVirtualLinkArray[i].remoteLinkEnd.ipAdd), null);
                    this.cacheAdd(virtualLinkModel);
                }
            }
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            SDebug.printStackTrace((Throwable)((Object)xFeatureUnsupported2));
        }
        catch (CmsCommFailException cmsCommFailException) {
            SDebug.printStackTrace((Throwable)((Object)cmsCommFailException));
        }
        catch (CmsObjectNotExistException cmsObjectNotExistException) {
            SDebug.printStackTrace((Throwable)((Object)cmsObjectNotExistException));
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    private VirtualLinksManager(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(VirtualLinksManager.class));
        this.index = 1;
        this.nmd = nodeModelDelegate;
        this.dumpDebug = new VlinkDebug(this.nmd.db, "VirtualLinks");
        this.virtualLinkCreator = new VirtualLinkCreator("virtualLinkCreator", this.nmd);
        this.virtualLinkDeletor = new VirtualLinkDeletor("virtualLinkDeletor", this.nmd);
        this.virtualLinkRetriever = new VirtualLinkRetriever("virtualLinkRetriever", this.nmd);
        this.virtualLinkEditor = new VirtualLinkEditor("virtualLinkEditor", this.nmd);
    }

    public String toString() {
        return "VirtualLinksManager";
    }

    private VirtualLink getVirtualLinkRef() {
        return this.nmd.getIorRepository().getVirtualLinkRef();
    }

    @Override
    public INodeModel getNodeModel() {
        return this.nmd;
    }

    private class VirtualLinkCreator
    extends NonCachedValue {
        public VirtualLinkCreator(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            int n = (Integer)objectArray[0];
            VirtualLinksManager.this.getVirtualLinkRef().add(n, (sLinkEnd)objectArray[1], (sLinkEnd)objectArray[2]);
        }

        public Object outer() {
            return VirtualLinksManager.this;
        }
    }

    private class VirtualLinkDeletor
    extends NonCachedValue {
        public VirtualLinkDeletor(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            Short s = (Short)object;
            VirtualLinksManager.this.getVirtualLinkRef().removeByVlinkId(s);
        }

        public Object outer() {
            return VirtualLinksManager.this;
        }
    }

    private class VirtualLinkEditor
    extends NonCachedValue {
        public VirtualLinkEditor(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xDuplicateRemoteVlinkId, xNoSuchVirtualLink, xFeatureUnsupported {
            Object[] objectArray = (Object[])object;
            VirtualLinksManager.this.getVirtualLinkRef().changeRemoteVlinkEnd((sLinkEnd)objectArray[0], (sLinkEnd)objectArray[1]);
        }
    }

    private class VirtualLinkRetriever
    extends NonCachedValue {
        public VirtualLinkRetriever(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            sVirtualLink[] sVirtualLinkArray = VirtualLinksManager.this.getVirtualLinkRef().getAllVirtualLinks();
            return sVirtualLinkArray;
        }

        public Object outer() {
            return VirtualLinksManager.this;
        }
    }

    protected class VlinkDebug
    extends SDebug {
        public VlinkDebug(SDebug sDebug, String string) {
            super((KDebug)sDebug, string);
        }

        public final void dumpLinks() {
            this.println("Known Links [" + VirtualLinksManager.this.toString() + "]:");
            try {
                IVirtualLinkModel[] iVirtualLinkModelArray = VirtualLinksManager.this.getVirtualLinks();
                for (int i = 0; i < iVirtualLinkModelArray.length; ++i) {
                    this.println("\t" + iVirtualLinkModelArray[i]);
                }
            }
            catch (CmsCommFailException cmsCommFailException) {
                this.println("\tEncountered " + cmsCommFailException.getMessage());
            }
        }
    }
}

