/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.xNotSupportedOnEquipment;
import cerent.cms.idl.EtherL2Media.ChannelGroup;
import cerent.cms.idl.EtherL2Media.sBasicL2Info;
import cerent.cms.idl.EtherL2Media.sChannelGroupAttributes;
import cerent.cms.idl.EtherL2Media.sChannelGroupInfo;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.Model;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.NotSupportedOnEquipment;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.SDebug;
import java.util.Observable;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;

public class XPL2ChannelGroupManager
extends Model {
    private int cardIndex;
    private eEqType cardEntType;
    private NodeModelDelegate nmd;
    private CreateChannelGroup createChGroup;
    private DeleteChannelGroup deleteChGroup;
    private ChannelGroupDefault chGroupDefault;

    public XPL2ChannelGroupManager(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2) {
        super(nodeModelDelegate.getChildDebug(XPL2ChannelGroupManager.class));
        this.cardIndex = n;
        this.cardEntType = eEqType2;
        this.nmd = nodeModelDelegate;
        this.createChGroup = new CreateChannelGroup(nodeModelDelegate, "XPL2ModudelModel.CreateChannelGroup");
        this.deleteChGroup = new DeleteChannelGroup(nodeModelDelegate, "XPL2ModudelModel.DeleteChannelGroup");
        this.chGroupDefault = new ChannelGroupDefault(nodeModelDelegate, "XPL2ModudelModel.ChannelGroupDefault");
    }

    public sChannelGroupInfo getChannelGroupDefault(int n) throws NotSupportedOnEquipment {
        try {
            return (sChannelGroupInfo)this.chGroupDefault.get(n);
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            throw new NotSupportedOnEquipment((UserException)xNotSupportedOnEquipment2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getChannelGroupDefault", userException);
        }
    }

    public void createChannelGroup(char c, sChannelGroupAttributes sChannelGroupAttributes2, sBasicL2Info sBasicL2Info2, int[] nArray) throws WrongInterfaceType, NoSuchInterface, EMCProvisionError {
        Object[] objectArray = new Object[]{new Character(c), sChannelGroupAttributes2.info, sBasicL2Info2, sChannelGroupAttributes2.base.alias, nArray};
        try {
            this.createChGroup.set(objectArray);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.nmd.getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("createChannelGroup", userException);
        }
    }

    public void deleteChannelGroup(int n) throws WrongInterfaceType, NoSuchInterface, EMCProvisionError {
        try {
            this.deleteChGroup.set(new Integer(n));
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.nmd.getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("deleteChannelGroup", userException);
        }
    }

    protected UNKNOWN doUnknown(String string, UserException userException) {
        this.db.warning("Caught " + (Object)((Object)userException) + " in " + string);
        if (this.db.on()) {
            SDebug.printStackTrace((Throwable)userException);
        }
        return new UNKNOWN("Caught " + (Object)((Object)userException) + " in " + string);
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public void dispose() {
        if (this.db.on()) {
            this.db.println("dispose");
        }
        super.dispose();
    }

    protected ChannelGroup getChannelGroupL2Ref() {
        return this.nmd.getIorRepository().getChannelGroupL2Ref();
    }

    @Override
    public void update(Observable observable, Object object) {
    }

    private class ChannelGroupDefault
    extends NonCachedValue {
        public ChannelGroupDefault(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws xNotSupportedOnEquipment {
            Integer n = (Integer)object;
            eEqType.from_int(n);
            return XPL2ChannelGroupManager.this.getChannelGroupL2Ref().getDefaultChannelGroupInfo(XPL2ChannelGroupManager.this.cardEntType, eEqType.from_int(n));
        }
    }

    private class CreateChannelGroup
    extends NonCachedValue {
        public CreateChannelGroup(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xWrongInterfaceType, xProvisionError, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            Character c = (Character)objectArray[0];
            sChannelGroupInfo sChannelGroupInfo2 = (sChannelGroupInfo)objectArray[1];
            sBasicL2Info sBasicL2Info2 = (sBasicL2Info)objectArray[2];
            String string = (String)objectArray[3];
            int[] nArray = (int[])objectArray[4];
            Integer n = XPL2ChannelGroupManager.this.cardIndex;
            XPL2ChannelGroupManager.this.getChannelGroupL2Ref().createChannelGroupAndAttachIfs(n, c.charValue(), sChannelGroupInfo2, sBasicL2Info2, string, nArray);
        }
    }

    private class DeleteChannelGroup
    extends NonCachedValue {
        public DeleteChannelGroup(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xWrongInterfaceType, xProvisionError, xNoSuchInterface {
            XPL2ChannelGroupManager.this.getChannelGroupL2Ref().deleteChannelGroup((Integer)object);
        }
    }
}

