/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.xInUse;
import cerent.cms.idl.EtherL2Media.ChannelGroup;
import cerent.cms.idl.EtherL2Media.eHashingMode;
import cerent.cms.idl.EtherL2Media.eLacpMode;
import cerent.cms.idl.EtherL2Media.sChannelGroupAttributes;
import cerent.cms.idl.EtherL2Media.sChannelGroupInfo;
import cerent.cms.idl.EtherMedia.eEtherSpeed;
import cerent.cms.idl.EtherMedia.sIngressQOSInfo;
import cerent.cms.idl.EtherMedia.sL1Info;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.IXPL2ChannelGroupModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.NotSupportedOnEquipment;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.XPL2Layer2LineModel;
import cerent.util.SDebug;
import org.omg.CORBA.UserException;

public class XPL2ChannelGroupModel
extends XPL2Layer2LineModel
implements IXPL2ChannelGroupModel {
    private AttachPort attachPort;
    private DetachPort detachPort;
    private ChannelGroupId chGrpId;
    private ChannelGroupInfo chGrpInfo;
    private ChannelGroupPortList chGrpPortList;
    private sChannelGroupAttributes channelGroup;
    private static final SDebug db = new SDebug("XPL2ChannelGroupModel");

    public XPL2ChannelGroupModel(NodeModelDelegate nodeModelDelegate, int n) {
        super(nodeModelDelegate, n);
        this.index = n;
        this.attachPort = new AttachPort(nodeModelDelegate, "ChannelGroupL2Model.AttachPort");
        this.detachPort = new DetachPort(nodeModelDelegate, "ChannelGroupL2Model.DetachPort");
        this.chGrpId = new ChannelGroupId(nodeModelDelegate, "ChannelGroupModel.ChannelGroupId");
        this.chGrpInfo = new ChannelGroupInfo(nodeModelDelegate, "ChannelGroupModel.ChannelGroupInfo");
        this.chGrpPortList = new ChannelGroupPortList(nodeModelDelegate, "ChannelGroupModel.ChannelGroupPortList");
    }

    protected ChannelGroup getChannelGroupL2Ref() {
        return this.getNodeModelDelegate().getIorRepository().getChannelGroupL2Ref();
    }

    public void attachPort(int n) throws NoSuchInterface, WrongInterfaceType, EMCProvisionError, ResourceInUse {
        try {
            this.attachPort.set(new Integer(n));
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xInUse xInUse2) {
            throw new ResourceInUse((UserException)xInUse2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("modifyChannelGroup", userException);
        }
    }

    public void detachPort(int n) throws NoSuchInterface, WrongInterfaceType, EMCProvisionError {
        try {
            this.detachPort.set(new Integer(n));
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("modifyChannelGroup", userException);
        }
    }

    public void modifyChannelGroup(sChannelGroupInfo sChannelGroupInfo2) throws WrongInterfaceType, NoSuchInterface, EMCProvisionError {
        Object[] objectArray = new Object[]{new Integer(this.getIndex()), sChannelGroupInfo2};
        try {
            this.chGrpInfo.set(objectArray);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.node.getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("modifyChannelGroup", userException);
        }
    }

    public sChannelGroupInfo getChGrpInfo() {
        sChannelGroupInfo sChannelGroupInfo2 = null;
        try {
            sChannelGroupInfo2 = (sChannelGroupInfo)this.chGrpInfo.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getChGrpInfo", userException);
        }
        return sChannelGroupInfo2;
    }

    public int getChGroupID() {
        char c = '\u0000';
        try {
            c = ((Character)this.chGrpId.get()).charValue();
        }
        catch (UserException userException) {
            throw this.doUnknown("getChGroupID", userException);
        }
        return c;
    }

    public int[] getPortList() {
        int[] nArray = new int[]{};
        try {
            nArray = (int[])this.chGrpPortList.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getPortList", userException);
        }
        return nArray;
    }

    public int[] getL1PortList() {
        int[] nArray = this.getPortList();
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            try {
                InterfaceModel interfaceModel = this.getNodeModelDelegate().getIfModels().getInterfaceModel(nArray[i]);
                nArray2[i] = interfaceModel.getPort().getEntityIndex();
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
                continue;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return nArray2;
    }

    public sL1Info getEtherL1Info() {
        return this.getChGrpInfo().l1Info;
    }

    @Override
    public int getCIR() throws NoSuchInterface, WrongInterfaceType, NotSupportedOnEquipment {
        return this.getEtherL1Info().ingressQos.committedInfoRate;
    }

    public void setAttributes(sChannelGroupAttributes sChannelGroupAttributes2, long l) {
        super.setAttributes(sChannelGroupAttributes2.base, l);
        this.chGrpId.setValueExternally(Character.valueOf(sChannelGroupAttributes2.cgId));
        this.chGrpInfo.setValueExternally(sChannelGroupAttributes2.info);
        this.chGrpPortList.setValueExternally(sChannelGroupAttributes2.portList);
        if (db.on()) {
            db.println("ChGrpModel " + Integer.toHexString(this.getIndex()) + " setAttributes()");
        }
    }

    public eLacpMode getLacpMode() {
        return this.getChGrpInfo().lacpMode;
    }

    public eHashingMode getLacpHashing() {
        return this.getChGrpInfo().algoritm;
    }

    public eEtherSpeed getExpSpeed() {
        return this.getChGrpInfo().expectedSpeed;
    }

    public boolean equals(Object object) {
        if (object instanceof XPL2ChannelGroupModel) {
            XPL2ChannelGroupModel xPL2ChannelGroupModel = (XPL2ChannelGroupModel)object;
            return this.getIndex() == xPL2ChannelGroupModel.getIndex();
        }
        return false;
    }

    public int hashCode() {
        return 37 * this.getIndex();
    }

    @Override
    public void dispose() {
        if (db.on()) {
            db.println("ChGrpModel dispose()");
        }
        this.chGrpId.dispose();
        this.chGrpInfo.dispose();
        this.chGrpPortList.dispose();
        super.dispose();
    }

    @Override
    public void destroy() {
        if (db.on()) {
            db.println("ChGrpModel destroy()");
        }
        super.destroy();
    }

    @Override
    public boolean isChannelGroup() {
        return true;
    }

    @Override
    protected void updateLocal(long l) {
        if (db.on()) {
            db.println("ChGrpModel " + Integer.toHexString(this.getIndex()) + " updateLocal()");
        }
        this.chGrpId.update();
        this.chGrpInfo.update();
        this.chGrpPortList.update();
        super.updateLocal(l);
    }

    private class AttachPort
    extends NonCachedValue {
        public AttachPort(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xWrongInterfaceType, xProvisionError, xNoSuchInterface, xInUse {
            XPL2ChannelGroupModel.this.getChannelGroupL2Ref().attachInterface(XPL2ChannelGroupModel.this.getIndex(), (Integer)object);
        }
    }

    private class ChannelGroupId
    extends CachedValue {
        public ChannelGroupId(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() {
            return Character.valueOf(XPL2ChannelGroupModel.this.getChannelGroupL2Ref().getChannelGroupId(XPL2ChannelGroupModel.this.getIndex()));
        }
    }

    private class ChannelGroupInfo
    extends CachedValue {
        public ChannelGroupInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xWrongInterfaceType, xProvisionError, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            Integer n = (Integer)objectArray[0];
            sChannelGroupInfo sChannelGroupInfo2 = (sChannelGroupInfo)objectArray[1];
            XPL2ChannelGroupModel.this.getChannelGroupL2Ref().modifyChannelGroup(n, sChannelGroupInfo2);
        }

        @Override
        protected Object getValue() {
            return XPL2ChannelGroupModel.this.getChannelGroupL2Ref().getChannelGroupInfo(XPL2ChannelGroupModel.this.getIndex());
        }

        @Override
        protected Object cloneValue() {
            sChannelGroupInfo sChannelGroupInfo2 = (sChannelGroupInfo)this.value;
            sChannelGroupInfo sChannelGroupInfo3 = new sChannelGroupInfo(sChannelGroupInfo2.lacpMode, sChannelGroupInfo2.algoritm, new sL1Info(sChannelGroupInfo2.l1Info.duplex, sChannelGroupInfo2.l1Info.speed, sChannelGroupInfo2.l1Info.flowControl, new sIngressQOSInfo(sChannelGroupInfo2.l1Info.ingressQos.committedInfoRate, sChannelGroupInfo2.l1Info.ingressQos.committedBurstSize, sChannelGroupInfo2.l1Info.ingressQos.excOrPeakBurstSize, sChannelGroupInfo2.l1Info.ingressQos.peakInfoRate, sChannelGroupInfo2.l1Info.ingressQos.couplingFlag, sChannelGroupInfo2.l1Info.ingressQos.colorMode), sChannelGroupInfo2.l1Info.mtu, sChannelGroupInfo2.l1Info.mappingMode, sChannelGroupInfo2.l1Info.etherMode), sChannelGroupInfo2.expectedSpeed);
            return sChannelGroupInfo3;
        }
    }

    private class ChannelGroupPortList
    extends CachedValue {
        public ChannelGroupPortList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() {
            return XPL2ChannelGroupModel.this.getChannelGroupL2Ref().getPortList(XPL2ChannelGroupModel.this.getIndex());
        }
    }

    private class DetachPort
    extends NonCachedValue {
        public DetachPort(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xWrongInterfaceType, xProvisionError, xNoSuchInterface {
            XPL2ChannelGroupModel.this.getChannelGroupL2Ref().detachInterface(XPL2ChannelGroupModel.this.getIndex(), (Integer)object);
        }
    }
}

