/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.IModel;
import cerent.cms.ui.AbstractLeavePageException;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractTabbedView
extends TabbedView
implements ITabName {
    private Pane currentPane = null;
    private static final SDebug db = new SDebug("AbstractTabbedView");

    public AbstractTabbedView(IModel iModel) {
        this.uiModel = iModel;
        this.initialize();
    }

    public void addTab(String string, Component component) {
        if (component != null) {
            if (component instanceof Pane) {
                super.addTab(string, component);
            } else {
                SDebug.printStackTrace((Throwable)new Exception("An error occurred while attempting to add a non-Pane component to a TabbedView."));
            }
        }
    }

    public void removeTab(String string) {
        int n = this.indexOfTab(string);
        if (n >= 0 && n < this.getTabCount()) {
            this.remove(n);
        } else {
            db.println("removeTab(" + string + "): no such tab!");
        }
    }

    public IModel getUiModel() {
        return this.uiModel;
    }

    public Dimension getMinimumSize() {
        return new Dimension(500, 200);
    }

    public Pane getCurrentPane() {
        return this.currentPane;
    }

    public void initialize() {
        try {
            this.currentPane = (Pane)this.getSelectedComponent();
        }
        catch (Exception exception) {
            this.currentPane = null;
        }
        this.addChangeListener((ChangeListener)((Object)this));
    }

    public void stateChanged(ChangeEvent changeEvent) {
        block17: {
            if (this.getSelectedComponent() instanceof Pane) {
                Pane pane = (Pane)this.getSelectedComponent();
                try {
                    boolean bl = this.showing;
                    if (this.currentPane != null) {
                        if (db.on()) {
                            db.println("setShowing(false): " + this.currentPane);
                        }
                        this.setShowing(false);
                    }
                    this.currentPane = pane;
                    if (this.currentPane != null) {
                        try {
                            if (bl) {
                                if (db.on()) {
                                    db.println("setShowing(true): " + this.currentPane);
                                }
                                this.setShowing(true);
                            } else if (db.on()) {
                                db.println("wasShowing==false: " + this.currentPane);
                            }
                            break block17;
                        }
                        catch (Exception exception) {
                            SDebug.printStackTrace((Throwable)exception);
                            ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_FAIL_REFRESH);
                        }
                        break block17;
                    }
                    if (db.on()) {
                        db.println("new pane is null: " + (Object)((Object)this));
                    }
                }
                catch (AbstractLeavePageException abstractLeavePageException) {
                    if (this.currentPane != null) {
                        this.removeChangeListener((ChangeListener)((Object)this));
                        this.setSelectedComponent((Component)this.currentPane);
                        this.addChangeListener((ChangeListener)((Object)this));
                    }
                }
                catch (Exception exception) {
                    db.finest("Exception in stateChanged(), evt=" + changeEvent + " " + exception);
                }
            } else if (db.on()) {
                db.println("not a Pane: " + this.getSelectedComponent());
            }
        }
    }

    public void setShowing(boolean bl) throws Exception, AbstractLeavePageException {
        if (this.currentPane != null && bl != this.showing) {
            try {
                this.showing = bl;
                this.currentPane.setShowing(bl);
            }
            catch (AbstractLeavePageException abstractLeavePageException) {
                this.showing = true;
                throw abstractLeavePageException;
            }
        }
    }

    public void showAndCatchException() {
        try {
            this.setShowing(true);
        }
        catch (AbstractLeavePageException abstractLeavePageException) {
            db.finest("AbstractLeavePageException in showAndCatchException(): " + (Object)((Object)abstractLeavePageException));
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_FAIL_REFRESH);
        }
    }

    public void destroy() {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof Pane)) continue;
            ((Pane)componentArray[i]).destroy();
        }
        this.removeChangeListener((ChangeListener)((Object)this));
        this.uiModel = null;
        this.currentPane = null;
        this.removeAll();
    }

    public void insertTab(String string, Icon icon, Component component, String string2, int n) {
        int n2 = this.getSelectedIndex();
        super.insertTab(string, icon, component, string2, n);
        if (n == n2 && this.getSelectedComponent() instanceof Pane) {
            this.currentPane = (Pane)this.getSelectedComponent();
        }
    }

    public boolean changeTab(int n) throws AbstractLeavePageException {
        String string;
        switch (n) {
            case 0: {
                return true;
            }
            case 1: {
                string = "Alarms";
                break;
            }
            case 2: {
                string = "History";
                break;
            }
            case 3: {
                string = "Circuits";
                break;
            }
            case 5: {
                string = "Provisioning";
                break;
            }
            case 6: {
                string = "Inventory";
                break;
            }
            case 7: {
                string = "Maintenance";
                break;
            }
            case 8: {
                string = "Performance";
                break;
            }
            default: {
                return false;
            }
        }
        int n2 = this.indexOfTab(string);
        if (n2 == -1) {
            return false;
        }
        if (this.getSelectedIndex() != n2) {
            this.setSelectedIndex(n2);
        }
        return true;
    }
}

