/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.MSIsc100T;

import cerent.cms.model.ModuleModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.event.AlarmStatus;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.ui.ml2.MLPortGraphic;
import cerent.cms.ui.shelf.CardView;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MSIsc100TCardView
extends CardView {
    private static final SDebug db = new SDebug("MSIsc100TCardView");
    private PortModel[] etherPortModels = null;
    private PortModel[] posPortModels = null;
    private MLPortGraphic[] etherPorts = null;
    private MLPortGraphic[] posPorts = null;
    private boolean isMapper = false;

    public MSIsc100TCardView(ModuleModel moduleModel, PortModel[] portModelArray) {
        this(moduleModel, portModelArray, false);
    }

    public MSIsc100TCardView(ModuleModel moduleModel, PortModel[] portModelArray, boolean bl) {
        super(moduleModel);
        this.etherPortModels = portModelArray;
        this.isMapper = bl;
        this.addPorts();
    }

    @Override
    protected List getPorts() {
        return new ArrayList();
    }

    @Override
    protected void addPorts(boolean bl) {
    }

    protected void addPorts() {
        this.etherPorts = new MLPortGraphic[this.etherPortModels.length];
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        if (this.pci.positionPortsVertically()) {
            jPanel.setPreferredSize(new Dimension(0, 0));
        } else {
            jPanel.setPreferredSize(new Dimension(0, 20));
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 3, 2, 2);
        this.add((Component)new JLabel("      ETHER"), gridBagConstraints);
        this.addPortsToCard(this.etherPortModels, this.etherPorts, gridBagConstraints);
        if (this.pci.positionPortsVertically()) {
            ++gridBagConstraints.gridx;
            gridBagConstraints.gridy = 0;
            this.add((Component)jPanel, gridBagConstraints);
            ++gridBagConstraints.gridx;
        } else {
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            this.add((Component)jPanel, gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
        this.repaint();
    }

    private void addPortsToCard(PortModel[] portModelArray, MLPortGraphic[] mLPortGraphicArray, GridBagConstraints gridBagConstraints) {
        for (int i = 0; i < portModelArray.length; ++i) {
            PortModel portModel = portModelArray[i];
            mLPortGraphicArray[i] = new MLPortGraphic(this, portModel, portModel.getPort());
            if (this.pci.positionPortsVertically()) {
                gridBagConstraints.gridy = i + 1;
            } else {
                gridBagConstraints.gridx = i + 1;
            }
            switch (i) {
                case 0: {
                    this.add((Component)new JLabel("DCN1:"), gridBagConstraints);
                    break;
                }
                case 1: {
                    this.add((Component)new JLabel("DCN2:"), gridBagConstraints);
                    break;
                }
                case 2: {
                    this.add((Component)new JLabel("SSC1:"), gridBagConstraints);
                    break;
                }
                case 3: {
                    this.add((Component)new JLabel("SSC2:"), gridBagConstraints);
                    break;
                }
                case 4: {
                    this.add((Component)new JLabel("SSC3:"), gridBagConstraints);
                    break;
                }
                case 5: {
                    this.add((Component)new JLabel("SSC4:"), gridBagConstraints);
                    break;
                }
                case 6: {
                    this.add((Component)new JLabel("SSC5:"), gridBagConstraints);
                    break;
                }
                case 7: {
                    this.add((Component)new JLabel("SSC6:"), gridBagConstraints);
                    break;
                }
                case 8: {
                    this.add((Component)new JLabel("SSC7:"), gridBagConstraints);
                    break;
                }
                case 9: {
                    this.add((Component)new JLabel("NC:"), gridBagConstraints);
                    break;
                }
                case 10: {
                    this.add((Component)new JLabel("PRT:"), gridBagConstraints);
                    break;
                }
                default: {
                    this.add((Component)new JLabel(""), gridBagConstraints);
                }
            }
            gridBagConstraints.gridx = 2;
            this.add((Component)mLPortGraphicArray[i], gridBagConstraints);
            gridBagConstraints.gridx = 0;
        }
        this.updatePortAlarmColor(portModelArray, mLPortGraphicArray);
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof AlarmStatus) {
            AlarmStatus alarmStatus = (AlarmStatus)object;
            this.setAlarmColor(alarmStatus.getHighestSeverity());
            this.updatePortAlarmColor(this.etherPortModels, this.etherPorts);
            this.updatePortAlarmColor(this.posPortModels, this.posPorts);
        }
    }

    private void updatePortAlarmColor(PortModel[] portModelArray, MLPortGraphic[] mLPortGraphicArray) {
        if (portModelArray == null || mLPortGraphicArray == null) {
            return;
        }
        for (int i = 0; i < portModelArray.length; ++i) {
            PortModel portModel = portModelArray[i];
            int n = -1;
            IAlarmStatus iAlarmStatus = this.cardAlarmStore.getEntityAlarmStatus(portModel);
            if (iAlarmStatus != null) {
                mLPortGraphicArray[i].setAlarmState(iAlarmStatus.getHighestSeverity());
                continue;
            }
            if (!db.on()) continue;
            db.println("null portAlarmStatus for port " + portModel.getPort() + ", eqType " + portModel.getEqType() + ", port " + n);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
    }

    @Override
    public void dispose() {
        if (this.etherPorts != null) {
            for (int i = 0; i < this.etherPorts.length; ++i) {
                if (this.etherPorts[i] == null) continue;
                this.etherPorts[i].dispose();
            }
        }
        super.dispose();
    }
}

