/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.PortModel;
import cerent.cms.ui.EqTypeListCellRenderer;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.SDebug;
import javax.swing.table.AbstractTableModel;

public class MutablePortsTableModel
extends AbstractTableModel {
    private PortModel[] _models;
    private int _cardEqType;
    private int _numLines;
    private String[] _ports;
    private String[] _rates;
    private SDebug _db;
    private static final int PORT_INDEX = 0;
    private static final int RATE_INDEX = 1;
    final String[] columnNames = new String[]{"Port", "Rate"};
    private EqTypeListCellRenderer _eqt;

    public MutablePortsTableModel(PortModel[] portModelArray, int n, INodeModel iNodeModel, SDebug sDebug) {
        this._models = portModelArray;
        this._cardEqType = n;
        this._db = sDebug;
        this._eqt = new EqTypeListCellRenderer(iNodeModel);
        this.init();
    }

    protected void init() {
        this._numLines = this._models == null ? 0 : this._models.length;
        this._ports = new String[this._numLines];
        this._rates = new String[this._numLines];
    }

    public Class getColumnClass(int n) {
        return super.getColumnClass(n);
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this._numLines;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    private String getPort(int n) {
        if (this._ports[n] == null) {
            this._ports[n] = PortHelper.getPortNumString((IPortModel)this._models[n]);
        }
        return this._ports[n];
    }

    private String getRate(int n) {
        if (this._rates[n] == null) {
            this._rates[n] = this._eqt.getDataRateString(this._cardEqType, this._models[n].getEqType());
        }
        return this._rates[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        String string;
        block6: {
            string = null;
            try {
                switch (n2) {
                    case 0: {
                        string = this.getPort(n);
                        break;
                    }
                    case 1: {
                        string = this.getRate(n);
                        break;
                    }
                }
            }
            catch (Exception exception) {
                this._db.println("Error in getValueAt in MutablePortsTableModel");
                if (!this._db.on()) break block6;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return string;
    }

    public void refreshFromModel() {
        for (int i = 0; i < this._numLines; ++i) {
            this._ports[i] = null;
            this._rates[i] = null;
        }
        this.fireTableRowsUpdated(0, this._numLines - 1);
    }

    protected void refreshMyLines(PortModel[] portModelArray) {
        this._models = portModelArray;
        this.init();
        this.fireTableDataChanged();
    }
}

