/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.ResettablePmThresholdsTableModel;
import cerent.util.SDebug;

public class ResetPmThresholdsAction {
    protected ResettablePmThresholdsTableModel dataModel;
    protected NodeModelDelegate node;
    protected static SDebug db = new SDebug("ResetPmThresholdsAction");

    public ResetPmThresholdsAction(ResettablePmThresholdsTableModel resettablePmThresholdsTableModel, NodeModelDelegate nodeModelDelegate) {
        this.dataModel = resettablePmThresholdsTableModel;
        this.node = nodeModelDelegate;
    }

    public void performAction() {
        if (this.dataModel == null) {
            return;
        }
        Object object = null;
        int n = this.dataModel.getNumberOfLines();
        try {
            if (this.dataModel.resetToDefaultByLine()) {
                for (int i = 0; i < n; ++i) {
                    object = this.dataModel.getThresholdNeDefault(this.node.getNeDefaultsModel(), i);
                    if (db.on()) {
                        db.println("Obtained Default Thresholds values for line " + i);
                    }
                    this.dataModel.setThresholdValue(i, object);
                    this.dataModel.markRowDirty(i);
                }
            } else if (n > 0) {
                object = this.dataModel.getThresholdNeDefault(this.node.getNeDefaultsModel(), 0);
                if (db.on()) {
                    db.println("Obtained Default Thresholds values for all lines");
                }
                for (int i = 0; i < n; ++i) {
                    this.dataModel.setThresholdValue(i, object);
                    this.dataModel.markRowDirty(i);
                }
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }
}

