/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.Attribute;
import cerent.cms.ui.Wavelength;
import cerent.util.gui.UComboBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class WavelengthAttribute
implements ActionListener {
    private final DefaultComboBoxModel allBandsModel = new DefaultComboBoxModel<Attribute>(new Attribute[]{new Attribute("C Band", 0), new Attribute("L Band", 1)});
    private final DefaultComboBoxModel cBandModel = new DefaultComboBoxModel<Attribute>(new Attribute[]{new Attribute("C Band", 0)});
    private final DefaultComboBoxModel lBandModel = new DefaultComboBoxModel<Attribute>(new Attribute[]{new Attribute("L Band", 1)});
    private final DefaultComboBoxModel allOdditiesModel = new DefaultComboBoxModel<Attribute>(new Attribute[]{new Attribute("Odd", 0), new Attribute("Even", 1)});
    private final DefaultComboBoxModel oddChModel = new DefaultComboBoxModel<Attribute>(new Attribute[]{new Attribute("Odd", 0)});
    private final DefaultComboBoxModel evenChModel = new DefaultComboBoxModel<Attribute>(new Attribute[]{new Attribute("Even", 1)});
    private Attribute[] channelAttrs = null;
    private int nofchannels = 0;
    private JPanel p;
    private JLabel label;
    private UComboBox channelsCB;
    private UComboBox bandsCB;
    private UComboBox oddityCB;
    private JCheckBox colorless;

    public WavelengthAttribute() {
        this(false);
    }

    public WavelengthAttribute(boolean bl) {
        this.commonInit(bl);
        this.updateChannels();
    }

    public void setEnabled(boolean bl) {
        this.label.setEnabled(bl);
        this.channelsCB.setEnabled(bl);
        this.bandsCB.setEnabled(bl);
        this.oddityCB.setEnabled(bl);
        this.colorless.setEnabled(bl);
    }

    public JPanel getUI() {
        return this.p;
    }

    public boolean isColorless() {
        return this.colorless.isSelected();
    }

    public int getChannel() {
        Attribute attribute;
        if (!this.isColorless() && (attribute = (Attribute)this.channelsCB.getSelectedItem()) != null) {
            return attribute.getIntValue();
        }
        return -1;
    }

    public String getChannelString() {
        if (this.isColorless()) {
            return "Colorless";
        }
        return Wavelength.getWavelengthStringFromWavelength(this.getChannel());
    }

    public String toString() {
        return "OCHNC Wavelength: " + Wavelength.getWavelengthStringFromWavelength(this.getChannel());
    }

    private void commonInit(boolean bl) {
        this.p = new JPanel();
        this.p.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        this.label = new JLabel("OCHNC Wavelength: ");
        this.p.add((Component)this.label, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.channelsCB = new UComboBox((Object[])this.getAttributes(0, 0));
        this.p.add((Component)this.channelsCB, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        this.bandsCB = new UComboBox((ComboBoxModel)this.allBandsModel);
        this.p.add((Component)this.bandsCB, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.oddityCB = new UComboBox((ComboBoxModel)this.allOdditiesModel);
        this.p.add((Component)this.oddityCB, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        this.colorless = new JCheckBox("Colorless");
        this.p.add((Component)this.colorless, gridBagConstraints);
        this.allowColorless(bl);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 1.0;
        this.p.add((Component)new JPanel(), gridBagConstraints);
        this.bandsCB.addActionListener((ActionListener)this);
        this.oddityCB.addActionListener((ActionListener)this);
        this.colorless.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.bandsCB || actionEvent.getSource() == this.oddityCB) {
            this.updateChannels();
        } else if (actionEvent.getSource() == this.colorless) {
            this.channelsCB.setEnabled(!this.colorless.isSelected());
            this.bandsCB.setEnabled(!this.colorless.isSelected());
            this.oddityCB.setEnabled(!this.colorless.isSelected());
        }
    }

    public int getBand() {
        Attribute attribute = (Attribute)this.bandsCB.getSelectedItem();
        return attribute.getIntValue();
    }

    public int getOddity() {
        Attribute attribute = (Attribute)this.oddityCB.getSelectedItem();
        return attribute.getIntValue();
    }

    public void setBandAndOddity(int n, int n2, int n3) {
        DefaultComboBoxModel defaultComboBoxModel;
        ComboBoxModel comboBoxModel;
        Attribute attribute = (Attribute)this.bandsCB.getSelectedItem();
        Attribute attribute2 = (Attribute)this.oddityCB.getSelectedItem();
        if (n3 == 80) {
            n3 = 40;
            n2 = 2;
        }
        if ((comboBoxModel = this.bandsCB.getModel()) != (defaultComboBoxModel = this.getBandModel(n))) {
            this.bandsCB.setModel((ComboBoxModel)defaultComboBoxModel);
            if (defaultComboBoxModel.getIndexOf(attribute) != -1) {
                defaultComboBoxModel.setSelectedItem(attribute);
            }
            this.bandsCB.setEnabled(defaultComboBoxModel.getSize() > 1);
        }
        if ((comboBoxModel = this.oddityCB.getModel()) != (defaultComboBoxModel = this.getOddityModel(n2))) {
            this.oddityCB.setModel((ComboBoxModel)defaultComboBoxModel);
            if (defaultComboBoxModel.getIndexOf(attribute2) != -1) {
                defaultComboBoxModel.setSelectedItem(attribute2);
            }
            this.oddityCB.setEnabled(defaultComboBoxModel.getSize() > 1);
        }
        this.nofchannels = n3;
        this.updateChannels();
    }

    private DefaultComboBoxModel getBandModel(int n) {
        if (n == 0) {
            return this.cBandModel;
        }
        if (n == 1) {
            return this.lBandModel;
        }
        return this.allBandsModel;
    }

    private DefaultComboBoxModel getOddityModel(int n) {
        if (n == 0) {
            return this.oddChModel;
        }
        if (n == 1) {
            return this.evenChModel;
        }
        return this.allOdditiesModel;
    }

    protected Attribute[] getAttributes(int n, int n2) {
        if (this.nofchannels != 0) {
            return Wavelength.getWavelengthAttrs(n, n2, this.nofchannels, false);
        }
        return Wavelength.getWavelengthAttrs(n, n2, false);
    }

    private void updateChannels() {
        Attribute[] attributeArray = this.getAttributes(this.getBand(), this.getOddity());
        if (this.channelAttrs == null || !this.areEquals(this.channelAttrs, attributeArray)) {
            this.channelAttrs = attributeArray;
            Attribute attribute = (Attribute)this.channelsCB.getSelectedItem();
            DefaultComboBoxModel<Attribute> defaultComboBoxModel = new DefaultComboBoxModel<Attribute>(attributeArray);
            this.channelsCB.setModel(defaultComboBoxModel);
            if (defaultComboBoxModel.getIndexOf(attribute) != -1) {
                defaultComboBoxModel.setSelectedItem(attribute);
            }
        }
    }

    private boolean areEquals(Attribute[] attributeArray, Attribute[] attributeArray2) {
        boolean bl = true;
        if (attributeArray.length == attributeArray2.length) {
            for (int i = 0; bl && i < attributeArray.length; ++i) {
                Attribute attribute = attributeArray[i];
                Attribute attribute2 = attributeArray2[i];
                bl = attribute.equals(attribute2);
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public void allowColorless(boolean bl) {
        this.colorless.setVisible(bl);
        this.colorless.setSelected(false);
    }
}

