/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.util.gui.GridPanel;
import cerent.util.gui.PersistentFileChooserDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Stack;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

public class WzStatusPanel
extends JPanel
implements MouseListener,
ActionListener {
    public static final Font STATUS_FONT = new Font("Arial", 0, 12);
    public static final Font TITLE_FONT = new Font("Arial", 1, 12);
    public static final String ORIGINAL_COMPONENT = "Original Component";
    public static final String TITLE_COMPONENT = "Title Component";
    protected static String VIGNETTE = "/images/CTC_dialogVignette.gif";
    protected Stack componentStack = new Stack();
    protected GridBagLayout gridbag;
    protected GridBagConstraints gbc;
    protected Border useThisBorder = BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createLoweredBevelBorder());
    protected Color useThisBgColor = Color.white;
    protected static Color TITLE_COLOR = new Color(205, 205, 255);
    JPopupMenu popup;
    protected static final String CMD_SAVE_TEXT = "SAVETEXT";

    public WzStatusPanel(boolean bl) {
        this.setBackground(this.useThisBgColor);
        this.gridbag = new GridBagLayout();
        this.setLayout(this.gridbag);
        this.redoLayout();
        this.setupPopupMenu();
        if (bl) {
            this.addMouseListener(this);
        }
    }

    public WzStatusPanel() {
        this(true);
    }

    protected void setupPopupMenu() {
        this.popup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Save Status to Text File...");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand(CMD_SAVE_TEXT);
        this.popup.add(jMenuItem);
    }

    public static JComponent decapsulateComponent(JPanel jPanel) {
        Component[] componentArray = jPanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            JComponent jComponent = (JComponent)componentArray[i];
            String string = jComponent.getName();
            if (string == null || !string.equals(ORIGINAL_COMPONENT)) continue;
            return jComponent;
        }
        return null;
    }

    public static String getTitleOfEncapsulatedComponent(JPanel jPanel) {
        Component[] componentArray = jPanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            String string;
            JComponent jComponent = (JComponent)componentArray[i];
            if (!(jComponent instanceof JLabel) || (string = jComponent.getName()) == null || !string.equals(TITLE_COMPONENT)) continue;
            return ((JLabel)jComponent).getText();
        }
        return null;
    }

    protected static void standardizeComponent(Component component, Font font, Color color, String string) {
        String string2 = component.getName();
        if (string2 == null || string == null || !string.equals(string2)) {
            if (font != null) {
                component.setFont(font);
            }
            if (color != null) {
                component.setBackground(color);
            }
        }
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                WzStatusPanel.standardizeComponent(componentArray[i], font, color, string);
            }
        }
    }

    protected static void standardizeComponent(Component component, Font font, Color color) {
        WzStatusPanel.standardizeComponent(component, font, color, null);
    }

    public void setComponentBorder(Border border) {
        this.useThisBorder = border;
        this.redoLayout();
    }

    public void setEntireBackground(Color color) {
        this.useThisBgColor = color;
        this.setBackground(color);
        for (int i = 0; i < this.componentStack.size(); ++i) {
            JComponent jComponent = (JComponent)this.componentStack.get(i);
            WzStatusPanel.standardizeComponent(jComponent, null, this.useThisBgColor, TITLE_COMPONENT);
        }
        this.redoLayout();
    }

    public static JPanel encapsulateComponent(JComponent jComponent, Color color, String string) {
        jComponent.setAlignmentX(0.0f);
        jComponent.setName(ORIGINAL_COMPONENT);
        WzStatusPanel.standardizeComponent(jComponent, STATUS_FONT, color, null);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setAlignmentX(0.0f);
        if (string != null && string.length() > 0) {
            JLabel jLabel = new JLabel(string);
            jLabel.setName(TITLE_COMPONENT);
            jLabel.setBackground(TITLE_COLOR);
            jLabel.setOpaque(true);
            jLabel.setFont(TITLE_FONT);
            jPanel.add((Component)jLabel, "North");
        }
        jPanel.add((Component)jComponent, "Center");
        return jPanel;
    }

    public void push(JComponent jComponent, String string, boolean bl) {
        JPanel jPanel = WzStatusPanel.encapsulateComponent(jComponent, this.useThisBgColor, string);
        if (bl) {
            jPanel.setBorder(this.useThisBorder);
        }
        this.componentStack.add(jPanel);
        this.redoLayout();
    }

    public void push(JComponent jComponent, String string) {
        this.push(jComponent, string, true);
    }

    public void push(JComponent jComponent) {
        this.push(jComponent, null, true);
    }

    public JComponent pop() {
        if (this.componentStack.empty()) {
            return null;
        }
        JPanel jPanel = (JPanel)this.componentStack.pop();
        JComponent jComponent = WzStatusPanel.decapsulateComponent(jPanel);
        this.redoLayout();
        return jComponent;
    }

    protected void redoLayout() {
        this.removeAll();
        if (this.componentStack.size() == 0) {
            this.handleNoComponents();
        } else {
            this.gbc = new GridBagConstraints();
            this.gbc.gridheight = this.componentStack.size();
            this.gbc.weightx = 1.0;
            this.gbc.fill = 2;
            this.gbc.anchor = 17;
            this.gbc.gridx = 0;
            this.gbc.gridy = 0;
            this.gbc.insets = new Insets(0, 0, 1, 0);
            for (int i = 0; i < this.componentStack.size(); ++i) {
                JComponent jComponent = (JComponent)this.componentStack.get(i);
                if (jComponent == null) continue;
                this.gridbag.setConstraints(jComponent, this.gbc);
                this.add(jComponent);
                this.gbc.gridy = -1;
            }
            this.gbc.weighty = 1.0;
            JPanel jPanel = new JPanel();
            WzStatusPanel.standardizeComponent(jPanel, STATUS_FONT, this.useThisBgColor, null);
            this.gridbag.setConstraints(jPanel, this.gbc);
            this.add(jPanel);
        }
        this.repaint();
    }

    public boolean containsComponentWithTitle(String string) {
        boolean bl = false;
        for (int i = 0; i < this.componentStack.size(); ++i) {
            String string2;
            if (!(this.componentStack.get(i) instanceof JPanel) || (string2 = WzStatusPanel.getTitleOfEncapsulatedComponent((JPanel)this.componentStack.get(i))) == null || !string2.equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected void handleNoComponents() {
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource(VIGNETTE));
        JLabel jLabel = new JLabel(imageIcon);
        this.gbc = new GridBagConstraints();
        this.gridbag.setConstraints(jLabel, this.gbc);
        this.add(jLabel);
    }

    public String getText() {
        String string = "";
        for (int i = 0; i < this.componentStack.size(); ++i) {
            String string2 = WzStatusPanel.getTitleOfEncapsulatedComponent((JPanel)this.componentStack.get(i));
            JComponent jComponent = WzStatusPanel.decapsulateComponent((JPanel)this.componentStack.get(i));
            String string3 = WzStatusPanel.getStringFromJComponent(jComponent);
            string = string + (string2 != null ? "[" + string2 + "]\n" : "") + string3;
        }
        return string;
    }

    public static String getStringFromJComponent(Component component) {
        String string = "";
        if (component instanceof WzStatusPanel) {
            string = ((WzStatusPanel)component).getText();
        } else if (component instanceof GridPanel) {
            Component[] componentArray = ((GridPanel)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(string = string + WzStatusPanel.getStringFromJComponent(componentArray[i])).endsWith("\n") || i % 2 != 0) continue;
                string = string.substring(0, string.length() - 1) + "\t";
            }
        } else if (component instanceof JPanel) {
            Component[] componentArray = ((JPanel)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                string = string + WzStatusPanel.getStringFromJComponent(componentArray[i]);
            }
        } else if (component instanceof JTextComponent) {
            string = ((JTextComponent)component).getText();
        } else if (component instanceof AbstractButton) {
            string = ((AbstractButton)component).getText();
        } else if (component instanceof JLabel) {
            string = ((JLabel)component).getText();
        } else if (component instanceof JList) {
            ListModel listModel = ((JList)component).getModel();
            for (int i = 0; i < listModel.getSize(); ++i) {
                string = string + listModel.getElementAt(i) + "\n";
            }
        } else if (component instanceof JTable) {
            int n;
            JTable jTable = (JTable)component;
            for (n = 0; n < jTable.getColumnCount(); ++n) {
                string = string + jTable.getColumnName(n) + "\t";
            }
            string = string + "\n";
            for (n = 0; n < jTable.getRowCount(); ++n) {
                for (int i = 0; i < jTable.getColumnCount(); ++i) {
                    string = string + jTable.getValueAt(n, i) + "\t";
                }
                string = string + " \n";
            }
        } else if (component instanceof JComboBox) {
            string = ((JComboBox)component).getSelectedItem().toString();
        } else if (component instanceof JSlider) {
            string = String.valueOf(((JSlider)component).getValue());
        } else if (component instanceof JSpinner) {
            string = ((JSpinner)component).getValue().toString();
        } else if (component instanceof JSplitPane) {
            Component component2;
            int n = ((JSplitPane)component).getOrientation();
            Component component3 = n == 0 ? ((JSplitPane)component).getTopComponent() : ((JSplitPane)component).getLeftComponent();
            Component component4 = component2 = n == 0 ? ((JSplitPane)component).getBottomComponent() : ((JSplitPane)component).getRightComponent();
            if (component3 != null && component3 instanceof JComponent) {
                string = string + WzStatusPanel.getStringFromJComponent((JComponent)component3);
            }
            if (component2 != null && component2 instanceof JComponent) {
                string = string + WzStatusPanel.getStringFromJComponent((JComponent)component2);
            }
        }
        if (string != null) {
            return string + "\n";
        }
        return "\n";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CMD_SAVE_TEXT)) {
            this.doSaveText();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSaveText() {
        byte by = 3;
        File file = PersistentFileChooserDialog.getFile((Component)this, (String)"Save Status To Text File", (Object)"Select the file where the status text will be saved to:", (byte)by, (String)"ctc.dialog.wz", (String)"save", (int)4);
        if (file != null) {
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter(new FileOutputStream(file, false));
                printWriter.println(this.getText());
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "An error occurred while trying to save the file\n" + file.getAbsolutePath() + ".\n" + iOException.getMessage(), "Error Saving", 0);
            }
            finally {
                if (printWriter != null) {
                    printWriter.flush();
                    printWriter.close();
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    private void maybeShowPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

