/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.aici;

import cerent.cms.idl.Equipment.eAiciExtAlarms;
import cerent.cms.model.AiciModuleModel;
import cerent.cms.model.ChassisModel;
import cerent.cms.model.CmsNodeUpgradingException;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EnvAlarmModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.ui.AbstractDataSourceControl;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.ObserverProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.IntegerDocument;
import cerent.util.gui.TextPanel;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AiciCardPane
extends ObserverProvPane
implements ActionListener,
DocumentListener {
    private TabbedView parent;
    private EnvAlarmModel[] inputModels;
    private JRadioButton button_alarm;
    private JRadioButton button_control;
    private JRadioButton button_aep;
    private JRadioButton button_aie;
    private Pane[] panes = null;
    private Pane currentPane = null;
    private JTextField stationNumberTF;
    private boolean alarmDirty;
    private boolean stationNumberDirty;
    private JCheckBox extCB;
    private boolean extUsed;
    private boolean isSDHChassis;
    private WaitDialog waitDialog;
    private Frame frame;
    private static final SDebug db = new SDebug("AiciCardPane");

    public AiciCardPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.registerWithModel();
        this.parent = tabbedView;
        this.setDataSourceControl(new InnerDsc());
        this.findChassisType();
        JPanel jPanel = AiciCardPane.createVerticalPanel(null);
        jPanel.add(this.createAlarmPanel());
        if (!this.isM6()) {
            jPanel.add(this.createStationNumberPanel());
        }
        this.add((Component)new UScrollPane((Component)jPanel));
        if (this.isUserAuthorized()) {
            this.addButtonPanel();
        }
        this.frame = this.uiToolkit.getApplicationFrame();
        this.waitDialog = new WaitDialog(this.frame);
    }

    private void findChassisType() {
        this.isSDHChassis = ((EntityModel)this.uiModel).getChassis().getEqType() == 71;
    }

    private boolean isM6() {
        boolean bl = ((EntityModel)this.uiModel).getChassis().isM6Chassis();
        return bl;
    }

    private JPanel createAlarmPanel() {
        JPanel jPanel = AiciCardPane.createVerticalPanel("Alarm Contacts");
        if (!this.isM6()) {
            jPanel.add(this.createCheckboxPanel());
        }
        jPanel.add(this.createOptionPanel());
        return jPanel;
    }

    private JPanel createCheckboxPanel() {
        JPanel jPanel = AiciCardPane.createHorizontalPanel(null);
        this.extCB = new JCheckBox("Add extension", false);
        if (this.isUserAuthorized()) {
            this.extCB.addActionListener(this);
        }
        jPanel.add(this.extCB);
        jPanel.add(Box.createHorizontalGlue());
        if (this.isSDHChassis) {
            this.extCB.setEnabled(false);
        }
        return jPanel;
    }

    private JPanel createOptionPanel() {
        JPanel jPanel = AiciCardPane.createHorizontalPanel(null);
        JPanel jPanel2 = AiciCardPane.createHorizontalPanel("Input/Output");
        this.button_alarm = new JRadioButton("External Alarm");
        this.button_control = new JRadioButton("External Control");
        if (this.isUserAuthorized()) {
            this.button_alarm.addActionListener(this);
            this.button_control.addActionListener(this);
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.button_alarm);
        buttonGroup.add(this.button_control);
        this.button_alarm.setSelected(true);
        jPanel2.add(this.button_alarm);
        jPanel2.add(this.button_control);
        jPanel.add(jPanel2);
        if (!this.isM6()) {
            JPanel jPanel3 = AiciCardPane.createHorizontalPanel("Extension Type");
            this.button_aep = new JRadioButton("AEP");
            this.button_aie = new JRadioButton("AIE");
            if (this.isUserAuthorized()) {
                this.button_aep.addActionListener(this);
                this.button_aie.addActionListener(this);
            }
            ButtonGroup buttonGroup2 = new ButtonGroup();
            buttonGroup2.add(this.button_aep);
            buttonGroup2.add(this.button_aie);
            if (this.isSDHChassis) {
                this.button_aep.setEnabled(false);
            } else {
                this.button_aep.setSelected(true);
            }
            this.button_aie.setEnabled(false);
            jPanel3.add(this.button_aep);
            jPanel3.add(this.button_aie);
            jPanel.add(jPanel3);
        }
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }

    private JPanel createStationNumberPanel() {
        JPanel jPanel = AiciCardPane.createHorizontalPanel("Station Number");
        TextPanel textPanel = new TextPanel("Station Number: ", 5);
        jPanel.add(textPanel);
        IntegerDocument integerDocument = new IntegerDocument(0, 9999, 4);
        this.stationNumberTF = textPanel.getTextField();
        this.stationNumberTF.setDocument(integerDocument);
        if (this.isUserAuthorized()) {
            this.stationNumberTF.getDocument().addDocumentListener(this);
        } else {
            this.stationNumberTF.setEditable(false);
        }
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }

    @Override
    public boolean hasSubTabs() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.extCB) {
            this.enableButtons();
        }
        AiciModuleModel aiciModuleModel = null;
        ChassisModel chassisModel = null;
        boolean bl = false;
        if (this.isM6()) {
            chassisModel = (ChassisModel)this.parent.getUiModel();
            bl = chassisModel.getInputOutputPortMode();
            if (this.button_alarm.isSelected() || this.button_control.isSelected()) {
                this.alarmDirty = true;
                this.setDirty();
            }
        } else {
            aiciModuleModel = (AiciModuleModel)this.parent.getUiModel();
            bl = aiciModuleModel.getInputOutputPortMode();
            eAiciExtAlarms eAiciExtAlarms2 = aiciModuleModel.getExtAlarmUsage();
            if (this.extCB.isSelected() && eAiciExtAlarms2 == eAiciExtAlarms.AICI_DEFAULT || !this.extCB.isSelected() && eAiciExtAlarms2 != eAiciExtAlarms.AICI_DEFAULT || !this.extCB.isSelected() && this.button_alarm.isSelected() && bl || !this.extCB.isSelected() && this.button_control.isSelected() && !bl) {
                this.alarmDirty = true;
                this.setDirty();
            } else {
                this.alarmDirty = false;
                if (!this.stationNumberDirty) {
                    this.resetDirty();
                }
            }
        }
    }

    private void enableButtons() {
        if (!this.extUsed) {
            this.button_alarm.setEnabled(!this.extCB.isSelected());
            this.button_control.setEnabled(!this.extCB.isSelected());
        } else {
            this.button_alarm.setEnabled(false);
            if (this.extCB.isSelected()) {
                this.button_control.setEnabled(false);
            } else {
                this.button_control.setEnabled(true);
                this.button_control.setSelected(true);
            }
        }
        if (!this.isSDHChassis) {
            this.button_aep.setEnabled(this.extCB.isSelected());
        }
        if (!this.isUserAuthorized()) {
            this.extCB.setEnabled(false);
            this.button_alarm.setEnabled(false);
            this.button_control.setEnabled(false);
            this.button_aep.setEnabled(false);
            this.button_aie.setEnabled(false);
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        super.update(observable, object);
        if (observable instanceof AiciModuleModel && object == ModelUpdateType.ADDED) {
            this.closeWaitDialog();
        }
    }

    private synchronized void showWaitDialog() {
        this.waitDialog.setVisible(true);
        this.frame.setEnabled(false);
    }

    private synchronized void closeWaitDialog() {
        if (!this.waitDialog.isVisible()) {
            this.showWaitDialog();
        }
        try {
            Thread.sleep(3000L);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        this.frame.setEnabled(true);
        this.waitDialog.setVisible(false);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.documentModified(documentEvent);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.documentModified(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.documentModified(documentEvent);
    }

    private void documentModified(DocumentEvent documentEvent) {
        this.setDirty();
        this.stationNumberDirty = true;
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.AiciCardPane;
    }

    public class InnerDsc
    extends AbstractDataSourceControl {
        @Override
        public void disposeDataSource() {
        }

        public void applyToModel() throws Exception {
            if (db.on()) {
                db.println("applying changes to model");
            }
            AiciModuleModel aiciModuleModel = null;
            ChassisModel chassisModel = null;
            if (AiciCardPane.this.isM6()) {
                chassisModel = (ChassisModel)AiciCardPane.this.parent.getUiModel();
            } else {
                aiciModuleModel = (AiciModuleModel)AiciCardPane.this.parent.getUiModel();
            }
            if (AiciCardPane.this.isM6()) {
                boolean bl = true;
                if (AiciCardPane.this.button_alarm.isSelected()) {
                    bl = false;
                }
                chassisModel.setInputOutputPortMode(bl);
            } else {
                if (AiciCardPane.this.alarmDirty) {
                    AiciCardPane.this.showWaitDialog();
                    try {
                        if (!AiciCardPane.this.extCB.isSelected()) {
                            if (AiciCardPane.this.extUsed) {
                                aiciModuleModel.setExtAlarmUsage(eAiciExtAlarms.AICI_DEFAULT);
                                if (db.on()) {
                                    db.println("setExtAlarmUsage " + eAiciExtAlarms.AICI_DEFAULT.value());
                                }
                            } else {
                                boolean bl = true;
                                if (AiciCardPane.this.button_alarm.isSelected()) {
                                    bl = false;
                                }
                                aiciModuleModel.setInputOutputPortMode(bl);
                                if (db.on()) {
                                    db.println("setInputOutputPortMode " + bl);
                                }
                            }
                        } else if (AiciCardPane.this.button_aep.isSelected()) {
                            aiciModuleModel.setExtAlarmUsage(eAiciExtAlarms.ALRM_EXP_PANEL);
                            if (db.on()) {
                                db.println("setExtAlarmUsage " + eAiciExtAlarms.ALRM_EXP_PANEL.value());
                            }
                        } else {
                            aiciModuleModel.setExtAlarmUsage(eAiciExtAlarms.ALRM_INT_EXT);
                            if (db.on()) {
                                db.println("setExtAlarmUsage " + eAiciExtAlarms.ALRM_INT_EXT.value());
                            }
                        }
                    }
                    catch (EMCProvisionError eMCProvisionError) {
                        AiciCardPane.this.closeWaitDialog();
                        ErrorMsg.displayDetailed((Component)AiciCardPane.this.frame, EMC.EID_FAIL_AIC_REMOVE, eMCProvisionError.getEID().getMessage());
                        this.refreshFromModel();
                    }
                    catch (CmsNodeUpgradingException cmsNodeUpgradingException) {
                        AiciCardPane.this.closeWaitDialog();
                        this.refreshFromModel();
                        throw cmsNodeUpgradingException;
                    }
                }
                if (AiciCardPane.this.stationNumberDirty) {
                    aiciModuleModel.setStationNumber(AiciCardPane.this.stationNumberTF.getText());
                }
            }
        }

        public void refreshFromModel() throws Exception {
            block11: {
                if (db.on()) {
                    db.println("refreshing from model");
                }
                ChassisModel chassisModel = null;
                AiciModuleModel aiciModuleModel = null;
                if (AiciCardPane.this.isM6()) {
                    chassisModel = (ChassisModel)AiciCardPane.this.parent.getUiModel();
                } else {
                    aiciModuleModel = (AiciModuleModel)AiciCardPane.this.parent.getUiModel();
                }
                try {
                    boolean bl = false;
                    bl = AiciCardPane.this.isM6() ? chassisModel.getInputOutputPortMode() : aiciModuleModel.getInputOutputPortMode();
                    if (bl) {
                        AiciCardPane.this.button_control.setSelected(true);
                    } else {
                        AiciCardPane.this.button_alarm.setSelected(true);
                    }
                    if (!AiciCardPane.this.isM6()) {
                        AiciCardPane.this.stationNumberTF.setText(aiciModuleModel.getStationNumber());
                        eAiciExtAlarms eAiciExtAlarms2 = aiciModuleModel.getExtAlarmUsage();
                        if (eAiciExtAlarms2 == eAiciExtAlarms.AICI_DEFAULT) {
                            AiciCardPane.this.extCB.setSelected(false);
                            AiciCardPane.this.extUsed = false;
                        } else {
                            AiciCardPane.this.extCB.setSelected(true);
                            if (eAiciExtAlarms2 == eAiciExtAlarms.ALRM_EXP_PANEL) {
                                AiciCardPane.this.button_aep.setSelected(true);
                            }
                            AiciCardPane.this.extUsed = true;
                        }
                        AiciCardPane.this.enableButtons();
                    }
                    AiciCardPane.this.resetDirty();
                    AiciCardPane.this.alarmDirty = false;
                    AiciCardPane.this.stationNumberDirty = false;
                }
                catch (NullPointerException nullPointerException) {
                    if (!db.on()) break block11;
                    db.println("Caught exception in enable buttons");
                }
            }
        }

        public IObservableManager getObservableManager() {
            if (this.dscObservableManager == null) {
                this.dscObservableManager = new ObservableManager((Observer)((Object)AiciCardPane.this), true);
            }
            return this.dscObservableManager;
        }
    }

    private class WaitDialog
    extends JDialog {
        private JLabel info;
        private Frame parentFrame;

        public WaitDialog(Frame frame) {
            super(frame, "Update Card", false);
            this.parentFrame = frame;
            this.info = new JLabel("Updating card, please wait.", 0);
            this.getContentPane().add((Component)this.info, "Center");
            this.setSize(new Dimension(250, 80));
            this.setLocationRelativeTo(this.parentFrame);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    WaitDialog.this.parentFrame.setEnabled(true);
                    WaitDialog.this.setVisible(false);
                }
            });
        }
    }
}

