/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ampli;

import cerent.cms.idl.Optics.eOpticalAmplifierRole;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.AdminState;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ampli.AmpliParametersTableModel;
import cerent.cms.ui.ampli.ParametersProvPane;
import cerent.util.SDebug;
import cerent.util.gui.UTable;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class AOTSParametersProvPane
extends ParametersProvPane {
    public AOTSParametersProvPane(String string, TabbedView tabbedView, AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        super(string, tabbedView, abstractOpticsLineModelArray);
    }

    @Override
    protected void prepareColumns() {
        super.prepareColumns();
        TableColumn tableColumn = this.table.getColumn(this.getColumnName(2));
        tableColumn.sizeWidthToFit();
        tableColumn.setPreferredWidth(tableColumn.getWidth());
        tableColumn = this.table.getColumn(this.getColumnName(22));
        tableColumn.setPreferredWidth(170);
        tableColumn = this.table.getColumn(this.getColumnName(24));
        tableColumn.setPreferredWidth(170);
        tableColumn = this.table.getColumn(this.getColumnName(23));
        tableColumn.setPreferredWidth(170);
        OpticsModuleModel opticsModuleModel = (OpticsModuleModel)this.getUiModel();
        this.removeColumn(4);
        this.removeColumn(6);
        this.removeColumn(8);
        this.removeColumn(14);
        if (opticsModuleModel.getEqType() == 130 || opticsModuleModel.getEqType() == 239 || opticsModuleModel.getEqType() == 196) {
            this.removeColumn(20);
        }
        if (opticsModuleModel.isOpticsAmplifiedLinePowerSupported() && opticsModuleModel.getEqType() != 287 && opticsModuleModel.getEqType() != 321) {
            this.removeColumn(12);
            this.removeColumn(11);
            this.removeColumn(10);
            this.removeColumn(9);
        } else {
            this.removeColumn(16);
            this.removeColumn(9);
            this.removeColumn(10);
        }
        if (opticsModuleModel.getEqType() == 277 || opticsModuleModel.getEqType() == 278) {
            this.removeColumn(24);
            this.removeColumn(20);
        }
        if (opticsModuleModel.getEqType() == 287 || opticsModuleModel.getEqType() == 321) {
            this.removeColumn(24);
            this.removeColumn(15);
        }
        if (opticsModuleModel.getEqType() == 129 || opticsModuleModel.getEqType() == 298 || opticsModuleModel.getEqType() == 299) {
            this.removeColumn(15);
        }
    }

    @Override
    protected AmpliParametersTableModel getDataModel() {
        return new AmpliParametersTableModel(this.lineModels);
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.AmpliOTSAmpliParametersProvPane;
    }

    @Override
    protected JTable getTable(TableModel tableModel) {
        UTable uTable = new UTable(tableModel){

            public TableCellEditor getCellEditor(int n, int n2) {
                if (this.convertColumnIndexToModel(n2) == 2) {
                    boolean bl = AdminState.isANSI(AOTSParametersProvPane.this.getUiModel().getNodeModel().getTdmProtocolType());
                    AdminState[] adminStateArray = null;
                    adminStateArray = AOTSParametersProvPane.this.supportsFullyDSBLD() ? AdminState.getAdminStatesNoIS(bl) : AdminState.getAdminStatesNoDSBLD(bl);
                    JComboBox<AdminState> jComboBox = new JComboBox<AdminState>(adminStateArray);
                    jComboBox.setEditable(false);
                    return new DefaultCellEditor(jComboBox);
                }
                return super.getCellEditor(n, n2);
            }
        };
        return uTable;
    }

    @Override
    protected void removeColumn(int n) {
        if (n >= 14) {
            String string = AmpliParametersTableModel.columnNames[n - 14];
            try {
                TableColumn tableColumn = this.getTable().getColumn(string);
                this.getTable().removeColumn(tableColumn);
            }
            catch (Exception exception) {
                if (AOTSParametersProvPane.db.on) {
                    db.fine("Caught " + exception + " in removeColumn");
                }
            }
        } else {
            super.removeColumn(n);
        }
    }

    @Override
    protected String getColumnName(int n) {
        if (n >= 14) {
            return AmpliParametersTableModel.columnNames[n - 14];
        }
        return super.getColumnName(n);
    }

    private boolean supportsFullyDSBLD() {
        OpticsModuleModel opticsModuleModel = (OpticsModuleModel)this.getUiModel();
        try {
            eOpticalAmplifierRole eOpticalAmplifierRole2 = opticsModuleModel.getAmpliRole();
            return eOpticalAmplifierRole2.value() == 1;
        }
        catch (Exception exception) {
            db.println("WARNING: cannot get ampli role for " + opticsModuleModel + ": " + exception.getMessage());
            if (db.isFinestEnabled()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return false;
        }
    }
}

