/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ampli;

import cerent.cms.idl.Common.eWavelength;
import cerent.cms.idl.Optics.sOChPowerAttributes;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.Attribute;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OpticalPortType;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.CombosCellRenderer;
import cerent.cms.ui.Wavelength;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import java.util.HashMap;

public class WlPowerDataSource
extends AbstractRowDataSource {
    protected HashMap ochInfoMap = new HashMap();
    private String currStatusPort = null;
    private static final String NOTUPDATED = "Not Updated";
    private static final String UPDATED = "Updated";
    protected sOChPowerAttributes[] currOchPwr = null;
    protected OchInfo[] currOchInfo = null;
    private Attribute wave = null;
    protected static final SDebug db = new SDebug("WlPowerDataSource");
    protected int numLines = -1;

    public void refreshFromModel(OpticsPortModel opticsPortModel) {
        sOChPowerAttributes[] sOChPowerAttributesArray = null;
        boolean bl = false;
        AbstractOpticsLineModel abstractOpticsLineModel = (AbstractOpticsLineModel)opticsPortModel.getInterfaceModel();
        try {
            sOChPowerAttributesArray = abstractOpticsLineModel.getAllWlPower();
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (FeatureUnsupported featureUnsupported) {
            SDebug.printStackTrace((Throwable)featureUnsupported);
        }
        this.currStatusPort = CombosCellRenderer.toString(opticsPortModel);
        this.currOchPwr = sOChPowerAttributesArray;
        bl = this.isMaintXConnPresent(abstractOpticsLineModel);
        if (this.ochInfoMap.get(this.currStatusPort) == null) {
            this.currOchInfo = new OchInfo[sOChPowerAttributesArray.length];
            for (int i = 0; i < sOChPowerAttributesArray.length; ++i) {
                this.currOchInfo[i] = new OchInfo(sOChPowerAttributesArray[i], UPDATED, this.isLambsaUsed(opticsPortModel, sOChPowerAttributesArray[i].lambdaId.value(), bl));
            }
            this.ochInfoMap.put(this.currStatusPort, this.currOchInfo);
        } else {
            this.currOchInfo = (OchInfo[])this.ochInfoMap.get(this.currStatusPort);
            for (int i = 0; i < this.currOchInfo.length; ++i) {
                if (this.currOchInfo[i].timeStamp < sOChPowerAttributesArray[i].timeStamp) {
                    this.currOchInfo[i].timeStamp = sOChPowerAttributesArray[i].timeStamp;
                    this.currOchInfo[i].power = sOChPowerAttributesArray[i].power;
                    this.currOchInfo[i].ochStatus = UPDATED;
                    this.currOchInfo[i].isLambdaUsed = this.isLambsaUsed(opticsPortModel, sOChPowerAttributesArray[i].lambdaId.value(), bl);
                    continue;
                }
                this.currOchInfo[i].ochStatus = NOTUPDATED;
                this.currOchInfo[i].isLambdaUsed = this.isLambsaUsed(opticsPortModel, sOChPowerAttributesArray[i].lambdaId.value(), bl);
            }
            this.ochInfoMap.put(this.currStatusPort, this.currOchInfo);
        }
        this.numLines = this.currOchInfo.length;
        this.fireDataSourceChanged();
    }

    private AbstractOpticsLineModel getLineTxModel(AbstractOpticsLineModel abstractOpticsLineModel) {
        OpticsModuleModel opticsModuleModel = null;
        AbstractOpticsLineModel abstractOpticsLineModel2 = null;
        try {
            opticsModuleModel = (OpticsModuleModel)abstractOpticsLineModel.getModuleModel();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        AbstractOpticsLineModel[] abstractOpticsLineModelArray = opticsModuleModel.getAllOpticsInterfaces();
        for (int i = 0; i < abstractOpticsLineModelArray.length; ++i) {
            try {
                if (abstractOpticsLineModelArray[i].getOptPortType() != OpticalPortType.OUT_LINE && !this.isWxc80Port(abstractOpticsLineModelArray[i])) continue;
                abstractOpticsLineModel2 = abstractOpticsLineModelArray[i];
                break;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return abstractOpticsLineModel2;
    }

    private boolean isMaintXConnPresent(AbstractOpticsLineModel abstractOpticsLineModel) {
        int n;
        block11: {
            n = 0;
            try {
                AbstractOpticsLineModel abstractOpticsLineModel2 = this.getLineTxModel(abstractOpticsLineModel);
                if (abstractOpticsLineModel2 == null) break block11;
                int[] nArray = abstractOpticsLineModel2.getMaintenanceChanelPower(abstractOpticsLineModel2.getIndex());
                try {
                    n = abstractOpticsLineModel.getIndex() == abstractOpticsLineModel2.getIndex() ? Integer.parseInt(String.valueOf(nArray[0])) : Integer.parseInt(String.valueOf(nArray[1]));
                }
                catch (NumberFormatException numberFormatException) {
                    n = 0;
                }
                if (n == abstractOpticsLineModel.getPortModel().getIndex()) {
                    if (n != 0) {
                        this.wave = nArray[2] == 82 ? Wavelength.getCMaintenanceWlAttribute() : Wavelength.getWlAttribute(nArray[2]);
                    }
                } else {
                    n = 0;
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                KDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                KDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
            catch (InternalCommError internalCommError) {
                KDebug.printStackTrace((Throwable)internalCommError);
            }
            catch (FeatureUnsupported featureUnsupported) {
                KDebug.printStackTrace((Throwable)featureUnsupported);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                KDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return n != 0;
    }

    private boolean isLambsaUsed(OpticsPortModel opticsPortModel, int n, boolean bl) {
        boolean bl2 = false;
        Integer[] integerArray = ((AbstractOpticsLineModel)opticsPortModel.getInterfaceModel()).getUsedWavelengthAsInt();
        if (bl && n == this.wave.getIntValue()) {
            bl2 = true;
        }
        if (!bl2) {
            for (int i = 0; i < integerArray.length; ++i) {
                if (n != integerArray[i]) continue;
                bl2 = true;
            }
        }
        return bl2;
    }

    private boolean isWxc80Port(AbstractOpticsLineModel abstractOpticsLineModel) throws NoSuchInterface, WrongInterfaceType {
        return abstractOpticsLineModel.getOptPortType() == OpticalPortType.COM_BIDI;
    }

    public Object getObjectAtRow(int n) {
        if (this.currStatusPort != null && this.ochInfoMap.get(this.currStatusPort) != null) {
            return ((OchInfo[])this.ochInfoMap.get(this.currStatusPort))[n];
        }
        return null;
    }

    public void dispose() {
        this.ochInfoMap.clear();
        this.currOchPwr = null;
        this.currOchInfo = null;
        this.currStatusPort = null;
    }

    public int getRowCount() {
        return this.numLines;
    }

    protected class OchInfo {
        protected eWavelength lambda;
        protected int power;
        protected String ochStatus;
        protected int timeStamp;
        protected boolean isLambdaUsed;

        public OchInfo(sOChPowerAttributes sOChPowerAttributes2, String string, boolean bl) {
            this.lambda = sOChPowerAttributes2.lambdaId;
            this.power = sOChPowerAttributes2.power;
            this.ochStatus = string;
            this.timeStamp = sOChPowerAttributes2.timeStamp;
            this.isLambdaUsed = bl;
        }
    }
}

