/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ans;

import cerent.cms.model.ANS.ANSElement;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableCellRenderer;

public class ANSTableCellRenderer
extends DefaultTableCellRenderer {
    private static final int PORT_IDX = 0;
    private static final int PARAM_IDX = 1;
    public static final int VALUE_IDX = 2;
    private static final int ACTVL_IDX = 3;
    private static final int ORIG_IDX = 4;
    private static final String[] COL_NAMES = new String[]{"Port", "Parameter", "Value", "Active Value", "Origin"};
    private static final int[] COL_SIZES = new int[]{250, 130, 100, 100, 80};
    private static final String N_ITEM_DIRTY_ICON = "/images/icons/edit_entry_16.gif";
    private static final String N_ITEM_CLEAN_ICON = "/images/icons/clean_entry_16.gif";
    private static final ImageIcon ITEM_CLEAN_ICON = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ANSTableCellRenderer.class.getResource("/images/icons/clean_entry_16.gif")));
    private static final ImageIcon ITEM_DIRTY_ICON = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ANSTableCellRenderer.class.getResource("/images/icons/edit_entry_16.gif")));
    private JTextArea textArea = new JTextArea();

    public ANSTableCellRenderer() {
        this.textArea.setEditable(true);
        this.textArea.setLineWrap(true);
        this.textArea.setOpaque(true);
        this.setVerticalAlignment(1);
    }

    public static int getColumnCount() {
        return COL_NAMES.length;
    }

    public static String getColumnName(int n) {
        if (n < COL_NAMES.length) {
            return COL_NAMES[n];
        }
        return "N/A";
    }

    public static int getColumnWidth(int n) {
        if (n < COL_SIZES.length) {
            return COL_SIZES[n];
        }
        return 0;
    }

    public static int getColumnsWidth() {
        int n = 0;
        for (int i = 0; i < COL_SIZES.length; ++i) {
            n += COL_SIZES[i];
        }
        return n;
    }

    public static boolean isColumnResizable(int n) {
        return true;
    }

    public static boolean isColumnReadOnly(int n) {
        return n != 2;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        ImageIcon imageIcon = null;
        ANSElement aNSElement = (ANSElement)object;
        if (aNSElement == null) {
            return null;
        }
        switch (jTable.convertColumnIndexToModel(n2)) {
            case 0: {
                object = aNSElement.getPortName();
                break;
            }
            case 1: {
                object = aNSElement.getName();
                if (!aNSElement.causesReboot()) break;
                object = object + " (reboots node)";
                break;
            }
            case 2: {
                object = aNSElement.getANSValue().getValue();
                int n3 = aNSElement.getANSValue().getDefElemClass();
                if (n3 == 1) {
                    this.textArea.setText((String)object);
                    if (bl) {
                        this.textArea.setForeground(jTable.getSelectionForeground());
                        this.textArea.setBackground(jTable.getSelectionBackground());
                    } else {
                        if (aNSElement.isFail()) {
                            this.textArea.setForeground(Color.RED);
                        } else {
                            this.textArea.setForeground(jTable.getForeground());
                        }
                        this.textArea.setBackground(jTable.getBackground());
                    }
                    return this.textArea;
                }
                if (n3 == 4) {
                    object = "<html>" + (String)object;
                } else if (aNSElement.getANSValue().getUnits().length() > 0) {
                    object = object + "    (" + aNSElement.getANSValue().getUnits() + ")";
                }
                if (aNSElement.isDirty()) {
                    imageIcon = ITEM_DIRTY_ICON;
                    break;
                }
                imageIcon = ITEM_CLEAN_ICON;
                break;
            }
            case 3: {
                object = aNSElement.getANSValue().getActiveValue();
                if (aNSElement.getANSValue().getUnits().length() <= 0) break;
                object = object + "    (" + aNSElement.getANSValue().getUnits() + ")";
                break;
            }
            case 4: {
                object = aNSElement.getOriginString();
                break;
            }
        }
        if (aNSElement.isFail()) {
            this.setForeground(Color.RED);
        } else {
            this.setForeground(jTable.getForeground());
        }
        Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (component instanceof JLabel) {
            JLabel jLabel = (JLabel)component;
            jLabel.setIcon(imageIcon);
        }
        component.setEnabled(!aNSElement.isReadOnly());
        return component;
    }
}

