/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ans;

import cerent.cms.model.ANS.ANSNode;
import cerent.cms.model.ANS.ANSResult;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.IProvisioning;
import cerent.cms.ui.ans.ANSHelper;
import cerent.cms.ui.ans.ANSTableModel;
import cerent.cms.ui.ans.IANSController;
import cerent.util.CEMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.UDialog;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class AnsRegulatedPathDialog
extends UDialog
implements IProvisioning,
IANSController {
    private ANSTableModel tableModel;
    private UTable utable;
    private JButton applyButton;
    private JButton resetButton;
    private final ANSResult result;
    private final ANSHelper helper;
    protected static final SDebug db = new SDebug("AnsRegulatedPathDialog");
    private static final String DIALOG_TITLE = "ANS Regulated Path";

    public static AnsRegulatedPathDialog instance(Frame frame, ANSResult aNSResult) {
        return new AnsRegulatedPathDialog(frame, aNSResult);
    }

    private AnsRegulatedPathDialog(Frame frame, ANSResult aNSResult) {
        super(frame, DIALOG_TITLE, true);
        if (db.on()) {
            db.println(this.getClass().toString() + " AnsParamCreationDialog constructor");
        }
        this.result = aNSResult;
        this.helper = new ANSHelper(frame, aNSResult.getNmd());
        this.tableModel.setScope((JTable)this.utable, aNSResult.getPortRegulationPath());
        this.setVisible(true);
    }

    public void dispose() {
        this.helper.dispose();
        super.dispose();
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        if (db.on()) {
            db.println(this.getClass().toString() + " initContentPane");
        }
        this.setSize(new Dimension(450, 520));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.getParamPanel(), "North");
        jPanel.add((Component)this.getButtonPanel(), "South");
    }

    private JPanel getButtonPanel() {
        if (db.on()) {
            db.println(this.getClass().toString() + " getButtonPanel");
        }
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 5, 5));
        this.applyButton = new JButton("Apply");
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnsRegulatedPathDialog.this.apply();
            }
        });
        this.applyButton.setEnabled(false);
        jPanel2.add(this.applyButton);
        this.resetButton = new JButton("Reset");
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnsRegulatedPathDialog.this.reset();
            }
        });
        this.resetButton.setEnabled(false);
        jPanel2.add(this.resetButton);
        JButton jButton = new JButton("Cancel");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnsRegulatedPathDialog.this.dispose();
            }
        });
        jButton.setEnabled(true);
        jPanel2.add(jButton);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private JPanel getParamPanel() {
        if (db.on()) {
            db.println(this.getClass().toString() + " getParamPanel");
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.tableModel = new ANSTableModel(this);
        this.utable = new UTable((TableModel)this.tableModel);
        this.utable.setPreferredScrollableViewportSize(new Dimension(650, 180));
        this.tableModel.initTable((JTable)this.utable, this);
        JScrollPane jScrollPane = new JScrollPane((Component)this.utable, 20, 30);
        jPanel.add(jScrollPane);
        return jPanel;
    }

    public void apply() {
        db.info("reset() called");
        try {
            if (this.helper.applyToNode(this.tableModel.getANSElementList())) {
                this.reset();
            }
        }
        catch (Exception exception) {
            ErrorMsg.displayDetailed((Component)((Object)this), CEMC.EID_FAIL_APPLY_CHANGES, exception);
        }
    }

    public void reset() {
        db.info("reset() called");
        this.tableModel.setScope((JTable)this.utable, this.result.getPortRegulationPath());
        this.setDirty(false);
    }

    public void setDirty(boolean bl) {
        this.applyButton.setEnabled(bl);
        this.resetButton.setEnabled(bl);
    }

    @Override
    public Component getParentComponent() {
        return this;
    }

    @Override
    public boolean isAuthorized() {
        return this.result.getNmd().isUserAuthorized(SecurityLevel.SUPERUSER);
    }

    @Override
    public void setDirty(ANSNode aNSNode) {
        this.setDirty(true);
    }
}

