/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds1;

import cerent.cms.IPlatform;
import cerent.cms.idl.Ds123Media.eDs1Mapping;
import cerent.cms.idl.Ds123Media.eSaBit;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Attribute;
import cerent.cms.model.ChassisModel;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds1LineModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ds1.Ds1LineTableModel;
import cerent.cms.ui.ds123.Ds123LineProvPane;
import cerent.cms.ui.ds123.Ds123LineTableModel;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.util.NoSuchElementException;
import java.util.Observable;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.table.TableColumn;

public class Ds1LineProvPane
extends Ds123LineProvPane {
    protected IPlatform p = ((ModuleModel)this.getUiModel()).getNodeModelDelegate().getPlatform();
    private JComboBox adminSsmCB;
    public static final String ENABLE_RETIMING_WARNING = "Enabling retiming on ports that have associated circuits may affect traffic.\nIs it OK to continue?";

    public Ds1LineProvPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray, CSHelpID cSHelpID) {
        super(string, tabbedView, ds123LineModelArray, cSHelpID);
        int n = ((ModuleModel)this.getUiModel()).getEqType();
        Attribute[] attributeArray = null;
        TableColumn tableColumn = null;
        if (!this.p.supportsDs1Timing(n)) {
            tableColumn = this.table.getColumn(Ds1LineTableModel.ds1ColumnNames[16]);
            this.table.removeColumn(tableColumn);
            tableColumn = this.table.getColumn(Ds1LineTableModel.ds1ColumnNames[17]);
            this.table.removeColumn(tableColumn);
            tableColumn = this.table.getColumn(Ds1LineTableModel.ds1ColumnNames[18]);
            this.table.removeColumn(tableColumn);
            tableColumn = this.table.getColumn(Ds1LineTableModel.ds1ColumnNames[19]);
            this.table.removeColumn(tableColumn);
        } else if (n == 234) {
            tableColumn = this.table.getColumn(Ds1LineTableModel.ds1ColumnNames[19]);
            this.table.removeColumn(tableColumn);
        }
        tableColumn = this.table.getColumn(Ds1LineTableModel.ds1ColumnNames[20]);
        if (!this.p.supportsDs1SyncAsync(n)) {
            this.table.removeColumn(tableColumn);
        } else {
            try {
                attributeArray = this.getAttributeArray(eDs1Mapping.class);
            }
            catch (NoSuchElementException noSuchElementException) {
                attributeArray = null;
                this.table.removeColumn(tableColumn);
            }
            if (attributeArray != null) {
                tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
                tableColumn.sizeWidthToFit();
            }
        }
        if (!this.p.supportsCompleteDs1E1TimingOptions(n)) {
            tableColumn = this.table.getColumn(Ds1LineTableModel.ds1ColumnNames[22]);
            if (!this.p.supportsCompleteDs1TimingOptions(n)) {
                this.table.removeColumn(tableColumn);
            } else {
                try {
                    attributeArray = this.getSelectableSSMAttributes();
                    this.adminSsmCB = this.getComboBoxFor(attributeArray);
                    tableColumn.setCellEditor(new DefaultCellEditor(this.adminSsmCB));
                }
                catch (NoSuchElementException noSuchElementException) {
                    attributeArray = null;
                    this.table.removeColumn(tableColumn);
                    if (db.on()) {
                        db.println("No Such Element Exception when getting Slectable SSM attributes" + noSuchElementException);
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    attributeArray = null;
                    this.table.removeColumn(tableColumn);
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            tableColumn = this.table.getColumn(Ds1LineTableModel.ds1ColumnNames[21]);
            this.table.removeColumn(tableColumn);
        }
    }

    @Override
    protected Ds123LineTableModel getDataModel(Ds123LineModel[] ds123LineModelArray) {
        return new Ds1LineTableModel(this.node, ds123LineModelArray);
    }

    @Override
    protected Attribute[] getAttributeArray(Class clazz) {
        String string = "DS1_LINE_CARD";
        return this.getAttributeMap().getAttributeArray(string + "." + clazz.getName());
    }

    @Override
    protected Attribute[] getAttributeArray(String string) {
        String string2 = "DS1_LINE_CARD";
        return this.getAttributeMap().getAttributeArray(string2 + "." + string);
    }

    private void handleSyncConfig(int n) throws Exception {
        if (this.dataModel.isDirty(n, 17) || this.dataModel.isDirty(n, 18) || this.dataModel.isDirty(n, 22)) {
            ((Ds1LineModel)this.lineModels[n]).setSyncConfig(((Ds1LineTableModel)this.dataModel).getSyncConfig(n));
        }
    }

    @Override
    protected void applyToLine(int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = this.dataModel.isDirty(n, 17) && !((Ds1LineTableModel)this.dataModel).getSyncConfig((int)n).syncMessageIn;
        if (bl) {
            this.handleSyncConfig(n);
            super.applyToLine(n);
        } else {
            super.applyToLine(n);
            this.handleSyncConfig(n);
        }
        if (this.dataModel.isDirty(n, 19)) {
            boolean bl3 = ((Ds1LineTableModel)this.dataModel).getRetimingEnabled(n);
            int n2 = ((Ds1LineModel)this.lineModels[n]).getConnectionsList().size();
            if (bl3 && n2 > 0) {
                if (CerentDialog.yesNoDialog((Component)((Object)this), (String)ENABLE_RETIMING_WARNING, (String)"Confirm Enable Retiming")) {
                    ((Ds1LineModel)this.lineModels[n]).setDs1RetimingEnabled(((Ds1LineTableModel)this.dataModel).getRetimingEnabled(n));
                }
            } else {
                ((Ds1LineModel)this.lineModels[n]).setDs1RetimingEnabled(((Ds1LineTableModel)this.dataModel).getRetimingEnabled(n));
            }
        }
        if (this.dataModel.isDirty(n, 20)) {
            ((Ds1LineModel)this.lineModels[n]).setDs1Mapping(eDs1Mapping.from_int(((Ds1LineTableModel)this.dataModel).getDs1Mapping(n).getValue()));
        }
        if (this.dataModel.isDirty(n, 21)) {
            ((Ds1LineModel)this.lineModels[n]).setE1SaBit(eSaBit.from_int(((Ds1LineTableModel)this.dataModel).getE1SaBit(n).getValue()));
        }
    }

    @Override
    protected boolean needToRemoveAutoProvision() {
        return !this.pci.supportsDs1AutoProvision();
    }

    @Override
    protected boolean needToRemoveDetectedLineType() {
        return !this.pci.supportsDs1DetectedLineType();
    }

    @Override
    protected Attribute[] getDetectedAttributeArray(Class clazz) {
        return this.getAttributeMap().getAttributeArray("DS1_LINE_CARD." + clazz.getName() + ".detected");
    }

    @Override
    protected Attribute[] getDetectedAttributeArray(String string) {
        return this.getAttributeMap().getAttributeArray("DS1_LINE_CARD." + string + ".detected");
    }

    protected Attribute[] getSelectableSSMAttributes() throws AbstractCmsNoSuchEntityException {
        if (((ChassisModel)this.node.getChassis()).getSyncModel().isG1SsmGeneration()) {
            return this.getAttributeMap().getAttributeArray("timingSonetSsmQuality");
        }
        return this.getAttributeMap().getAttributeArray("timingSonetG2SsmQuality");
    }

    @Override
    protected void refreshLine(Observable observable) {
        int n = ((ModuleModel)this.getUiModel()).getEqType();
        if (db.on()) {
            db.println("Ds1LineProvPane: refreshLine");
        }
        if (this.p.supportsCompleteDs1TimingOptions(n)) {
            this.updateQualityList(this.adminSsmCB);
        }
        super.refreshLine(observable);
    }

    protected void updateQualityList(JComboBox jComboBox) {
        if (db.on()) {
            db.println("Ds1LineProvPane: updateQualityList");
        }
        Attribute[] attributeArray = null;
        try {
            attributeArray = this.getSelectableSSMAttributes();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            return;
        }
        jComboBox.removeAllItems();
        for (int i = 0; i < attributeArray.length; ++i) {
            jComboBox.addItem(attributeArray[i]);
        }
        if (db.on()) {
            db.println("updateQualityList: new count=" + jComboBox.getItemCount());
        }
    }
}

