/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds1e1;

import cerent.cms.model.Ds1ModuleModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ds1e1.Ds1E1CardProvTableModel;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class Ds1E1CardProvPane
extends NodeProvPane
implements TableModelListener {
    protected ModuleModel model = null;
    protected Ds1E1CardProvTableModel dataModel;
    protected int numLines;
    protected int thresholdLayer;
    private boolean initialized = false;
    protected static final SDebug db = new SDebug("Ds1E1CardProvPane");

    public Ds1E1CardProvPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.model = (Ds1ModuleModel)tabbedView.getUiModel();
    }

    protected void init() {
        this.dataModel = this.getDataModel(this.thresholdLayer);
        this.dataModel.addTableModelListener(this);
        this.table = new JTable(this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(true);
        TableColumn tableColumn = this.table.getColumn(Ds1E1CardProvTableModel.columnNames[0]);
        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxForTransportMode()));
        tableColumn.setPreferredWidth(90);
        tableColumn = this.table.getColumn(Ds1E1CardProvTableModel.columnNames[1]);
        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxForOperMode()));
        tableColumn.setPreferredWidth(90);
        tableColumn = this.table.getColumn(Ds1E1CardProvTableModel.columnNames[3]);
        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxForVtMappingMode()));
        tableColumn.setPreferredWidth(90);
        this.registerWithModel();
        this.add((Component)uScrollPane, "Center");
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.table.setAutoResizeMode(0);
        this.initialized = true;
    }

    @Override
    protected void registerWithModel() {
        if (this.model != null) {
            this.model.addObserver((Observer)((Object)this));
        }
    }

    protected JComboBox getComboBoxForTransportMode() {
        JComboBox<String> jComboBox = new JComboBox<String>(this.dataModel.transportModeStrings);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    protected JComboBox getComboBoxForOperMode() {
        JComboBox<String> jComboBox = new JComboBox<String>(this.dataModel.operModeStrings);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    protected JComboBox getComboBoxForVtMappingMode() {
        JComboBox<String> jComboBox = new JComboBox<String>(this.dataModel.portToVtMappingStrings);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    @Override
    public void dispose() {
        if (this.model != null) {
            this.model.deleteObserver((Observer)((Object)this));
        }
    }

    @Override
    public void leavingPage() throws Exception {
        if (this.table != null) {
            TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        }
        super.leavingPage();
    }

    @Override
    public void enteringPage() throws Exception {
        if (!this.initialized) {
            this.init();
        }
        super.enteringPage();
    }

    @Override
    public void refreshFromModel() throws Exception {
        if (this.initialized) {
            this.dataModel.refreshFromModel();
        }
    }

    @Override
    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        this.initialized = false;
        super.destroy();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            this.dataModel.fireTableDataChanged();
            this.requestRefresh(observable, this.getRefreshThread(observable));
        }
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            @Override
            public void run() {
                Ds1E1CardProvPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        block2: {
            try {
                this.dataModel.refreshLineFromModel(0);
            }
            catch (Exception exception) {
                ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_REFRESH_ROW_PARAM_1, "1", exception.toString());
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    @Override
    public void applyChangesToModel() throws Exception {
        this.dataModel.applyToModel();
        this.resetDirty();
    }

    protected Ds1E1CardProvTableModel getDataModel(int n) {
        return new Ds1E1CardProvTableModel(this.model, n);
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.Ds1E1CardProvPane;
    }

    public String getHelpIDString() {
        return "Ds1E1CardProvPane";
    }
}

