/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds3;

import cerent.cms.idl.Ds123Media.eThresholdType;
import cerent.cms.model.ConfigError;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ds123.Ds123PathThresholdsPane;
import cerent.cms.ui.ds123.Ds123PmThresholdsTableModel;
import cerent.cms.ui.ds3.Ds3CPBitThresholdsTableModel;
import cerent.util.SDebug;
import javax.swing.table.TableColumn;

public class Ds3CPBitThresholdsPane
extends Ds123PathThresholdsPane {
    private static final SDebug db = new SDebug("Ds3CPBitThresholdsPane");

    public Ds3CPBitThresholdsPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray, eThresholdType eThresholdType2, boolean bl, CSHelpID cSHelpID) {
        super(string, tabbedView, ds123LineModelArray, eThresholdType2, bl, cSHelpID);
    }

    @Override
    protected void initialize() {
        super.initialize();
        try {
            TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(6));
            this.table.removeColumn(tableColumn);
            if (this.nearEnd) {
                tableColumn = this.table.getColumn(this.dataModel.getColumnName(5));
                this.table.removeColumn(tableColumn);
            }
        }
        catch (Exception exception) {
            db.finer("Exception in initialize() " + exception);
        }
    }

    @Override
    protected Ds123PmThresholdsTableModel getDataModel() {
        INodeModel iNodeModel = this.uiModel.getNodeModel();
        return new Ds3CPBitThresholdsTableModel(iNodeModel, this.lineModels, this.thresholdType, this.nearEnd);
    }

    @Override
    public void applyChangesToModel() throws NoSuchInterface, WrongInterfaceType, ConfigError, UnsupportedOperation {
        for (int i = 0; i < this.lineModels.length; ++i) {
            if (!this.dataModel.isRowDirty(i)) continue;
            this.printThresholds(this.dataModel.getThresholdsVal(i));
            this.lineModels[i].setPmCPBitThresholds(this.nearEnd, this.thresholdType, this.dataModel.getThresholdsVal(i));
        }
        this.dataModel.resetDirtyBits();
    }
}

