/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds3e;

import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds3LineUpdate;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.Pane;
import cerent.cms.ui.ProtCardDualPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ds123.Ds123LinePmThresholdsPane;
import cerent.cms.ui.ds3e.Ds3eLineProvPane;
import cerent.cms.ui.ds3e.Ds3ePathPmThresholdsPane;
import cerent.cms.ui.ds3e.Ds3eSonetPmThresholdsPane;
import cerent.cms.ui.e3.E3SdhPmThresholdsPane;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.awt.Component;

public class Ds3eProvPane
extends AbstractSubTabbedPane
implements ITabName {
    Ds123LineModel[] lineModels = null;
    boolean needsAlarmingPane;
    private INodeModel node;
    private static final SDebug db = new SDebug("Ds3eProvPane");

    public Ds3eProvPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray) {
        this(string, tabbedView, ds123LineModelArray, true);
    }

    public Ds3eProvPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray, boolean bl) {
        super(string, tabbedView);
        this.lineModels = ds123LineModelArray;
        this.needsAlarmingPane = bl;
        this.registerWithModel();
    }

    @Override
    protected void createSubTabs() {
        db.info("Creating SubTabs");
        this.node = this.getUiModel().getNodeModel();
        TDMTerminology tDMTerminology = this.node.getTDMTerminology();
        this.subTabs.addTab("Line", (Component)this.getLineProvTab());
        this.subTabs.addTab("Line Thresholds", (Component)this.getLineThreshold());
        this.subTabs.addTab("Elect Path Thresholds", (Component)this.getElecPathThreshold());
        boolean bl = this.node.getTdmProtocolTypeObj().isSonet();
        if (bl) {
            this.subTabs.addTab("SONET Thresholds", (Component)this.getSonetThreshold());
        } else {
            this.subTabs.addTab("SDH Thresholds", (Component)this.getSonetThreshold());
        }
        if (this.needsAlarmingPane) {
            this.subTabs.addTab("Alarm Profiles", (Component)CardTabbedView.getCardProvAlarmsPane(this.subTabs, true));
        }
    }

    private Pane getLineProvTab() {
        CSHelpID cSHelpID = CSHelpConst.Ds3eLineProvPane;
        int n = ((ModuleModel)this.getUiModel()).getEqType();
        if (n == 157 || n == 234 || n == 233) {
            cSHelpID = CSHelpConst.CtxDs3eLineProvPane;
        }
        return new ProtCardDualPane(this.subTabs, (ModuleModel)this.getUiModel(), new Ds3eLineProvPane("Line", this.getParentView(), this.lineModels, cSHelpID));
    }

    private Pane getLineThreshold() {
        CSHelpID cSHelpID = CSHelpConst.Ds3eLineThresholdsPane;
        int n = ((ModuleModel)this.getUiModel()).getEqType();
        if (n == 157 || n == 234 || n == 233) {
            cSHelpID = CSHelpConst.CtxDs3eLineThresholdsPane;
        }
        return new ProtCardDualPane(this.subTabs, (ModuleModel)this.getUiModel(), new Ds123LinePmThresholdsPane("Line Thresholds", this.getParentView(), this.lineModels, cSHelpID));
    }

    private Pane getSonetThreshold() {
        if (this.node.getTdmProtocolTypeObj().isSonet()) {
            return new ProtCardDualPane(this.subTabs, (ModuleModel)this.getUiModel(), new Ds3eSonetPmThresholdsPane("SONET Thresholds", this.getParentView(), this.lineModels));
        }
        return new ProtCardDualPane(this.subTabs, (ModuleModel)this.getUiModel(), new E3SdhPmThresholdsPane("SDH Thresholds", this.getParentView(), this.lineModels));
    }

    private Pane getElecPathThreshold() {
        CSHelpID cSHelpID = CSHelpConst.Ds3eElectPathThresholdsPane;
        int n = ((ModuleModel)this.getUiModel()).getEqType();
        if (n == 157 || n == 234 || n == 233) {
            cSHelpID = CSHelpConst.CtxDs3eElectPathThresholdsPane;
        }
        return new ProtCardDualPane(this.subTabs, (ModuleModel)this.getUiModel(), new Ds3ePathPmThresholdsPane("Elect Path Thresholds", this.getParentView(), this.lineModels, cSHelpID));
    }

    @Override
    protected void refreshMyLines(Object object) {
        if (object instanceof Ds3LineUpdate) {
            db.info("Received Ds3LineUpdate..");
            this.lineModels = (Ds123LineModel[])((Ds3LineUpdate)object).getModels();
        } else {
            db.fine("refreshMyLines received " + object);
        }
    }
}

