/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds3i;

import cerent.cms.idl.Ds123Media.eThresholdType;
import cerent.cms.idl.Ds123Media.sThresholds;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.nedefaults.NeDefaultsModel;
import cerent.cms.ui.PmThresholdsTableModel;
import cerent.util.SDebug;

public class Ds3iPBitPmThresholdsTableModel
extends PmThresholdsTableModel {
    public static final int LINENUMBER_INDEX = 0;
    public static final int CV_INDEX = 1;
    public static final int ES_INDEX = 2;
    public static final int SES_INDEX = 3;
    public static final int SAS_INDEX = 4;
    public static final int UAS_INDEX = 5;
    public static final int AISS_INDEX = 6;
    public static final int COLUMNS = 7;
    private static final SDebug db = new SDebug("Ds3iPBitPmThresholdsTableModel");

    public Ds3iPBitPmThresholdsTableModel(Ds123LineModel[] ds123LineModelArray, eThresholdType eThresholdType2, boolean bl) {
        super(ds123LineModelArray, 12, eThresholdType2, bl);
    }

    @Override
    protected void initColumnNames() {
        this.columnNames = new String[7];
        this.columnNames[0] = "Port";
        this.columnNames[1] = "CVP";
        this.columnNames[2] = "ESP";
        this.columnNames[3] = "SESP";
        this.columnNames[4] = "SASP";
        this.columnNames[5] = "UASP";
        this.columnNames[6] = "AISSP";
    }

    @Override
    protected sThresholds getPmThreshold(Ds123LineModel ds123LineModel) throws NoSuchInterface, WrongInterfaceType {
        sThresholds sThresholds2 = null;
        sThresholds2 = ds123LineModel.getPmPathThresholds(this.nearEnd, this.thresholdType);
        return sThresholds2;
    }

    @Override
    protected void setPmThreshold(Ds123LineModel ds123LineModel, sThresholds sThresholds2) throws Exception {
        ds123LineModel.setPmPathThresholds(this.nearEnd, this.thresholdType, sThresholds2);
    }

    @Override
    public Object getThresholdNeDefault(NeDefaultsModel neDefaultsModel, int n) throws Exception {
        eEqType eEqType2 = this.model[n].getModuleModel().getEqTypeEnum();
        IPortModel iPortModel = this.model[n].getPortModel();
        eEqType eEqType3 = ((EntityModel)iPortModel).getEqTypeEnum();
        return neDefaultsModel.getDefPmPathThr(eEqType2, eEqType3, this.nearEnd, this.thresholdType);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getPortDescriptionFor(n);
                }
                case 1: {
                    return new Integer(this.getCv(n));
                }
                case 2: {
                    return new Integer(this.getEs(n));
                }
                case 3: {
                    return new Integer(this.getSes(n));
                }
                case 4: {
                    return new Integer(this.getSas(n));
                }
                case 5: {
                    return new Integer(this.getUas(n));
                }
                case 6: {
                    return new Integer(this.getAis(n));
                }
            }
            return null;
        }
        catch (Exception exception) {
            db.println("Error in getValueAt " + exception);
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        try {
            if (db.on()) {
                db.println("Change in value " + n + " " + n2);
            }
            this.validatePmThresholds(this.pmType, (InterfaceModel)this.model[n], this.thresholdType, this.nearEnd, this.getColumnName(n2), object.toString());
            int n3 = -1;
            if (object instanceof Integer) {
                n3 = (Integer)object;
            } else if (object instanceof String) {
                n3 = Integer.parseInt((String)object);
            }
            if (n3 < 0) {
                Exception exception = new Exception();
                db.println("Error in setValueAt");
                SDebug.printStackTrace((Throwable)exception);
                return;
            }
            switch (n2) {
                case 1: {
                    this.thresholdsVal[n].cv = n3;
                    break;
                }
                case 2: {
                    this.thresholdsVal[n].es = n3;
                    break;
                }
                case 3: {
                    this.thresholdsVal[n].ses = n3;
                    break;
                }
                case 4: {
                    this.thresholdsVal[n].sas = n3;
                    break;
                }
                case 5: {
                    this.thresholdsVal[n].uas = n3;
                    break;
                }
                case 6: {
                    this.thresholdsVal[n].ais = n3;
                    break;
                }
            }
            if (db.on()) {
                db.println("marking row dirty");
            }
            this.rowDirty[n] = true;
            this.fireTableCellUpdated(n, n2);
        }
        catch (NumberFormatException numberFormatException) {
            db.severe("NumberFormatException caught in setValueAt");
            SDebug.printStackTrace((Throwable)numberFormatException);
        }
        catch (ProvisionError provisionError) {
            this.presentProvisionError(this.getColumnName(n2), provisionError);
        }
        catch (Exception exception) {
            db.severe("Error in setValueAt " + exception);
        }
    }
}

