/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.idl.Common.eReach;
import cerent.cms.idl.Common.eWavelength;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.DwdmCliLineModel;
import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.ISupportsOpticsProvExtModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OTU2XpModuleModel;
import cerent.cms.model.OpticsProvExtModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.BooleanCellRenderer;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.OpticsProvExtHelper;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.VariComboBoxCellEditor;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.dwdm.DwdmLineCellEditor;
import cerent.cms.ui.dwdm.DwdmLineProvTableModel;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.FixedLengthField;
import cerent.util.gui.MacAddrCellEditor;
import cerent.util.gui.SoakTimeCellEditor;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class DwdmLinePane
extends NodeProvPane
implements TableModelListener,
PropertyChangeListener {
    protected DwdmLineProvTableModel dataModel;
    protected DwdmModuleModel eqpmtModel;
    protected AbstractDwdmLineModel[] lineModels;
    OpticsProvExtModel[] opticModels;
    protected int numLines;
    protected PaneType pt;
    private boolean notInited = true;
    private ObservableManager _obsMgr;
    EtherLineModel[] ether;
    protected static final SDebug db = new SDebug("DwdmLinePane");

    public DwdmLinePane(String string, TabbedView tabbedView, AbstractDwdmLineModel[] abstractDwdmLineModelArray, PaneType paneType) {
        super(string, tabbedView);
        this.lineModels = abstractDwdmLineModelArray;
        this.numLines = abstractDwdmLineModelArray.length;
        this.eqpmtModel = (DwdmModuleModel)this.getUiModel();
        this.pt = paneType;
        this.updateOpticModels();
        this.registerWithModel();
    }

    @Override
    public void refreshMyLines(Object object) {
        if (!(object instanceof DwdmLineUpdate)) {
            return;
        }
        DwdmLineUpdate dwdmLineUpdate = (DwdmLineUpdate)object;
        switch (this.pt.value()) {
            case 1: {
                this.lineModels = dwdmLineUpdate.getDwdmTrkLineModels();
                break;
            }
            case 2: {
                if (((EntityModel)this.getUiModel()).getDescendantsOfEqType(279).isEmpty() && ((EntityModel)this.getUiModel()).getDescendantsOfEqType(326).isEmpty()) {
                    this.lineModels = dwdmLineUpdate.getDwdmCliLineModels();
                    break;
                }
                this.lineModels = dwdmLineUpdate.getDwdmLineModels();
                break;
            }
            case 4: {
                this.lineModels = this.eqpmtModel.get1GEthLines(dwdmLineUpdate.getDwdmCliLineModels());
                if (this.eqpmtModel.getEqType() != 293) break;
                this.lineModels = this.eqpmtModel.get10GELines(dwdmLineUpdate.getDwdmLineModels());
                break;
            }
            case 5: {
                if (!this.eqpmtModel.isPolluceCard()) break;
                this.lineModels = this.eqpmtModel.getEthGELines(dwdmLineUpdate.getDwdmLineModels());
                break;
            }
            default: {
                this.lineModels = dwdmLineUpdate.getDwdmLineModels();
            }
        }
        this.numLines = this.lineModels.length;
        this.updateOpticModels();
        if (!this.notInited) {
            this.getObsMgr().setObservable((Observable[])this.lineModels);
            this.getObsMgr().addObservable((Observable[])this.opticModels);
            this.ether = DwdmModuleModel.getEtherLineModels(this.lineModels);
            this.getObsMgr().addObservable((Observable[])this.ether);
            this.dataModel.refreshMyLines(this.lineModels, this.opticModels);
            try {
                this.setOpticsExtCellEditor(8, this.getEqpmtModel(), this.opticModels, db);
                this.setOpticsExtCellEditor(9, this.getEqpmtModel(), this.opticModels, db);
                this.setOpticsExtCellEditor(18, this.getEqpmtModel(), this.opticModels, db);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void init() {
        this.dataModel = this.getDataModel();
        this.dataModel.addTableModelListener(this);
        this.table = new UTableExt(this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(true);
        this.prepareColumns();
        this.getObsMgr().addObservable((Observable[])this.lineModels);
        this.ether = DwdmModuleModel.getEtherLineModels(this.lineModels);
        this.getObsMgr().addObservable((Observable[])this.ether);
        this.getObsMgr().addObservable((Observable[])this.opticModels);
        this.add((Component)uScrollPane, "Center");
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.notInited = false;
    }

    protected void prepareColumns() {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(0));
        tableColumn.setPreferredWidth(90);
        tableColumn.setCellRenderer(PORT_CELL_RENDERER);
        tableColumn.setMinWidth(90);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(1));
        tableColumn.setCellEditor(new DefaultCellEditor(new FixedLengthField()));
        tableColumn.setPreferredWidth(150);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(2));
        tableColumn.setMinWidth(100);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(3));
        tableColumn.setMinWidth(130);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(12));
        this.setAttrCellEditor(12, "FortyGMappingMode");
        tableColumn.sizeWidthToFit();
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(13));
        this.setAttrCellEditor(13, "FortyGOverclock");
        tableColumn.sizeWidthToFit();
        this.setAttrCellEditor(17, "Client Distance");
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(17));
        tableColumn.sizeWidthToFit();
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(19));
        this.setAttrCellEditor(19, "FortyGDpskVals");
        tableColumn.sizeWidthToFit();
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(16));
        tableColumn.setCellRenderer(new BooleanCellRenderer());
        tableColumn.sizeWidthToFit();
        tableColumn = null;
        if (this.isReachAndWave()) {
            this.setOpticsExtCellEditor(8, this.getEqpmtModel(), this.opticModels, db);
            this.setOpticsExtCellEditor(9, this.getEqpmtModel(), this.opticModels, db);
            this.setOpticsExtCellEditor(18, this.getEqpmtModel(), this.opticModels, db);
        } else {
            this.removeColumn(8);
            this.removeColumn(9);
            this.removeColumn(18);
        }
        int n = this.eqpmtModel.getEqType();
        if (this.pt.value() == 3) {
            this.removeColumn(5);
            this.removeColumn(6);
            this.removeColumn(11);
            if (this.eqpmtModel.isPolluceCard()) {
                this.removeColumn(12);
                this.setAttrCellEditor(10, "aisSquelch");
                tableColumn = this.table.getColumn(this.dataModel.getColumnName(10));
                tableColumn.sizeWidthToFit();
                this.removeColumn(19);
            } else {
                this.removeColumn(12);
                this.removeColumn(19);
                this.removeColumn(13);
                this.removeColumn(10);
                this.removeColumn(18);
            }
            this.removeColumn(14);
            this.removeColumn(15);
            this.removeColumn(16);
            this.removeColumn(17);
        } else {
            if (this.is10GEPayload()) {
                this.setAttrCellEditor(5, "G1000 Port Max Size");
                tableColumn = this.table.getColumn(this.dataModel.getColumnName(6));
                tableColumn.setCellEditor(new MacAddrCellEditor());
                tableColumn.sizeWidthToFit();
            } else {
                if (n != 273) {
                    this.removeColumn(5);
                }
                this.removeColumn(6);
            }
            if (this.eqpmtModel.isPolluceCard()) {
                this.setAttrCellEditor(5, "XM40GEthMaxSize");
                if (this.eqpmtModel.getEqType() == 300 || this.eqpmtModel.getEqType() == 358) {
                    this.removeColumn(5);
                }
                tableColumn = this.table.getColumn(this.dataModel.getColumnName(6));
                tableColumn.setCellEditor(new MacAddrCellEditor());
                tableColumn.sizeWidthToFit();
                this.removeColumn(6);
                this.removeColumn(14);
                this.removeColumn(15);
                if (this.pt.value() == 5) {
                    this.removeColumn(13);
                    this.removeColumn(18);
                    this.removeColumn(9);
                    this.removeColumn(19);
                    if (this.eqpmtModel.getEqType() == 300 || this.eqpmtModel.getEqType() == 358) {
                        this.removeColumn(12);
                    }
                }
            } else {
                this.removeColumn(12);
                this.removeColumn(13);
                this.removeColumn(18);
                this.removeColumn(19);
            }
            if (n == 243 || n == 282) {
                this.setAttrCellEditor(10, "disableSquelch");
                tableColumn = this.table.getColumn(this.dataModel.getColumnName(10));
                tableColumn.sizeWidthToFit();
            } else {
                this.removeColumn(10);
            }
            if (this.pt.value() == 4) {
                this.removeColumn(1);
                this.removeColumn(2);
                this.removeColumn(3);
                this.removeColumn(4);
                this.removeColumn(8);
                this.removeColumn(9);
                this.removeColumn(18);
                this.removeColumn(19);
                if (n != 293) {
                    this.setAttrCellEditor(5, "Adm10GEthMaxSize");
                    this.removeColumn(16);
                    this.removeColumn(17);
                }
                this.setAttrCellEditor(11, "EtherGeSpeed");
                tableColumn = this.table.getColumn(this.dataModel.getColumnName(14));
                JComboBox jComboBox = this.getComboBoxFor(this.dataModel.getPosFramingTypeAttrs());
                tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
                tableColumn.setPreferredWidth(100);
                tableColumn = this.table.getColumn(this.dataModel.getColumnName(15));
                tableColumn.setCellEditor(new DwdmLineCellEditor(this.lineModels, this.dataModel, this.getComboBoxFor(this.dataModel.getEncapCrcTypeAttrs()), jComboBox));
                tableColumn.setPreferredWidth(100);
            }
            if (this.pt.value() != 4 || n == 293 || this.eqpmtModel.isPolluceCard()) {
                this.removeColumn(11);
                if (this.eqpmtModel instanceof OTU2XpModuleModel) {
                    int n2;
                    block27: {
                        n2 = -1;
                        try {
                            n2 = ((OTU2XpModuleModel)this.eqpmtModel).getCardMode();
                        }
                        catch (NoSuchInterface noSuchInterface) {
                            if (db.on()) {
                                SDebug.printStackTrace((Throwable)noSuchInterface);
                            }
                        }
                        catch (WrongInterfaceType wrongInterfaceType) {
                            if (!db.on()) break block27;
                            SDebug.printStackTrace((Throwable)wrongInterfaceType);
                        }
                    }
                    if (n2 != 4 && n2 != 6) {
                        this.removeColumn(16);
                        this.removeColumn(17);
                    }
                } else {
                    if (n != 301 && n != 356) {
                        this.removeColumn(16);
                    }
                    this.removeColumn(17);
                }
                this.removeColumn(14);
                this.removeColumn(15);
            }
        }
    }

    protected void setOpticsExtCellEditor(int n, ModuleModel moduleModel, OpticsProvExtModel[] opticsProvExtModelArray, SDebug sDebug) {
        if (this.table.convertColumnIndexToView(n) == -1) {
            return;
        }
        if (this.isReachAndWave()) {
            int n2 = 90;
            String string = this.dataModel.columnNames[n];
            TableColumn tableColumn = this.table.getColumn(string);
            Attribute[][] attributeArray = null;
            switch (n) {
                case 8: {
                    attributeArray = OpticsProvExtHelper.getCombinedReaches(moduleModel, opticsProvExtModelArray, sDebug);
                    break;
                }
                case 9: {
                    n2 = 120;
                    attributeArray = OpticsProvExtHelper.getCombinedWavelengths(moduleModel, opticsProvExtModelArray, sDebug);
                    break;
                }
                case 18: {
                    n2 = 120;
                    attributeArray = OpticsProvExtHelper.getCombinedWavelengths(moduleModel, opticsProvExtModelArray, sDebug);
                }
            }
            tableColumn.setCellEditor(new VariComboBoxCellEditor(attributeArray));
            tableColumn.sizeWidthToFit();
            tableColumn.setMinWidth(n2);
        }
    }

    protected AttributeMaps getAttributeMap() {
        return ElementDefaults.getAttributeMap(this.getEqpmtModel());
    }

    protected ModuleModel getEqpmtModel() {
        return (ModuleModel)this.getUiModel();
    }

    private boolean is10GEPayload() {
        try {
            return this.lineModels.length > 0 && this.lineModels[0].getFramingType() == 2;
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return false;
        }
    }

    protected void setAttrCellEditor(int n, String string) {
        this.setAttrCellEditor(n, string, -1);
    }

    protected void setAttrCellEditor(int n, String string, int n2) {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(n));
        try {
            Object[] objectArray = this.getAttributeArray(string);
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(objectArray)));
            tableColumn.sizeWidthToFit();
            if (n2 == -1) {
                tableColumn.setPreferredWidth(tableColumn.getWidth());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            db.println("WARNING: cannot find attributes for " + string + "\nPlease edit ElementDefaults.java");
            this.table.removeColumn(tableColumn);
        }
    }

    protected void removeColumn(int n) {
        if (this.table.convertColumnIndexToView(n) == -1) {
            return;
        }
        TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(n));
        this.table.removeColumn(tableColumn);
    }

    private JComboBox getComboBoxFor(Object[] objectArray) {
        JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    protected DwdmLineProvTableModel getDataModel() {
        return new DwdmLineProvTableModel(this.lineModels, this.opticModels);
    }

    private int getTdmProtocolType() {
        return this.eqpmtModel.getNodeModel().getTdmProtocolType();
    }

    public Attribute[] getAttributeArray(String string) throws NoSuchElementException {
        Attribute[] attributeArray = ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeArray(string);
        if (attributeArray == null) {
            throw new NoSuchElementException();
        }
        return attributeArray;
    }

    protected List getAttributeList(Class clazz) {
        return ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeList("DWDM." + clazz.getName());
    }

    protected Attribute getAttribute(Class clazz, int n) {
        return ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeForVal("DWDM." + clazz.getName(), n);
    }

    @Override
    protected boolean queryRemainDirty() {
        return true;
    }

    @Override
    public void applyChangesToModel() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (AdminState.adminStateChangedToFormOfOOS(this.dataModel, this.lineModels)) {
            stringBuffer.append(AdminState.getBaseOosWarning(this.terms)).append('\n');
            bl = true;
        }
        if (bl) {
            String string = AdminState.getSevWarningMsg(this.dataModel, this.lineModels, false, true);
            stringBuffer.append(string).append("\n\n").append(this.getApplyString(false));
            if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)stringBuffer.toString(), (String)"Confirmation Dialog")) {
                return;
            }
        }
        try {
            this.dataModel.applyToModel();
            this.resetDirty();
        }
        catch (Exception exception) {
            this.refresh();
            throw exception;
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    @Override
    protected void changeMessage(Observable observable, Object object) {
        this.requestRefresh(observable, this.getRefreshThread(observable));
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            @Override
            public void run() {
                DwdmLinePane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = -1;
        if (this.lineModels != null) {
            n = Arrays.asList(this.lineModels).indexOf(observable);
        }
        if (n == -1 && this.ether != null) {
            n = Arrays.asList(this.ether).indexOf(observable);
        }
        if (n == -1 && this.opticModels != null) {
            n = Arrays.asList(this.opticModels).indexOf(observable);
        }
        if (n != -1 && this.dataModel != null && this.opticModels != null) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
            if (this.pt.value() != 4) {
                this.setOpticsExtCellEditor(8, this.getEqpmtModel(), this.opticModels, db);
                this.setOpticsExtCellEditor(9, this.getEqpmtModel(), this.opticModels, db);
                this.setOpticsExtCellEditor(18, this.getEqpmtModel(), this.opticModels, db);
            }
        } else if (db.on()) {
            db.println("In DwdmLinePane changeMessage cannot find Model " + observable);
        }
    }

    @Override
    public void dispose() {
        if (this._obsMgr != null) {
            this._obsMgr.reset();
        }
        super.dispose();
    }

    @Override
    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    @Override
    public void enteringPage() throws Exception {
        if (this.notInited) {
            this.init();
        }
        super.enteringPage();
        this.getObsMgr().setPassing(true);
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    @Override
    public void leavingPage() throws Exception {
        this.getObsMgr().setPassing(false);
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setDirty();
    }

    @Override
    public CSHelpID getHelpID() {
        if (this.eqpmtModel == null) {
            return CSHelpConst.DwdmLinePane;
        }
        if (this.is10GEPayload() && !DwdmModuleModel.isTxp10ECard(this.eqpmtModel.getEqType())) {
            return CSHelpConst.DwdmHdgeLineProvPane;
        }
        return CSHelpConst.DwdmLinePane;
    }

    private String[] getWlString(eWavelength[] eWavelengthArray) {
        String[] stringArray = new String[eWavelengthArray.length];
        for (int i = 0; i < eWavelengthArray.length; ++i) {
            stringArray[i] = Wavelength.getWavelengthStringFromWavelength(eWavelengthArray[i].value());
        }
        return stringArray;
    }

    private ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
        }
        return this._obsMgr;
    }

    protected boolean isReachAndWave() {
        boolean bl = true;
        switch (this.eqpmtModel.getEqType()) {
            case 118: {
                bl = false;
                break;
            }
            case 182: 
            case 276: {
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    private void updateOpticModels() {
        this.opticModels = new OpticsProvExtModel[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            InterfaceModel interfaceModel = this.lineModels[i] instanceof DwdmCliLineModel ? this.lineModels[i].getPayloadModel() : this.lineModels[i];
            if (!(interfaceModel instanceof ISupportsOpticsProvExtModel)) continue;
            this.opticModels[i] = (OpticsProvExtModel)((ISupportsOpticsProvExtModel)((Object)interfaceModel)).getOpticsProvExtModel();
        }
    }

    public static class PaneType {
        public static final int _DEFAULT = 0;
        public static final int _TRUNK = 1;
        public static final int _COMBO = 2;
        public static final int _PLUGGABLES = 3;
        public static final int _ADM_ETH = 4;
        public static final int _FORTYG_ETH = 5;
        public static final PaneType DEFAULT = new PaneType(0);
        public static final PaneType TRUNK = new PaneType(1);
        public static final PaneType COMBO = new PaneType(2);
        public static final PaneType PLUGGABLES = new PaneType(3);
        public static final PaneType ADM_ETH = new PaneType(4);
        public static final PaneType FORTYG_ETH = new PaneType(5);
        private int _val;

        private PaneType(int n) {
            this._val = n;
        }

        public int value() {
            return this._val;
        }
    }

    private class UTableExt
    extends UTable {
        private DefaultCellEditor stateEditor;
        private DefaultCellEditor nonAINSStateEditor;
        private DefaultCellEditor tdmAlsEditor;
        private DefaultCellEditor nonTdmAlsEditor;
        private SoakTimeCellEditor soakTimeEditor;

        public UTableExt(DwdmLineProvTableModel dwdmLineProvTableModel) {
            super((TableModel)dwdmLineProvTableModel);
            boolean bl = AdminState.isANSI(this.getTdmProtocolType());
            this.stateEditor = new DefaultCellEditor(DwdmLinePane.this.getComboBoxFor(AdminState.getDefaultAdminStates(bl)));
            this.nonAINSStateEditor = new DefaultCellEditor(DwdmLinePane.this.getComboBoxFor(AdminState.getAdminStatesNoAINS(bl)));
            this.tdmAlsEditor = new DefaultCellEditor(DwdmLinePane.this.getComboBoxFor(DwdmLinePane.this.getAttributeArray("AlsMode")));
            this.nonTdmAlsEditor = new DefaultCellEditor(DwdmLinePane.this.getComboBoxFor(DwdmLinePane.this.getAttributeArray("NoAutoAlsMode")));
            this.soakTimeEditor = new SoakTimeCellEditor(DwdmLinePane.this);
            TableColumn tableColumn = this.getColumn(this.getColumnName(7));
            tableColumn.setCellEditor(this.soakTimeEditor);
            tableColumn.setMinWidth(this.soakTimeEditor.getPreferredWidth() + 10);
            this.setRowHeight(this.soakTimeEditor.getPreferredHeight());
        }

        public TableCellEditor getCellEditor(int n, int n2) {
            boolean bl = false;
            boolean bl2 = false;
            int n3 = this.convertColumnIndexToModel(n2);
            if (DwdmLinePane.this.lineModels[n] != null) {
                bl = DwdmLinePane.this.lineModels[n].isSonetSdhPayload();
                bl2 = DwdmLinePane.this.lineModels[n].supportsAutoALS();
            }
            if (n3 == 2) {
                return DwdmLinePane.this.lineModels[n].supportsAINS() ? this.stateEditor : this.nonAINSStateEditor;
            }
            if (n3 == 4) {
                if (DwdmModuleModel.isTxp10ECard(DwdmLinePane.this.eqpmtModel.getEqType())) {
                    return this.tdmAlsEditor;
                }
                if (DwdmLinePane.this.eqpmtModel.getEqType() == 293 || DwdmLinePane.this.eqpmtModel.getEqType() == 272 || DwdmLinePane.this.eqpmtModel.getEqType() == 271 || DwdmLinePane.this.eqpmtModel.getEqType() == 300 || DwdmLinePane.this.eqpmtModel.getEqType() == 301 || DwdmLinePane.this.eqpmtModel.getEqType() == 356 || DwdmLinePane.this.eqpmtModel.getEqType() == 358) {
                    if (DwdmLinePane.this.lineModels[n].supportsAutoALS()) {
                        return this.tdmAlsEditor;
                    }
                    return this.nonTdmAlsEditor;
                }
                return bl ? this.tdmAlsEditor : this.nonTdmAlsEditor;
            }
            if (n3 == 7) {
                return this.soakTimeEditor;
            }
            if ((n3 == 9 || n3 == 18) && DwdmLinePane.this.pt == PaneType.PLUGGABLES) {
                return this.getWlCellEditor(n, n2);
            }
            return super.getCellEditor(n, n2);
        }

        private int getTdmProtocolType() {
            return DwdmLinePane.this.eqpmtModel.getNodeModel().getTdmProtocolType();
        }

        private TableCellEditor getWlCellEditor(int n, int n2) {
            boolean bl = DwdmLinePane.this.eqpmtModel.getState().value() != 0;
            eReach eReach2 = DwdmLinePane.this.dataModel.getSelectedReach(n);
            boolean bl2 = DwdmLinePane.this.lineModels[n] instanceof DwdmTrkLineModel;
            Object[] objectArray = this.getWlsByReach(eReach2, bl2);
            DefaultCellEditor defaultCellEditor = new DefaultCellEditor(DwdmLinePane.this.getComboBoxFor(objectArray));
            if (bl) {
                String[] stringArray;
                block3: {
                    stringArray = null;
                    try {
                        stringArray = DwdmLinePane.this.getWlString(DwdmLinePane.this.opticModels[n].getLineWavelengths());
                    }
                    catch (Exception exception) {
                        if (!db.on()) break block3;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                }
                ((JComboBox)defaultCellEditor.getComponent()).setRenderer(new WavelengthListCellRenderer(stringArray));
            }
            return defaultCellEditor;
        }

        private Attribute[] getWlsByReach(eReach eReach2, boolean bl) {
            boolean bl2 = DwdmLinePane.this.eqpmtModel.isPolluceCard();
            Attribute[] attributeArray = null;
            switch (eReach2.value()) {
                case 49: {
                    attributeArray = this.getDwdmWl();
                    break;
                }
                case 48: {
                    attributeArray = this.getCwdmWl(true);
                    break;
                }
                case 31: {
                    attributeArray = this.getSimpleArray(172);
                    break;
                }
                case 45: {
                    attributeArray = this.addArray(this.getSimpleArray(172), new Attribute[]{Wavelength.getWlAttribute(73)});
                    break;
                }
                case 3: 
                case 11: 
                case 12: 
                case 32: {
                    attributeArray = this.getSimpleArray(73);
                    break;
                }
                case 44: {
                    attributeArray = this.getSimpleArray(73);
                    attributeArray = this.addArray(attributeArray, new Attribute[]{Wavelength.getWlAttribute(74)});
                    if (!bl) break;
                    attributeArray = this.addArray(attributeArray, Wavelength.getWavelengthAttrs(0, 0, false));
                    break;
                }
                case 7: 
                case 13: 
                case 37: 
                case 43: 
                case 47: {
                    attributeArray = this.getSimpleArray(74);
                    break;
                }
                default: {
                    if (bl) {
                        if (!bl2) {
                            attributeArray = this.getAllWl();
                            break;
                        }
                        attributeArray = this.addArray(Wavelength.getWavelengthAttrs(0, 0, true), Wavelength.getWavelengthAttrs(0, 1, false));
                        break;
                    }
                    attributeArray = this.addArray(this.getSimpleArray(172), new Attribute[]{Wavelength.getWlAttribute(73)});
                    attributeArray = this.addArray(attributeArray, this.getCwdmWl(false));
                }
            }
            return attributeArray;
        }

        private Attribute[] getSimpleArray(int n) {
            Attribute[] attributeArray = new Attribute[]{Wavelength.getFirstTunableWLAttr(), Wavelength.getWlAttribute(n)};
            return attributeArray;
        }

        private Attribute[] getAllWl() {
            return Wavelength.getAllWavelengthAttrs(true);
        }

        private Attribute[] getCwdmWl(boolean bl) {
            return Wavelength.getCwdmWavelengthAttrs(bl);
        }

        private Attribute[] getDwdmWl() {
            Attribute[] attributeArray = this.addArray(Wavelength.getWavelengthAttrs(0, 0, true), Wavelength.getWavelengthAttrs(0, 1, false));
            attributeArray = this.addArray(attributeArray, Wavelength.getWavelengthAttrs(1, 0, false));
            attributeArray = this.addArray(attributeArray, Wavelength.getWavelengthAttrs(1, 1, false));
            return attributeArray;
        }

        private Attribute[] addArray(Attribute[] attributeArray, Attribute[] attributeArray2) {
            Attribute[] attributeArray3 = new Attribute[attributeArray.length + attributeArray2.length];
            System.arraycopy(attributeArray, 0, attributeArray3, 0, attributeArray.length);
            System.arraycopy(attributeArray2, 0, attributeArray3, attributeArray.length, attributeArray2.length);
            Arrays.sort(attributeArray3, 1, attributeArray3.length, new Wavelength.AttrSorter());
            return attributeArray3;
        }
    }

    private class WavelengthListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        protected Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        private String[] tunableWavelength;

        public WavelengthListCellRenderer(String[] stringArray) {
            this.setOpaque(true);
            this.tunableWavelength = stringArray;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = object.toString();
            Color color = Color.lightGray;
            boolean bl3 = false;
            if (this.tunableWavelength != null) {
                for (int i = 0; i < this.tunableWavelength.length; ++i) {
                    if (!string.equals(this.tunableWavelength[i])) continue;
                    bl3 = true;
                    break;
                }
            }
            if (bl3) {
                string = string + " **";
                color = Color.white;
            }
            this.setText(string);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
            } else {
                this.setBackground(color);
            }
            this.setForeground(Color.black);
            this.setEnabled(jList.isEnabled() && DwdmLinePane.this.isUserAuthorized());
            this.setFont(jList.getFont());
            this.setBorder(bl2 ? UIManager.getBorder("List.focusCellHighlightBorder") : this.noFocusBorder);
            return this;
        }
    }
}

