/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.eReach;
import cerent.cms.idl.Common.eWavelength;
import cerent.cms.idl.Common.sEtherMacAddr;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.idl.Dwdm.eAisSquelchMode;
import cerent.cms.idl.Dwdm.eDataRate;
import cerent.cms.idl.Dwdm.eDwdmDpsk;
import cerent.cms.idl.EtherMedia.eEncapCrcType;
import cerent.cms.idl.EtherMedia.eEtherSpeed;
import cerent.cms.idl.EtherMedia.eFlowControlNegotiated;
import cerent.cms.idl.EtherMedia.ePosFramingType;
import cerent.cms.idl.EtherMedia.sL1Info;
import cerent.cms.idl.EtherMedia.sML2PosPortAdminInfo;
import cerent.cms.idl.If.eALSMode;
import cerent.cms.idl.If.eClientDist;
import cerent.cms.idl.If.sClientDistAttr;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DetailedConfigError;
import cerent.cms.model.DwdmCliLineModel;
import cerent.cms.model.DwdmOTULineModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.HdGeLineModel;
import cerent.cms.model.IOpticsProvExtModel;
import cerent.cms.model.IServiceState;
import cerent.cms.model.InvalidState;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NotSupportedOnEquipment;
import cerent.cms.model.OTU2XpModuleModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.enumeration.EtherEnumStrings;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.IAdminTableAccess;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.dwdm.DwdmTableModel;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.MacAddrFormat;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.WID;
import cerent.util.gui.SoakTimePropertyEditor;
import java.awt.Component;

public class DwdmLineProvTableModel
extends DwdmTableModel
implements IAdminTableAccess {
    private IOpticsProvExtModel[] opticModels;
    private long[] macAddr;
    private Attribute[] frameSize;
    protected AdminState[] adminState;
    protected IServiceState[] serviceState;
    protected Attribute[] alsMode;
    protected int[] soakTime;
    protected Attribute[] reach;
    protected Attribute[] wavelength;
    protected Attribute[] squelch;
    protected Attribute[] negotiationMode;
    protected Attribute[] fortyGMode;
    protected Attribute[] fortyGOverclock;
    protected Attribute[] ethFramingType;
    protected Attribute[] ethEncapMode;
    protected Boolean[] flowControl;
    protected Attribute[] clientDistance;
    protected Attribute[] rxWavelength;
    protected Attribute[] dpskVal;
    public static final int LINENUMBER_INDEX = 0;
    public static final int PORTNAME_INDEX = 1;
    public static final int ADMIN_STATE_INDEX = 2;
    public static final int SERVICE_STATE_INDEX = 3;
    public static final int ALS_MODE_INDEX = 4;
    public static final int FRAME_SIZE_INDEX = 5;
    public static final int MAC_ADDR_INDEX = 6;
    public static final int AINS_SOAK_INDEX = 7;
    public static final int REACH_INDEX = 8;
    public static final int WAVELENGTH_INDEX = 9;
    public static final int AIS_SQUELCH_INDEX = 10;
    public static final int NEGOTIATION_MODE_INDEX = 11;
    public static final int FORTYG_MODE = 12;
    public static final int FORTYG_OVERCLOCK = 13;
    public static final int ETH_FRAMING_TYPE = 14;
    public static final int ETH_CRC_ENCAP = 15;
    public static final int ENABLE_FLOW_CONTROL = 16;
    public static final int CLIENT_DISTANCE = 17;
    public static final int TRK_RX_WL = 18;
    public static final int DPSK_VAL = 19;
    public static final int NEXT_COLUMN_INDEX = 20;
    protected String[] columnNames = new String[]{"Port", "Port Name", "Admin State", "Service State", "ALS Mode", "MTU", "Incoming MAC Address", "AINS Soak", "Reach", "Wavelength", "Squelch", "Mode", "Mapping Mode", "Overclock", "Framing", "CRC Encap", "Enable Flow Control", "Client Distance", "Rx Wavelength", "Modulation"};
    protected boolean[][] isDirty;
    private boolean FlgDlgAlreadyShowed = false;
    private static final SDebug db = new SDebug("DwdmLineProvTableModel");

    public DwdmLineProvTableModel(AbstractDwdmLineModel[] abstractDwdmLineModelArray, IOpticsProvExtModel[] iOpticsProvExtModelArray) {
        super(db, abstractDwdmLineModelArray);
        this.refreshMyLines(abstractDwdmLineModelArray, iOpticsProvExtModelArray);
    }

    public void refreshMyLines(AbstractDwdmLineModel[] abstractDwdmLineModelArray, IOpticsProvExtModel[] iOpticsProvExtModelArray) {
        int n;
        super.refreshMyLines(abstractDwdmLineModelArray);
        this.opticModels = iOpticsProvExtModelArray;
        this.adminState = new AdminState[this.numLines];
        this.serviceState = new IServiceState[this.numLines];
        this.alsMode = new Attribute[this.numLines];
        this.frameSize = new Attribute[this.numLines];
        this.macAddr = new long[this.numLines];
        this.soakTime = new int[this.numLines];
        this.reach = new Attribute[this.numLines];
        this.wavelength = new Attribute[this.numLines];
        this.squelch = new Attribute[this.numLines];
        this.negotiationMode = new Attribute[this.numLines];
        this.fortyGMode = new Attribute[this.numLines];
        this.fortyGOverclock = new Attribute[this.numLines];
        this.ethFramingType = new Attribute[this.numLines];
        this.ethEncapMode = new Attribute[this.numLines];
        this.flowControl = new Boolean[this.numLines];
        this.clientDistance = new Attribute[this.numLines];
        this.rxWavelength = new Attribute[this.numLines];
        this.dpskVal = new Attribute[this.numLines];
        for (n = 0; n < this.numLines; ++n) {
            this.macAddr[n] = -1L;
        }
        for (n = 0; n < this.numLines; ++n) {
            this.soakTime[n] = -1;
        }
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.numLines;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    public Class getColumnClass(int n) {
        if (n == 16) {
            return Boolean.class;
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        block38: {
            DwdmTrkLineModel dwdmTrkLineModel;
            block40: {
                block39: {
                    if (this.model == null || this.numLines <= 0 || n2 == 3) break block38;
                    if (n2 == 14) break block39;
                    if (n2 != 15) break block40;
                }
                return true;
            }
            if (n2 == 8 || n2 == 9) {
                if (this.model[n] instanceof DwdmTrkLineModel) {
                    if (this.eqpmtModel.isPolluceCard() && n2 == 8) {
                        return false;
                    }
                    DwdmTrkLineModel dwdmTrkLineModel2 = (DwdmTrkLineModel)this.model[n];
                    return dwdmTrkLineModel2.isPluggableTrk();
                }
                if (this.model[n] instanceof DwdmCliLineModel || this.model[n] instanceof DwdmOTULineModel) {
                    if (this.eqpmtModel.getEqType() == 300 || this.eqpmtModel.getEqType() == 358) {
                        return false;
                    }
                    if (n2 == 8) {
                        try {
                            if (this.model[n].getEqTypeFromDataRate().value() == 322 || this.model[n].getEqTypeFromDataRate().value() == 323 || this.model[n].getEqTypeFromDataRate().value() == 173) {
                                return false;
                            }
                        }
                        catch (NoSuchInterface noSuchInterface) {
                            SDebug.printStackTrace((Throwable)noSuchInterface);
                        }
                        catch (WrongInterfaceType wrongInterfaceType) {
                            SDebug.printStackTrace((Throwable)wrongInterfaceType);
                        }
                    }
                }
            }
            if (n2 == 7) {
                boolean bl = true;
                if (this.model[n] instanceof DwdmTrkLineModel) {
                    DwdmTrkLineModel dwdmTrkLineModel3 = (DwdmTrkLineModel)this.model[n];
                    bl = !dwdmTrkLineModel3.isInterlink();
                    bl = bl && dwdmTrkLineModel3.supportsAINS();
                } else if (this.model[n] instanceof DwdmCliLineModel) {
                    DwdmCliLineModel dwdmCliLineModel = (DwdmCliLineModel)this.model[n];
                    bl = dwdmCliLineModel.supportsAINS();
                }
                return bl;
            }
            if (n2 == 5 && this.eqpmtModel.isPolluceCard()) {
                return false;
            }
            if (n2 == 13) {
                if (this.model[n] instanceof DwdmTrkLineModel) {
                    dwdmTrkLineModel = (DwdmTrkLineModel)this.model[n];
                    try {
                        if (this.eqpmtModel.isPolluceCard() && this.model[n].isClient()) {
                            return false;
                        }
                    }
                    catch (NoSuchInterface noSuchInterface) {
                        SDebug.printStackTrace((Throwable)noSuchInterface);
                    }
                    catch (WrongInterfaceType wrongInterfaceType) {
                        SDebug.printStackTrace((Throwable)wrongInterfaceType);
                    }
                } else {
                    return false;
                }
            }
            if (n2 == 16 && this.eqpmtModel.isPolluceCard()) {
                boolean bl = this.model[n].getPayloadModel() instanceof HdGeLineModel;
                return bl && ((HdGeLineModel)this.model[n].getPayloadModel()).hasChildWISPort() || !bl;
            }
            if (n2 == 16 || n2 == 17) {
                return this.isOtu2inLANWAN() && n == 0;
            }
            if (n2 == 18) {
                if (this.model[n] instanceof DwdmTrkLineModel) {
                    dwdmTrkLineModel = (DwdmTrkLineModel)this.model[n];
                    if (this.eqpmtModel.isPolluceCard()) {
                        return true;
                    }
                } else {
                    return false;
                }
            }
            if (n2 == 19) {
                if (this.model[n] instanceof DwdmTrkLineModel) {
                    dwdmTrkLineModel = (DwdmTrkLineModel)this.model[n];
                    return this.eqpmtModel.getEqType() == 356 || this.eqpmtModel.getEqType() == 358;
                }
                return false;
            }
            if (AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.PROVISIONING) && (!this.isProtectedTrunkPort(n) || n2 != 4)) {
                if (n2 == 10) {
                    return this.isSquelchSettable(n);
                }
                return n2 == 4 ? this.isAlsSettable(n, n2) : n2 > 0;
            }
        }
        return false;
    }

    private boolean isOtu2inLANWAN() {
        if (this.eqpmtModel instanceof OTU2XpModuleModel) {
            int n;
            block6: {
                n = -1;
                try {
                    n = ((OTU2XpModuleModel)this.eqpmtModel).getCardMode();
                }
                catch (NoSuchInterface noSuchInterface) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)noSuchInterface);
                    }
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    if (!db.on()) break block6;
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
            if (n == 4 || n == 6) {
                return true;
            }
        }
        return false;
    }

    private boolean isAlsSettable(int n, int n2) {
        if (n2 != 4 || this.model[n] == null) {
            return true;
        }
        return this.model[n].isAlsSettable();
    }

    @Override
    protected boolean isProtectedTrunkPort(int n) {
        if (this.model[n].isCatinaccioTrunk()) {
            return false;
        }
        return super.isProtectedTrunkPort(n);
    }

    public boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    @Override
    public boolean isAdminStateDirty(int n) {
        return this.isDirty(n, 2);
    }

    public boolean isRowDirty(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.isDirty(n, i)) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.isRowDirty(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getPortDescriptionFor(n);
                }
                case 1: {
                    return this.getPortName(n);
                }
                case 4: {
                    return this.getAlsMode(n);
                }
                case 2: {
                    return this.getAdminState(n).toString(this.getTerms());
                }
                case 3: {
                    return this.getServiceState(n).toString(this.getTerms());
                }
                case 5: {
                    return this.getMaxFrameSize(n);
                }
                case 6: {
                    return this.getMacAddress(n);
                }
                case 7: {
                    return this.getSoakTimeAsHHMM(n);
                }
                case 8: {
                    return this.getReach(n);
                }
                case 9: {
                    return this.getWavelength(n);
                }
                case 10: {
                    return this.getAisSquelchMode(n);
                }
                case 11: {
                    return this.getNegotiationMode(n);
                }
                case 12: {
                    return this.getFortyGMode(n);
                }
                case 13: {
                    return this.getFortyGOverclock(n);
                }
                case 14: {
                    return this.getFramingType(n);
                }
                case 15: {
                    return this.getEthCrcEncap(n);
                }
                case 16: {
                    return this.getEnableFlowControl(n);
                }
                case 17: {
                    return this.getClientDistance(n);
                }
                case 18: {
                    return this.getRxWavelength(n);
                }
                case 19: {
                    return this.getDpskVal(n);
                }
            }
            return "";
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("DwdmLineProvTableModel: error in getValueAt" + exception);
            }
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    private Attribute getReach(int n) {
        if (this.reach[n] == null) {
            eReach eReach2 = null;
            Attribute attribute = null;
            try {
                eReach2 = this.opticModels[n].getLineReach();
                this.reach[n] = attribute = this.getAttributeMap().getAttributeForVal("declDwdmReach", eReach2.value());
            }
            catch (UnsupportedOperation unsupportedOperation) {
                this.reach[n] = attribute = this.getAttributeMap().getAttributeForVal("declDwdmReach", 0);
            }
            catch (Exception exception) {
                if (db.on()) {
                    db.println("DwdmLineProvTableModel: " + exception);
                }
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return this.reach[n];
    }

    public eReach getSelectedReach(int n) {
        eReach eReach2 = eReach.REACH_AUTOPROV;
        if (this.reach[n] != null) {
            eReach2 = eReach.from_int(this.reach[n].getValue());
        }
        return eReach2;
    }

    private Attribute getWavelength(int n) {
        if (this.wavelength[n] == null) {
            eWavelength eWavelength2 = eWavelength.WV_UNKNOWN;
            try {
                eWavelength2 = this.opticModels[n].getLineWavelength();
            }
            catch (UnsupportedOperation unsupportedOperation) {
                if (db.on()) {
                    db.println("DwdmLineProvTableModel: " + (Object)((Object)unsupportedOperation));
                }
            }
            catch (Exception exception) {
                if (db.on()) {
                    db.println("DwdmLineProvTableModel: " + exception);
                }
                SDebug.printStackTrace((Throwable)exception);
            }
            this.wavelength[n] = Wavelength.getWlAttribute(eWavelength2.value());
        }
        return this.wavelength[n];
    }

    @Override
    public AdminState getAdminState(int n) throws Exception {
        if (this.adminState[n] == null) {
            eAdminState eAdminState2 = this.model[n].getAdminStateEnum();
            this.adminState[n] = AdminState.enumToAdminState(eAdminState2);
        }
        return this.adminState[n];
    }

    private IServiceState getServiceState(int n) throws NoSuchInterface {
        if (this.serviceState[n] == null) {
            sServiceState sServiceState2 = this.model[n].getServiceState();
            this.serviceState[n] = ServiceStateFactory.getServiceState(sServiceState2);
        }
        return this.serviceState[n];
    }

    private TDMTerminology getTerms() {
        return this.eqpmtModel.getNodeModel().getTDMTerminology();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (db.on()) {
            db.println("Change in value row=" + n + " col=" + n2 + " newVal=" + object);
        }
        try {
            switch (n2) {
                case 1: {
                    this.portNames[n] = (String)object;
                    break;
                }
                case 4: {
                    Attribute attribute = (Attribute)object;
                    if (!this.model[n].supportsAutoALS() && eALSMode.from_int(attribute.getIntValue()) == eALSMode.AUTO) {
                        ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_AUTO_RESTART_NOT_SUPPORTED);
                        return;
                    }
                    if (attribute == this.alsMode[n]) {
                        return;
                    }
                    this.alsMode[n] = attribute;
                    break;
                }
                case 2: {
                    AdminState adminState = (AdminState)object;
                    if (adminState.equals(this.adminState[n])) {
                        return;
                    }
                    this.adminState[n] = adminState;
                    break;
                }
                case 5: {
                    Attribute attribute = (Attribute)object;
                    if (attribute == this.frameSize[n]) {
                        return;
                    }
                    this.frameSize[n] = attribute;
                    break;
                }
                case 6: {
                    long l = MacAddrFormat.parseMacAddr((String)object);
                    if (this.macAddr[n] == l) {
                        return;
                    }
                    this.macAddr[n] = l;
                    break;
                }
                case 7: {
                    int n3 = this.soakTime[n];
                    try {
                        n3 = SoakTimePropertyEditor.toIntValue((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {
                        db.fine("Number Format Exception on " + (String)object);
                    }
                    if (this.soakTime[n] == n3) {
                        return;
                    }
                    this.soakTime[n] = n3;
                    break;
                }
                case 8: {
                    this.reach[n] = (Attribute)object;
                    break;
                }
                case 9: {
                    this.wavelength[n] = (Attribute)object;
                    break;
                }
                case 10: {
                    this.squelch[n] = (Attribute)object;
                    break;
                }
                case 11: {
                    this.negotiationMode[n] = (Attribute)object;
                    break;
                }
                case 12: {
                    this.fortyGMode[n] = (Attribute)object;
                    break;
                }
                case 13: {
                    this.fortyGOverclock[n] = (Attribute)object;
                    break;
                }
                case 14: {
                    this.ethFramingType[n] = (Attribute)object;
                    break;
                }
                case 15: {
                    this.ethEncapMode[n] = (Attribute)object;
                    break;
                }
                case 16: {
                    this.flowControl[n] = (Boolean)object;
                    break;
                }
                case 17: {
                    this.clientDistance[n] = (Attribute)object;
                    break;
                }
                case 18: {
                    this.rxWavelength[n] = (Attribute)object;
                    break;
                }
                case 19: {
                    this.dpskVal[n] = (Attribute)object;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return;
        }
        this.isDirty[n][n2] = true;
        this.fireTableCellUpdated(n, n2);
    }

    private void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.refreshLineFromModel(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void refreshLineFromModel(int n) {
        if (n > this.numLines || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        this.resetLineCache(n);
        this.FlgDlgAlreadyShowed = false;
        this.fireTableRowsUpdated(n, n);
    }

    protected void resetLineCache(int n) {
        this.portNames[n] = null;
        this.adminState[n] = null;
        this.serviceState[n] = null;
        this.alsMode[n] = null;
        this.macAddr[n] = -1L;
        this.frameSize[n] = null;
        this.soakTime[n] = -1;
        this.reach[n] = null;
        this.wavelength[n] = null;
        this.squelch[n] = null;
        this.negotiationMode[n] = null;
        this.fortyGMode[n] = null;
        this.fortyGOverclock[n] = null;
        this.ethFramingType[n] = null;
        this.ethEncapMode[n] = null;
        this.flowControl[n] = null;
        this.clientDistance[n] = null;
        this.rxWavelength[n] = null;
        this.dpskVal[n] = null;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    protected eAdminState getAdminStateFor(int n) throws Exception {
        return this.getAdminState(n).getAdminStateEnum();
    }

    public void applyToModel() throws Exception {
        int n = 0;
        try {
            for (n = 0; n < this.numLines; ++n) {
                Object object;
                Object object2;
                if (this.isDirty(n, 1)) {
                    this.model[n].setAlias(this.getPortName(n));
                    this.isDirty[n][1] = false;
                }
                if (this.isDirty(n, 4)) {
                    if (this.model[n].isSplitterProtectedLine() && !this.model[n].isCatinaccioTrunk() && this.alsMode[n].getIntValue() != 0) {
                        if (!this.FlgDlgAlreadyShowed) {
                            ErrorMsg.displayWarning(null, (WID)EMC.WID_ALS_WONT_ENGAGE);
                        }
                        this.FlgDlgAlreadyShowed = true;
                    }
                    this.model[n].setALSMode(this.getAlsMode(n).getIntValue());
                    this.isDirty[n][4] = false;
                }
                if (this.isDirty(n, 2)) {
                    if (db.on()) {
                        db.fine("setting line to admin state " + this.getAdminState(n).toString());
                    }
                    this.model[n].setAdminStateNoLpbk(this.getAdminStateFor(n));
                    this.isDirty[n][2] = false;
                }
                if (this.isDirty(n, 5)) {
                    if (this.eqpmtModel.isADMCard()) {
                        this.setAdmEthL1Info(n);
                        this.isDirty[n][11] = false;
                    } else {
                        this.model[n].setMaxFrame(this.getMaxFrameSize(n).getIntValue());
                    }
                    this.isDirty[n][5] = false;
                }
                if (this.isDirty[n][6]) {
                    this.model[n].setMacAddress(new sEtherMacAddr(MacAddrFormat.toBytes(this.macAddr[n])));
                    this.isDirty[n][6] = false;
                }
                if (this.isDirty(n, 7)) {
                    if (db.on()) {
                        db.println("setting line soakTime " + this.getSoakTime(n));
                    }
                    this.model[n].setSoakTime(this.getSoakTime(n));
                }
                if (this.isDirty(n, 8)) {
                    boolean bl = true;
                    if (this.model[n] instanceof DwdmTrkLineModel) {
                        object2 = (DwdmTrkLineModel)this.model[n];
                        bl = ((DwdmTrkLineModel)object2).isPluggableTrk();
                    }
                    if (bl) {
                        object2 = this.getReach(n);
                        if (db.on()) {
                            db.println("setting reach " + object2);
                            db.println("Model is " + this.model[n]);
                        }
                        if (((eReach)(object = eReach.from_int(((Attribute)object2).getValue()))).value() != 0) {
                            this.opticModels[n].setLineReach((eReach)object);
                        }
                    }
                }
                if (this.isDirty(n, 9)) {
                    Attribute attribute = this.getWavelength(n);
                    if (db.on()) {
                        db.println("setting wave " + attribute);
                    }
                    if (((eWavelength)(object2 = eWavelength.from_int(attribute.getValue()))).value() != 174) {
                        this.opticModels[n].setLineWavelength((eWavelength)object2);
                    }
                }
                if (this.isDirty(n, 10)) {
                    eAisSquelchMode eAisSquelchMode2 = eAisSquelchMode.from_int(this.getAisSquelchMode(n).getIntValue());
                    this.model[n].setAisSquelchMode(eAisSquelchMode2);
                    this.isDirty[n][10] = false;
                }
                if (this.isDirty(n, 11)) {
                    this.setAdmEthL1Info(n);
                    this.isDirty[n][11] = false;
                    this.isDirty[n][5] = false;
                }
                if (this.isDirty(n, 12)) {
                    this.model[n].setEMappingMode(this.getFortyGMode(n).getIntValue());
                    this.isDirty[n][12] = false;
                }
                if (this.isDirty(n, 13)) {
                    this.model[n].setOverclock(this.getFortyGOverclock(n).getIntValue());
                    this.isDirty[n][13] = false;
                }
                if (this.isDirty(n, 14)) {
                    this.setAdmPosAdminInfo(n);
                    this.isDirty[n][14] = false;
                    this.isDirty[n][15] = false;
                }
                if (this.isDirty(n, 15)) {
                    this.setAdmPosAdminInfo(n);
                    this.isDirty[n][15] = false;
                    this.isDirty[n][14] = false;
                }
                if (this.isDirty(n, 16) && this.isDirty(n, 17)) {
                    this.setDistanceExtension(n);
                    this.isDirty[n][16] = false;
                    this.isDirty[n][17] = false;
                }
                if (this.isDirty(n, 16)) {
                    if (this.eqpmtModel.isPolluceCard()) {
                        this.set40GFlowCtrlAdmEthL1Info(n);
                    } else {
                        this.setDistanceExtension(n);
                    }
                    this.isDirty[n][16] = false;
                }
                if (this.isDirty(n, 17)) {
                    this.setDistanceExtension(n);
                    this.isDirty[n][17] = false;
                }
                if (this.isDirty(n, 18)) {
                    Attribute attribute = this.getRxWavelength(n);
                    if (db.on()) {
                        db.println("setting wave " + attribute);
                    }
                    if (((eWavelength)(object2 = eWavelength.from_int(attribute.getValue()))).value() != 174 && this.model[n] instanceof DwdmTrkLineModel) {
                        object = (DwdmTrkLineModel)this.model[n];
                        ((DwdmTrkLineModel)object).setRxWavelength((eWavelength)object2);
                        this.isDirty[n][18] = false;
                    }
                }
                if (!this.isDirty(n, 19)) continue;
                Attribute attribute = this.getDpskVal(n);
                object2 = eDwdmDpsk.from_int(attribute.getValue());
                if (!(this.model[n] instanceof DwdmTrkLineModel)) continue;
                object = (DwdmTrkLineModel)this.model[n];
                ((DwdmTrkLineModel)object).setDpskVal((eDwdmDpsk)object2);
                this.isDirty[n][19] = false;
            }
        }
        catch (DetailedConfigError detailedConfigError) {
            throw new ConfigError(detailedConfigError.getMessage());
        }
        catch (UnsupportedOperation unsupportedOperation) {
            throw new AnnotatedException("An error occurred while applying changes to row " + (n + 1), (Exception)((Object)unsupportedOperation));
        }
        catch (Exception exception) {
            throw new AnnotatedException("An error occurred while applying changes to row " + (n + 1) + ".", exception);
        }
    }

    private void setDistanceExtension(int n) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation, InvalidState {
        sClientDistAttr sClientDistAttr2 = new sClientDistAttr();
        sClientDistAttr2.enablePauseFrame = this.getEnableFlowControl(n);
        sClientDistAttr2.clientDist = eClientDist.from_int(this.getClientDistance(n).getIntValue());
        this.model[n].setClientDistanceAttr(sClientDistAttr2);
    }

    private void setAdmEthL1Info(int n) throws NoSuchInterface, WrongInterfaceType, NotSupportedOnEquipment, EMCProvisionError, ConfigError {
        HdGeLineModel hdGeLineModel = (HdGeLineModel)this.model[n].getPayloadModel();
        sL1Info sL1Info2 = null;
        sL1Info2 = hdGeLineModel.getEtherL1Info();
        sL1Info2.mtu = this.getMaxFrameSize(n).getIntValue();
        sL1Info2.speed = eEtherSpeed.from_int(this.getNegotiationMode(n).getIntValue());
        hdGeLineModel.setEtherL1Info(sL1Info2);
    }

    private void set40GFlowCtrlAdmEthL1Info(int n) throws NoSuchInterface, WrongInterfaceType, NotSupportedOnEquipment, EMCProvisionError, ConfigError {
        HdGeLineModel hdGeLineModel = (HdGeLineModel)this.model[n].getPayloadModel();
        sL1Info sL1Info2 = null;
        sL1Info2 = hdGeLineModel.getEtherL1Info();
        try {
            sL1Info2.flowControl = eFlowControlNegotiated.from_int(this.getEnableFlowControl(n) != false ? 3 : 0);
        }
        catch (UnsupportedOperation unsupportedOperation) {
            throw new NotSupportedOnEquipment(unsupportedOperation.getMessage());
        }
        hdGeLineModel.setEtherL1Info(sL1Info2);
    }

    private void setAdmPosAdminInfo(int n) throws NoSuchInterface, WrongInterfaceType, EMCProvisionError, ConfigError {
        block3: {
            try {
                HdGeLineModel hdGeLineModel = (HdGeLineModel)this.model[n].getPayloadModel();
                int n2 = this.model[n].getPortModel().getPortNum()[0];
                sML2PosPortAdminInfo sML2PosPortAdminInfo2 = null;
                if (this.eqpmtModel.isADMCard()) {
                    sML2PosPortAdminInfo2 = hdGeLineModel.getAdmPosPortInfo(n2);
                    sML2PosPortAdminInfo2.framingType = ePosFramingType.from_int(this.getFramingType(n).getIntValue());
                    sML2PosPortAdminInfo2.payloadCrcType = eEncapCrcType.from_int(this.getEthCrcEncap(n).getIntValue());
                    hdGeLineModel.setAdmPosPortInfo(sML2PosPortAdminInfo2, n2);
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!db.on()) break block3;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
    }

    private Attribute getAlsMode(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.alsMode[n] == null) {
            try {
                this.alsMode[n] = this.getAttributeFor("AlsMode", this.model[n].getALSMode());
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                this.alsMode[n] = new Attribute("N/A", -1);
            }
        }
        return this.alsMode[n];
    }

    private Attribute getMaxFrameSize(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.frameSize[n] == null) {
            int n2 = 1548;
            String string = null;
            if (this.eqpmtModel.isADMCard()) {
                sL1Info sL1Info2 = this.getAdmL1Info(n);
                if (sL1Info2 != null) {
                    n2 = sL1Info2.mtu;
                    string = "Adm10GEthMaxSize";
                }
            } else if (this.eqpmtModel.isPolluceCard()) {
                n2 = this.model[n].getMaxFrame();
                string = "XM40GEthMaxSize";
            } else {
                n2 = this.model[n].getMaxFrame();
                string = "G1000 Port Max Size";
            }
            this.frameSize[n] = this.getAttributeFor(string, n2);
        }
        return this.frameSize[n];
    }

    private Attribute getNegotiationMode(int n) {
        if (this.negotiationMode[n] == null && this.eqpmtModel.isADMCard()) {
            int n2 = 3;
            sL1Info sL1Info2 = this.getAdmL1Info(n);
            if (sL1Info2 != null) {
                n2 = sL1Info2.speed.value();
            }
            this.negotiationMode[n] = this.getAttributeFor("EtherGeSpeed", n2);
        }
        return this.negotiationMode[n];
    }

    private Attribute getFramingType(int n) {
        if (this.ethFramingType[n] == null && this.eqpmtModel.isADMCard()) {
            int n2 = 0;
            sML2PosPortAdminInfo sML2PosPortAdminInfo2 = this.getAdmPosAdminInfo(n);
            if (sML2PosPortAdminInfo2 != null) {
                n2 = sML2PosPortAdminInfo2.framingType.value();
            }
            this.ethFramingType[n] = EtherEnumStrings.get(ePosFramingType.class, n2);
        }
        return this.ethFramingType[n];
    }

    private Attribute getEthCrcEncap(int n) {
        if (this.ethEncapMode[n] == null && this.eqpmtModel.isADMCard()) {
            int n2 = 0;
            sML2PosPortAdminInfo sML2PosPortAdminInfo2 = this.getAdmPosAdminInfo(n);
            if (sML2PosPortAdminInfo2 != null) {
                n2 = sML2PosPortAdminInfo2.payloadCrcType.value();
            }
            this.ethEncapMode[n] = EtherEnumStrings.get(eEncapCrcType.class, n2);
        }
        return this.ethEncapMode[n];
    }

    private String getMacAddress(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.macAddr[n] == -1L) {
            this.macAddr[n] = MacAddrFormat.toLong(this.model[n].getMacAddress().addr);
        }
        return MacAddrFormat.formatMacAddr(this.macAddr[n]);
    }

    private Boolean getEnableFlowControl(int n) throws WrongInterfaceType, NoSuchInterface, UnsupportedOperation {
        if (this.flowControl[n] == null) {
            if (this.eqpmtModel.isPolluceCard()) {
                sL1Info sL1Info2 = this.getAdmL1Info(n);
                if (sL1Info2 != null) {
                    this.flowControl[n] = sL1Info2.flowControl != eFlowControlNegotiated.NO_FLOW_CONTROL;
                }
            } else {
                this.flowControl[n] = this.model[n].getClientDistanceAttr().enablePauseFrame;
            }
        }
        if (!this.eqpmtModel.isPolluceCard() && n != 0) {
            return null;
        }
        return this.flowControl[n];
    }

    private Attribute getClientDistance(int n) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        if (this.clientDistance[n] == null) {
            this.clientDistance[n] = this.getAttributeFor("Client Distance", this.model[n].getClientDistanceAttr().clientDist.value());
        }
        if (n != 0) {
            return null;
        }
        return this.clientDistance[n];
    }

    private sL1Info getAdmL1Info(int n) {
        sL1Info sL1Info2;
        block6: {
            sL1Info2 = null;
            HdGeLineModel hdGeLineModel = (HdGeLineModel)this.model[n].getPayloadModel();
            try {
                sL1Info2 = hdGeLineModel.getEtherL1Info();
            }
            catch (NoSuchInterface noSuchInterface) {
                db.println("Exception in getMaxFrameSize, Invalid frame size");
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                db.println("Exception in getMaxFrameSize, Invalid frame size");
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
            catch (NotSupportedOnEquipment notSupportedOnEquipment) {
                db.println("Exception in getMaxFrameSize, Invalid frame size");
                if (!db.on()) break block6;
                SDebug.printStackTrace((Throwable)notSupportedOnEquipment);
            }
        }
        return sL1Info2;
    }

    private sML2PosPortAdminInfo getAdmPosAdminInfo(int n) {
        sML2PosPortAdminInfo sML2PosPortAdminInfo2;
        block2: {
            sML2PosPortAdminInfo2 = null;
            try {
                int n2 = this.model[n].getPortModel().getPortNum()[0];
                HdGeLineModel hdGeLineModel = (HdGeLineModel)this.model[n].getPayloadModel();
                sML2PosPortAdminInfo2 = hdGeLineModel.getAdmPosPortInfo(n2);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return sML2PosPortAdminInfo2;
    }

    private Attribute getAisSquelchMode(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.squelch[n] == null) {
            this.squelch[n] = this.getAttributeFor("disableAisSquelch", this.model[n].getAisSquelchMode().value());
        }
        return this.squelch[n];
    }

    protected int getSoakTime(int n) throws NoSuchInterface {
        if (this.soakTime[n] == -1) {
            this.soakTime[n] = this.model[n].getSoakTime();
        }
        return this.soakTime[n];
    }

    private String getSoakTimeAsHHMM(int n) throws NoSuchInterface {
        return SoakTimePropertyEditor.toStringHHMM(this.getSoakTime(n));
    }

    protected AttributeMaps getAttributeMap() {
        return ElementDefaults.getAttributeMap(this.eqpmtModel.getNodeModel().getTdmProtocolType(), this.getTerms());
    }

    private boolean isSquelchSettable(int n) {
        try {
            int n2 = this.eqpmtModel.getEqType();
            boolean bl = (n2 == 243 || n2 == 282) && this.model[n].getDataRateEnum() != eDataRate.ISC;
            boolean bl2 = !(n2 != 301 && n2 != 356 && n2 != 300 && n2 != 358 || this.model[n].getDataRateEnum() != eDataRate.OC192 && this.model[n].getDataRateEnum() != eDataRate.STM64 && this.model[n].getDataRateEnum() != eDataRate.OC768 && this.model[n].getDataRateEnum() != eDataRate.STM256 && this.model[n].getDataRateEnum() != eDataRate.OTU2 && this.model[n].getDataRateEnum() != eDataRate.OTU3 || !this.model[n].isClient());
            return bl || bl2;
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return false;
        }
    }

    private Attribute getFortyGMode(int n) {
        if (this.fortyGMode[n] == null) {
            int n2 = -1;
            boolean bl = false;
            if (this.model[n].getPayloadModel() instanceof HdGeLineModel) {
                try {
                    n2 = this.model[n].getEMappingMode();
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
                catch (NoSuchInterface noSuchInterface) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
            }
            this.fortyGMode[n] = this.getAttributeFor("FortyGMappingMode", n2);
        }
        return this.fortyGMode[n];
    }

    private Attribute getFortyGOverclock(int n) {
        if (this.fortyGOverclock[n] == null) {
            int n2 = 0;
            try {
                if (this.model[n].isClient()) {
                    return new Attribute("N/A", -1);
                }
                n2 = this.model[n].getOverclock();
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
            catch (DetailedConfigError detailedConfigError) {
                SDebug.printStackTrace((Throwable)detailedConfigError);
            }
            this.fortyGOverclock[n] = this.getAttributeFor("FortyGOverclock", n2);
        }
        return this.fortyGOverclock[n];
    }

    private Attribute getRxWavelength(int n) {
        if (this.rxWavelength[n] == null) {
            int n2 = 0;
            try {
                if (!(this.model[n] instanceof DwdmTrkLineModel)) {
                    return new Attribute("N/A", -1);
                }
                n2 = ((DwdmTrkLineModel)this.model[n]).getRxWavelength().value();
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
            catch (EMCProvisionError eMCProvisionError) {
                SDebug.printStackTrace((Throwable)((Object)eMCProvisionError));
            }
            catch (DetailedConfigError detailedConfigError) {
                SDebug.printStackTrace((Throwable)detailedConfigError);
            }
            this.rxWavelength[n] = Wavelength.getWlAttribute(n2);
        }
        return this.rxWavelength[n];
    }

    private Attribute getDpskVal(int n) {
        if (this.dpskVal[n] == null) {
            int n2 = 0;
            try {
                if (!(this.model[n] instanceof DwdmTrkLineModel)) {
                    return new Attribute("N/A", -1);
                }
                n2 = ((DwdmTrkLineModel)this.model[n]).getDpskVal();
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
            this.dpskVal[n] = this.getAttributeFor("FortyGDpskVals", n2);
        }
        return this.dpskVal[n];
    }

    public Attribute[] getPosFramingTypeAttrs() {
        return EtherEnumStrings.get(ePosFramingType.class, EtherEnumStrings.ADM_POS_FRAMING);
    }

    public Attribute[] getEncapCrcTypeAttrs() {
        return EtherEnumStrings.get(eEncapCrcType.class, EtherEnumStrings.ADM_POS_CRC);
    }
}

