/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.FcmrLineModel;
import cerent.cms.model.HdGeLineModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TraceMode;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.dwdm.DwdmLinePane;
import cerent.cms.ui.dwdm.DwdmSonetLineProvPane;
import cerent.cms.ui.dwdm.DwdmTrkMlsePane;
import cerent.cms.ui.dwdm.DwdmTrkWlPane;
import cerent.cms.ui.dwdm.NAProtectPane;
import cerent.cms.ui.fcmr.FcmrPortDistExtensionPane;
import cerent.cms.ui.fcmr.FcmrPortEnhancedFCFiconPane;
import cerent.cms.ui.sonet.TdmHoProvPane;
import cerent.cms.ui.trace.GenericTraceProvPane;
import cerent.util.SDebug;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public class DwdmPayloadLinePane
extends AbstractSubTabbedPane
implements ITabName {
    private boolean isSDH = false;
    private boolean isMonvisoMxp = false;
    private boolean isPolluce = false;
    private boolean isPolluceMXP = false;
    private AbstractPane dwdmLinePane;
    private AbstractPane fcDistExtPane;
    private AbstractPane fcPortEnhPane;
    private AbstractPane sonetLinePane;
    private AbstractPane monvisoTrkPane;
    private AbstractPane comboPane;
    private AbstractPane pluggablePortsPane;
    private GenericTraceProvPane sonetTracePane;
    private AbstractPane currentPane;
    private AbstractPane hoProvPane;
    private AbstractPane trkPane;
    private AbstractPane mlsePane;

    public DwdmPayloadLinePane(String string, TabbedView tabbedView, DwdmModuleModel dwdmModuleModel) {
        super(string, tabbedView);
        this.registerWithModel();
        this.isSDH = dwdmModuleModel.getNodeModel().getTdmProtocolTypeObj().isSdh();
        this.isMonvisoMxp = dwdmModuleModel.getEqType() == 182 || dwdmModuleModel.getEqType() == 276;
        this.isPolluce = dwdmModuleModel.isPolluceCard();
        this.isPolluceMXP = dwdmModuleModel.getEqType() == 301 || dwdmModuleModel.getEqType() == 356;
    }

    @Override
    public void destroy() {
        int n = this.subTabs.getComponentCount();
        AbstractPane[] abstractPaneArray = new AbstractPane[]{this.dwdmLinePane, this.fcDistExtPane, this.fcPortEnhPane, this.sonetLinePane, this.sonetTracePane, this.monvisoTrkPane, this.comboPane, this.trkPane, this.pluggablePortsPane, this.hoProvPane};
        ArrayList<AbstractPane> arrayList = new ArrayList<AbstractPane>(Arrays.asList(abstractPaneArray));
        for (int i = 0; i < n; ++i) {
            Component object = this.subTabs.getComponentAt(i);
            if (!arrayList.contains(object)) continue;
            arrayList.remove(object);
        }
        for (AbstractPane abstractPane : arrayList) {
            if (abstractPane == null) continue;
            abstractPane.destroy();
        }
        super.destroy();
    }

    @Override
    protected void createSubTabs() {
        TdmLineModel[] tdmLineModelArray;
        int n;
        String string = "SONET STS/VC4";
        int n2 = 0;
        if (this.isSDH) {
            string = "VC4";
            n2 = 1;
        } else {
            string = "SONET STS";
        }
        DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.getUiModel();
        AbstractDwdmLineModel[] abstractDwdmLineModelArray = dwdmModuleModel.getDwdmCliLineModels();
        AbstractDwdmLineModel[] abstractDwdmLineModelArray2 = dwdmModuleModel.getDwdmTrkLineModels();
        AbstractDwdmLineModel[] abstractDwdmLineModelArray3 = dwdmModuleModel.getAllDwdmLineModels();
        FcmrLineModel[] fcmrLineModelArray = FcmrLineModel.filterUndefinedMedia(DwdmModuleModel.getFcmrLineModels(abstractDwdmLineModelArray));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<AbstractDwdmLineModel> arrayList2 = new ArrayList<AbstractDwdmLineModel>();
        if (dwdmModuleModel.getEqType() == 293 || this.isPolluce) {
            for (n = 0; n < abstractDwdmLineModelArray3.length; ++n) {
                try {
                    if (abstractDwdmLineModelArray3[n].isSonetSdhPayload()) {
                        if (!this.isPolluceMXP || abstractDwdmLineModelArray3[n].isClient()) {
                            arrayList.add(abstractDwdmLineModelArray3[n].getTdmLineModel());
                        }
                        arrayList2.add(abstractDwdmLineModelArray3[n]);
                    }
                    if (!this.isPolluceMXP || abstractDwdmLineModelArray3[n].getPayloadModel() == null || abstractDwdmLineModelArray3[n].getPayloadModel().getPortModel().getEqType() != 168 || (tdmLineModelArray = ((HdGeLineModel)abstractDwdmLineModelArray3[n].getPayloadModel()).getChildWISLineModel()) == null) continue;
                    arrayList.add(tdmLineModelArray);
                    arrayList2.add(abstractDwdmLineModelArray3[n]);
                    continue;
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                    continue;
                }
                catch (NoSuchInterface noSuchInterface) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                    continue;
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        } else {
            for (n = 0; n < abstractDwdmLineModelArray.length; ++n) {
                try {
                    if (!abstractDwdmLineModelArray[n].isSonetSdhPayload()) continue;
                    arrayList.add(abstractDwdmLineModelArray[n].getTdmLineModel());
                    arrayList2.add(abstractDwdmLineModelArray[n]);
                    continue;
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
            for (n = 0; n < abstractDwdmLineModelArray2.length; ++n) {
                try {
                    if (!abstractDwdmLineModelArray2[n].isSonetSdhPayload()) continue;
                    arrayList.add(abstractDwdmLineModelArray2[n].getTdmLineModel());
                    arrayList2.add(abstractDwdmLineModelArray2[n]);
                    continue;
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    if (!db.on()) continue;
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
        }
        AbstractDwdmLineModel[] abstractDwdmLineModelArray4 = arrayList2.toArray(new AbstractDwdmLineModel[0]);
        tdmLineModelArray = arrayList.toArray(new TdmLineModel[0]);
        if (dwdmModuleModel.isADMCard()) {
            this.dwdmLinePane = new DwdmLinePane("Unframed", this.subTabs, dwdmModuleModel.get1GEthLines(null), DwdmLinePane.PaneType.ADM_ETH);
        } else if (dwdmModuleModel.getEqType() == 293) {
            this.dwdmLinePane = new DwdmLinePane("Unframed", this.subTabs, dwdmModuleModel.get10GELines(null), DwdmLinePane.PaneType.ADM_ETH);
        } else if (this.isPolluce) {
            this.dwdmLinePane = new DwdmLinePane("Unframed", this.subTabs, dwdmModuleModel.getEthGELines(null), DwdmLinePane.PaneType.FORTYG_ETH);
        } else {
            this.dwdmLinePane = new DwdmLinePane("Unframed", this.subTabs, abstractDwdmLineModelArray3, DwdmLinePane.PaneType.DEFAULT);
            if (abstractDwdmLineModelArray2.length > 0 && !this.isPolluce) {
                this.trkPane = new DwdmTrkWlPane("Wavelength Trunk Settings", this.subTabs, (DwdmTrkLineModel[])abstractDwdmLineModelArray2);
                if (dwdmModuleModel.supportsMLSEModule()) {
                    this.mlsePane = new DwdmTrkMlsePane("Error Decorrelator Settings", this.subTabs, (DwdmTrkLineModel[])abstractDwdmLineModelArray2);
                }
            }
        }
        this.fcDistExtPane = new FcmrPortDistExtensionPane("Distance Extension", this.subTabs, fcmrLineModelArray, !dwdmModuleModel.supportsDEParams());
        this.fcPortEnhPane = new FcmrPortEnhancedFCFiconPane("Enhanced FC/FICON ISL", this.subTabs, fcmrLineModelArray, true);
        this.sonetLinePane = new DwdmSonetLineProvPane(this.isSDH ? "SDH" : "SONET", this.subTabs, tdmLineModelArray, abstractDwdmLineModelArray4);
        int n3 = 6;
        if (dwdmModuleModel.isADMCard()) {
            n3 |= 1;
        }
        this.sonetTracePane = new GenericTraceProvPane("Section Trace", this.subTabs, TraceMode.SECTION, tdmLineModelArray, n3);
        this.monvisoTrkPane = new DwdmLinePane("Trunk", this.subTabs, abstractDwdmLineModelArray2, DwdmLinePane.PaneType.TRUNK);
        this.hoProvPane = new TdmHoProvPane(string, this.getParentView(), tdmLineModelArray, 1, n2);
        AbstractDwdmLineModel[] abstractDwdmLineModelArray5 = ((EntityModel)this.getUiModel()).getDescendantsOfEqType(279).isEmpty() && ((EntityModel)this.getUiModel()).getDescendantsOfEqType(326).isEmpty() ? abstractDwdmLineModelArray : abstractDwdmLineModelArray3;
        this.comboPane = new DwdmLinePane("Client", this.subTabs, abstractDwdmLineModelArray5, DwdmLinePane.PaneType.COMBO);
        this.pluggablePortsPane = new DwdmLinePane("Ports", this.subTabs, abstractDwdmLineModelArray3, DwdmLinePane.PaneType.PLUGGABLES);
        if (dwdmModuleModel.getEqType() == 293) {
            if (abstractDwdmLineModelArray3.length > 0) {
                this.setupTabs(dwdmModuleModel.getDwdmLineModels(), (DwdmTrkLineModel[])abstractDwdmLineModelArray2, abstractDwdmLineModelArray4, tdmLineModelArray, fcmrLineModelArray);
            } else {
                NAProtectPane nAProtectPane = NAProtectPane.createPane(this.getParentView(), true);
                nAProtectPane.setText("", "");
                this.subTabs.add((Component)((Object)nAProtectPane));
            }
        } else {
            this.setupTabs(dwdmModuleModel.getDwdmLineModels(), (DwdmTrkLineModel[])abstractDwdmLineModelArray2, abstractDwdmLineModelArray4, tdmLineModelArray, fcmrLineModelArray);
        }
    }

    @Override
    protected void refreshMyLines(Object object) {
        Serializable serializable;
        if (!(object instanceof DwdmLineUpdate)) {
            return;
        }
        DwdmLineUpdate dwdmLineUpdate = (DwdmLineUpdate)object;
        this.currentPane = (AbstractPane)((Object)this.subTabs.getSelectedComponent());
        TdmLineModel[] tdmLineModelArray = dwdmLineUpdate.getTdmLineModels();
        AbstractDwdmLineModel[] abstractDwdmLineModelArray = dwdmLineUpdate.getTdmDwdmLineModels();
        boolean bl = false;
        if (dwdmLineUpdate.getDwdmLineModels().length > 0) {
            try {
                serializable = dwdmLineUpdate.getDwdmLineModels()[0].getModuleModel();
                bl = ((EntityModel)serializable).getEqType() == 301 || ((EntityModel)serializable).getEqType() == 356;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        if (bl) {
            Object object2;
            serializable = new ArrayList();
            ArrayList<AbstractDwdmLineModel> arrayList = new ArrayList<AbstractDwdmLineModel>();
            AbstractDwdmLineModel[] abstractDwdmLineModelArray2 = dwdmLineUpdate.getDwdmLineModels();
            for (int i = 0; i < abstractDwdmLineModelArray2.length; ++i) {
                try {
                    if (abstractDwdmLineModelArray2[i].getPayloadModel() == null || abstractDwdmLineModelArray2[i].getPayloadModel().getPortModel().getEqType() != 168 || (object2 = ((HdGeLineModel)abstractDwdmLineModelArray2[i].getPayloadModel()).getChildWISLineModel()) == null) continue;
                    ((ArrayList)serializable).add(object2);
                    arrayList.add(abstractDwdmLineModelArray2[i]);
                    continue;
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            if (((ArrayList)serializable).size() > 0) {
                TdmLineModel[] tdmLineModelArray2 = new TdmLineModel[tdmLineModelArray.length + ((ArrayList)serializable).size()];
                object2 = new AbstractDwdmLineModel[abstractDwdmLineModelArray.length + arrayList.size()];
                System.arraycopy(((ArrayList)serializable).toArray(new TdmLineModel[0]), 0, tdmLineModelArray2, 0, ((ArrayList)serializable).size());
                System.arraycopy(tdmLineModelArray, 0, tdmLineModelArray2, ((ArrayList)serializable).size(), tdmLineModelArray.length);
                System.arraycopy(arrayList.toArray(new AbstractDwdmLineModel[0]), 0, object2, 0, arrayList.size());
                System.arraycopy(abstractDwdmLineModelArray, 0, object2, arrayList.size(), abstractDwdmLineModelArray.length);
                tdmLineModelArray = tdmLineModelArray2;
                abstractDwdmLineModelArray = object2;
            }
        }
        this.setupTabs(dwdmLineUpdate.getDwdmLineModels(), dwdmLineUpdate.getDwdmTrkLineModels(), abstractDwdmLineModelArray, tdmLineModelArray, FcmrLineModel.filterUndefinedMedia(dwdmLineUpdate.getFcmrLineModels()));
        if (this.showing && this.currentPane != null) {
            try {
                this.subTabs.setSelectedComponent((Component)((Object)this.currentPane));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.subTabs.setSelectedIndex(0);
            }
            try {
                this.currentPane.setShowing(true);
                this.repaint();
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
            if (this.currentPane.getTable() != null) {
                TablePropertyMgr.getColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
            }
        }
    }

    private void setupTabs(AbstractDwdmLineModel[] abstractDwdmLineModelArray, DwdmTrkLineModel[] dwdmTrkLineModelArray, AbstractDwdmLineModel[] abstractDwdmLineModelArray2, TdmLineModel[] tdmLineModelArray, FcmrLineModel[] fcmrLineModelArray) {
        block26: {
            try {
                this.subTabs.removeAll();
                boolean bl = true;
                DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.getUiModel();
                if (dwdmModuleModel.isADMCard()) {
                    this.subTabs.addTab("Ports", (Component)((Object)this.pluggablePortsPane));
                    if (dwdmModuleModel.get1GEthLines(abstractDwdmLineModelArray).length > 0) {
                        this.subTabs.addTab("Ethernet", (Component)((Object)this.dwdmLinePane));
                    }
                } else if (dwdmModuleModel.getEqType() == 293 || this.isPolluce) {
                    this.subTabs.addTab("Ports", (Component)((Object)this.pluggablePortsPane));
                    if (this.isPolluce && dwdmModuleModel.getEthGELines(abstractDwdmLineModelArray).length > 0) {
                        this.subTabs.addTab("Ethernet", (Component)((Object)this.dwdmLinePane));
                    } else if (dwdmModuleModel.get10GELines(abstractDwdmLineModelArray).length > 0) {
                        this.subTabs.addTab("Ethernet", (Component)((Object)this.dwdmLinePane));
                    }
                } else {
                    int n;
                    int n2 = abstractDwdmLineModelArray[0].getFramingType();
                    if (n2 != (n = dwdmTrkLineModelArray[0].getFramingType()) && n2 != 4) {
                        this.subTabs.addTab("Client", (Component)((Object)this.comboPane));
                        if (fcmrLineModelArray != null && fcmrLineModelArray.length > 0) {
                            this.subTabs.addTab("Distance Extension", (Component)((Object)this.fcDistExtPane));
                            if (dwdmModuleModel.supportsDEParams()) {
                                this.subTabs.addTab("Enhanced FC/FICON ISL", (Component)((Object)this.fcPortEnhPane));
                            }
                        }
                    } else {
                        EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
                        String string = EntityCellRenderer.getPayloadTypeStr(abstractDwdmLineModelArray[0]);
                        bl = false;
                        switch (n2) {
                            case 0: 
                            case 1: {
                                bl = true;
                                if (!this.isMonvisoMxp) break;
                                this.subTabs.addTab("Trunk", (Component)((Object)this.monvisoTrkPane));
                                break;
                            }
                            case 2: {
                                this.subTabs.addTab("Ethernet", (Component)((Object)this.dwdmLinePane));
                                break;
                            }
                            case 3: 
                            case 5: {
                                this.subTabs.addTab(string, (Component)((Object)this.dwdmLinePane));
                                break;
                            }
                            case 4: {
                                this.subTabs.addTab(string, (Component)((Object)this.comboPane));
                                break;
                            }
                            default: {
                                db.println("Unknown payload type " + n2);
                            }
                        }
                    }
                }
                if (bl && tdmLineModelArray != null && tdmLineModelArray.length > 0) {
                    this.subTabs.addTab(this.isSDH ? "SDH" : "SONET", (Component)((Object)this.sonetLinePane));
                    this.sonetTracePane.refreshMyLines(tdmLineModelArray);
                    this.sonetTracePane.refreshFromModel();
                    this.subTabs.addTab("Section Trace", (Component)((Object)this.sonetTracePane));
                    if (dwdmModuleModel.isADMCard()) {
                        this.subTabs.addTab(this.isSDH ? "VC4" : "SONET STS", (Component)((Object)this.hoProvPane));
                    }
                }
                if (!dwdmModuleModel.isADMCard()) {
                    this.subTabs.addTab("Wavelength Trunk Settings", (Component)((Object)this.trkPane));
                    if (dwdmModuleModel.supportsMLSEModule()) {
                        this.subTabs.addTab("Error Decorrelator Settings", (Component)((Object)this.mlsePane));
                    }
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                db.println("Exception in setupTabs");
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                db.println("Exception in setupTabs");
                if (!db.on()) break block26;
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
    }
}

