/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.HdGeLineModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.dwdm.DwdmSonetLineTableModel;
import cerent.cms.ui.sonet.TdmLineProvPane;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Observable;

public class DwdmSonetLineProvPane
extends TdmLineProvPane {
    private static final SDebug db = new SDebug("DwdmSonetLineProvPane");
    private AbstractDwdmLineModel[] dwdmLineModels;

    public DwdmSonetLineProvPane(String string, TabbedView tabbedView, TdmLineModel[] tdmLineModelArray, AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        super(string, tabbedView, tdmLineModelArray, new DwdmSonetLineTableModel((NodeModelDelegate)tabbedView.getUiModel().getNodeModel(), tdmLineModelArray, abstractDwdmLineModelArray));
        this.dwdmLineModels = abstractDwdmLineModelArray;
        this.getObsMgr().addObservable((Observable[])abstractDwdmLineModelArray);
    }

    @Override
    protected void prepareColumns() {
        super.prepareColumns();
        this.removeColumn(2);
        this.removeColumn(12);
        DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.getUiModel();
        if (!dwdmModuleModel.isADMCard()) {
            this.removeColumn(14);
        }
        if (!dwdmModuleModel.supportTiming()) {
            this.removeColumn(9);
            this.removeColumn(10);
            this.removeColumn(13);
        }
        if (dwdmModuleModel.isADMCard() || dwdmModuleModel.getEqType() == 293 || dwdmModuleModel.isPolluceCard()) {
            this.removeColumn(1);
            this.removeColumn(3);
            this.removeColumn(4);
            this.removeColumn(17);
            this.removeColumn(20);
            if (dwdmModuleModel.getEqType() == 293) {
                this.removeColumn(11);
            }
        } else {
            this.removeColumn(11);
        }
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.DwdmSonetPayloadLineProvPane;
    }

    @Override
    protected String getSplitterString() {
        String string = "";
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < this.dwdmLineModels.length; ++i) {
            if (!(this.dwdmLineModels[i] instanceof DwdmTrkLineModel)) continue;
            DwdmTrkLineModel dwdmTrkLineModel = (DwdmTrkLineModel)this.dwdmLineModels[i];
            if (dwdmTrkLineModel.isSplitterProtectedLine()) {
                bl2 = true;
            }
            if (!this.dataModel.isAdminStateDirty(i)) continue;
            bl = true;
        }
        if (bl && bl2) {
            string = "\nSafety Warning: The laser will not be turned off.\nPlease shutter the port.\n";
        }
        return string;
    }

    @Override
    protected void refreshMyLines(Object object) {
        if (object instanceof DwdmLineUpdate) {
            if (db.on()) {
                db.println("in refreshMyLines, processing " + object);
            }
            DwdmLineUpdate dwdmLineUpdate = (DwdmLineUpdate)object;
            this.getObsMgr().removeObservable((Observable[])this.dwdmLineModels);
            this.dwdmLineModels = dwdmLineUpdate.getTdmDwdmLineModels();
            TdmLineModel[] tdmLineModelArray = dwdmLineUpdate.getTdmLineModels();
            boolean bl = ((DwdmModuleModel)this.getUiModel()).isPolluceCard();
            if (bl) {
                Object object2;
                ArrayList<AbstractDwdmLineModel[]> arrayList = new ArrayList<AbstractDwdmLineModel[]>();
                ArrayList<AbstractDwdmLineModel> arrayList2 = new ArrayList<AbstractDwdmLineModel>();
                AbstractDwdmLineModel[] abstractDwdmLineModelArray = dwdmLineUpdate.getDwdmLineModels();
                for (int i = 0; i < abstractDwdmLineModelArray.length; ++i) {
                    try {
                        if (abstractDwdmLineModelArray[i].getPayloadModel() == null || abstractDwdmLineModelArray[i].getPayloadModel().getPortModel().getEqType() != 168 || (object2 = ((HdGeLineModel)abstractDwdmLineModelArray[i].getPayloadModel()).getChildWISLineModel()) == null) continue;
                        arrayList.add((AbstractDwdmLineModel[])object2);
                        arrayList2.add(abstractDwdmLineModelArray[i]);
                        continue;
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                }
                if (arrayList.size() > 0) {
                    TdmLineModel[] tdmLineModelArray2 = new TdmLineModel[tdmLineModelArray.length + arrayList.size()];
                    object2 = new AbstractDwdmLineModel[this.dwdmLineModels.length + arrayList2.size()];
                    System.arraycopy(arrayList.toArray(new TdmLineModel[0]), 0, tdmLineModelArray2, 0, arrayList.size());
                    System.arraycopy(tdmLineModelArray, 0, tdmLineModelArray2, arrayList.size(), tdmLineModelArray.length);
                    System.arraycopy(arrayList2.toArray(new AbstractDwdmLineModel[0]), 0, object2, 0, arrayList2.size());
                    System.arraycopy(this.dwdmLineModels, 0, object2, arrayList2.size(), this.dwdmLineModels.length);
                    tdmLineModelArray = tdmLineModelArray2;
                    this.dwdmLineModels = object2;
                }
            }
            ((DwdmSonetLineTableModel)this.dataModel).setLineModels(this.dwdmLineModels);
            this.setLineModels(tdmLineModelArray);
            this.getObsMgr().addObservable((Observable[])this.dwdmLineModels);
        }
    }

    protected boolean isReachAndWave() {
        boolean bl = true;
        switch (this.getEqpmtModel().getEqType()) {
            case 183: 
            case 184: 
            case 243: 
            case 282: {
                bl = false;
                break;
            }
            case 118: {
                bl = false;
                break;
            }
            case 273: {
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    protected void refreshLine(Observable object) {
        int n = Arrays.asList(this.dwdmLineModels).indexOf(object);
        if (n != -1 && n < this.lineModels.length) {
            object = this.lineModels[n];
        }
        super.refreshLine((Observable)object);
    }
}

