/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.model.Attribute;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.WLenCellEditor;
import cerent.cms.ui.WLenCellRenderer;
import cerent.cms.ui.WLenSelectorPopup;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.dwdm.DwdmTrkWlProvTableModel;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class DwdmTrkWlPane
extends NodeProvPane
implements TableModelListener,
PropertyChangeListener {
    protected static final SDebug db = new SDebug("DwdmTrkWlPane");
    protected DwdmTrkWlProvTableModel dataModel;
    protected DwdmModuleModel eqpmtModel;
    protected DwdmTrkLineModel[] lineModels;
    protected int numLines;
    private boolean notInited = true;
    private WLenSelectorPopup.DefaultWLDialogValue dv;
    private final int INVALID_INDEX = -1;

    public DwdmTrkWlPane(String string, TabbedView tabbedView, DwdmTrkLineModel[] dwdmTrkLineModelArray) {
        super(string, tabbedView);
        this.lineModels = dwdmTrkLineModelArray;
        this.numLines = dwdmTrkLineModelArray.length;
        this.eqpmtModel = (DwdmModuleModel)this.getUiModel();
        this.dataModel = this.getDataModel();
    }

    protected void init() {
        this.dataModel.addTableModelListener(this);
        this.table = new UTableExt(this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(true);
        this.prepareColumns();
        this.add((Component)uScrollPane, "Center");
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.notInited = false;
    }

    protected void prepareColumns() {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(0));
        tableColumn.setPreferredWidth(90);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(1));
        tableColumn.setCellRenderer(new WLenCellRenderer());
        tableColumn.setPreferredWidth(150);
    }

    protected void removeColumn(int n) {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(n));
        this.table.removeColumn(tableColumn);
    }

    protected DwdmTrkWlProvTableModel getDataModel() {
        return new DwdmTrkWlProvTableModel(this.lineModels);
    }

    public Attribute[] getAttributeArray(String string) throws NoSuchElementException {
        Attribute[] attributeArray = ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeArray(string);
        if (attributeArray == null) {
            throw new NoSuchElementException();
        }
        return attributeArray;
    }

    protected List getAttributeList(Class clazz) {
        return ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeList("DWDM." + clazz.getName());
    }

    protected Attribute getAttribute(Class clazz, int n) {
        return ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeForVal("DWDM." + clazz.getName(), n);
    }

    @Override
    protected boolean queryRemainDirty() {
        return true;
    }

    @Override
    public void applyChangesToModel() throws Exception {
        this.dataModel.applyToModel();
        this.resetDirty();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1 && this.dataModel != null) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else if (db.on()) {
            db.println("In DwdmTrkWlPane changeMessage cannot find Model " + observable);
        }
    }

    @Override
    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    @Override
    public void enteringPage() throws Exception {
        if (this.notInited) {
            this.init();
        }
        super.enteringPage();
        this.registerWithModel();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    @Override
    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
        this.unRegisterWithModel();
    }

    @Override
    protected void registerWithModel() {
        for (int i = 0; i < this.numLines; ++i) {
            if (this.lineModels[i] == null) continue;
            this.lineModels[i].addObserver((Observer)((Object)this));
        }
    }

    protected void unRegisterWithModel() {
        for (int i = 0; i < this.numLines; ++i) {
            if (this.lineModels[i] == null) continue;
            this.lineModels[i].deleteObserver((Observer)((Object)this));
        }
    }

    @Override
    protected void changeMessage(Observable observable, Object object) {
        this.requestRefresh(observable, this.getRefreshThread(observable));
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            @Override
            public void run() {
                DwdmTrkWlPane.this.refreshLine(observable);
            }
        };
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setDirty();
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.DwdmTrkWlPane;
    }

    private class UTableExt
    extends UTable {
        private DwdmTrkWlProvTableModel tableModel;
        private WLenCellEditor wLenCellEditor;

        public UTableExt(DwdmTrkWlProvTableModel dwdmTrkWlProvTableModel) {
            super((TableModel)dwdmTrkWlProvTableModel);
            this.tableModel = dwdmTrkWlProvTableModel;
            Attribute[] attributeArray = dwdmTrkWlProvTableModel.getTunableWlList(0);
            Attribute[] attributeArray2 = null;
            Attribute[] attributeArray3 = null;
            Attribute[] attributeArray4 = null;
            Attribute[] attributeArray5 = null;
            WLenSelectorPopup.WavelengthSets wavelengthSets = null;
            if (DwdmTrkWlPane.this.eqpmtModel.supportsCLBand()) {
                attributeArray2 = Wavelength.getWavelengthAttrs(0, 1, false);
                attributeArray3 = Wavelength.getWavelengthAttrs(0, 0, false);
                attributeArray4 = Wavelength.getWavelengthAttrs(1, 1, false);
                attributeArray5 = Wavelength.getWavelengthAttrs(1, 0, false);
                wavelengthSets = new WLenSelectorPopup.WavelengthSets(attributeArray2, attributeArray3, attributeArray4, attributeArray5, true, attributeArray);
            } else {
                attributeArray3 = Wavelength.getWavelengthAttrs(0, 0, 32, false);
                wavelengthSets = new WLenSelectorPopup.WavelengthSets(null, attributeArray3, null, null, true, attributeArray);
            }
            DwdmTrkWlPane.this.dv = new WLenSelectorPopup.DefaultWLDialogValue();
            DwdmTrkWlPane.this.dv.setPossibleChoices(wavelengthSets);
            this.wLenCellEditor = new WLenCellEditor(DwdmTrkWlPane.this.dv);
            this.getColumnModel().getColumn(1).setCellEditor(this.wLenCellEditor);
        }
    }
}

