/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ether;

import cerent.cms.idl.Epos.xVlanHardwareViolation;
import cerent.cms.idl.Epos.xVlanSpanningTreeViolation;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.Attribute;
import cerent.cms.model.CmsNodeUpgradingException;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EtherPortModel;
import cerent.cms.model.IEtherBridgeModel;
import cerent.cms.model.IModel;
import cerent.cms.model.IVlanModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.VlanInfoCellRenderer;
import cerent.cms.ui.ether.EtherPortProvPane;
import cerent.cms.ui.ether.EtherPortTableHeaderRenderer;
import cerent.cms.ui.ether.EtherVlanTableModel;
import cerent.util.AnnotatedException;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class EtherVlanProvPane
extends NodeProvPane
implements TableModelListener {
    private EtherVlanTableModel dataModel = null;
    private EtherPortModel[] portModels = null;
    private IVlanModel[] allVlans = null;
    private IEtherBridgeModel bridgeModel = null;
    private int numPorts = 0;
    private boolean dialogDisplayed = false;
    private static final SDebug db = new SDebug("VlanProvPane");

    public EtherVlanProvPane(String string, TabbedView tabbedView, EtherPortModel[] etherPortModelArray) {
        super(string, tabbedView);
        TableColumn tableColumn = null;
        Object var5_5 = null;
        if (etherPortModelArray == null) {
            if (db.on()) {
                db.println("No Ports found in EtherVlanProvPane");
            }
            return;
        }
        this.portModels = etherPortModelArray;
        this.bridgeModel = etherPortModelArray[0].getChassis().getEtherBridgeModel();
        this.dataModel = new EtherVlanTableModel(this.portModels);
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.dataModel.addTableModelListener(this);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(0));
        tableColumn.setCellRenderer(new VlanInfoCellRenderer());
        this.numPorts = etherPortModelArray.length;
        for (int i = 1; i < this.numPorts + 1; ++i) {
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(i));
            tableColumn.setHeaderRenderer(new EtherPortTableHeaderRenderer());
            tableColumn.setHeaderValue(etherPortModelArray[i - 1]);
            tableColumn.setCellEditor(new DefaultCellEditor((JComboBox<?>)this.getVlanComboBox()));
        }
        this.table.setAutoCreateColumnsFromModel(false);
        this.table.setRowSelectionAllowed(false);
        this.registerForUpdates();
        this.add((Component)uScrollPane);
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName() + this.numPorts);
    }

    private UComboBox getVlanComboBox() {
        UComboBox uComboBox = new UComboBox((Object[])this.getVlanAttributeArray());
        uComboBox.setEditable(false);
        return uComboBox;
    }

    private Attribute[] getVlanAttributeArray() {
        return ElementDefaults.getAttributeMap((IModel)this.portModels[0].getNodeModel()).getAttributeArray("ETHER.Vlan");
    }

    private void registerForUpdates() {
        this.registerForPortUpdates();
        this.registerForVlanUpdates();
    }

    private void registerForPortUpdates() {
        if (this.portModels == null) {
            return;
        }
        for (int i = 0; i < this.portModels.length; ++i) {
            this.portModels[i].addObserver((Observer)((Object)this));
        }
    }

    private void registerForVlanUpdates() {
        this.bridgeModel.addObserver((Observer)((Object)this));
        try {
            this.allVlans = this.bridgeModel.getVlanList();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            db.finer("Exception in getAllVlans() " + (Object)((Object)abstractCmsIOException));
        }
        if (this.allVlans != null) {
            for (int i = 0; i < this.allVlans.length; ++i) {
                if (this.allVlans[i] == null) continue;
                this.allVlans[i].addObserver((Observer)((Object)this));
            }
        }
    }

    private void unregisterForVlanUpdates() {
        this.bridgeModel.deleteObserver((Observer)((Object)this));
        for (int i = 0; i < this.allVlans.length; ++i) {
            this.allVlans[i].deleteObserver((Observer)((Object)this));
        }
    }

    @Override
    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName() + this.numPorts);
        if (this.portModels != null) {
            db.fine("Destroying EtherVlanProvPane: " + this.portModels.length + " PortModels");
            for (int i = 0; i < this.portModels.length; ++i) {
                db.fine("Destroying PortModels[" + i + "]");
                if (this.portModels[i] != null) {
                    this.portModels[i].deleteObserver((Observer)((Object)this));
                    continue;
                }
                db.fine("PortModels[" + i + "] is null!");
            }
            this.portModels = null;
        }
        this.unregisterForVlanUpdates();
        this.bridgeModel = null;
        this.allVlans = null;
        if (this.dataModel != null) {
            db.fine("Destroying EtherVlanProvPane: DataModel");
            this.dataModel.removeTableModelListener(this);
            this.dataModel = null;
        }
        if (db.on()) {
            db.println("Destroying EtherVlanProvPane: super");
        }
        super.destroy();
    }

    protected Attribute[] getAttributeArray(Class clazz) {
        return ElementDefaults.getAttributeMap((IModel)this.portModels[0].getNodeModel()).getAttributeArray("ETHER." + clazz.getName());
    }

    @Override
    public boolean onValidate() {
        boolean bl = true;
        String string = "";
        for (int i = 0; i < this.portModels.length; ++i) {
            int n;
            if (!this.dataModel.isColumnDirty(i) || (n = this.dataModel.getNumberOfUntagged(i)) == 1) continue;
            string = string + (i + 1) + " ,";
        }
        if (!string.equals("")) {
            string = string.substring(0, string.length() - 1);
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_EXACTLY_ONE_UNMARKED_VLAN_PARAM_1, (Object)string);
            bl = false;
        }
        return bl;
    }

    @Override
    public void applyChangesToModel() throws Exception {
        int n = 0;
        try {
            for (n = 0; n < this.portModels.length; ++n) {
                if (!this.dataModel.isColumnDirty(n)) continue;
                if (db.on()) {
                    db.println("Setting for line " + n + " ,Untagged is " + this.dataModel.getUntaggedVlanForPort(n));
                }
                if (db.on()) {
                    db.println("Size of Vlan Array " + this.dataModel.getVlanArrayForPort(n).length);
                }
                this.portModels[n].setPortVlansNoProv(this.dataModel.getVlanArrayForPort(n));
                this.portModels[n].setPortVlanTaggingNoProv(this.dataModel.getUntaggedVlanForPort(n));
            }
            this.dataModel.resetColumnDirty();
            this.portModels[0].getNodeModelDelegate().getEtherBridgeModel().finalizePortProvisioning();
        }
        catch (xVlanHardwareViolation xVlanHardwareViolation2) {
            throw new AnnotatedException("This card does not allow more than one\nenabled port to be a member of the same VLAN.\n\n(This condition may occur only temporarily,\nduring the Apply operation.  If so, work around\nit by disabling one of the ports before changing\nVLANs, and enabling it afterward.)\n", (Exception)((Object)xVlanHardwareViolation2));
        }
        catch (xVlanSpanningTreeViolation xVlanSpanningTreeViolation2) {
            throw xVlanSpanningTreeViolation2;
        }
        catch (CmsNodeUpgradingException cmsNodeUpgradingException) {
            if (EtherVlanProvPane.db.on) {
                SDebug.printStackTrace((Throwable)cmsNodeUpgradingException);
            }
            ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_NODE_UPGRADING_EXCEPTION);
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (EtherVlanProvPane.db.on) {
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
        }
        catch (Exception exception) {
            throw new AnnotatedException("An error occurred while applying changes to Port " + (n + 1) + ".", exception);
        }
    }

    @Override
    protected void displayErrorDialog(Pane pane, Exception exception, EID eID) {
        if (exception instanceof xVlanSpanningTreeViolation) {
            EtherPortProvPane.displayVlanStpError(this.bridgeModel.getNodeModel(), pane, EMC.EID_PORT_VLAN_FAILED);
        } else {
            super.displayErrorDialog(pane, exception, eID);
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        for (int i = 0; i < this.portModels.length; ++i) {
            if (!this.dataModel.isColumnDirty(i)) continue;
            if (EtherVlanProvPane.db.on) {
                db.println("tableChanged: column " + i + " is DIRTY");
            }
            this.setDirty();
            return;
        }
        if (EtherVlanProvPane.db.on) {
            db.println("tableChanged: CLEAN");
        }
        this.resetDirty();
    }

    @Override
    public void refreshFromModel() throws Exception {
        if (EtherVlanProvPane.db.on) {
            db.println(" refreshFromModel()");
        }
        if (this.dataModel != null) {
            this.dataModel.resetColumnDirty();
            this.dataModel.refresh();
        } else if (db.on()) {
            db.println("refreshFromModel:  dataModel is null!!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshEtherPortFromUpdates(Observable observable) {
        EtherVlanProvPane etherVlanProvPane = this;
        synchronized (etherVlanProvPane) {
            if (this.dialogDisplayed) {
                return;
            }
            this.stopTableCellEditing();
            int n = Arrays.asList(this.portModels).indexOf(observable);
            if (n == -1) {
                if (db.on()) {
                    db.println("EtherVlanProvPane: changeMessage cannot find Model " + observable);
                }
                return;
            }
            if (this.dataModel.isColumnDirty(n)) {
                this.dialogDisplayed = true;
                switch (CerentDialog.questionDialog((Component)((Object)this), (String)"New update(s) have arrived.  Is it OK to apply the changes before updating?", (String)"New Updates", (int)0)) {
                    case 0: {
                        this.apply();
                    }
                    case 1: 
                    case 2: {
                        this.unregisterForVlanUpdates();
                        this.registerForVlanUpdates();
                        this.refresh();
                    }
                }
                this.dialogDisplayed = false;
            } else {
                this.dataModel.refreshLineFromModel(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshVlanFromUpdates(Observable observable) {
        EtherVlanProvPane etherVlanProvPane = this;
        synchronized (etherVlanProvPane) {
            if (this.dialogDisplayed) {
                return;
            }
            this.stopTableCellEditing();
            if (this.isPaneDirty()) {
                this.dialogDisplayed = true;
                switch (CerentDialog.questionDialog((Component)((Object)this), (String)"New update(s) have arrived.  Is it OK to apply the changes before updating?", (String)"New Updates")) {
                    case 0: {
                        this.apply();
                        break;
                    }
                    case 1: 
                    case 2: {
                        this.unregisterForVlanUpdates();
                        this.registerForVlanUpdates();
                        this.refresh();
                    }
                }
                this.dialogDisplayed = false;
            } else {
                this.unregisterForVlanUpdates();
                this.registerForVlanUpdates();
                this.refresh();
            }
        }
    }

    private boolean isPaneDirty() {
        for (int i = 0; i < this.portModels.length; ++i) {
            if (!this.dataModel.isColumnDirty(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable instanceof EtherPortModel) {
            if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
                this.requestRefresh(observable, this.getEtherPortUpdateThread(observable));
            }
        } else if (observable instanceof IEtherBridgeModel) {
            if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.ADDED)) {
                this.requestRefresh(observable, this.getVlanUpdateThread(observable));
            }
        } else if (observable instanceof IVlanModel && object instanceof Integer && ((Integer)object).equals(ModelUpdateType.DELETED)) {
            this.requestRefresh(observable, this.getVlanUpdateThread(observable));
        }
    }

    private Runnable getEtherPortUpdateThread(final Observable observable) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    EtherVlanProvPane.this.refreshEtherPortFromUpdates(observable);
                }
                catch (Exception exception) {
                    db.fine("Caught " + exception + " in Refreshing EtherVlanProvPane");
                }
            }
        };
    }

    private Runnable getVlanUpdateThread(final Observable observable) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    EtherVlanProvPane.this.refreshVlanFromUpdates(observable);
                }
                catch (Exception exception) {
                    db.fine("Caught " + exception + " in Refreshing EtherVlanProvPane");
                }
            }
        };
    }

    @Override
    public void enteringPage() throws Exception {
        super.enteringPage();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName() + this.numPorts);
    }

    @Override
    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName() + this.numPorts);
        super.leavingPage();
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.EtherVlanProvPane;
    }
}

