/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.event;

import cerent.cms.model.event.EventFilter;
import cerent.cms.ui.event.FilterConditionPane;
import cerent.cms.ui.event.FilterGeneralPane;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.AbstractPropertySheet;
import cerent.util.matcher.AbstractMatcher;
import java.awt.Window;

class FilterPropertySheet
extends AbstractPropertySheet {
    private EventFilter eventFilter = null;
    private FilterGeneralPane generalPane = null;
    private FilterConditionPane conditionPane = null;

    public FilterPropertySheet(Window window, EventFilter eventFilter) {
        super(window, true);
        this.eventFilter = eventFilter;
        this.onInitialUpdate(eventFilter);
    }

    public void onInitialUpdate(EventFilter eventFilter) {
        Preferences preferences = Preferences.instance();
        this.generalPane = new FilterGeneralPane("General", this, preferences, eventFilter);
        this.addPane(this.generalPane);
        this.conditionPane = new FilterConditionPane("Conditions", this, preferences, eventFilter);
        this.addPane(this.conditionPane);
    }

    @Override
    public void onApply() {
        try {
            Preferences.instance().setBoolean(this.eventFilter.getPreference(), "IS_FILTER_ACTIVE", true);
            AbstractMatcher abstractMatcher = this.generalPane.createSeverityMatcher();
            AbstractMatcher abstractMatcher2 = this.conditionPane.createConditionMatcher();
            AbstractMatcher abstractMatcher3 = this.generalPane.createTimeMatcher();
            AbstractMatcher abstractMatcher4 = this.generalPane.createSAMatcher();
            this.eventFilter.buildAndSetMatchers(abstractMatcher, abstractMatcher3, abstractMatcher2, abstractMatcher4);
            super.onApply();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }
}

