/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.fcmr;

import cerent.cms.model.FcmrLineModel;
import cerent.cms.model.FcmrModuleModel;
import cerent.cms.model.FcmrPortModel;
import cerent.cms.model.RmonModel;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.fcmr.FcmrCardProvPane;
import cerent.cms.ui.fcmr.FcmrPortPane;
import cerent.cms.ui.rmon.RmonThresholdPane;
import cerent.util.SDebug;
import java.awt.Component;
import javax.swing.JLabel;

public class FcmrProvPane
extends NodeProvPane {
    private FcmrModuleModel fcmrModel;
    private FcmrPortModel[] portModels = null;
    private FcmrLineModel[] lineModels = null;
    private static final SDebug db = new SDebug("FcmrProvPane");

    public FcmrProvPane(String string, TabbedView tabbedView, FcmrModuleModel fcmrModuleModel, FcmrPortModel[] fcmrPortModelArray, FcmrLineModel[] fcmrLineModelArray) {
        super(string, tabbedView);
        if (fcmrPortModelArray == null || fcmrLineModelArray == null) {
            db.println("ERROR: Line or Port Models are null!");
            this.add(new JLabel("This pane is unimplemented."));
            return;
        }
        this.fcmrModel = fcmrModuleModel;
        this.portModels = fcmrPortModelArray;
        this.lineModels = fcmrLineModelArray;
        this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
        this.subTabs.addTab("Port", (Component)this.getPortTab());
        this.subTabs.addTab("RMON Thresholds", (Component)this.getLineThresholdsTab());
        this.subTabs.addTab("Alarm Profiles", (Component)CardTabbedView.getCardProvAlarmsPane(this.subTabs, false));
        this.subTabs.addTab("Card", (Component)this.getCardTab());
        this.subTabs.setTabPlacement(2);
        this.add((Component)this.subTabs);
    }

    private Pane getPortTab() {
        return new FcmrPortPane("FcmrPortProvPane", this.getParentView(), this.fcmrModel, this.portModels, this.lineModels);
    }

    private Pane getLineThresholdsTab() {
        return new RmonThresholdPane("RMON Thresholds", this.getParentView(), RmonModel.getRmonModels(FcmrLineModel.filterUndefinedMedia(this.lineModels)));
    }

    private Pane getCardTab() {
        return new FcmrCardProvPane("Card", this.getParentView());
    }

    @Override
    public boolean hasSubTabs() {
        return true;
    }
}

