/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.functional.card;

import cerent.cms.fv.IFvInterfaceModel;
import cerent.cms.fv.IFvOpticsLineModel;
import cerent.cms.fv.IFvOpticsPortModel;
import cerent.cms.fv.IFvPSMModuleModel;
import cerent.cms.model.Attribute;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.functional.card.FunctCardGrapher;
import cerent.cms.ui.functional.port.FunctPortGraphic;
import cerent.cms.ui.functional.svg.SvgGeneralFactory;
import cerent.util.view.fv.AbstractSvgFactory;
import cerent.util.view.fv.ILinkDefine;
import cerent.util.view.fv.IViewPSMCardGrapher;
import cerent.util.view.fv.IViewSvg;
import cerent.util.view.fv.IViewSvgParamInfo;
import cerent.util.view.fv.ViewAttribute;
import cerent.util.view.fv.ViewCompositeGraphic;
import cerent.util.view.fv.ViewGraphic;
import cerent.util.view.fv.ViewGraphicEnumeration;
import cerent.util.view.fv.ViewGraphicSet;
import cerent.util.view.fv.ViewSvgDecoderHelper;
import cerent.util.view.fv.helper.FunctDebug;
import cerent.util.view.fv.helper.SvgParams;
import ilog.views.IlvGraphic;
import ilog.views.graphic.IlvGraphicSet;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class FunctPSMCardGrapher
extends FunctCardGrapher
implements Observer,
IViewPSMCardGrapher {
    protected HashMap<String, ViewGraphicSet> selectorLine;
    private IFvInterfaceModel switchInterface;
    private boolean workingIsActive;

    private FunctPSMCardGrapher(SvgParams svgParams, ViewGraphicSet viewGraphicSet) {
        super(svgParams, viewGraphicSet);
        this.workingIsActive = ((IFvPSMModuleModel)this.card).isWorkingActive();
        this.paintLine();
        this.registerToLineModel();
    }

    private void registerToLineModel() {
        this.switchInterface = ((IFvPSMModuleModel)this.card).getWorkingInterface();
        if (this.switchInterface != null) {
            this.switchInterface.addObserver((Observer)this);
        }
    }

    private void paintLine() {
        if (this.workingIsActive) {
            ViewGraphic viewGraphic;
            IlvGraphic ilvGraphic;
            ViewGraphicSet viewGraphicSet = this.selectorLine.get(ViewSvgDecoderHelper.SvgTypeEnum.WORK_SELECT_LINE.name());
            ViewGraphicEnumeration viewGraphicEnumeration = viewGraphicSet.getViewObjects();
            while (viewGraphicEnumeration.hasMoreElements()) {
                ilvGraphic = viewGraphicEnumeration.nextElement();
                if (!(ilvGraphic instanceof IlvGraphic)) continue;
                viewGraphic = new ViewGraphic(ilvGraphic);
                viewGraphic.setBackground(ILinkDefine.SELECT_INTER_LNK_COLOR);
                viewGraphic.setForeground(ILinkDefine.SELECT_INTER_LNK_COLOR);
            }
            viewGraphicSet = this.selectorLine.get(ViewSvgDecoderHelper.SvgTypeEnum.PROT_SELECT_LINE.name());
            viewGraphicEnumeration = viewGraphicSet.getViewObjects();
            while (viewGraphicEnumeration.hasMoreElements()) {
                ilvGraphic = viewGraphicEnumeration.nextElement();
                if (!(ilvGraphic instanceof IlvGraphic)) continue;
                viewGraphic = new ViewGraphic(ilvGraphic);
                viewGraphic.setBackground(ILinkDefine.SELECT_INTER_STB_LNK_COLOR);
                viewGraphic.setForeground(ILinkDefine.SELECT_INTER_STB_LNK_COLOR);
            }
        } else {
            ViewGraphic viewGraphic;
            IlvGraphic ilvGraphic;
            ViewGraphicSet viewGraphicSet = this.selectorLine.get(ViewSvgDecoderHelper.SvgTypeEnum.PROT_SELECT_LINE.name());
            ViewGraphicEnumeration viewGraphicEnumeration = viewGraphicSet.getViewObjects();
            while (viewGraphicEnumeration.hasMoreElements()) {
                ilvGraphic = viewGraphicEnumeration.nextElement();
                if (!(ilvGraphic instanceof IlvGraphic)) continue;
                viewGraphic = new ViewGraphic(ilvGraphic);
                viewGraphic.setBackground(Color.GREEN);
                viewGraphic.setForeground(Color.GREEN);
            }
            viewGraphicSet = this.selectorLine.get(ViewSvgDecoderHelper.SvgTypeEnum.WORK_SELECT_LINE.name());
            viewGraphicEnumeration = viewGraphicSet.getViewObjects();
            while (viewGraphicEnumeration.hasMoreElements()) {
                ilvGraphic = viewGraphicEnumeration.nextElement();
                if (!(ilvGraphic instanceof IlvGraphic)) continue;
                viewGraphic = new ViewGraphic(ilvGraphic);
                viewGraphic.setBackground(ILinkDefine.SELECT_INTER_STB_LNK_COLOR);
                viewGraphic.setForeground(ILinkDefine.SELECT_INTER_STB_LNK_COLOR);
            }
        }
    }

    public String getGraphKey() {
        switch (this.getProtectionType()) {
            case 1: {
                if (((SvgParams)this.params).isHasOtherInstance()) {
                    return super.getGraphKey();
                }
                int n = ((IFvPSMModuleModel)this.card).getProtectedLambda();
                Attribute attribute = Wavelength.getWlAttribute(n);
                return String.valueOf(attribute.getIntValue());
            }
        }
        return super.getGraphKey();
    }

    public int getProtectionType() {
        return ((IFvPSMModuleModel)this.card).getPSMType();
    }

    protected void createSelectorLine(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
        if (this.selectorLine == null) {
            this.selectorLine = new HashMap();
        }
        if (viewAttribute.getValue() instanceof IlvGraphicSet) {
            ViewGraphicSet viewGraphicSet = new ViewGraphicSet((IlvGraphicSet)viewAttribute.getValue());
            viewGraphicSet.setName(((IViewSvgParamInfo)viewAttribute.getKey()).getSvgTyp().name());
            this.selectorLine.put(viewGraphicSet.getName(), viewGraphicSet);
        }
    }

    public static ViewCompositeGraphic createPSMIcon(SvgParams svgParams, ViewGraphicSet viewGraphicSet) {
        IFvPSMModuleModel iFvPSMModuleModel = (IFvPSMModuleModel)svgParams.getSvgValue();
        switch (iFvPSMModuleModel.getPSMType()) {
            case 1: {
                IViewSvg.SvgCardShape svgCardShape = IViewSvg.SvgCardShape.PSM_TXP;
                if (svgCardShape != null) {
                    try {
                        viewGraphicSet = AbstractSvgFactory.getSvgShape((IViewSvg.IViewSvgEnum)svgCardShape, (InputStream)SvgGeneralFactory.getSvgInputStream((IViewSvg.IViewSvgEnum)svgCardShape));
                    }
                    catch (SAXException sAXException) {
                        FunctDebug.printStackTrace((Throwable)sAXException);
                    }
                    catch (IOException iOException) {
                        FunctDebug.printStackTrace((Throwable)iOException);
                    }
                    catch (ParserConfigurationException parserConfigurationException) {
                        FunctDebug.printStackTrace((Throwable)parserConfigurationException);
                    }
                    if (viewGraphicSet == null) break;
                    return new FunctPSMCardGrapher(svgParams, viewGraphicSet);
                }
                return new FunctPSMCardGrapher(svgParams, viewGraphicSet);
            }
        }
        return new FunctPSMCardGrapher(svgParams, viewGraphicSet);
    }

    public boolean isWorkingActive() {
        return ((IFvPSMModuleModel)this.card).isWorkingActive();
    }

    @Override
    public void update(Observable observable, Object object) {
        super.update(observable, object);
        if (observable instanceof IFvOpticsLineModel) {
            try {
                boolean bl = this.switchInterface.isCurrentlyActive();
                if (bl != this.workingIsActive) {
                    this.workingIsActive = bl;
                    this.paintLine();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            FunctPSMCardGrapher.this.reDraw();
                        }
                    });
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                FunctDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                FunctDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
            catch (UnsupportedOperation unsupportedOperation) {
                FunctDebug.printStackTrace((Throwable)unsupportedOperation);
            }
        }
    }

    private Attribute getWavelengtAttr() {
        int n = 0;
        Object[] objectArray = this.getGraphChildren().values().toArray();
        try {
            IFvInterfaceModel iFvInterfaceModel = ((IFvOpticsPortModel)((FunctPortGraphic)((Object)objectArray[0])).getPortModel()).getIFvInterfaceModel();
            n = iFvInterfaceModel.getExpectedWaveLength();
            Attribute attribute = Wavelength.getWlAttribute(n);
            return attribute;
        }
        catch (NoSuchInterface noSuchInterface) {
            noSuchInterface.printStackTrace();
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            wrongInterfaceType.printStackTrace();
        }
        return Wavelength.getWlAttribute(174);
    }

    public Double getLambdaNum() {
        return Wavelength.getNumericWavelength(this.getWavelengtAttr().getIntValue());
    }

    @Override
    public void dispose() {
        if (this.switchInterface != null) {
            this.switchInterface.deleteObserver((Observer)this);
            this.switchInterface = null;
        }
        if (this.selectorLine != null) {
            this.selectorLine.clear();
            this.selectorLine = null;
        }
    }
}

