/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.functional.card;

import cerent.cms.fv.IFvNodeModel;
import cerent.cms.fv.IFvOpticsCardModel;
import cerent.cms.fv.IFvPortModel;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.ui.functional.FunctDomainGrapher;
import cerent.cms.ui.functional.card.FunctCardGrapher;
import cerent.cms.ui.functional.card.FunctPPmashGrapher;
import cerent.cms.ui.functional.svg.SvgFactoryDirector;
import cerent.util.view.fv.IViewGraph;
import cerent.util.view.fv.IViewSvgParamInfo;
import cerent.util.view.fv.ViewAttribute;
import cerent.util.view.fv.ViewGraphicSet;
import cerent.util.view.fv.ViewPortGraphic;
import cerent.util.view.fv.ViewSvgDecoderHelper;
import cerent.util.view.fv.ViewZoomLabel;
import cerent.util.view.fv.helper.FunctDebug;
import cerent.util.view.fv.helper.OpticalPatchCord;
import cerent.util.view.fv.helper.SvgParams;
import cerent.util.view.fv.helper.SvgParamsHelper;
import java.util.Collection;

public class WxcFunctCardGrapher
extends FunctCardGrapher {
    private ViewPortGraphic portExpTx;
    private ViewPortGraphic portMpoRX;

    public WxcFunctCardGrapher(SvgParams svgParams, ViewGraphicSet viewGraphicSet) {
        super(svgParams, viewGraphicSet);
    }

    public ViewPortGraphic getExpTx(FunctPPmashGrapher functPPmashGrapher, FunctDomainGrapher functDomainGrapher) {
        if (this.portExpTx == null) {
            this.portExpTx = (ViewPortGraphic)this.getPortByName("CARD_PORT-EXP-11-TX");
            OpticalPatchCord[] opticalPatchCordArray = null;
            try {
                opticalPatchCordArray = ((IFvOpticsCardModel)this.getCardModel()).getAllOpticalPatchCords();
                int n = this.portExpTx.getPortModel().getIndex();
                for (int i = 0; i < opticalPatchCordArray.length; ++i) {
                    if (opticalPatchCordArray[i].from != n) continue;
                    IFvPortModel iFvPortModel = (IFvPortModel)this.getCardModel().getIFVNodeModel().getEntityModelByIndex(opticalPatchCordArray[i].to);
                    IFvOpticsCardModel iFvOpticsCardModel = (IFvOpticsCardModel)iFvPortModel.getParentModel();
                    if (!(this.getGraphicBag() instanceof FunctDomainGrapher)) continue;
                    Collection collection = ((FunctDomainGrapher)this.getGraphicBag()).getGraphChildren().values();
                    for (IViewGraph iViewGraph : collection) {
                        FunctCardGrapher functCardGrapher;
                        if (!(iViewGraph instanceof FunctCardGrapher) || (functCardGrapher = (FunctCardGrapher)iViewGraph).getCardModel() != iFvOpticsCardModel) continue;
                        IViewGraph iViewGraph2 = functCardGrapher.getPortByName("CARD_PORT-LINE-6-TX");
                        if (iViewGraph2 == null) {
                            iViewGraph2 = functCardGrapher.getPortByName("CARD_PORT-COM-2-TX");
                        }
                        return (ViewPortGraphic)iViewGraph2;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                FunctDebug.printStackTrace((Throwable)numberFormatException);
            }
            catch (FeatureUnsupported featureUnsupported) {
                FunctDebug.printStackTrace((Throwable)featureUnsupported);
            }
            catch (NoSuchInterface noSuchInterface) {
                FunctDebug.printStackTrace((Throwable)noSuchInterface);
            }
            return this.portExpTx;
        }
        return this.portExpTx;
    }

    private String giveWxcMode(int n) {
        String string = "";
        switch (n) {
            case 30: {
                string = "BIDI";
                break;
            }
            case 32: {
                string = "DMX";
                break;
            }
            case 31: {
                string = "MUX";
            }
        }
        return string;
    }

    public ViewPortGraphic getExpRx() {
        if (this.portMpoRX == null) {
            this.portMpoRX = (ViewPortGraphic)this.getPortByName("MPO_PORT-SIDE-1-RX");
        }
        return this.portMpoRX;
    }

    @Override
    protected void createCardExtraLabel(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
        ViewZoomLabel viewZoomLabel = (ViewZoomLabel)SvgFactoryDirector.getViewElem(SvgParamsHelper.getSvgZoomLabelParams((IFvNodeModel)this.getViewManager().getNode(), (IViewGraph)this, viewAttribute));
        String string = " ( )";
        string = " (" + this.giveWxcMode(this.getCardModel().getCardOpMode()) + ")";
        viewZoomLabel.safeSetLabel(string);
        this.setLabel(ViewSvgDecoderHelper.SvgTypeEnum.CARD_EXTRA_LABEL.toString(), string);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.portExpTx = null;
        this.portMpoRX = null;
    }
}

