/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.functional.circuit;

import cerent.cms.fv.IFvCardModel;
import cerent.cms.fv.IFvDwdmTrkLineModel;
import cerent.cms.fv.IFvEntityModel;
import cerent.cms.fv.IFvInterfaceModel;
import cerent.cms.fv.IFvNodeModel;
import cerent.cms.fv.IFvOptLinkModel;
import cerent.cms.fv.IFvOpticsCardModel;
import cerent.cms.fv.IFvOpticsLineModel;
import cerent.cms.fv.IFvOpticsPortModel;
import cerent.cms.fv.IFvPSMModuleModel;
import cerent.cms.fv.IFvPortModel;
import cerent.cms.fv.IFvSideModel;
import cerent.cms.fv.IFvViewCircuitPath;
import cerent.cms.fv.helper.FunctionalCircuitsHelper;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.Attribute;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.FVNodeModelDelegate;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IOchncPathDefModel;
import cerent.cms.model.ISOchPath;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InterfaceModels;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OpticsChannelModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.SOchPath;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.WrongPortType;
import cerent.cms.ui.DwdmSide;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.functional.FunctBandDomainGrapher;
import cerent.cms.ui.functional.FunctDomainGrapher;
import cerent.cms.ui.functional.FunctView;
import cerent.cms.ui.functional.ViewManagerDelegate;
import cerent.cms.ui.functional.circuit.FunctViewCircuitPathElement;
import cerent.cms.ui.functional.link.FunctSideViewLink;
import cerent.cms.ui.functional.link.FunctViewDCULink;
import cerent.cms.ui.functional.link.FunctViewLink;
import cerent.cms.ui.functional.link.FunctViewPureGraphicalLink;
import cerent.cms.ui.functional.link.FunctViewWxcLink;
import cerent.cms.ui.functional.port.FunctSidePortCircuitPathElement;
import cerent.util.IFvDebug;
import cerent.util.SDebug;
import cerent.util.view.fv.IViewGraph;
import cerent.util.view.fv.IViewLink;
import cerent.util.view.fv.ViewCircuitPathElement;
import cerent.util.view.fv.ViewDomainGrapher;
import cerent.util.view.fv.ViewGrapher;
import cerent.util.view.fv.ViewManagerToolKit;
import cerent.util.view.fv.ViewPortGraphic;
import cerent.util.view.fv.ViewPureGraphicalLink;
import cerent.util.view.fv.helper.FunctDebug;
import cerent.util.view.fv.helper.FunctException;
import cerent.util.view.fv.helper.OpticalPatchCord;
import cerent.util.view.fv.helper.ViewCardHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class FunctionalCircuitPath
implements IFvViewCircuitPath {
    private static final int SIDEIDX = 65536;
    private SOchPath ochList;
    private ArrayList<SOchPath> ochDebugList = new ArrayList();
    private ViewManagerDelegate vm;
    private HashMap<Integer, ViewCircuitPathElement> circuitPathElement;
    private HashMap<Integer, ViewCircuitPathElement> currentCircuitPathElement;
    private HashMap<Integer, PpMeshLink> ppMeshLink;
    private IFvSideModel sideModel;
    private int circuitType;
    private boolean evenCircuit;
    private IFvNodeModel nmd = null;
    private boolean findOneLink;
    private int oadmSide;
    private Debug db;
    private int usedLambda;
    private boolean nodeIsInActivePath;
    private ArrayList<ViewDomainGrapher> pathUsedSide;
    private ViewDomainGrapher workingSideGrapher;
    private ActiveStby activeStbyLinks;
    private IOchncPathDefModel[] externalPort;
    private boolean externalPortsAlreadyDone = false;
    private int positionElementNetwork = 0;
    private int sideportPositionElementNetwork = 65536;

    public FunctionalCircuitPath(ViewManagerDelegate viewManagerDelegate, IFvSideModel iFvSideModel) {
        this.vm = viewManagerDelegate;
        this.sideModel = iFvSideModel;
        this.nmd = viewManagerDelegate.getNode();
        this.evenCircuit = false;
        this.circuitPathElement = new HashMap();
        this.pathUsedSide = new ArrayList();
        this.ppMeshLink = new HashMap();
        this.findOneLink = false;
        if (this.db == null) {
            this.db = new Debug("FunctionalCircuitPath");
        }
        this.nodeIsInActivePath = true;
    }

    public void addPath(ISOchPath iSOchPath, int n, int n2) {
        this.ochList = (SOchPath)iSOchPath;
        if (this.positionElementNetwork == 0) {
            this.ochDebugList.clear();
        }
        this.ochDebugList.add(this.ochList);
        this.evenCircuit = Wavelength.isEvenLambda(new Attribute("", n2));
        this.circuitType = n;
        this.usedLambda = n2;
        this.activeStbyLinks = new ActiveStby();
        if (this.db.on()) {
            int n3;
            this.db.println("addPath for type: " + n + "; lamba: " + n2);
            this.db.print("ochList Uptrail: ");
            int[] nArray = iSOchPath.getUpTrail();
            for (n3 = 0; n3 < nArray.length; ++n3) {
                this.db.print("0x" + Integer.toHexString(nArray[n3]) + " - ");
            }
            this.db.print("ochList Downtrail: ");
            nArray = iSOchPath.getDownTrail();
            for (n3 = 0; n3 < nArray.length; ++n3) {
                this.db.print("0x" + Integer.toHexString(nArray[n3]) + " - ");
            }
        }
        this.collectLinks(this.sideModel);
    }

    public void paint() {
        if (this.circuitPathElement != null) {
            this.vm.getCircuitsPathManager().paint(this.circuitPathElement.values());
            this.currentCircuitPathElement = new HashMap<Integer, ViewCircuitPathElement>(this.circuitPathElement);
            this.circuitPathElement.clear();
            this.ppMeshLink.clear();
            this.activeStbyLinks.clear();
        }
        this.clearCurrentselectedFlag();
    }

    private void clearCurrentselectedFlag() {
        this.externalPortsAlreadyDone = false;
        this.positionElementNetwork = 0;
        this.sideportPositionElementNetwork = 65536;
        this.pathUsedSide.clear();
        IFvSideModel[] iFvSideModelArray = this.nmd.getIfvSideModels();
        for (int i = 0; i < iFvSideModelArray.length; ++i) {
            ViewDomainGrapher viewDomainGrapher = this.vm.getViewTk().getSideDomain(DwdmSide.getSideLabelFromOffset(iFvSideModelArray[i].getId()));
            if (viewDomainGrapher == null) continue;
            viewDomainGrapher.setSideDomainInActivePath(true);
        }
    }

    public void paintAddedObj(ViewCircuitPathElement viewCircuitPathElement) {
        this.vm.getCircuitsPathManager().paintAddedObj(viewCircuitPathElement);
    }

    private void collectLinks(IFvSideModel iFvSideModel) {
        IViewGraph iViewGraph = null;
        ViewManagerToolKit viewManagerToolKit = this.vm.getViewTk();
        if (iFvSideModel == null) {
            HashMap<Integer, IViewLink> hashMap = new HashMap<Integer, IViewLink>();
            Collection collection = viewManagerToolKit.getGraphChildren().values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.findOneLink = false;
                iViewGraph = (IViewGraph)iterator.next();
                if (!(iViewGraph instanceof ViewDomainGrapher)) continue;
                this.findSidePort((ViewDomainGrapher)iViewGraph);
                hashMap.putAll(((ViewDomainGrapher)iViewGraph).getGraphLinks());
            }
            hashMap.putAll(viewManagerToolKit.getGraphLinks());
            this.findLinkInSide(hashMap);
        } else {
            String string = "FunctDomainGrapher" + DwdmSide.getSideFromOffset(iFvSideModel.getId());
            iViewGraph = viewManagerToolKit.getSpecificGraphChildren(string);
            if (iViewGraph instanceof ViewDomainGrapher) {
                this.workingSideGrapher = (ViewDomainGrapher)iViewGraph;
                this.findLinkInSide(this.workingSideGrapher.getGraphLinks());
            }
        }
        this.finalCheck(viewManagerToolKit, false);
        if (this.db.on()) {
            this.db.println("collectLinks(" + (iFvSideModel == null ? "-" : iFvSideModel.getName()) + ")");
            this.db.links(true);
        }
    }

    private void finalCheck(ViewManagerToolKit viewManagerToolKit, boolean bl) {
        block15: {
            try {
                this.adjustWxc();
            }
            catch (FunctException functException) {
                if (!this.db.on()) break block15;
                this.db.println("The WXC links are not found");
            }
        }
        if (this.circuitPathElement.size() == 0 || bl) {
            int[] nArray = this.ochList.getUpTrail();
            InterfaceModels interfaceModels = ((FVNodeModelDelegate)this.nmd).getDelegate().getIfModels();
            for (int i = 0; i < nArray.length; ++i) {
                try {
                    Object object;
                    InterfaceModel interfaceModel = interfaceModels.getInterfaceModel(nArray[i]);
                    boolean bl2 = false;
                    if (!(interfaceModel.getThePortModel() instanceof IFvOpticsPortModel)) continue;
                    IFvOpticsPortModel iFvOpticsPortModel = (IFvOpticsPortModel)interfaceModel.getThePortModel();
                    if (iFvOpticsPortModel.isLineOptPort()) {
                        bl2 = true;
                    } else if (iFvOpticsPortModel.isDCPort()) {
                        bl2 = true;
                    } else if (bl) {
                        object = this.nmd.getIfvSideModels();
                        int n = iFvOpticsPortModel.getIndex();
                        for (int j = 0; j < ((IFvSideModel[])object).length; ++j) {
                            if (n != object[j].getLineIn() && n != object[j].getLineOut()) continue;
                            bl2 = true;
                            break;
                        }
                    }
                    if (!bl2) continue;
                    object = "FunctDomainGrapher" + DwdmSide.getSideFromOffset(iFvOpticsPortModel.getSide());
                    IViewGraph iViewGraph = viewManagerToolKit.getSpecificGraphChildren((String)object);
                    this.takeExtraLine((ViewGrapher)iViewGraph);
                    continue;
                }
                catch (NoSuchInterface noSuchInterface) {
                    FunctDebug.printStackTrace((Throwable)noSuchInterface);
                    continue;
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    FunctDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    continue;
                }
                catch (NoSuchEquipment noSuchEquipment) {
                    FunctDebug.printStackTrace((Throwable)noSuchEquipment);
                    continue;
                }
                catch (WrongPortType wrongPortType) {
                    FunctDebug.printStackTrace((Throwable)wrongPortType);
                }
            }
        }
    }

    private void findSidePort(ViewDomainGrapher viewDomainGrapher) {
        if (this.externalPort != null && this.externalPort.length > 0) {
            if (!this.externalPortsAlreadyDone) {
                this.takeBoundaryPortFromNFV();
            }
            this.externalPortsAlreadyDone = true;
        } else {
            InterfaceModels interfaceModels = ((FVNodeModelDelegate)this.nmd).getDelegate().getIfModels();
            int[] nArray = this.ochList.getUpTrail();
            IFvInterfaceModel iFvInterfaceModel = null;
            for (int i = 0; i < nArray.length; ++i) {
                try {
                    IFvInterfaceModel[] iFvInterfaceModelArray;
                    InterfaceModel interfaceModel = interfaceModels.getInterfaceModel(nArray[i]);
                    if (interfaceModel instanceof OpticsChannelModel || (iFvInterfaceModelArray = interfaceModel.getLowerLayerModels()).length <= 0) continue;
                    iFvInterfaceModel = iFvInterfaceModelArray[0];
                    int n = iFvInterfaceModel.getIndex();
                    this.takeSidePort((FunctDomainGrapher)viewDomainGrapher, n);
                    List list = ((FunctDomainGrapher)viewDomainGrapher).getOtherSides();
                    if (list.size() == 0) continue;
                    for (IFvSideModel iFvSideModel : list) {
                        this.takeSidePort((FunctDomainGrapher)viewDomainGrapher, n);
                    }
                    continue;
                }
                catch (NoSuchInterface noSuchInterface) {
                    if (this.db.on()) {
                        this.db.println("Wrong interface id [" + Integer.toHexString(nArray[i]) + "] retrived by the upTrail");
                    }
                    FunctDebug.printStackTrace((Throwable)noSuchInterface);
                }
            }
        }
    }

    private void takeBoundaryPortFromNFV() {
        for (int i = 0; i < this.externalPort.length; ++i) {
            ViewPortGraphic viewPortGraphic;
            int n;
            block7: {
                n = this.externalPort[i].getPortEntityIdx();
                viewPortGraphic = (ViewPortGraphic)ViewCardHelper.getGraphPortByIndex((int)n, (ViewManagerToolKit)this.vm.getViewTk());
                if (viewPortGraphic == null) continue;
                try {
                    if (!(viewPortGraphic.getPortModel() instanceof IFvOpticsPortModel)) break block7;
                    List list = null;
                    IFvOpticsPortModel iFvOpticsPortModel = (IFvOpticsPortModel)viewPortGraphic.getPortModel();
                    if (iFvOpticsPortModel.isOptPortTypeTX()) {
                        list = iFvOpticsPortModel.getIFvNextPhysicalPorts(this.usedLambda);
                        if (list.size() != 0 && ((IFvOpticsPortModel)list.get(0)).isPassivePort()) {
                        }
                    } else {
                        list = iFvOpticsPortModel.getIFvPrevPhysicalPorts(this.usedLambda);
                        if (list.size() != 0 && ((IFvOpticsPortModel)list.get(0)).isPassivePort()) {
                        }
                    }
                }
                catch (Exception exception) {}
                continue;
            }
            this.insertElem(n, new FunctSidePortCircuitPathElement(viewPortGraphic, this.usedLambda), null);
        }
    }

    private void findLinkInSide(HashMap<Integer, IViewLink> hashMap) {
        this.findInternalLinks(hashMap.values());
        for (ViewDomainGrapher this.workingSideGrapher : this.pathUsedSide) {
            this.findOneLink |= this.nmd.getNodeOpticalType() == 13 || this.nmd.getNodeOpticalType() == 14;
            if (this.nmd.getNodeOpticalType() == 4) {
                String string = "FunctDomainGrapher" + DwdmSide.getSideFromOffset(this.oadmSide);
                this.findOneLink |= string.equalsIgnoreCase(this.workingSideGrapher.getGraphKey());
            }
            this.activeStbyLinks.init();
            if (!this.findOneLink) continue;
            this.takeExtraLine((ViewGrapher)this.workingSideGrapher);
        }
        if (this.pathUsedSide.size() == 0) {
            IFvSideModel[] iFvSideModelArray = this.nmd.getIfvSideModels();
            for (int i = 0; i < iFvSideModelArray.length; ++i) {
                this.workingSideGrapher = this.vm.getViewTk().getSideDomain(DwdmSide.getSideLabelFromOffset(iFvSideModelArray[i].getId()));
                this.activeStbyLinks.init();
                this.finalCheck(this.vm.getViewTk(), true);
            }
        }
    }

    private FunctViewPureGraphicalLink getLinkFromIndexMask(HashMap<Integer, IViewLink> hashMap, int n) {
        if (hashMap != null) {
            Iterator<Integer> iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                ViewPureGraphicalLink viewPureGraphicalLink = (ViewPureGraphicalLink)hashMap.get(iterator.next());
                if (viewPureGraphicalLink.getIndexMask() != n) continue;
                return (FunctViewPureGraphicalLink)viewPureGraphicalLink;
            }
        }
        return null;
    }

    private void findInternalLinks(Collection<IViewLink> collection) {
        Object abstractCmsNoSuchEntityException;
        IViewLink iViewLink;
        Object object;
        if (this.db.on()) {
            this.db.println("Enter in findInternalLinks");
        }
        InterfaceModels interfaceModels = ((FVNodeModelDelegate)this.nmd).getDelegate().getIfModels();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int[] nArray = this.ochList.getUpTrail();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(nArray[i]);
        }
        for (Integer n : arrayList) {
            try {
                InterfaceModel noSuchInterface = interfaceModels.getInterfaceModel(n);
                object = null;
                try {
                    if (noSuchInterface.getThePortModel() instanceof IFvOpticsPortModel) {
                        object = (IFvOpticsPortModel)noSuchInterface.getThePortModel();
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException2) {
                    FunctDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException2);
                }
                if (this.portAlreadyInCircuit((IFvOpticsPortModel)object)) continue;
                iViewLink = this.findLink(noSuchInterface, collection);
                try {
                    if (object != null && iViewLink != null) {
                        this.setWorkiningSide((IFvOpticsPortModel)object);
                        abstractCmsNoSuchEntityException = object.getIFvNextPhysicalPorts(this.usedLambda);
                        IFvPortModel wrongPortType = null;
                        if (abstractCmsNoSuchEntityException.size() > 0) {
                            wrongPortType = (IFvPortModel)abstractCmsNoSuchEntityException.get(0);
                        }
                        if (wrongPortType instanceof IFvOpticsPortModel && ((IFvOpticsPortModel)wrongPortType).isPassivePort() && !((IFvOpticsPortModel)wrongPortType).isDCPort() && !((IFvOpticsPortModel)wrongPortType).isPPMeshPort()) {
                            this.takePassivePorts(collection, (IFvOpticsPortModel)object, true);
                        } else {
                            abstractCmsNoSuchEntityException = object.getIFvPrevPhysicalPorts(this.usedLambda);
                            wrongPortType = null;
                            if (abstractCmsNoSuchEntityException.size() > 0) {
                                wrongPortType = (IFvPortModel)abstractCmsNoSuchEntityException.get(0);
                            }
                            if (wrongPortType instanceof IFvOpticsPortModel && ((IFvOpticsPortModel)wrongPortType).isPassivePort() && !((IFvOpticsPortModel)wrongPortType).isDCPort() && !((IFvOpticsPortModel)wrongPortType).isPPMeshPort()) {
                                this.takePassivePorts(collection, (IFvOpticsPortModel)object, false);
                            }
                        }
                    }
                }
                catch (NoSuchEquipment noSuchEquipment) {
                    FunctDebug.printStackTrace((Throwable)noSuchEquipment);
                }
                catch (WrongPortType wrongPortType) {
                    FunctDebug.printStackTrace((Throwable)wrongPortType);
                }
                if (iViewLink != null) {
                    collection.remove(iViewLink);
                    this.findOneLink = true;
                    continue;
                }
                abstractCmsNoSuchEntityException = this.vm.getViewTk();
                try {
                    int noSuchEquipment;
                    String string;
                    IViewGraph iViewGraph;
                    if (object == null || !object.isDCPort() || (iViewGraph = abstractCmsNoSuchEntityException.getSpecificGraphChildren(string = (noSuchEquipment = object.getSide()) != 0 ? "FunctDomainGrapher" + DwdmSide.getSideLabelFromOffset(noSuchEquipment) : "FunctDomainGrapherOmnidirectional")) != this.workingSideGrapher || this.workingSideGrapher == null) continue;
                    this.takeDCU((ViewGrapher)iViewGraph, (IFvOpticsPortModel)object);
                }
                catch (NoSuchEquipment wrongPortType) {
                    FunctDebug.printStackTrace((Throwable)wrongPortType);
                }
                catch (WrongPortType wrongPortType) {
                    FunctDebug.printStackTrace((Throwable)wrongPortType);
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                if (this.db.on()) {
                    this.db.println("Wrong interface id [" + Integer.toHexString(n) + "] retrived by the upTrail");
                }
                FunctDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        if ((this.circuitType == 15 || this.circuitType == 14) && this.ochList.hasDownTrail()) {
            IFvOpticsPortModel iFvOpticsPortModel = null;
            nArray = this.ochList.getDownTrail();
            for (int i = 0; i < nArray.length; ++i) {
                arrayList.add(nArray[i]);
            }
            for (Integer n : arrayList) {
                try {
                    block34: {
                        object = interfaceModels.getInterfaceModel(n);
                        iViewLink = this.findLink((IFvInterfaceModel)object, collection);
                        try {
                            if (!(object.getThePortModel() instanceof IFvOpticsPortModel) || (iFvOpticsPortModel = (IFvOpticsPortModel)object.getThePortModel()).getIFvPrevPhysicalPorts(this.usedLambda).size() == 0 || !((abstractCmsNoSuchEntityException = (IFvPortModel)iFvOpticsPortModel.getIFvPrevPhysicalPorts(this.usedLambda).get(0)) instanceof IFvOpticsPortModel)) break block34;
                            try {
                                if (((IFvOpticsPortModel)abstractCmsNoSuchEntityException).isPassivePort() && !((IFvOpticsPortModel)abstractCmsNoSuchEntityException).isDCPort() && !((IFvOpticsPortModel)abstractCmsNoSuchEntityException).isPPMeshPort()) {
                                    this.takePassivePorts(collection, (IFvOpticsPortModel)abstractCmsNoSuchEntityException, false);
                                }
                            }
                            catch (NoSuchEquipment noSuchEquipment) {
                                FunctDebug.printStackTrace((Throwable)noSuchEquipment);
                            }
                            catch (WrongPortType wrongPortType) {
                                FunctDebug.printStackTrace((Throwable)wrongPortType);
                            }
                        }
                        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException3) {
                            FunctDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException3);
                        }
                    }
                    if (iViewLink == null) continue;
                    collection.remove(iViewLink);
                    this.findOneLink = true;
                }
                catch (NoSuchInterface noSuchInterface) {
                    if (this.db.on()) {
                        this.db.println("Wrong interface id [" + n + "] retrived by the downTrail");
                    }
                    FunctDebug.printStackTrace((Throwable)noSuchInterface);
                }
            }
        }
    }

    private void setWorkiningSide(IFvOpticsPortModel iFvOpticsPortModel) {
        this.workingSideGrapher = this.vm.getViewTk().getSideDomain(DwdmSide.getSideLabelFromOffset(iFvOpticsPortModel.getSide()));
        if (this.workingSideGrapher != null && !this.pathUsedSide.contains(this.workingSideGrapher)) {
            this.pathUsedSide.add(this.workingSideGrapher);
        }
    }

    private boolean portAlreadyInCircuit(IFvOpticsPortModel iFvOpticsPortModel) {
        if (iFvOpticsPortModel == null) {
            return false;
        }
        for (ViewCircuitPathElement viewCircuitPathElement : this.circuitPathElement.values()) {
            IFvPortModel iFvPortModel;
            if (viewCircuitPathElement instanceof FunctSidePortCircuitPathElement) {
                iFvPortModel = ((FunctSidePortCircuitPathElement)viewCircuitPathElement).getPortGraphic();
                if (!iFvPortModel.hasIndex(iFvOpticsPortModel.getIndex())) continue;
                if (viewCircuitPathElement.getSequenceInNetwork() >= 65536) {
                    viewCircuitPathElement.addNetworkSequence(this.positionElementNetwork++);
                }
                return true;
            }
            iFvPortModel = viewCircuitPathElement.getPortIn();
            if (iFvPortModel != null && iFvPortModel.getIndex() == iFvOpticsPortModel.getIndex()) {
                return true;
            }
            iFvPortModel = viewCircuitPathElement.getPortOut();
            if (iFvPortModel == null || iFvPortModel.getIndex() != iFvOpticsPortModel.getIndex()) continue;
            return true;
        }
        return false;
    }

    private void takeExtraLine(ViewGrapher viewGrapher) {
        HashMap hashMap = viewGrapher.getSideGraphLinks();
        HashMap hashMap2 = viewGrapher.getMpoLinks();
        if (viewGrapher instanceof FunctDomainGrapher && !((FunctView)this.vm.getViewTk()).isFromNtw()) {
            Object object;
            InterfaceModel interfaceModel;
            int n;
            Object object2;
            InterfaceModels interfaceModels;
            Object object3;
            FunctDomainGrapher functDomainGrapher = (FunctDomainGrapher)viewGrapher;
            int n2 = 0;
            if (functDomainGrapher.hasProtection()) {
                n2 = 1;
            }
            for (int i = 0; i <= n2; ++i) {
                try {
                    this.takeSideLine(hashMap, functDomainGrapher.getSideId(i));
                    continue;
                }
                catch (FunctException functException) {
                    if (!this.db.on()) continue;
                    this.db.println("The link for the side " + i + " is not found");
                }
            }
            List list = functDomainGrapher.getOtherSides();
            if (list.size() != 0) {
                object3 = this.ochList.getUpTrail();
                interfaceModels = null;
                object2 = ((FVNodeModelDelegate)this.nmd).getDelegate().getIfModels();
                for (n = 0; n < ((int[])object3).length; ++n) {
                    try {
                        IFvInterfaceModel[] iFvInterfaceModelArray;
                        interfaceModel = ((InterfaceModels)object2).getInterfaceModel(object3[n]);
                        if (interfaceModel instanceof OpticsChannelModel || (iFvInterfaceModelArray = interfaceModel.getLowerLayerModels()).length <= 0) continue;
                        interfaceModels = iFvInterfaceModelArray[0];
                        int n3 = interfaceModels.getIndex();
                        object = list.iterator();
                        while (object.hasNext()) {
                            IFvSideModel iFvSideModel = (IFvSideModel)object.next();
                            if (iFvSideModel.getLineIn() != n3 && iFvSideModel.getLineOut() != n3) continue;
                            try {
                                this.takeSideLine(hashMap, iFvSideModel.getId());
                            }
                            catch (FunctException functException) {
                                FunctDebug.printStackTrace((Throwable)functException);
                            }
                        }
                        continue;
                    }
                    catch (NoSuchInterface noSuchInterface) {
                        if (this.db.on()) {
                            this.db.println("Wrong interface id [" + Integer.toHexString(object3[n]) + "] retrived by the upTrail");
                        }
                        FunctDebug.printStackTrace((Throwable)noSuchInterface);
                    }
                }
            }
            if (functDomainGrapher.hasMMU()) {
                object3 = functDomainGrapher.getSideModel(2);
                interfaceModels = ((FVNodeModelDelegate)this.nmd).getDelegate().getIfModels();
                object2 = this.ochList.getUpTrail();
                for (n = 0; n < ((Object)object2).length; ++n) {
                    try {
                        interfaceModel = interfaceModels.getInterfaceModel((int)object2[n]);
                        int n4 = interfaceModel.getThePortModel().getIndex();
                        int[] nArray = object3.getLinesIn();
                        object = object3.getLinesOut();
                        boolean bl = false;
                        for (Object object4 : nArray) {
                            if (object4 != n4) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            Object object5 = object;
                            int n3 = ((Object)object5).length;
                            for (int i = 0; i < n3; ++i) {
                                Object object4;
                                object4 = object5[i];
                                if (object4 != n4) continue;
                                bl = true;
                                break;
                            }
                        }
                        if (!bl) continue;
                        try {
                            this.takeSideLine(hashMap, functDomainGrapher.getSideId(2));
                        }
                        catch (FunctException functException) {
                            if (!this.db.on()) continue;
                            this.db.println("The link for the MMUside " + functDomainGrapher.getSideId(2) + " is not found");
                        }
                        continue;
                    }
                    catch (NoSuchInterface noSuchInterface) {
                        FunctDebug.printStackTrace((Throwable)noSuchInterface);
                        continue;
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        FunctDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                }
            }
        }
    }

    private void takePassivePorts(Collection<IViewLink> collection, IFvOpticsPortModel iFvOpticsPortModel, boolean bl) {
        Object var5_4 = null;
        int n = 0;
        boolean bl2 = false;
        IFvOpticsPortModel iFvOpticsPortModel2 = bl ? FunctionalCircuitsHelper.getNextPassivePort((IFvOpticsPortModel)iFvOpticsPortModel, (int)this.usedLambda) : FunctionalCircuitsHelper.getPrevPassivePort((IFvOpticsPortModel)iFvOpticsPortModel, (int)this.usedLambda);
        if (iFvOpticsPortModel2 != null) {
            n = iFvOpticsPortModel2.getCardModel().getIndex();
            iFvOpticsPortModel = bl ? FunctionalCircuitsHelper.getNextPassivePort((IFvOpticsPortModel)iFvOpticsPortModel2, (int)this.usedLambda) : FunctionalCircuitsHelper.getPrevPassivePort((IFvOpticsPortModel)iFvOpticsPortModel2, (int)this.usedLambda);
            while (iFvOpticsPortModel != null) {
                if (iFvOpticsPortModel.getCardModel().getIndex() != n) {
                    IViewLink iViewLink = this.findPassiveLink(collection, iFvOpticsPortModel2, iFvOpticsPortModel);
                    try {
                        this.addLinkForCircuitPaint(iViewLink, n, iFvOpticsPortModel.getCardModel().getIndex(), null, null, this.nmd, true);
                    }
                    catch (FunctException functException) {
                        FunctDebug.printStackTrace((Throwable)functException);
                    }
                }
                iFvOpticsPortModel2 = iFvOpticsPortModel;
                if (bl) {
                    iFvOpticsPortModel = FunctionalCircuitsHelper.getNextPassivePort((IFvOpticsPortModel)iFvOpticsPortModel, (int)this.usedLambda);
                    continue;
                }
                iFvOpticsPortModel = FunctionalCircuitsHelper.getPrevPassivePort((IFvOpticsPortModel)iFvOpticsPortModel, (int)this.usedLambda);
            }
        }
    }

    private IViewLink findPassiveLink(Collection<IViewLink> collection, IFvOpticsPortModel iFvOpticsPortModel, IFvOpticsPortModel iFvOpticsPortModel2) {
        for (IViewLink iViewLink : collection) {
            if ((iViewLink.getFromPort() != iFvOpticsPortModel.getIndex() || iViewLink.getToPort() != iFvOpticsPortModel2.getIndex()) && (iViewLink.getToPort() != iFvOpticsPortModel.getIndex() || iViewLink.getFromPort() != iFvOpticsPortModel2.getIndex())) continue;
            return iViewLink;
        }
        return null;
    }

    private void takeDCU(ViewGrapher viewGrapher, IFvOpticsPortModel iFvOpticsPortModel) {
        HashMap hashMap = viewGrapher.getMpoLinks();
        this.workingSideGrapher = (ViewDomainGrapher)viewGrapher;
        IViewLink iViewLink = (IViewLink)hashMap.get(iFvOpticsPortModel.getEntityIndex());
        if (iViewLink instanceof FunctViewDCULink) {
            FunctViewDCULink functViewDCULink = (FunctViewDCULink)iViewLink;
            try {
                this.addLinkForCircuitPaint(iViewLink, functViewDCULink.getPortModelFrom().getIndex(), functViewDCULink.getPortModelTo().getIndex(), functViewDCULink.getPortModelFrom().getIFvInterfaceModel(), functViewDCULink.getPortModelTo().getIFvInterfaceModel(), this.nmd, false);
                this.findOneLink = true;
            }
            catch (FunctException functException) {
                FunctDebug.printStackTrace((Throwable)functException);
            }
        }
    }

    private void takeSidePort(FunctDomainGrapher functDomainGrapher, int n) {
        int[] nArray;
        List list = functDomainGrapher.getOtherSides();
        for (int n2 : nArray = functDomainGrapher.getSideModel().getLinesIn()) {
            ViewPortGraphic viewPortGraphic;
            if (n != n2 || (viewPortGraphic = this.vm.getViewTk().getConnectedPort(n2)) == null) continue;
            this.insertElem(viewPortGraphic.getPortModel().getIndex(), new FunctSidePortCircuitPathElement(viewPortGraphic, this.usedLambda), null);
        }
        int[] nArray2 = functDomainGrapher.getSideModel().getLinesOut();
        for (int n3 : nArray2) {
            ViewPortGraphic viewPortGraphic;
            if (n != n3 || (viewPortGraphic = this.vm.getViewTk().getConnectedPort(n3)) == null) continue;
            this.insertElem(viewPortGraphic.getPortModel().getIndex(), new FunctSidePortCircuitPathElement(viewPortGraphic, this.usedLambda), null);
        }
        Object object = list.iterator();
        while (object.hasNext()) {
            ViewPortGraphic viewPortGraphic;
            IFvSideModel iFvSideModel = (IFvSideModel)object.next();
            for (int n4 : nArray = iFvSideModel.getLinesIn()) {
                if (n != n4 || (viewPortGraphic = this.vm.getViewTk().getConnectedPort(n4)) == null) continue;
                this.insertElem(viewPortGraphic.getPortModel().getIndex(), new FunctSidePortCircuitPathElement(viewPortGraphic, this.usedLambda), null);
            }
            for (int n4 : nArray2 = iFvSideModel.getLinesOut()) {
                if (n != n4 || (viewPortGraphic = this.vm.getViewTk().getConnectedPort(n4)) == null) continue;
                this.insertElem(viewPortGraphic.getPortModel().getIndex(), new FunctSidePortCircuitPathElement(viewPortGraphic, this.usedLambda), null);
            }
        }
    }

    private void takeSideLine(HashMap<Integer, IViewLink> hashMap, int n) throws FunctException {
        IViewLink iViewLink = hashMap.get(256 + n);
        if (iViewLink instanceof FunctSideViewLink) {
            this.addLinkForCircuitPaint(iViewLink, null, null, null, ((FunctSideViewLink)iViewLink).getInterfaceModel(), null, false);
        }
        if ((iViewLink = hashMap.get(512 + n)) instanceof FunctSideViewLink) {
            this.addLinkForCircuitPaint(iViewLink, null, null, ((FunctSideViewLink)iViewLink).getInterfaceModel(), null, null, false);
        }
    }

    private IViewLink findLink(IFvInterfaceModel iFvInterfaceModel, Collection<IViewLink> collection) {
        int n = 0;
        IFvInterfaceModel iFvInterfaceModel2 = null;
        int n2 = 0;
        try {
            n2 = iFvInterfaceModel.getModuleModel().getEqType();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            FunctDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        if (n2 == 286) {
            this.activeStbyLinks.addPsm(iFvInterfaceModel);
        }
        if (iFvInterfaceModel instanceof IFvDwdmTrkLineModel) {
            this.activeStbyLinks.addTxp(iFvInterfaceModel);
            return null;
        }
        if (!(iFvInterfaceModel instanceof OpticsChannelModel)) {
            iFvInterfaceModel2 = iFvInterfaceModel.getLowerLayerModels()[0];
            n = iFvInterfaceModel2.getIndex();
            if (this.nmd.getNodeOpticalType() == 4) {
                this.takeTheSide(iFvInterfaceModel2);
            }
        } else {
            n = iFvInterfaceModel.getIndex();
            iFvInterfaceModel2 = iFvInterfaceModel;
        }
        for (IViewLink iViewLink : collection) {
            block21: {
                IFvOptLinkModel iFvOptLinkModel = iViewLink.getLinkModel().getLink();
                int n3 = iFvOptLinkModel.getTo();
                int n4 = iFvOptLinkModel.getFrom();
                if (iViewLink instanceof FunctViewWxcLink) {
                    if (iFvInterfaceModel instanceof OpticsChannelModel) continue;
                    IFvPortModel iFvPortModel = null;
                    try {
                        IViewLink iViewLink2;
                        iFvPortModel = iFvInterfaceModel.getThePortModel();
                        if (!this.needPPMeshLinkCheck(iFvPortModel.getCardModel()) || (iViewLink2 = this.isPPMeshLink((FunctViewWxcLink)iViewLink, iFvPortModel)) == null) continue;
                        return iViewLink2;
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        FunctDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                        continue;
                    }
                }
                boolean bl = true;
                if (n == n3) {
                    block20: {
                        if (this.vm.isNodeEven()) {
                            bl = this.addCorrectLink(n3, n4);
                        }
                        if (bl) {
                            try {
                                this.addLinkForCircuitPaint(iViewLink, n3, n4, iFvInterfaceModel2, null, this.nmd, false);
                            }
                            catch (FunctException functException) {
                                if (!this.db.on()) break block20;
                                this.db.println("The link" + iViewLink.getName() + "is not found do not add it");
                            }
                        }
                    }
                    return iViewLink;
                }
                if (n != n4) continue;
                if (this.vm.isNodeEven()) {
                    bl = this.addCorrectLink(n3, n4);
                }
                if (bl) {
                    try {
                        this.addLinkForCircuitPaint(iViewLink, n3, n4, null, iFvInterfaceModel2, this.nmd, false);
                    }
                    catch (FunctException functException) {
                        if (!this.db.on()) break block21;
                        this.db.println("The link" + iViewLink.getName() + "is not found do not add it");
                    }
                }
            }
            return iViewLink;
        }
        return null;
    }

    private boolean needPPMeshLinkCheck(IFvCardModel iFvCardModel) {
        int n = iFvCardModel.getEqType();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = bl2 = n == 266 || n == 270 || n == 297 || n == 295;
        if (!bl2 && iFvCardModel instanceof IFvOpticsCardModel) {
            bl = ((IFvOpticsCardModel)iFvCardModel).isAmplitWithPreRole();
        }
        return bl2 || bl;
    }

    private void takeTheSide(IFvInterfaceModel iFvInterfaceModel) {
        if (iFvInterfaceModel instanceof IFvOpticsLineModel) {
            try {
                this.oadmSide = ((IFvOpticsLineModel)iFvInterfaceModel).getSide();
            }
            catch (NoSuchInterface noSuchInterface) {
                this.oadmSide = 0;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                this.oadmSide = 0;
            }
            catch (InternalCommError internalCommError) {
                this.oadmSide = 0;
            }
        }
    }

    private boolean addCorrectLink(int n, int n2) {
        boolean bl = true;
        try {
            InterfaceModels interfaceModels = ((FVNodeModelDelegate)this.nmd).getDelegate().getIfModels();
            ModuleModel moduleModel = interfaceModels.getInterfaceModel(n).getModuleModel();
            int n3 = moduleModel.getEqType();
            if (n3 == 263 || n3 == 267 || n3 == 242 || n3 == 191) {
                OpticsModuleModel opticsModuleModel = (OpticsModuleModel)moduleModel;
                return opticsModuleModel.isEvenWavelengthCard() == this.evenCircuit;
            }
            moduleModel = interfaceModels.getInterfaceModel(n2).getModuleModel();
            n3 = moduleModel.getEqType();
            if (n3 == 263 || n3 == 267 || n3 == 242 || n3 == 191) {
                OpticsModuleModel opticsModuleModel = (OpticsModuleModel)moduleModel;
                return opticsModuleModel.isEvenWavelengthCard() == this.evenCircuit;
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            FunctDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        catch (NoSuchInterface noSuchInterface) {
            FunctDebug.printStackTrace((Throwable)noSuchInterface);
        }
        return bl;
    }

    private IViewLink isPPMeshLink(FunctViewWxcLink functViewWxcLink, IFvPortModel iFvPortModel) {
        FunctViewWxcLink functViewWxcLink2 = null;
        IFvCardModel iFvCardModel = iFvPortModel.getCardModel();
        int n = iFvCardModel.getEqType();
        int n2 = iFvPortModel.getEntityIndex();
        IFvOptLinkModel iFvOptLinkModel = functViewWxcLink.getLinkModel().getLink();
        int n3 = iFvOptLinkModel.getFrom();
        int n4 = iFvOptLinkModel.getTo();
        if (n2 == n3 || n2 == n4) {
            PpMeshLink ppMeshLink = new PpMeshLink(functViewWxcLink, iFvPortModel);
            this.ppMeshLink.put(functViewWxcLink.getIndex(), ppMeshLink);
            functViewWxcLink2 = functViewWxcLink;
        } else if (n == 295 && ((IFvOpticsPortModel)iFvPortModel).isOptPortTypeTX() || n == 297 && ((IFvOpticsPortModel)iFvPortModel).isOptPortTypeRX()) {
            boolean bl = false;
            switch (n) {
                case 295: {
                    if (n2 != n3 && n2 != n4) break;
                    bl = true;
                    break;
                }
                case 297: {
                    if (!iFvPortModel.getPortString().contains("EAD")) break;
                    IFvInterfaceModel[] iFvInterfaceModelArray = functViewWxcLink.getExpRxIModels();
                    for (int i = 0; i < iFvInterfaceModelArray.length; ++i) {
                        if (iFvInterfaceModelArray[i].getIndex() != n2) continue;
                        bl = true;
                    }
                    break;
                }
            }
            if (bl) {
                PpMeshLink ppMeshLink = new PpMeshLink(functViewWxcLink, iFvPortModel);
                this.ppMeshLink.put(functViewWxcLink.getIndex(), ppMeshLink);
                functViewWxcLink2 = functViewWxcLink;
            }
        } else {
            try {
                int n5 = ((IFvOpticsPortModel)iFvPortModel).getMPO();
                if (n5 != 0) {
                    int n6;
                    int n7 = 0;
                    int n8 = 0;
                    n7 = iFvOptLinkModel.getFromPortModel().getCardModel().getEntityIndex();
                    n8 = iFvOptLinkModel.getToPortModel().getCardModel().getEntityIndex();
                    if (iFvCardModel.getEntityIndex() == n7) {
                        int n9 = ((IFvOpticsPortModel)iFvOptLinkModel.getFromPortModel()).getMPO();
                        if (n9 == n5) {
                            if (n == 295 && ((IFvOpticsPortModel)functViewWxcLink.getLinkModel().getLink().getFromPortModel()).isOptPortTypeTX()) {
                                return functViewWxcLink2;
                            }
                            PpMeshLink ppMeshLink = new PpMeshLink(functViewWxcLink, iFvPortModel);
                            this.ppMeshLink.put(functViewWxcLink.getIndex(), ppMeshLink);
                            functViewWxcLink2 = functViewWxcLink;
                        }
                    } else if (iFvCardModel.getEntityIndex() == n8 && (n6 = ((IFvOpticsPortModel)iFvOptLinkModel.getToPortModel()).getMPO()) == n5) {
                        if (n == 295 && ((IFvOpticsPortModel)functViewWxcLink.getLinkModel().getLink().getToPortModel()).isOptPortTypeTX()) {
                            return functViewWxcLink2;
                        }
                        PpMeshLink ppMeshLink = new PpMeshLink(functViewWxcLink, iFvPortModel);
                        this.ppMeshLink.put(functViewWxcLink.getIndex(), ppMeshLink);
                        functViewWxcLink2 = functViewWxcLink;
                    }
                }
            }
            catch (NoSuchEquipment noSuchEquipment) {
                FunctDebug.printStackTrace((Throwable)noSuchEquipment);
            }
            catch (WrongPortType wrongPortType) {
                FunctDebug.printStackTrace((Throwable)wrongPortType);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                FunctDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return functViewWxcLink2;
    }

    private void adjustWxc() throws FunctException {
        for (PpMeshLink ppMeshLink : this.ppMeshLink.values()) {
            FunctViewWxcLink functViewWxcLink = ppMeshLink.getLink();
            functViewWxcLink.getIndex();
            if (functViewWxcLink.getLinkDirection() == 0) {
                this.addLinkForCircuitPaint((IViewLink)functViewWxcLink, null, null, null, functViewWxcLink.getExpTxIModel(), this.nmd, false);
                this.findOneLink = true;
                continue;
            }
            if (functViewWxcLink.getLinkDirection() != 1) continue;
            this.addLinkForCircuitPaint((IViewLink)functViewWxcLink, null, null, functViewWxcLink.getExpRxIModel(ppMeshLink.getSideId()), null, this.nmd, false);
            this.findOneLink = true;
        }
    }

    private void addTxpLinkForCircuitPaint(IViewLink iViewLink, Integer n, Integer n2, IFvInterfaceModel iFvInterfaceModel, IFvInterfaceModel iFvInterfaceModel2, IFvNodeModel iFvNodeModel, boolean bl, Integer n3) throws FunctException {
        FunctViewCircuitPathElement functViewCircuitPathElement = null;
        if (iViewLink == null) {
            return;
        }
        functViewCircuitPathElement = !bl ? new FunctViewCircuitPathElement(iViewLink, n, n2, iFvInterfaceModel, iFvInterfaceModel2, iFvNodeModel, this.nodeIsInActivePath, this.workingSideGrapher) : new FunctViewCircuitPathElement(iViewLink, iFvNodeModel, this.nodeIsInActivePath, this.workingSideGrapher);
        this.addElement(functViewCircuitPathElement, iViewLink.getIndex(), n3);
    }

    private void addLinkForCircuitPaint(IViewLink iViewLink, Integer n, Integer n2, IFvInterfaceModel iFvInterfaceModel, IFvInterfaceModel iFvInterfaceModel2, IFvNodeModel iFvNodeModel, boolean bl) throws FunctException {
        FunctViewCircuitPathElement functViewCircuitPathElement = null;
        if (iViewLink == null) {
            return;
        }
        functViewCircuitPathElement = !bl ? new FunctViewCircuitPathElement(iViewLink, n, n2, iFvInterfaceModel, iFvInterfaceModel2, iFvNodeModel, this.nodeIsInActivePath, this.workingSideGrapher) : new FunctViewCircuitPathElement(iViewLink, iFvNodeModel, this.nodeIsInActivePath, this.workingSideGrapher);
        this.addElement(functViewCircuitPathElement, iViewLink.getIndex(), null);
    }

    public void addCircuitPath(ISOchPath iSOchPath, int n, int n2, boolean bl) {
        this.nodeIsInActivePath = bl;
        this.externalPort = new IOchncPathDefModel[0];
        this.addPath(iSOchPath, n, n2);
    }

    public void addCircuitPath(ISOchPath iSOchPath, Integer n, int n2, boolean bl, Object[] objectArray) {
        this.nodeIsInActivePath = bl;
        this.collectBoundaryPorts(n, (IOchncPathDefModel[])objectArray);
        this.addPath(iSOchPath, n, n2);
    }

    private void collectBoundaryPorts(Integer n, IOchncPathDefModel[] iOchncPathDefModelArray) {
        if (this.circuitType == 15 || this.circuitType == 14) {
            ArrayList<IOchncPathDefModel> arrayList = new ArrayList<IOchncPathDefModel>();
            for (int i = 0; i < iOchncPathDefModelArray.length; ++i) {
                OpticsPortModel opticsPortModel;
                IFvEntityModel iFvEntityModel = this.nmd.getEntityModelByIndex(iOchncPathDefModelArray[i].getPortEntityIdx());
                if (iFvEntityModel instanceof OpticsPortModel && (opticsPortModel = (OpticsPortModel)iFvEntityModel).isChannelPort() || (opticsPortModel = iFvEntityModel.getParentModel()) instanceof IFvPSMModuleModel) continue;
                arrayList.add(iOchncPathDefModelArray[i]);
            }
            this.externalPort = arrayList.toArray(new IOchncPathDefModel[0]);
        } else {
            this.externalPort = iOchncPathDefModelArray;
        }
    }

    public HashMap<Integer, ViewCircuitPathElement> getCopyCircuitPathElement() {
        return (HashMap)this.currentCircuitPathElement.clone();
    }

    public int getUsedLambda() {
        return this.usedLambda;
    }

    private void addElement(ViewCircuitPathElement viewCircuitPathElement, int n, Integer n2) {
        if (viewCircuitPathElement != null) {
            this.insertElem(n, viewCircuitPathElement, n2);
            viewCircuitPathElement.setLambda(this.usedLambda);
        }
    }

    private ViewCircuitPathElement insertElem(int n, ViewCircuitPathElement viewCircuitPathElement, Integer n2) {
        int n3 = 0;
        if (this.workingSideGrapher != null) {
            n3 = this.workingSideGrapher.getSideId();
        }
        boolean bl = false;
        if (viewCircuitPathElement instanceof FunctSidePortCircuitPathElement) {
            n += n3 * 0x1000000;
            if (n2 == null) {
                viewCircuitPathElement.addNetworkSequence(this.sideportPositionElementNetwork++);
            } else {
                viewCircuitPathElement.addNetworkSequence(n2.intValue());
            }
            bl = true;
        } else if (!this.circuitPathElement.containsKey(n)) {
            bl = true;
            if (viewCircuitPathElement.getLink() instanceof FunctViewWxcLink) {
                FunctViewWxcLink functViewWxcLink = (FunctViewWxcLink)viewCircuitPathElement.getLink();
                PpMeshLink ppMeshLink = this.ppMeshLink.get(functViewWxcLink.getIndex());
                viewCircuitPathElement.addNetworkSequence(ppMeshLink.getPositionElement());
            } else if (n2 == null) {
                viewCircuitPathElement.addNetworkSequence(this.positionElementNetwork++);
            } else {
                viewCircuitPathElement.addNetworkSequence(n2.intValue());
            }
        }
        if (bl) {
            return this.circuitPathElement.put(n, viewCircuitPathElement);
        }
        return this.circuitPathElement.get(n);
    }

    public void dispose() {
        this.clearCurrentselectedFlag();
        if (this.currentCircuitPathElement != null) {
            this.currentCircuitPathElement.clear();
        }
        if (this.circuitPathElement != null) {
            this.circuitPathElement.clear();
        }
        if (this.ppMeshLink != null) {
            this.ppMeshLink.clear();
        }
        if (this.activeStbyLinks != null) {
            this.activeStbyLinks.clear();
        }
        if (this.ochDebugList != null) {
            this.ochDebugList.clear();
        }
        if (this.pathUsedSide != null) {
            this.pathUsedSide.clear();
        }
        this.externalPort = null;
    }

    private class ActiveStby {
        private HashMap<Integer, IFvInterfaceModel> txpIndexes = null;
        private HashMap<Integer, IFvInterfaceModel> psmIndexes = null;
        private HashMap<Integer, Integer> txpCircuitPosition = null;
        private HashMap<Integer, Integer> psmCircuitPosition = null;

        public void addTxp(IFvInterfaceModel iFvInterfaceModel) {
            int n;
            if (this.txpIndexes == null) {
                this.txpIndexes = new HashMap();
                this.txpCircuitPosition = new HashMap();
            }
            if (!this.txpIndexes.containsKey(n = iFvInterfaceModel.getIndex())) {
                this.txpIndexes.put(n, iFvInterfaceModel);
                this.txpCircuitPosition.put(n, FunctionalCircuitPath.this.positionElementNetwork++);
            }
        }

        public void addPsm(IFvInterfaceModel iFvInterfaceModel) {
            int n;
            if (this.psmIndexes == null) {
                this.psmIndexes = new HashMap();
                this.psmCircuitPosition = new HashMap();
            }
            if (!this.psmIndexes.containsKey(n = iFvInterfaceModel.getIndex())) {
                this.psmIndexes.put(n, iFvInterfaceModel);
                this.psmCircuitPosition.put(n, FunctionalCircuitPath.this.positionElementNetwork++);
            }
        }

        public void clear() {
            if (this.txpIndexes != null) {
                this.txpIndexes.clear();
            }
            if (this.psmIndexes != null) {
                this.psmIndexes.clear();
            }
        }

        public void init() {
            this.fromTransponder();
            this.fromPSM();
        }

        private void fromPSM() {
            if (this.psmIndexes == null || this.psmIndexes.size() == 0) {
                return;
            }
            Collection collection = FunctionalCircuitPath.this.workingSideGrapher.getGraphChildren("FunctBandDomainGrapher").values();
            HashMap hashMap = FunctionalCircuitPath.this.workingSideGrapher.getMpoLinks();
            for (FunctBandDomainGrapher functBandDomainGrapher : collection) {
                Collection collection2 = functBandDomainGrapher.getGraphLinks().values();
                for (FunctViewLink functViewLink : collection2) {
                    int n;
                    IFvInterfaceModel iFvInterfaceModel;
                    boolean bl;
                    int n2;
                    block21: {
                        Integer n3;
                        Integer n4;
                        Integer n5;
                        block20: {
                            n5 = functViewLink.getFromPort();
                            n4 = functViewLink.getToPort();
                            Integer n6 = n5;
                            n3 = n4;
                            IFvPortModel iFvPortModel = null;
                            IFvPortModel iFvPortModel2 = null;
                            try {
                                iFvPortModel = functViewLink.getLinkModel().getLink().getFromPortModel();
                                iFvPortModel2 = functViewLink.getLinkModel().getLink().getToPortModel();
                            }
                            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                                FunctDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                            }
                            boolean bl2 = false;
                            n2 = 0;
                            bl = false;
                            iFvInterfaceModel = null;
                            n = 0;
                            if (iFvPortModel.getCardModel() instanceof DwdmModuleModel || iFvPortModel2.getCardModel() instanceof DwdmModuleModel) continue;
                            if (iFvPortModel.getCardModel() instanceof IFvPSMModuleModel) {
                                if (((InterfaceModel)iFvPortModel.getIFvInterfaceModel()).getHigherLayerIndexes_new().length != 0) {
                                    n6 = ((InterfaceModel)iFvPortModel.getIFvInterfaceModel()).getHigherLayerIndexes_new()[0];
                                }
                                bl2 = iFvPortModel2.getCardModel().isPassiveModule();
                                n2 = FunctDomainGrapher.getBandfromPos(iFvPortModel2.getPositionInParent(), bl2);
                                n = n5 - 1;
                            } else if (iFvPortModel2.getCardModel() instanceof IFvPSMModuleModel) {
                                if (((InterfaceModel)iFvPortModel2.getIFvInterfaceModel()).getHigherLayerIndexes_new().length != 0) {
                                    n3 = ((InterfaceModel)iFvPortModel2.getIFvInterfaceModel()).getHigherLayerIndexes_new()[0];
                                }
                                bl2 = iFvPortModel.getCardModel().isPassiveModule();
                                n2 = FunctDomainGrapher.getBandfromPos(iFvPortModel.getPositionInParent(), bl2);
                                n = n4 + 1;
                            }
                            if (this.psmIndexes.containsKey(n6)) {
                                try {
                                    FunctionalCircuitPath.this.addTxpLinkForCircuitPaint((IViewLink)functViewLink, n5, n4, this.psmIndexes.get(n6), null, FunctionalCircuitPath.this.nmd, false, this.psmCircuitPosition.get(n6));
                                    FunctionalCircuitPath.this.findOneLink = true;
                                    bl = true;
                                    iFvInterfaceModel = this.psmIndexes.get(n6);
                                }
                                catch (FunctException functException) {
                                    if (!FunctionalCircuitPath.this.db.on()) break block20;
                                    FunctionalCircuitPath.this.db.println("The link" + functViewLink.getName() + " is not found");
                                }
                            }
                        }
                        if (this.psmIndexes.containsKey(n3)) {
                            try {
                                FunctionalCircuitPath.this.addTxpLinkForCircuitPaint((IViewLink)functViewLink, n5, n4, null, this.psmIndexes.get(n3), FunctionalCircuitPath.this.nmd, false, this.psmCircuitPosition.get(n3));
                                FunctionalCircuitPath.this.findOneLink = true;
                                bl = true;
                                iFvInterfaceModel = this.psmIndexes.get(n3);
                            }
                            catch (FunctException functException) {
                                if (!FunctionalCircuitPath.this.db.on()) break block21;
                                FunctionalCircuitPath.this.db.println("The link" + functViewLink.getName() + " is not found");
                            }
                        }
                    }
                    if (!bl) continue;
                    InterfaceModel interfaceModel = null;
                    try {
                        interfaceModel = ((FVNodeModelDelegate)FunctionalCircuitPath.this.nmd).getDelegate().getIfModels().getInterfaceModel(n);
                    }
                    catch (NoSuchInterface noSuchInterface) {
                        FunctDebug.printStackTrace((Throwable)noSuchInterface);
                    }
                    this.addMPOLink(hashMap, n2, iFvInterfaceModel.getLowerLayerModels()[0]);
                    try {
                        this.psmIsInChannelProtection(iFvInterfaceModel.getLowerLayerModels()[0].getThePortModel(), FunctionalCircuitPath.this.workingSideGrapher);
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        FunctDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                    if (interfaceModel == null) continue;
                    this.addMPOLink(hashMap, n2, interfaceModel);
                }
            }
        }

        private void fromTransponder() {
            if (this.txpIndexes == null || this.txpIndexes.size() == 0) {
                return;
            }
            boolean bl = false;
            Collection collection = FunctionalCircuitPath.this.workingSideGrapher.getGraphChildren("FunctBandDomainGrapher").values();
            if (collection.size() == 0) {
                this.fromAdCard();
                return;
            }
            HashMap hashMap = FunctionalCircuitPath.this.workingSideGrapher.getMpoLinks();
            for (FunctBandDomainGrapher functBandDomainGrapher : collection) {
                Collection collection2 = functBandDomainGrapher.getGraphLinks().values();
                for (FunctViewLink functViewLink : collection2) {
                    IFvInterfaceModel iFvInterfaceModel;
                    boolean bl2;
                    int n;
                    block17: {
                        Integer n2;
                        Integer n3;
                        Integer n4;
                        Integer n5;
                        block16: {
                            n5 = functViewLink.getFromPort();
                            n4 = functViewLink.getToPort();
                            n3 = n5;
                            n2 = n4;
                            IFvPortModel iFvPortModel = functViewLink.getLinkModel().getOptPort();
                            boolean bl3 = iFvPortModel.getCardModel().isPassiveModule();
                            n = FunctDomainGrapher.getBandfromPos(iFvPortModel.getPositionInParent(), bl3);
                            bl2 = false;
                            iFvInterfaceModel = null;
                            if (iFvPortModel.getIndex() == n5.intValue() && iFvPortModel.getCardModel() instanceof IFvPSMModuleModel && ((InterfaceModel)iFvPortModel.getIFvInterfaceModel()).getHigherLayerIndexes_new().length != 0) {
                                n3 = ((InterfaceModel)iFvPortModel.getIFvInterfaceModel()).getHigherLayerIndexes_new()[0];
                            }
                            if (iFvPortModel.getIndex() == n4.intValue() && iFvPortModel.getCardModel() instanceof IFvPSMModuleModel && ((InterfaceModel)iFvPortModel.getIFvInterfaceModel()).getHigherLayerIndexes_new().length != 0) {
                                n2 = ((InterfaceModel)iFvPortModel.getIFvInterfaceModel()).getHigherLayerIndexes_new()[0];
                            }
                            if (this.txpIndexes.containsKey(n3)) {
                                try {
                                    if (FunctionalCircuitPath.this.circuitType != 9) {
                                        FunctionalCircuitPath.this.addTxpLinkForCircuitPaint((IViewLink)functViewLink, n5, n4, this.txpIndexes.get(n3), null, FunctionalCircuitPath.this.nmd, false, this.txpCircuitPosition.get(n3));
                                        FunctionalCircuitPath.this.findOneLink = true;
                                        bl2 = true;
                                        iFvInterfaceModel = this.txpIndexes.get(n3);
                                        if (n5 != n3 || n4 != n2) {
                                            bl = true;
                                        }
                                    }
                                }
                                catch (FunctException functException) {
                                    if (!FunctionalCircuitPath.this.db.on()) break block16;
                                    FunctionalCircuitPath.this.db.println("The link" + functViewLink.getName() + " is not found");
                                }
                            }
                        }
                        if (this.txpIndexes.containsKey(n2)) {
                            try {
                                if (FunctionalCircuitPath.this.circuitType != 9) {
                                    FunctionalCircuitPath.this.addTxpLinkForCircuitPaint((IViewLink)functViewLink, n5, n4, null, this.txpIndexes.get(n2), FunctionalCircuitPath.this.nmd, false, this.txpCircuitPosition.get(n2));
                                    FunctionalCircuitPath.this.findOneLink = true;
                                    bl2 = true;
                                    iFvInterfaceModel = this.txpIndexes.get(n2);
                                    if (n5 != n3 || n4 != n2) {
                                        bl = true;
                                    }
                                }
                            }
                            catch (FunctException functException) {
                                if (!FunctionalCircuitPath.this.db.on()) break block17;
                                FunctionalCircuitPath.this.db.println("The link" + functViewLink.getName() + " is not found");
                            }
                        }
                    }
                    if (!bl2 || bl) continue;
                    this.addMPOLink(hashMap, n, iFvInterfaceModel);
                }
            }
        }

        private void psmIsInChannelProtection(IFvPortModel iFvPortModel, ViewDomainGrapher viewDomainGrapher) {
            if (iFvPortModel.getCardModel() instanceof IFvPSMModuleModel) {
                try {
                    IFvOpticsLineModel iFvOpticsLineModel = (IFvOpticsLineModel)iFvPortModel.getIFvInterfaceModel();
                    if (iFvOpticsLineModel.isPortTypeTX()) {
                        iFvOpticsLineModel = (IFvOpticsLineModel)iFvOpticsLineModel.getReversePortModel();
                    }
                    if (iFvOpticsLineModel != null) {
                        viewDomainGrapher.setSideDomainInActivePath(iFvOpticsLineModel.isCurrentlyActive());
                    }
                }
                catch (NoSuchInterface noSuchInterface) {
                    FunctDebug.printStackTrace((Throwable)noSuchInterface);
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    FunctDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
                catch (UnsupportedOperation unsupportedOperation) {
                    FunctDebug.printStackTrace((Throwable)unsupportedOperation);
                }
            }
        }

        private void fromAdCard() {
            Collection collection = FunctionalCircuitPath.this.workingSideGrapher.getGraphLinks().values();
            for (IViewLink iViewLink : collection) {
                Integer n;
                Integer n2;
                block7: {
                    n2 = iViewLink.getFromPort();
                    n = iViewLink.getToPort();
                    if (this.txpIndexes.containsKey(n2)) {
                        try {
                            if (FunctionalCircuitPath.this.circuitType != 9) {
                                FunctionalCircuitPath.this.addLinkForCircuitPaint(iViewLink, n2, n, this.txpIndexes.get(n2), null, FunctionalCircuitPath.this.nmd, false);
                                FunctionalCircuitPath.this.findOneLink = true;
                            }
                        }
                        catch (FunctException functException) {
                            if (!FunctionalCircuitPath.this.db.on()) break block7;
                            FunctionalCircuitPath.this.db.println("The link" + iViewLink.getName() + " is not found");
                        }
                    }
                }
                if (!this.txpIndexes.containsKey(n)) continue;
                try {
                    if (FunctionalCircuitPath.this.circuitType == 9) continue;
                    FunctionalCircuitPath.this.addLinkForCircuitPaint(iViewLink, n2, n, null, this.txpIndexes.get(n), FunctionalCircuitPath.this.nmd, true);
                    FunctionalCircuitPath.this.findOneLink = true;
                }
                catch (FunctException functException) {
                    if (!FunctionalCircuitPath.this.db.on()) continue;
                    FunctionalCircuitPath.this.db.println("The link" + iViewLink.getName() + " is not found");
                }
            }
        }

        private void addMPOLink(HashMap<Integer, IViewLink> hashMap, Integer n, IFvInterfaceModel iFvInterfaceModel) {
            block16: {
                Object object;
                Object object2;
                int n2 = 256;
                OpticalPatchCord opticalPatchCord = null;
                OpticalPatchCord opticalPatchCord2 = null;
                int n3 = 0;
                try {
                    object2 = (IFvCardModel)iFvInterfaceModel.getModuleModel();
                    object = object2.getAllOpticalPatchCords();
                    int n4 = iFvInterfaceModel.getIndex();
                    for (int i = 0; i < ((OpticalPatchCord[])object).length; ++i) {
                        if (object[i].from == n4) {
                            opticalPatchCord = object[i];
                        }
                        if (object[i].to != n4) continue;
                        opticalPatchCord2 = object[i];
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    FunctDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
                catch (NumberFormatException numberFormatException) {
                    FunctDebug.printStackTrace((Throwable)numberFormatException);
                }
                catch (FeatureUnsupported featureUnsupported) {
                    FunctDebug.printStackTrace((Throwable)featureUnsupported);
                }
                catch (NoSuchInterface noSuchInterface) {
                    FunctDebug.printStackTrace((Throwable)noSuchInterface);
                }
                try {
                    n3 = iFvInterfaceModel instanceof IFvDwdmTrkLineModel ? ((IFvDwdmTrkLineModel)iFvInterfaceModel).getExpectedWaveLength() : ((AbstractOpticsLineModel)iFvInterfaceModel).getExpectedWaveLength();
                    if (Wavelength.isEvenLambda(new Attribute("", n3))) {
                        n2 += 16;
                    }
                }
                catch (NoSuchInterface noSuchInterface) {
                    FunctDebug.printStackTrace((Throwable)noSuchInterface);
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    FunctDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
                try {
                    object2 = FunctionalCircuitPath.this.getLinkFromIndexMask(hashMap, n2 + n);
                    if (opticalPatchCord2 != null) {
                        FunctionalCircuitPath.this.addLinkForCircuitPaint((IViewLink)object2, opticalPatchCord2.from, opticalPatchCord2.to, iFvInterfaceModel, null, FunctionalCircuitPath.this.nmd, false);
                        FunctionalCircuitPath.this.findOneLink = true;
                    }
                    n2 = 512;
                    if (Wavelength.isEvenLambda(new Attribute("", n3))) {
                        n2 += 16;
                    }
                    object2 = FunctionalCircuitPath.this.getLinkFromIndexMask(hashMap, n2 + n);
                    if (opticalPatchCord != null) {
                        FunctionalCircuitPath.this.addLinkForCircuitPaint((IViewLink)object2, opticalPatchCord.from, opticalPatchCord.to, null, iFvInterfaceModel, FunctionalCircuitPath.this.nmd, false);
                        FunctionalCircuitPath.this.findOneLink = true;
                    }
                }
                catch (FunctException functException) {
                    if (!FunctionalCircuitPath.this.db.on()) break block16;
                    object = (FunctViewPureGraphicalLink)hashMap.get(n2 + n);
                    FunctionalCircuitPath.this.db.println("The link" + object.getName() + "is not found do not add it");
                }
            }
        }
    }

    public class Debug
    extends SDebug {
        public static final String Hlinks = "Print links currently in the circuit path";

        public Debug(String string) {
            super(string);
        }

        public final void links(boolean bl) {
            block5: {
                if (FunctionalCircuitPath.this.currentCircuitPathElement == null) break block5;
                if (bl) {
                    block0: for (int i = 0; i < FunctionalCircuitPath.this.currentCircuitPathElement.size(); ++i) {
                        Collection collection = FunctionalCircuitPath.this.currentCircuitPathElement.values();
                        for (ViewCircuitPathElement viewCircuitPathElement : collection) {
                            if (viewCircuitPathElement.getSequenceInNetwork() != i) continue;
                            viewCircuitPathElement.printDebug((IFvDebug)this);
                            continue block0;
                        }
                    }
                } else {
                    for (ViewCircuitPathElement viewCircuitPathElement : FunctionalCircuitPath.this.currentCircuitPathElement.values()) {
                        viewCircuitPathElement.printDebug((IFvDebug)this);
                    }
                }
            }
        }

        public final void allLinks() {
            this.links(false);
        }

        public final void tccPath() {
            InterfaceModels interfaceModels = ((FVNodeModelDelegate)FunctionalCircuitPath.this.nmd).getDelegate().getIfModels();
            if (FunctionalCircuitPath.this.ochDebugList.size() != 0) {
                this.println("On node " + FunctionalCircuitPath.this.nmd.getName() + ">>>>>>>>>>>>>>>>>.");
                for (int i = 0; i < FunctionalCircuitPath.this.ochDebugList.size(); ++i) {
                    IFvPortModel iFvPortModel;
                    InterfaceModel interfaceModel;
                    int n;
                    int n2;
                    int[] nArray = ((SOchPath)FunctionalCircuitPath.this.ochDebugList.get(i)).getUpTrail();
                    this.print("\n This is the Uptrail List of the circuit :\n");
                    for (n2 = 0; n2 < nArray.length; ++n2) {
                        n = nArray[n2];
                        try {
                            interfaceModel = interfaceModels.getInterfaceModel(n);
                            iFvPortModel = interfaceModel.getThePortModel();
                            this.print("\toch_" + n2 + "=" + Integer.toHexString(n) + " on port (" + Integer.toHexString(iFvPortModel.getIndex()) + ") " + iFvPortModel.getEqLabel() + " on card " + iFvPortModel.getCardModel().getEqLabel() + "\n");
                            continue;
                        }
                        catch (NoSuchInterface noSuchInterface) {
                            this.print("\toch_" + n2 + "=" + Integer.toHexString(n) + "has NO interface" + "\n");
                            continue;
                        }
                        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                            this.print("\toch_" + n2 + "=" + Integer.toHexString(n) + "has NO port" + "\n");
                        }
                    }
                    nArray = ((SOchPath)FunctionalCircuitPath.this.ochDebugList.get(i)).getDownTrail();
                    this.print("This is the DownTrail List of the circuit :\n");
                    for (n2 = 0; n2 < nArray.length; ++n2) {
                        n = nArray[n2];
                        try {
                            interfaceModel = interfaceModels.getInterfaceModel(n);
                            iFvPortModel = interfaceModel.getThePortModel();
                            this.print("\toch_" + n2 + "=" + Integer.toHexString(n) + " on (" + Integer.toHexString(iFvPortModel.getIndex()) + ") " + iFvPortModel.getEqLabel() + " on card " + iFvPortModel.getCardModel().getEqLabel() + "\n");
                            continue;
                        }
                        catch (NoSuchInterface noSuchInterface) {
                            this.print("\toch_" + n2 + "=" + Integer.toHexString(n) + "has NO interface" + "\n");
                            continue;
                        }
                        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                            this.print("\toch_" + n2 + "=" + Integer.toHexString(n) + "has NO port" + "\n");
                        }
                    }
                }
            }
            this.println("This are the NFV found Links:");
            this.links(true);
            this.println("<<<<<<<<<<<<<<<<<On node " + FunctionalCircuitPath.this.nmd.getName());
        }
    }

    private class PpMeshLink {
        private FunctViewWxcLink link;
        int sideId;
        private int positionElement;

        public FunctViewWxcLink getLink() {
            return this.link;
        }

        public int getPositionElement() {
            return this.positionElement;
        }

        public int getSideId() {
            return this.sideId;
        }

        public void setSideId(int n) {
            this.sideId = n;
        }

        public PpMeshLink(FunctViewWxcLink functViewWxcLink, IFvPortModel iFvPortModel) {
            this.positionElement = FunctionalCircuitPath.this.positionElementNetwork++;
            this.link = functViewWxcLink;
            IFvInterfaceModel[] iFvInterfaceModelArray = this.link.getExpRxIModels();
            this.setSideId(0);
            if (iFvInterfaceModelArray != null) {
                for (int i = 0; i < iFvInterfaceModelArray.length; ++i) {
                    IFvInterfaceModel iFvInterfaceModel = iFvInterfaceModelArray[i];
                    if (iFvPortModel.getIFvInterfaceModel() != iFvInterfaceModel) continue;
                    this.setSideId(i);
                }
            }
        }
    }
}

