/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.functional.port;

import cerent.cms.fv.IFvInterfaceModel;
import cerent.cms.fv.IFvOpticsPortModel;
import cerent.cms.fv.IFvPortModel;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.WrongPortType;
import cerent.cms.ui.functional.PowerInfoComposerHelper;
import cerent.cms.ui.functional.port.FunctBandPortGraphic;
import cerent.util.view.fv.ViewCircuitPathElement;
import cerent.util.view.fv.ViewPortGraphic;
import java.util.List;

public class FunctSidePortCircuitPathElement
extends ViewCircuitPathElement {
    private ViewPortGraphic port;
    private IFvInterfaceModel circuitInterface;

    public FunctSidePortCircuitPathElement(ViewPortGraphic viewPortGraphic, int n) {
        super(viewPortGraphic.getPortModel().getIFvNodeModel());
        this.wavelength = n;
        this.port = viewPortGraphic;
        try {
            this.circuitInterface = viewPortGraphic.getPortModel().getIFvInterfaceModel();
        }
        catch (RuntimeException runtimeException) {
            this.circuitInterface = null;
        }
        if (viewPortGraphic instanceof FunctBandPortGraphic) {
            List list = viewPortGraphic.getPortModel().getCardModel().getChildren();
            for (Object e : list) {
                if (!(e instanceof IFvOpticsPortModel)) continue;
                try {
                    if (((IFvOpticsPortModel)e).getWaveLength() != n) continue;
                    try {
                        this.circuitInterface = ((IFvOpticsPortModel)e).getIFvInterfaceModel();
                    }
                    catch (RuntimeException runtimeException) {
                        this.circuitInterface = null;
                    }
                    break;
                }
                catch (WrongPortType wrongPortType) {
                }
            }
        }
    }

    public void setBalloonVisible(boolean bl) {
        this.port.setPowerVisibility(bl);
    }

    public ViewPortGraphic getPortGraphic() {
        return this.port;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setDebugInfo(boolean bl) {
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                if (this.circuitInterface == null) {
                    return;
                }
                String string = ViewCircuitPathElement.getPowerTooltipStr((IFvInterfaceModel)this.circuitInterface, (StringBuffer)stringBuffer, (int)this.wavelength);
                this.port.setBalloonLabel(string);
                if (!bl) return;
                try {
                    IFvPortModel iFvPortModel = this.port.getPortModel();
                    boolean bl2 = false;
                    if (iFvPortModel instanceof IFvOpticsPortModel) {
                        IFvOpticsPortModel iFvOpticsPortModel = (IFvOpticsPortModel)iFvPortModel;
                        bl2 = iFvOpticsPortModel.isOptPortTypeTX();
                    }
                    this.tableCell = PowerInfoComposerHelper.addThisPort(iFvPortModel, iFvPortModel.getSide(), bl2, this.node, string, String.valueOf(this.sequenceInNetwork));
                    return;
                }
                catch (Exception exception) {}
                return;
            }
            catch (CmsObjectNotExistException cmsObjectNotExistException) {
                return;
            }
        } else {
            this.port.setPowerVisibility(bl);
            this.port.showPowerBalloon();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("sidePort: ");
        if (this.port != null) {
            IFvPortModel iFvPortModel = this.port.getPortModel();
            if (iFvPortModel != null) {
                stringBuilder.append("[" + Integer.toHexString(iFvPortModel.getIndex()) + "] " + iFvPortModel.getPortString() + "; ");
            } else {
                stringBuilder.append("[" + this.port.getName() + "]");
            }
        }
        return stringBuilder.toString();
    }
}

