/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.l2sc;

import cerent.cms.model.EtherLineModel;
import cerent.cms.model.L2scModuleModel;
import cerent.cms.model.L2scPortModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.l2sc.L2scPosPortInfoTableModel;
import cerent.cms.ui.l2sc.L2scRPRSpanInfoTableModel;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import cerent.util.gui.FixedLengthField;
import cerent.util.gui.SoakTimeCellEditor;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class L2scPosPortInfoPane
extends NodeProvPane
implements PropertyChangeListener,
TableModelListener {
    private L2scPosPortInfoTableModel dataModel = null;
    private L2scRPRSpanInfoTableModel rprDataModel = null;
    private L2scPortModel[] portModels = null;
    private EtherLineModel[] lineModels = null;
    private L2scModuleModel eqpmtModel = null;
    private int numLines = 0;
    private int numPorts = 0;
    private boolean rprMode = false;
    private JScrollPane scrollPane = null;
    private UTable table = null;
    private UTableHeader tableHeader = null;
    private static final SDebug db = new SDebug("L2scPosPortInfoPane");

    public L2scPosPortInfoPane(String string, TabbedView tabbedView, L2scPortModel[] l2scPortModelArray, EtherLineModel[] etherLineModelArray) {
        super(string, tabbedView);
        Object var5_5 = null;
        this.portModels = l2scPortModelArray;
        this.lineModels = etherLineModelArray;
        this.numPorts = l2scPortModelArray == null ? 0 : l2scPortModelArray.length;
        int n = this.numLines = etherLineModelArray == null ? 0 : etherLineModelArray.length;
        if (this.getParentView().getUiModel() instanceof L2scModuleModel) {
            this.eqpmtModel = (L2scModuleModel)this.getParentView().getUiModel();
        } else if (db.on()) {
            db.println("Equipment Model is not L2scModuleModel");
        }
        this.rprMode = this.eqpmtModel.isRPRMode();
        this.rprDataModel = new L2scRPRSpanInfoTableModel(this.eqpmtModel, l2scPortModelArray, etherLineModelArray);
        this.rprDataModel.addTableModelListener(this);
        this.dataModel = new L2scPosPortInfoTableModel(this.eqpmtModel, l2scPortModelArray, etherLineModelArray);
        this.dataModel.addTableModelListener(this);
        this.table = this.rprMode ? new UTable((TableModel)this.rprDataModel) : new UTable((TableModel)this.dataModel);
        this.scrollPane = new JScrollPane();
        this.add(this.scrollPane);
        this.tableHeader = new UTableHeader(this.table.getColumnModel());
        this.setTable();
        this.registerForUpdates();
    }

    private void setTable() {
        TableColumn tableColumn = null;
        this.table.setModel((TableModel)(this.rprMode ? this.rprDataModel : this.dataModel));
        this.tableHeader.setColumnModel(this.table.getColumnModel());
        this.table.setTableHeader((JTableHeader)this.tableHeader);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        tableColumn = !this.rprMode ? this.table.getColumn((Object)this.dataModel.columnNames[1]) : this.table.getColumn((Object)this.rprDataModel.rprColumnNames[1]);
        tableColumn.setCellEditor(new DefaultCellEditor(new FixedLengthField(32)));
        tableColumn.setPreferredWidth(150);
        SoakTimeCellEditor soakTimeCellEditor = new SoakTimeCellEditor(this);
        tableColumn = this.rprMode ? this.table.getColumn((Object)this.rprDataModel.rprColumnNames[4]) : this.table.getColumn((Object)this.dataModel.columnNames[4]);
        tableColumn.setCellEditor(soakTimeCellEditor);
        tableColumn.setMinWidth(soakTimeCellEditor.getPreferredWidth() + 10);
        this.table.setRowHeight(soakTimeCellEditor.getPreferredHeight());
        this.table.sizeColumnsToFit(-1);
        this.scrollPane.setViewportView((Component)this.table);
        this.validate();
    }

    private void registerForUpdates() {
        this.registerWithModel();
        if (this.lineModels == null) {
            return;
        }
        for (int i = 0; i < this.numLines; ++i) {
            if (null != this.lineModels[i]) {
                this.lineModels[i].addObserver((Observer)((Object)this));
                if (!L2scPosPortInfoPane.db.on) continue;
                db.finest("L2scPosPortInfoPane added as observer for lineModel: " + this.lineModels[i]);
                continue;
            }
            db.println("Could not add observer for line=" + i + " because the lineModel is null!");
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (L2scPosPortInfoPane.db.on) {
            db.finest("ob:" + observable + ", o:" + object);
        }
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            this.requestRefresh(observable, this.getRefreshThread(observable));
        }
    }

    private synchronized Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            @Override
            public void run() {
                L2scPosPortInfoPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        boolean bl;
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        boolean bl2 = this.eqpmtModel.isRPRMode();
        boolean bl3 = bl = this.rprMode != bl2;
        if (bl) {
            this.rprMode = bl2;
            this.setTable();
        }
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            if (this.rprMode) {
                this.rprDataModel.refreshLineFromModel(n);
            } else {
                this.dataModel.refreshLineFromModel(n);
            }
        } else {
            if (this.rprMode) {
                this.rprDataModel.refresh();
            } else {
                this.dataModel.refresh();
            }
            if (db.on()) {
                db.println("Do full refresh on table");
            }
        }
    }

    @Override
    public void destroy() {
        if (this.lineModels != null) {
            for (int i = 0; i < this.numLines; ++i) {
                this.lineModels[i].deleteObserver((Observer)((Object)this));
                if (!L2scPosPortInfoPane.db.on) continue;
                db.finest("L2scPosPortInfoPane deleted as observer for lineModel: " + this.lineModels[i]);
            }
            this.lineModels = null;
        }
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
            this.dataModel.destroy();
            this.dataModel = null;
        }
        if (this.rprDataModel != null) {
            this.rprDataModel.removeTableModelListener(this);
            this.rprDataModel.destroy();
            this.rprDataModel = null;
        }
        super.destroy();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.numPorts == 0) {
            return;
        }
        if (!this.rprMode && this.dataModel.isDirty()) {
            this.setDirty();
            return;
        }
        if (this.rprMode && this.rprDataModel.isDirty()) {
            this.setDirty();
            return;
        }
        this.resetDirty();
    }

    @Override
    protected boolean queryRemainDirty() {
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setDirty();
    }

    @Override
    public void applyChangesToModel() throws AnnotatedException {
        try {
            if (this.rprMode) {
                this.rprDataModel.applyToModel();
                this.rprDataModel.resetDirty();
            } else {
                this.dataModel.applyToModel();
                this.dataModel.resetDirty();
            }
            this.setDirty(false);
        }
        catch (Exception exception) {
            throw new AnnotatedException("An error occurred while applying changes.", exception);
        }
    }

    @Override
    public void refreshFromModel() throws Exception {
        if (this.rprMode) {
            this.rprDataModel.refresh();
            this.rprDataModel.resetDirty();
        } else {
            this.dataModel.refresh();
            this.dataModel.resetDirty();
        }
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.L2scPosPortInfoPane;
    }

    class UTableHeader
    extends JTableHeader {
        TableColumnModel columnModel;

        public UTableHeader(TableColumnModel tableColumnModel) {
            super(tableColumnModel);
            this.columnModel = tableColumnModel;
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            String string;
            Point point = mouseEvent.getPoint();
            int n = this.columnModel.getColumnIndexAtX(point.x);
            int n2 = this.columnModel.getColumn(n).getModelIndex();
            if (L2scPosPortInfoPane.this.rprMode) {
                L2scPosPortInfoPane.this.rprDataModel;
                string = L2scRPRSpanInfoTableModel.columnToolTips[n2];
            } else {
                L2scPosPortInfoPane.this.dataModel;
                string = L2scPosPortInfoTableModel.columnToolTips[n2];
            }
            return string;
        }

        @Override
        public void setColumnModel(TableColumnModel tableColumnModel) {
            super.setColumnModel(tableColumnModel);
            this.columnModel = tableColumnModel;
        }
    }
}

