/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ml2;

import cerent.cms.idl.EtherMedia.eContType;
import cerent.cms.idl.EtherMedia.sEtherStsInfo;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.ML2EnhModuleModel;
import cerent.cms.model.ML2ModuleModel;
import cerent.cms.model.ML2PosPortModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.HoLoFactory;
import cerent.util.IHoNum;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import javax.swing.table.AbstractTableModel;

public class CEMRHoUsageTableModel
extends AbstractTableModel {
    public static final int STS_INDEX = 0;
    public static final int POOL_INDEX = 1;
    public static final int TYPE_INDEX = 2;
    public static final int PORT_INDEX = 3;
    public static final int VCG_INDEX = 4;
    private static final SDebug db = new SDebug("CEMRHoUsageTableModel");
    private TDMTerminology terms;
    private String[] columnNames;
    private ML2ModuleModel eqpmtModel = null;
    private ML2PosPortModel[] portModels = null;
    private sEtherStsInfo[] infoList = null;
    private EntityCellRenderer myPortRenderer;

    public CEMRHoUsageTableModel(ML2ModuleModel mL2ModuleModel) {
        this.eqpmtModel = mL2ModuleModel;
        this.terms = this.eqpmtModel.getNodeModel().getTDMTerminology();
        this.initColumnNames();
        this.portModels = mL2ModuleModel instanceof ML2EnhModuleModel ? ((ML2EnhModuleModel)this.eqpmtModel).getAllPortModels() : this.eqpmtModel.getPosPortModels();
        this.myPortRenderer = new EntityCellRenderer();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        if (n >= 0 && n < this.columnNames.length) {
            return this.columnNames[n];
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.infoList == null ? 0 : this.infoList.length;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            default: 
        }
        return Object.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getHoIndex(this.infoList[n].stsNum);
                }
                case 1: {
                    return this.infoList[n].pool;
                }
                case 2: {
                    return this.getType(this.infoList[n].contType);
                }
                case 3: {
                    return this.getPortDescription(this.infoList[n].port);
                }
                case 4: {
                    if (this.infoList[n].nextVcgMem != 0) {
                        return this.getHoIndex(this.infoList[n].nextVcgMem);
                    }
                    return "";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String getHoIndex(int n) {
        int n2 = this.eqpmtModel.getNodeModel().getTdmProtocolType();
        if (db.on()) {
            db.println("HoUsage getHoIndex: sts=" + n + " framingType=" + n2);
        }
        IHoNum iHoNum = HoLoFactory.idlSts2HoNum(n2, n);
        if (db.on()) {
            db.println("HoUsage getHoIndex: hoNum=" + iHoNum);
        }
        return String.valueOf(iHoNum.getHoNum());
    }

    private String getType(eContType eContType2) {
        if (eContType2 == eContType.CONT_HO) {
            return this.terms.getGeneralTerms(0);
        }
        if (eContType2 == eContType.CONT_LO) {
            return this.terms.getGeneralTerms(1);
        }
        return "";
    }

    private String getPortDescription(int n) throws AbstractCmsNoSuchEntityException {
        String string = null;
        if (this.portModels.length < n) {
            if (--n == this.eqpmtModel.getRPREastPort()) {
                string = this.myPortRenderer.getPortString(this.portModels[((ML2EnhModuleModel)this.eqpmtModel).getNumberOfPosPorts()], false);
            }
            if (n == this.eqpmtModel.getRPRWestPort()) {
                string = this.myPortRenderer.getPortString(this.portModels[((ML2EnhModuleModel)this.eqpmtModel).getNumberOfPosPorts() + 1], false);
            }
        } else {
            string = this.myPortRenderer.getPortString(this.portModels[--n], false);
        }
        return string;
    }

    public void refreshFromModel() throws Exception {
        this.infoList = this.eqpmtModel.getEtherStsInfoList();
        if (db.on()) {
            db.println("\ngetEtherStsInfoList: infoList.length=" + this.infoList.length);
            for (int i = 0; i < this.infoList.length; ++i) {
                db.println(this.infoList[i].stsNum + "  " + this.infoList[i].contType.value() + "  " + this.infoList[i].port + "  " + this.infoList[i].nextVcgMem);
            }
        }
        this.fireTableDataChanged();
    }

    public boolean isLo(int n) {
        return this.infoList[n].contType == eContType.CONT_LO;
    }

    public int getStsNum(int n) {
        return this.infoList[n].stsNum;
    }

    private void initColumnNames() {
        this.columnNames = new String[5];
        this.columnNames[0] = this.terms.getGeneralTerms(0);
        this.columnNames[1] = "Pool";
        this.columnNames[2] = "Type";
        this.columnNames[3] = "Port";
        this.columnNames[4] = "Next " + this.terms.getGeneralTerms(0) + " in VCG";
    }
}

