/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.muxdemux;

import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.ui.AbstractRoDataSourceControl;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.ObserverPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.muxdemux.MuxDmuxOpticalPlugInTableModel;
import cerent.util.IObservableManager;
import cerent.util.ObservableManager;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class MuxDmuxInventoryPane
extends ObserverPane
implements Observer {
    public MuxDmuxInventoryPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.setLayout(new BorderLayout());
        this.setDataSourceControl(new MuxDmuxInfo());
        JPanel jPanel = new JPanel(new FlowLayout(2, 5, 5));
        jPanel.add(new CSHelpButton(CSHelpConst.MuxDmuxInventoryPane));
        this.add(jPanel, "South");
    }

    @Override
    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.getTable(), this.getClass().getName());
        super.destroy();
    }

    @Override
    public void enteringPage() throws Exception {
        super.enteringPage();
        TablePropertyMgr.getColumnPrefs(this.getTable(), this.getClass().getName());
    }

    @Override
    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.getTable(), this.getClass().getName());
        super.leavingPage();
    }

    private void setTable(JTable jTable) {
        this.table = jTable;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (this.isChangeUpdate(object)) {
            this.requestRefresh(observable, null);
        }
    }

    private boolean isChangeUpdate(Object object) {
        return object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED);
    }

    private class MuxDmuxInfo
    extends AbstractRoDataSourceControl {
        private ObservableManager _observableManager;
        private MuxDmuxOpticalPlugInTableModel _dataModel;

        MuxDmuxInfo() {
            this._observableManager = new ObservableManager(MuxDmuxInventoryPane.this, true);
            this._dataModel = null;
        }

        public void refreshFromModel() throws Exception {
            this._dataModel.refreshFromModel();
        }

        @Override
        public void refreshFromModel(int n) throws Exception {
            if (n == -1) {
                OpticsModuleModel opticsModuleModel = (OpticsModuleModel)MuxDmuxInventoryPane.this.getUiModel();
                this._observableManager.addObservable((Observable)((Object)opticsModuleModel));
                this._dataModel = new MuxDmuxOpticalPlugInTableModel(opticsModuleModel);
                MuxDmuxInventoryPane.this.setTable((JTable)new UTable((TableModel)this._dataModel));
                UScrollPane uScrollPane = new UScrollPane((Component)MuxDmuxInventoryPane.this.getTable());
                uScrollPane.setPreferredSize(new Dimension(200, 150));
                MuxDmuxInventoryPane.this.add((Component)uScrollPane, "Center");
            } else {
                this._dataModel.refreshFromModel();
            }
        }

        public IObservableManager getObservableManager() {
            return this._observableManager;
        }

        @Override
        public void disposeDataSource() {
        }
    }
}

