/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.muxdemux;

import cerent.cms.model.OpticsLineModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.OpticsPortModel;
import cerent.util.SDebug;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;

public class MuxDmuxOpticalPlugInTableModel
extends AbstractTableModel {
    private static final SDebug db = new SDebug("MuxDmuxOpticalPlugInTableModel");
    private final OpticsModuleModel _module;
    private String[] _Key;
    private String[] _vals;
    private static final TreeMap _names = new TreeMap();
    private static final TreeMap _units;
    private OpticsPortModel[] models;
    private OpticsLineModel[] lineModels;
    private OpticsModuleModel eqpmtModel;
    private boolean[] rowDirty;
    private int numLines;
    private int numPorts;
    protected String[] columnNames = new String[]{"Attribute", "Value", "Units"};

    public MuxDmuxOpticalPlugInTableModel(OpticsModuleModel opticsModuleModel) {
        this._module = opticsModuleModel;
        this.fetchValues();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public boolean isRowDirty(int n) {
        return this.rowDirty[n];
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    private String getKey(int n) {
        String string = (String)_names.get(this._Key[n]);
        if (string == null) {
            string = this._Key[n];
        }
        return string;
    }

    private String getUnits(int n) {
        if (this._Key[n].startsWith("IL")) {
            return "dB";
        }
        return (String)_units.get(this._Key[n]);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.getKey(n);
            }
            case 1: {
                return this._vals[n];
            }
            case 2: {
                return this.getUnits(n);
            }
        }
        return null;
    }

    private void fetchValues() {
        TreeMap treeMap = new TreeMap();
        treeMap.putAll(this._module.getExtraInfoMap());
        this._Key = new String[treeMap.size()];
        this._vals = new String[treeMap.size()];
        Iterator iterator = treeMap.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            this._Key[n] = (String)iterator.next();
            this._vals[n] = (String)treeMap.get(this._Key[n]);
            ++n;
        }
    }

    @Override
    public int getRowCount() {
        return this._Key.length;
    }

    public void refreshFromModel() {
        int n = this.getRowCount();
        this.fetchValues();
        int n2 = this.getRowCount();
        if (n < n2) {
            this.fireTableRowsInserted(n, n2 - 1);
        } else {
            this.fireTableRowsDeleted(n2, n - 1);
        }
        this.fireTableRowsUpdated(0, this._Key.length - 1);
    }

    static {
        _names.put("VENDOR_NAME", "Vendor ID");
        _names.put("VENDOR_P/N", "Part Number");
        _names.put("SERIAL_NUMBER", "Serial Number");
        _names.put("FW_VERSION", "FW Version");
        _names.put("HW_VERSION", "HW Version");
        _units = new TreeMap();
        _units.put("VENDOR_NAME", "");
        _units.put("VENDOR_P/N", "");
        _units.put("SERIAL_NUMBER", "");
        _units.put("FW_VERSION", "");
        _units.put("HW_VERSION", "");
    }
}

