/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.muxdemux;

import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OpticsChannelModel;
import cerent.cms.model.OpticsLineModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.OpticsMultiplexSectionModel;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.muxdemux.MuxDmuxOCHParametersProvPane;
import cerent.cms.ui.muxdemux.MuxDmuxOMSParametersProvPane;
import cerent.cms.ui.muxdemux.MuxDmuxOTSParametersProvPane;
import cerent.cms.ui.muxdemux.MuxDmuxOpticalThresholdPane;
import cerent.util.SDebug;
import java.awt.Component;
import java.util.ArrayList;

public class MuxDmuxProvPane
extends NodeProvPane
implements ITabName {
    ModuleModel eqpmtModel = null;
    private OpticsModuleModel model = (OpticsModuleModel)this.getUiModel();
    private OpticsChannelModel[] chModels;
    private OpticsMultiplexSectionModel[] omsModels = this.model.getOpticsOMSModels();
    private OpticsLineModel[] otsModels = this.model.getOpticsLineModels();

    public MuxDmuxProvPane(String string, TabbedView tabbedView, ModuleModel moduleModel) {
        super(string, tabbedView);
        this.eqpmtModel = moduleModel;
        this.subTabs = new SubTabbedView(moduleModel, tabbedView);
        if (191 == moduleModel.getEqType() || 263 == moduleModel.getEqType() || 267 == moduleModel.getEqType() || 242 == moduleModel.getEqType()) {
            OpticsChannelModel[][] opticsChannelModelArray = this.getOpticsChannelModelsByOptConn(this.model.getOpticsChannelModels());
            int n = opticsChannelModelArray.length;
            for (int i = 0; i < n; ++i) {
                this.subTabs.addTab("<html>Optical Chn:<br>Optical Connector " + Integer.toString(i + 1) + "<html>", (Component)this.getOCHTabs(this.subTabs, opticsChannelModelArray[i]));
            }
        } else {
            this.chModels = this.model.getOpticsChannelModels();
            this.subTabs.addTab("Optical Chn", (Component)this.getOCHTabs(this.subTabs, this.chModels));
        }
        if (133 == moduleModel.getEqType()) {
            this.subTabs.addTab("Optical Band", (Component)this.getOMSTabs(this.subTabs, this.omsModels));
        } else {
            this.subTabs.addTab("Optical Line", (Component)this.getOtsTabs(this.subTabs, this.otsModels));
        }
        this.subTabs.addTab("Alarm Profiles", (Component)CardTabbedView.getCardProvAlarmsPane(this.subTabs, false));
        this.subTabs.setTabPlacement(2);
        this.add((Component)this.subTabs);
    }

    private OpticsChannelModel[][] getOpticsChannelModelsByOptConn(OpticsChannelModel[] opticsChannelModelArray) {
        OpticsChannelModel[][] opticsChannelModelArray2 = null;
        ArrayList<OpticsChannelModel> arrayList = null;
        int n = opticsChannelModelArray.length / 2;
        int n2 = n / 8;
        int n3 = 0;
        opticsChannelModelArray2 = new OpticsChannelModel[n2][];
        arrayList = new ArrayList<OpticsChannelModel>();
        for (int i = 0; i < opticsChannelModelArray.length; ++i) {
            try {
                if (opticsChannelModelArray[i].isPortTypePT()) continue;
                n3 = (opticsChannelModelArray[i].getPortNumber() - 1) / 8;
                if (i == n3 * 8) {
                    arrayList.clear();
                }
                arrayList.add(opticsChannelModelArray[i]);
                arrayList.add(opticsChannelModelArray[i + n]);
                if (i != 7 + n3 * 8) continue;
                opticsChannelModelArray2[n3] = arrayList.toArray(new OpticsChannelModel[0]);
                arrayList.clear();
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return opticsChannelModelArray2;
    }

    protected Pane getOtsTabs(TabbedView tabbedView, OpticsLineModel[] opticsLineModelArray) {
        return new MuxDmuxOTSProvPane(tabbedView, opticsLineModelArray);
    }

    protected Pane getOMSTabs(TabbedView tabbedView, OpticsMultiplexSectionModel[] opticsMultiplexSectionModelArray) {
        return new MuxDmuxOMSProvPane(tabbedView, opticsMultiplexSectionModelArray);
    }

    protected Pane getOCHTabs(TabbedView tabbedView, OpticsChannelModel[] opticsChannelModelArray) {
        return new MuxDmuxOCHProvPane(tabbedView, opticsChannelModelArray);
    }

    protected Pane getOMSParametersProvTab(OpticsMultiplexSectionModel[] opticsMultiplexSectionModelArray) {
        return new MuxDmuxOMSParametersProvPane("Parameters", this.getParentView(), opticsMultiplexSectionModelArray);
    }

    protected Pane getOCHParametersProvTab(OpticsChannelModel[] opticsChannelModelArray) {
        return new MuxDmuxOCHParametersProvPane("Parameters", this.getParentView(), opticsChannelModelArray);
    }

    protected Pane getOTSParametersProvTab(OpticsLineModel[] opticsLineModelArray) {
        return new MuxDmuxOTSParametersProvPane("Parameters", this.getParentView(), opticsLineModelArray);
    }

    protected Pane getOptThresholdsTab(AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        return new MuxDmuxOpticalThresholdPane("Optics Thresholds", this.getParentView(), abstractOpticsLineModelArray);
    }

    @Override
    public boolean hasSubTabs() {
        return true;
    }

    private class MuxDmuxOCHProvPane
    extends NodeProvPane {
        public MuxDmuxOCHProvPane(TabbedView tabbedView, OpticsChannelModel[] opticsChannelModelArray) {
            super("MuxDmuxProvPane", tabbedView);
            this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
            this.subTabs.addTab("Parameters", (Component)MuxDmuxProvPane.this.getOCHParametersProvTab(opticsChannelModelArray));
            this.subTabs.addTab("Optics Thresholds", (Component)MuxDmuxProvPane.this.getOptThresholdsTab(opticsChannelModelArray));
            this.add((Component)this.subTabs);
        }

        @Override
        public boolean hasSubTabs() {
            return true;
        }
    }

    private class MuxDmuxOMSProvPane
    extends NodeProvPane {
        public MuxDmuxOMSProvPane(TabbedView tabbedView, OpticsMultiplexSectionModel[] opticsMultiplexSectionModelArray) {
            super("MaxDmaxOMSProvPane", tabbedView);
            this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
            this.subTabs.addTab("Parameters", (Component)MuxDmuxProvPane.this.getOMSParametersProvTab(opticsMultiplexSectionModelArray));
            this.subTabs.addTab("Optics Thresholds", (Component)MuxDmuxProvPane.this.getOptThresholdsTab(opticsMultiplexSectionModelArray));
            this.add((Component)this.subTabs);
        }

        @Override
        public boolean hasSubTabs() {
            return true;
        }
    }

    private class MuxDmuxOTSProvPane
    extends NodeProvPane {
        public MuxDmuxOTSProvPane(TabbedView tabbedView, OpticsLineModel[] opticsLineModelArray) {
            super("MuxDmuxOTSProvPane", tabbedView);
            this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
            this.subTabs.addTab("Parameters", (Component)MuxDmuxProvPane.this.getOTSParametersProvTab(opticsLineModelArray));
            this.subTabs.addTab("Optics Thresholds", (Component)MuxDmuxProvPane.this.getOptThresholdsTab(opticsLineModelArray));
            this.add((Component)this.subTabs);
        }

        @Override
        public boolean hasSubTabs() {
            return true;
        }
    }
}

