/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.oscm;

import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.oscm.OscmOTSTableModel;
import cerent.cms.ui.oscm.OscmOptLineProvTable;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.FixedLengthField;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class OscOTSProvPane
extends NodeProvPane
implements TableModelListener {
    protected OscmOTSTableModel dataModel;
    protected OpticsModuleModel eqpmtModel;
    protected AbstractOpticsLineModel[] lineModels;
    protected int numLines;
    private boolean notInited = true;
    protected static final SDebug db = new SDebug("OscOTSProvPane");

    public OscOTSProvPane(String string, TabbedView tabbedView, AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        super(string, tabbedView);
        this.lineModels = abstractOpticsLineModelArray;
    }

    protected void init() {
        this.eqpmtModel = (OpticsModuleModel)this.getUiModel();
        this.numLines = this.lineModels.length;
        this.dataModel = this.getDataModel();
        this.dataModel.addTableModelListener(this);
        boolean bl = AdminState.isANSI(this.getUiModel().getNodeModel().getTdmProtocolType());
        this.table = this.getTable(this.dataModel, bl);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(true);
        this.prepareColumns();
        this.registerWithModel();
        this.add((Component)uScrollPane, "Center");
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.table.setAutoResizeMode(0);
        this.notInited = false;
    }

    private JTable getTable(TableModel tableModel, boolean bl) {
        if (this.eqpmtModel.getEqType() == 127) {
            return new UTable((TableModel)this.dataModel);
        }
        return new OscmOptLineProvTable(this.dataModel, bl);
    }

    protected void prepareColumns() {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(0));
        tableColumn.setPreferredWidth(90);
        tableColumn.setCellRenderer(PORT_CELL_RENDERER);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(1));
        tableColumn.setCellEditor(new DefaultCellEditor(new FixedLengthField(32)));
        tableColumn.setPreferredWidth(150);
        boolean bl = AdminState.isANSI(this.getUiModel().getNodeModel().getTdmProtocolType());
        AdminState[] adminStateArray = AdminState.getAdminStatesNoDSBLD(bl);
        JComboBox<AdminState> jComboBox = new JComboBox<AdminState>(adminStateArray);
        jComboBox.setEditable(false);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(2));
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        tableColumn.sizeWidthToFit();
        tableColumn.setPreferredWidth(tableColumn.getWidth());
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(3));
        tableColumn.sizeWidthToFit();
        tableColumn.setPreferredWidth(tableColumn.getWidth());
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(8));
        tableColumn.setPreferredWidth(170);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(9));
        tableColumn.setPreferredWidth(170);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(10));
        tableColumn.setPreferredWidth(170);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(11));
        tableColumn.setPreferredWidth(170);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(12));
        tableColumn.setPreferredWidth(170);
        this.removeColumn(4);
        OpticsModuleModel opticsModuleModel = (OpticsModuleModel)this.getUiModel();
        if (opticsModuleModel.isOpticsLinePowerSupported()) {
            this.removeColumn(12);
            this.removeColumn(11);
            this.removeColumn(10);
            this.removeColumn(9);
        } else {
            this.removeColumn(7);
            this.removeColumn(6);
        }
    }

    protected void setAttrCellEditor(int n, String string) {
        this.setAttrCellEditor(n, string, -1);
    }

    protected void setAttrCellEditor(int n, String string, int n2) {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(n));
        try {
            Attribute[] attributeArray = this.getAttributeArray(string);
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
            tableColumn.sizeWidthToFit();
            if (n2 == -1) {
                tableColumn.setPreferredWidth(tableColumn.getWidth());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            db.println("WARNING: cannot find attributes for " + string + "\nPlease edit ElementDefaults.java");
            this.table.removeColumn(tableColumn);
        }
    }

    protected void removeColumn(int n) {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(n));
        this.table.removeColumn(tableColumn);
    }

    protected JComboBox getComboBoxFor(Attribute[] attributeArray) {
        JComboBox<Attribute> jComboBox = new JComboBox<Attribute>(attributeArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    protected OscmOTSTableModel getDataModel() {
        return new OscmOTSTableModel(this.lineModels);
    }

    public Attribute[] getAttributeArray(String string) throws NoSuchElementException {
        Attribute[] attributeArray = ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeArray(string);
        if (attributeArray == null) {
            throw new NoSuchElementException();
        }
        return attributeArray;
    }

    protected JComboBox getComboBoxForStatus() {
        JComboBox<String> jComboBox = new JComboBox<String>(this.dataModel.getStatusStrings());
        jComboBox.setEditable(false);
        return jComboBox;
    }

    @Override
    protected boolean queryRemainDirty() {
        return true;
    }

    @Override
    public void applyChangesToModel() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        if (AdminState.adminStateChangedToFormOfOOS(this.dataModel, this.lineModels)) {
            stringBuffer.append(AdminState.getBaseOosWarning(this.terms)).append('\n');
            bl2 = true;
        }
        if (bl || bl2) {
            boolean bl3 = true;
            if (bl2) {
                String string = AdminState.getSevWarningMsg(this.dataModel, this.lineModels, bl);
                bl3 = false;
                stringBuffer.append(string).append("\n");
            }
            stringBuffer.append("\n");
            if (!bl3) {
                stringBuffer.append(this.getApplyString(bl3));
            } else {
                stringBuffer.append(this.getApplyString());
            }
            if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)stringBuffer.toString(), (String)"Confirmation Dialog")) {
                return;
            }
        }
        this.dataModel.applyToModel();
        this.resetDirty();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            this.requestRefresh(observable, this.getRefreshThread(observable));
        }
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            @Override
            public void run() {
                OscOTSProvPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else if (db.on()) {
            db.println("In AbstractOscmProvpane changeMessage cannot find Model " + observable);
        }
    }

    @Override
    protected void registerWithModel() {
        for (int i = 0; i < this.numLines; ++i) {
            if (this.lineModels[i] == null) continue;
            this.lineModels[i].addObserver((Observer)((Object)this));
        }
    }

    @Override
    public void destroy() {
        for (int i = 0; i < this.numLines; ++i) {
            if (this.lineModels[i] != null) {
                this.lineModels[i].deleteObserver((Observer)((Object)this));
            }
            this.lineModels[i] = null;
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    @Override
    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    @Override
    public void enteringPage() throws Exception {
        if (this.notInited) {
            this.init();
        }
        super.enteringPage();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    @Override
    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.OscOTSProvPane;
    }
}

