/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.pm;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.model.ConfigError;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.PmTableModel;
import cerent.cms.ui.pm.PmLayer;
import cerent.cms.ui.pm.PmLayerDs1iLine;
import cerent.cms.ui.pm.PmLayerDs1iPathRx;
import cerent.cms.ui.pm.PmLayerDs1iPathTx;

public class PmLayerDs1i
extends PmLayer {
    protected int lineCount;
    protected PmLayer lineLayer;
    protected int numParms;
    protected int pathCount;
    protected PmLayer pathLayer;
    protected int pathCountTx;
    protected PmLayer pathLayerTx;

    public PmLayerDs1i(PmTableModel pmTableModel, Ds123LineModel ds123LineModel, int n) {
        this.lineLayer = new PmLayerDs1iLine(pmTableModel, ds123LineModel, n);
        this.pathLayer = new PmLayerDs1iPathRx(pmTableModel, ds123LineModel, n);
        this.pathLayerTx = new PmLayerDs1iPathTx(pmTableModel, ds123LineModel, n);
        this.lineCount = this.lineLayer.parmCount();
        this.pathCount = this.pathLayer.parmCount();
        this.pathCountTx = this.pathLayerTx.parmCount();
        this.numParms = this.lineCount + this.pathCount + this.pathCountTx;
    }

    @Override
    public void clearStats() throws UnsupportedOperation, ConfigError, NoSuchInterface, WrongInterfaceType, InternalCommError {
        this.lineLayer.clearStats();
    }

    @Override
    public boolean hasFarEnd() {
        return this.lineLayer.hasFarEnd() || this.pathLayer.hasFarEnd() || this.pathLayerTx.hasFarEnd();
    }

    @Override
    public void setNearEnd(boolean bl) {
        this.lineLayer.setNearEnd(bl);
        this.pathLayer.setNearEnd(bl);
        this.pathLayerTx.setNearEnd(bl);
    }

    @Override
    public void setIntervalType(eIntervalType eIntervalType2) {
        this.lineLayer.setIntervalType(eIntervalType2);
        this.pathLayer.setIntervalType(eIntervalType2);
        this.pathLayerTx.setIntervalType(eIntervalType2);
    }

    @Override
    public Object getPmValue(int n, int n2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        if (n < this.lineCount) {
            return this.lineLayer.getPmValue(n, n2);
        }
        if ((n -= this.lineCount) < this.pathCount) {
            return this.pathLayer.getPmValue(n, n2);
        }
        return this.pathLayerTx.getPmValue(n -= this.pathCount, n2);
    }

    @Override
    public String layerLabel() {
        return "DS1";
    }

    @Override
    public int parmCount() {
        return this.numParms;
    }

    @Override
    public void refreshPmStats(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        this.lineLayer.refreshPmStats(n);
        this.pathLayer.refreshPmStats(n);
        this.pathLayerTx.refreshPmStats(n);
        this.fromPeerCard = this.lineLayer.isFromPeerCard() || this.pathLayer.isFromPeerCard() || this.pathLayerTx.isFromPeerCard();
    }

    @Override
    public String parmName(int n) {
        if (n < this.lineCount) {
            return this.lineLayer.parmName(n);
        }
        if ((n -= this.lineCount) < this.pathCount) {
            return this.pathLayer.parmName(n);
        }
        return this.pathLayerTx.parmName(n -= this.pathCount);
    }

    @Override
    public void setModel(InterfaceModel interfaceModel) {
        this.lineLayer.setModel(interfaceModel);
        this.pathLayer.setModel(interfaceModel);
        this.pathLayerTx.setModel(interfaceModel);
    }

    @Override
    public void tossData() {
        this.lineLayer.tossData();
        this.pathLayer.tossData();
        this.pathLayerTx.tossData();
        this.fromPeerCard = false;
    }

    @Override
    public void destroy() {
        this.lineLayer.destroy();
        this.pathLayer.destroy();
        this.pathLayerTx.destroy();
        super.destroy();
    }
}

