/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.pm;

import cerent.cms.idl.Common.sPmStat;
import cerent.cms.idl.Common.sPmStatRatio;
import cerent.cms.idl.Ds123Media.eStatsType;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.PmRendererStat;
import cerent.cms.ui.PmRendererStatRatio;
import cerent.cms.ui.PmTableModel;
import cerent.cms.ui.pm.PmLayerDsnEn;
import cerent.util.SDebug;

public class PmLayerDs3iPbit
extends PmLayerDsnEn {
    protected int numParms;
    public static String[] parmNames;
    public static final int CVP_P_INDEX = 0;
    public static final int ESP_P_INDEX = 1;
    public static final int SESP_P_INDEX = 2;
    public static final int SASP_P_INDEX = 3;
    public static final int UASP_P_INDEX = 4;
    public static final int AISS_P_INDEX = 5;
    public static final int NUM_OF_PARMS = 6;
    private static final SDebug db;

    public PmLayerDs3iPbit(PmTableModel pmTableModel, Ds123LineModel ds123LineModel, int n) {
        super(pmTableModel, ds123LineModel, n, db);
        this.initParmName();
        this.numParms = parmNames.length;
    }

    @Override
    public Object getPmValue(int n, int n2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        sPmStat sPmStat2 = PM_STATS_VALID;
        sPmStatRatio sPmStatRatio2 = PM_STATS_RATIO_INVALID;
        boolean bl = false;
        if (PmLayerDs3iPbit.db.on) {
            db.println("entering getPmValue - row = " + n + ", interval= " + n2);
        }
        switch (n) {
            case 5: {
                sPmStat2 = this.statsVal[n2].ais;
                break;
            }
            case 0: {
                sPmStat2 = this.statsVal[n2].cv;
                break;
            }
            case 1: {
                sPmStat2 = this.statsVal[n2].es;
                break;
            }
            case 3: {
                sPmStat2 = this.statsVal[n2].sas;
                break;
            }
            case 2: {
                sPmStat2 = this.statsVal[n2].ses;
                break;
            }
            case 4: {
                sPmStat2 = this.statsVal[n2].uas;
                break;
            }
        }
        if (bl) {
            return new PmRendererStatRatio(sPmStatRatio2);
        }
        return new PmRendererStat(sPmStat2);
    }

    @Override
    public String layerLabel() {
        return "PBit";
    }

    @Override
    public void refreshPmStats(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        this.refreshPmStats(n, eStatsType.P_BIT_STATS);
    }

    @Override
    public String parmName(int n) {
        return parmNames[n];
    }

    @Override
    public int parmCount() {
        return parmNames.length;
    }

    private void initParmName() {
        parmNames = new String[6];
        PmLayerDs3iPbit.parmNames[0] = "DS3 CVP-P";
        PmLayerDs3iPbit.parmNames[1] = "DS3 ESP-P";
        PmLayerDs3iPbit.parmNames[2] = "DS3 SESP-P";
        PmLayerDs3iPbit.parmNames[3] = "DS3 SASP-P";
        PmLayerDs3iPbit.parmNames[4] = "DS3 UASP-P";
        PmLayerDs3iPbit.parmNames[5] = "DS3 AISSP-P";
    }

    static {
        db = new SDebug("PmLayerDs3iPbit");
    }
}

