/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.pm;

import cerent.cms.idl.Common.sPmStat;
import cerent.cms.idl.Dwdm.sOpticsPmStats;
import cerent.cms.idl.Dwdm.sValPmStat;
import cerent.cms.model.IOpticsPmModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.PmRendererOpticStat;
import cerent.cms.ui.PmTableModel;
import cerent.cms.ui.pm.PmLayer;
import cerent.util.SDebug;

public class PmLayerDwdmOptics
extends PmLayer {
    protected IOpticsPmModel model = null;
    protected int numRegisters;
    protected sOpticsPmStats[] statsVal;
    protected static final sValPmStat defValPmStat = new sValPmStat(PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID);
    public String[] parmNames = new String[]{"Laser Bias (Min,%)", "Laser Bias (Avg,%)", "Laser Bias (Max,%)", "RX Optical Pwr (Min,dBm)", "RX Optical Pwr (Avg,dBm)", "RX Optical Pwr (Max,dBm)", "TX Optical Pwr (Min,dBm)", "TX Optical Pwr (Avg,dBm)", "TX Optical Pwr (Max,dBm)"};
    public static final int LASER_BIAS_MIN_INDEX = 0;
    public static final int LASER_BIAS_AVG_INDEX = 1;
    public static final int LASER_BIAS_MAX_INDEX = 2;
    public static final int RX_POWER_MIN_INDEX = 3;
    public static final int RX_POWER_AVG_INDEX = 4;
    public static final int RX_POWER_MAX_INDEX = 5;
    public static final int TX_POWER_MIN_INDEX = 6;
    public static final int TX_POWER_AVG_INDEX = 7;
    public static final int TX_POWER_MAX_INDEX = 8;
    private static final sOpticsPmStats _defaultStats = new sOpticsPmStats(defValPmStat, defValPmStat, defValPmStat, defValPmStat, defValPmStat, defValPmStat);
    private static final SDebug db = new SDebug("PmLayerDwdmOptics");

    public PmLayerDwdmOptics(PmTableModel pmTableModel, IOpticsPmModel iOpticsPmModel, int n) {
        this.model = iOpticsPmModel;
        this.numRegisters = n;
        this.statsVal = new sOpticsPmStats[n];
        this.tossData();
    }

    @Override
    public void clearStats() {
        try {
            this.model.clearOpticsStats(this.intervalType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            SDebug.printStackTrace((Throwable)illegalArgumentException);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    @Override
    public Object getPmValue(int n, int n2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        switch (n) {
            case 0: {
                return new PmRendererOpticStat(1, this.statsVal[n2].laserBias.min);
            }
            case 1: {
                return new PmRendererOpticStat(1, this.statsVal[n2].laserBias.avg);
            }
            case 2: {
                return new PmRendererOpticStat(1, this.statsVal[n2].laserBias.max);
            }
            case 3: {
                return new PmRendererOpticStat(0, this.statsVal[n2].rxPower.min);
            }
            case 4: {
                return new PmRendererOpticStat(0, this.statsVal[n2].rxPower.avg);
            }
            case 5: {
                return new PmRendererOpticStat(0, this.statsVal[n2].rxPower.max);
            }
            case 6: {
                return new PmRendererOpticStat(0, this.statsVal[n2].txPower.min);
            }
            case 7: {
                return new PmRendererOpticStat(0, this.statsVal[n2].txPower.avg);
            }
            case 8: {
                return new PmRendererOpticStat(0, this.statsVal[n2].txPower.max);
            }
        }
        db.println("WARNING: PmLayerDwdmOptics.getPmValue needs updating, unknown value " + n);
        return null;
    }

    @Override
    public String layerLabel() {
        return "Port";
    }

    @Override
    public void refreshPmStats(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            if (this.statsVal[n] == null || this.statsVal[n] == _defaultStats) {
                this.statsVal[n] = _defaultStats;
                this.statsVal[n] = this.model.getOpticsStats(this.intervalType, (short)n);
                if (db.on() && n == 0) {
                    this.printStats(0);
                }
            }
        }
        catch (InternalCommError internalCommError) {
            this.statsVal[n] = new sOpticsPmStats(defValPmStat, defValPmStat, defValPmStat, defValPmStat, defValPmStat, defValPmStat);
            throw internalCommError;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            SDebug.printStackTrace((Throwable)illegalArgumentException);
        }
    }

    private void printStats(int n) {
        db.println("Optics rxPower.avg=" + this.strPmStat(this.statsVal[n].rxPower.avg) + " txPower.avg=" + this.strPmStat(this.statsVal[n].txPower.avg) + " laserBias.avg=" + this.strPmStat(this.statsVal[n].laserBias.avg) + " rxPower.min=" + this.strPmStat(this.statsVal[n].rxPower.min) + " txPower.min=" + this.strPmStat(this.statsVal[n].txPower.min) + " laserbias.min=" + this.strPmStat(this.statsVal[n].laserBias.min) + " rxPower.max=" + this.strPmStat(this.statsVal[n].rxPower.max) + " txPower.max=" + this.strPmStat(this.statsVal[n].txPower.max) + " laserbias.max=" + this.strPmStat(this.statsVal[n].laserBias.max));
    }

    private String strPmStat(sPmStat sPmStat2) {
        if (sPmStat2.valid) {
            return Integer.toString(sPmStat2.cnt);
        }
        return "#";
    }

    @Override
    public String parmName(int n) {
        return this.parmNames[n];
    }

    @Override
    public int parmCount() {
        int n = this.parmNames.length;
        if (!this.model.supportsTxPower()) {
            n = 6;
        }
        return n;
    }

    @Override
    public void setModel(InterfaceModel interfaceModel) {
        if (interfaceModel instanceof IOpticsPmModel) {
            this.model = (IOpticsPmModel)((Object)interfaceModel);
        }
    }

    @Override
    public void tossData() {
        for (int i = 0; i < this.numRegisters; ++i) {
            this.statsVal[i] = null;
        }
    }

    @Override
    public boolean isHigherPmDisplayed() {
        return false;
    }
}

