/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.pm;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.model.ConfigError;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.PmTableModel;
import cerent.cms.ui.pm.PmLayer;
import cerent.cms.ui.pm.PmLayerE3Line;
import cerent.cms.ui.pm.PmLayerE3Path;

public class PmLayerE3
extends PmLayer {
    protected int numParms;
    protected int lineCount;
    protected int pathCount;
    protected PmLayer lineLayer;
    protected PmLayer pathLayer;

    public PmLayerE3(PmTableModel pmTableModel, Ds123LineModel ds123LineModel, int n) {
        this.lineLayer = new PmLayerE3Line(pmTableModel, ds123LineModel, n);
        this.pathLayer = new PmLayerE3Path(pmTableModel, ds123LineModel, n);
        this.lineCount = this.lineLayer.parmCount();
        this.pathCount = this.pathLayer.parmCount();
        this.numParms = this.lineCount + this.pathCount;
    }

    @Override
    public void clearStats() throws NoSuchInterface, WrongInterfaceType, InternalCommError, ConfigError, UnsupportedOperation {
        this.lineLayer.clearStats();
    }

    @Override
    public boolean hasFarEnd() {
        return this.lineLayer.hasFarEnd() || this.pathLayer.hasFarEnd();
    }

    @Override
    public void setNearEnd(boolean bl) {
        this.lineLayer.setNearEnd(bl);
        this.pathLayer.setNearEnd(bl);
    }

    @Override
    public void setIntervalType(eIntervalType eIntervalType2) {
        this.lineLayer.setIntervalType(eIntervalType2);
        this.pathLayer.setIntervalType(eIntervalType2);
    }

    @Override
    public Object getPmValue(int n, int n2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        if (n < this.lineCount) {
            return this.lineLayer.getPmValue(n, n2);
        }
        return this.pathLayer.getPmValue(n -= this.lineCount, n2);
    }

    @Override
    public String layerLabel() {
        return "E3";
    }

    @Override
    public int parmCount() {
        return this.numParms;
    }

    @Override
    public void refreshPmStats(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        this.lineLayer.refreshPmStats(n);
        this.pathLayer.refreshPmStats(n);
        this.fromPeerCard = this.lineLayer.isFromPeerCard() || this.pathLayer.isFromPeerCard();
    }

    @Override
    public String parmName(int n) {
        if (n < this.lineCount) {
            return this.lineLayer.parmName(n);
        }
        return this.pathLayer.parmName(n -= this.lineCount);
    }

    @Override
    public void setModel(InterfaceModel interfaceModel) {
        this.lineLayer.setModel(interfaceModel);
        this.pathLayer.setModel(interfaceModel);
    }

    @Override
    public void tossData() {
        this.lineLayer.tossData();
        this.pathLayer.tossData();
        this.fromPeerCard = false;
    }
}

