/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.pm;

import cerent.cms.idl.Common.sPmStat;
import cerent.cms.idl.Dwdm.sValPmStat;
import cerent.cms.idl.Optics.PM_OPTICS_UNDEFINED;
import cerent.cms.idl.Optics.sOpticsPmStats;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.PmRendererStatRatio;
import cerent.cms.ui.PmTableModel;
import cerent.cms.ui.ochterm.OchPmTableModel;
import cerent.cms.ui.pm.PmLayer;
import cerent.util.SDebug;

public class PmLayerOptics
extends PmLayer
implements PM_OPTICS_UNDEFINED {
    private int ifType;
    protected AbstractOpticsLineModel model = null;
    protected int numParms;
    protected int numRegisters;
    protected sOpticsPmStats[] statsVal;
    private static final sPmStat defOptPmStat = new sPmStat(-1000000, false);
    protected static final sValPmStat defValPmStat = new sValPmStat(defOptPmStat, defOptPmStat, defOptPmStat);
    protected static final sValPmStat defValPayloadPmStat = new sValPmStat(defOptPmStat, defOptPmStat, defOptPmStat);
    protected static final sValPmStat defValOscPmStat = new sValPmStat(defOptPmStat, defOptPmStat, defOptPmStat);
    private String[] paramName = new String[]{"Optical Pwr (Min)", "Optical Pwr (Avg)", "Optical Pwr (Max)", "Osc Pwr (Min)", "Osc Pwr (Avg)", "Osc Pwr (Max)"};
    private int[] indexRemap;
    private int numParam;
    public static final int POWER_MIN_INDEX = 0;
    public static final int POWER_AVG_INDEX = 1;
    public static final int POWER_MAX_INDEX = 2;
    public static final int OSC_POWER_MIN_INDEX = 3;
    public static final int OSC_POWER_AVG_INDEX = 4;
    public static final int OSC_POWER_MAX_INDEX = 5;
    private static final sOpticsPmStats _defaultStats = new sOpticsPmStats(0, defValPmStat, defValOscPmStat);
    private static final SDebug db = new SDebug("PmLayerOptics");

    public PmLayerOptics(PmTableModel pmTableModel, AbstractOpticsLineModel abstractOpticsLineModel, int n, int n2) {
        super(pmTableModel, abstractOpticsLineModel);
        this.model = abstractOpticsLineModel;
        this.numRegisters = n;
        this.statsVal = new sOpticsPmStats[n];
        this.ifType = n2;
        this.indexRemap = new int[this.paramName.length];
        this.initRows();
        this.tossData();
    }

    private void initRows() {
        int n = 0;
        if (this.model.isFeatureSupported(256)) {
            this.indexRemap[n] = 0;
            this.indexRemap[++n] = 1;
            this.indexRemap[++n] = 2;
            ++n;
        }
        if (this.model.isFeatureSupported(262144)) {
            this.indexRemap[n] = 3;
            this.indexRemap[++n] = 4;
            this.indexRemap[++n] = 5;
        }
        int n2 = ++n;
        ++n;
        this.numParam = n2;
    }

    @Override
    public void clearStats() {
        try {
            this.model.clearOpticsStats(this.intervalType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            SDebug.printStackTrace((Throwable)illegalArgumentException);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    @Override
    public Object getPmValue(int n, int n2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        Float f = new Float(0.0f);
        boolean bl = false;
        this.refreshPmStats(n2);
        switch (this.indexRemap[n]) {
            case 0: {
                f = new Float((float)this.statsVal[n2].opticalPower.min.cnt / 10.0f);
                bl = this.statsVal[n2].opticalPower.min.valid;
                break;
            }
            case 1: {
                f = new Float((float)this.statsVal[n2].opticalPower.avg.cnt / 10.0f);
                bl = this.statsVal[n2].opticalPower.avg.valid;
                break;
            }
            case 2: {
                f = new Float((float)this.statsVal[n2].opticalPower.max.cnt / 10.0f);
                bl = this.statsVal[n2].opticalPower.max.valid;
                break;
            }
            case 3: {
                f = new Float((float)this.statsVal[n2].oscPower.min.cnt / 10.0f);
                bl = this.statsVal[n2].oscPower.min.valid;
                break;
            }
            case 4: {
                f = new Float((float)this.statsVal[n2].oscPower.avg.cnt / 10.0f);
                bl = this.statsVal[n2].oscPower.avg.valid;
                break;
            }
            case 5: {
                f = new Float((float)this.statsVal[n2].oscPower.max.cnt / 10.0f);
                bl = this.statsVal[n2].oscPower.max.valid;
                break;
            }
            default: {
                db.println("WARNING: PmLayerOptics.getPmValue needs updating, unknown value " + n);
            }
        }
        return new PmRendererStatRatio(f.floatValue(), bl, true);
    }

    @Override
    public String layerLabel() {
        switch (this.ifType) {
            case 26: {
                return "Wavelength";
            }
        }
        return "Port";
    }

    public int getInterfaceType() {
        return this.ifType;
    }

    @Override
    public void refreshPmStats(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            if (this.statsVal[n] == null || this.statsVal[n] == _defaultStats) {
                this.statsVal[n] = _defaultStats;
                this.statsVal[n] = this.model.getOpticsStats(this.intervalType, (short)n);
            }
        }
        catch (InternalCommError internalCommError) {
            this.statsVal[n] = new sOpticsPmStats(0, defValPmStat, defValOscPmStat);
            throw internalCommError;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            SDebug.printStackTrace((Throwable)illegalArgumentException);
        }
    }

    @Override
    public String parmName(int n) {
        return this.paramName[this.indexRemap[n]];
    }

    @Override
    public int parmCount() {
        return this.numParam;
    }

    @Override
    public void setModel(InterfaceModel interfaceModel) {
        this.model = (AbstractOpticsLineModel)interfaceModel;
    }

    @Override
    public void tossData() {
        for (int i = 0; i < this.numRegisters; ++i) {
            this.statsVal[i] = null;
        }
    }

    @Override
    public boolean isHigherPmDisplayed() {
        return this.tblModel instanceof OchPmTableModel;
    }
}

