/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.pm;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.SonetMedia.sLineStats600;
import cerent.cms.idl.SonetMedia.sPhysicalStats600;
import cerent.cms.idl.SonetMedia.sSectionStats600;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.PmTableModel;
import cerent.cms.ui.pm.PmLayer;
import cerent.util.SDebug;

public abstract class PmLayerTdmLinePhys
extends PmLayer {
    protected sLineStats600[] lineStatsVal;
    protected sSectionStats600[] sectionStatsVal;
    protected sPhysicalStats600[] physicalStatsVal;
    protected TdmLineModel model;
    protected int numRegisters;
    protected static String[] parmNames;
    protected static int parmCount;
    private static final SDebug db;

    public PmLayerTdmLinePhys(PmTableModel pmTableModel, TdmLineModel tdmLineModel, int n, boolean bl) {
        super(pmTableModel, tdmLineModel, bl);
        this.model = tdmLineModel;
        this.initParams();
        this.numRegisters = n;
        this.lineStatsVal = new sLineStats600[this.numRegisters];
        this.sectionStatsVal = new sSectionStats600[this.numRegisters];
        this.physicalStatsVal = new sPhysicalStats600[this.numRegisters];
    }

    public PmLayerTdmLinePhys(PmTableModel pmTableModel, TdmLineModel tdmLineModel, int n) {
        this(pmTableModel, tdmLineModel, n, true);
    }

    @Override
    public void clearStats() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        this.model.clearLineStats(this.nearEnd, this.intervalType);
    }

    @Override
    public void clearStats(String[] stringArray) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        this.model.clearStatsPerParam(this.nearEnd, this.intervalType, stringArray);
    }

    @Override
    public void clearAllStatsForLine() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        this.model.clearAllStatsForLine();
    }

    @Override
    public void clearAllStatsForCard() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        this.model.clearAllStatsForCard();
    }

    @Override
    public String layerLabel() {
        return "Port";
    }

    @Override
    public void refreshPmStats(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        if (this.lineStatsVal[n] == null) {
            if (db.on()) {
                db.println("calling getLineStats in PmLayerSonetLinePhys");
            }
            int n2 = this.intervalType == eIntervalType.INTERVAL_15_MIN ? this.numRegisters : this.numRegisters - 4;
            sLineStats600[] sLineStats600Array = new sLineStats600[n2];
            sSectionStats600[] sSectionStats600Array = new sSectionStats600[n2];
            sPhysicalStats600[] sPhysicalStats600Array = new sPhysicalStats600[n2];
            for (int i = 0; i < n2; ++i) {
                this.lineStatsVal[i] = new sLineStats600(PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID);
                this.sectionStatsVal[i] = new sSectionStats600(PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID);
                this.physicalStatsVal[i] = new sPhysicalStats600(PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID);
                sLineStats600Array[i] = this.lineStatsVal[i];
                sSectionStats600Array[i] = this.sectionStatsVal[i];
                sPhysicalStats600Array[i] = this.physicalStatsVal[i];
            }
            this.model.getLineStats(this.nearEnd, this.intervalType, (short)-1, sLineStats600Array, sSectionStats600Array, sPhysicalStats600Array);
        }
    }

    @Override
    public String parmName(int n) {
        return parmNames[n];
    }

    @Override
    public int parmCount() {
        return parmNames.length;
    }

    @Override
    public void setModel(InterfaceModel interfaceModel) {
        this.model = (TdmLineModel)interfaceModel;
    }

    @Override
    public void tossData() {
        for (int i = 0; i < this.numRegisters; ++i) {
            this.lineStatsVal[i] = null;
            this.sectionStatsVal[i] = null;
            this.physicalStatsVal[i] = null;
        }
    }

    protected void initParams() {
        this.initColumnParamNames();
        this.initParamCount();
    }

    protected abstract void initColumnParamNames();

    protected abstract void initParamCount();

    @Override
    public abstract Object getPmValue(int var1, int var2) throws NoSuchInterface, WrongInterfaceType, InternalCommError;

    static {
        db = new SDebug("PmLayerTdmLinePhys");
    }
}

