/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.psm;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.ui.AbstractLeavePageException;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.LeavePageException;
import cerent.cms.ui.NotApplicablePane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ampli.AmpliAlsTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.EventBus;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class PsmAlsPane
extends AbstractPane
implements TableModelListener,
ActionListener {
    protected OpticsModuleModel model;
    protected AmpliAlsTableModel dataModel = null;
    private AbstractOpticsLineModel[] lineModels;
    protected int numLines = 0;
    private boolean notInited = true;
    private NotApplicablePane nap;
    private UScrollPane scrollPane = null;
    public static final String APPLY = "Apply";
    public static final String RESET = "Reset";
    public static final String HELP = "Help";
    protected int thresholdLayer;
    private JButton applyButton;
    private JButton resetButton;
    private boolean isDirty = false;
    private JPanel buttonPanel = null;
    private CSHelpButton helpButton;
    protected static final SDebug db = new SDebug("PsmAlsPane");

    public PsmAlsPane(String string, TabbedView tabbedView, OpticsModuleModel opticsModuleModel) {
        super(string, tabbedView);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout(5, 5));
        this.model = opticsModuleModel;
        this.buttonPanel = this.getButtonPanel();
        this.add(this.buttonPanel, "East");
    }

    private void updateAlsPane() {
        try {
            if (!this.lineModels[0].isALSSupported()) {
                if (this.scrollPane != null) {
                    this.remove((Component)this.scrollPane);
                    if (this.dataModel != null) {
                        this.dataModel.removeTableModelListener(this);
                    }
                    this.dataModel = null;
                    this.buttonPanel.setVisible(false);
                    this.nap = new NotApplicablePane("NotApplicablePane", this.getSubTabs());
                    this.scrollPane = null;
                    this.add((Component)((Object)this.nap), "Center");
                    SwingUtilities.updateComponentTreeUI((Component)((Object)this));
                }
            } else if (this.nap != null) {
                this.remove((Component)((Object)this.nap));
                this.nap = null;
                this.scrollPane = new UScrollPane((Component)this.table);
                this.dataModel = this.getDataModel();
                this.table.setModel(this.dataModel);
                this.add((Component)this.scrollPane, "Center");
                this.dataModel.addTableModelListener(this);
                this.initColumns();
                this.dataModel.refreshFromModel();
                SwingUtilities.updateComponentTreeUI((Component)((Object)this));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initAlsPane() {
        try {
            this.table = new JTable();
            if (this.lineModels[0] != null) {
                if (!this.lineModels[0].isALSSupported()) {
                    this.dataModel = null;
                    this.buttonPanel.setVisible(false);
                    this.nap = new NotApplicablePane("NotApplicablePane", this.getSubTabs());
                    this.add((Component)((Object)this.nap), "Center");
                    this.scrollPane = null;
                } else {
                    this.buttonPanel.setVisible(true);
                    this.numLines = this.lineModels.length;
                    this.dataModel = this.getDataModel();
                    this.dataModel.addTableModelListener(this);
                    this.table.setModel(this.dataModel);
                    this.scrollPane = new UScrollPane((Component)this.table);
                    this.add((Component)this.scrollPane, "Center");
                    this.dataModel.addTableModelListener(this);
                    this.initColumns();
                    this.dataModel.refreshFromModel();
                    this.nap = null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initColumns() {
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(true);
        TableColumn tableColumn = this.table.getColumn(AmpliAlsTableModel.columnNames[0]);
        TableColumn tableColumn2 = this.table.getColumn(AmpliAlsTableModel.columnNames[7]);
        this.table.removeColumn(tableColumn);
        this.table.removeColumn(tableColumn2);
        tableColumn = this.table.getColumn(AmpliAlsTableModel.columnNames[1]);
        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxForOSRICommand()));
        tableColumn.setPreferredWidth(70);
        tableColumn = this.table.getColumn(AmpliAlsTableModel.columnNames[2]);
        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxForALSCommand()));
        tableColumn.setPreferredWidth(200);
        tableColumn = this.table.getColumn(AmpliAlsTableModel.columnNames[3]);
        tableColumn.setPreferredWidth(250);
        tableColumn = this.table.getColumn(AmpliAlsTableModel.columnNames[4]);
        tableColumn.setPreferredWidth(250);
        tableColumn = this.table.getColumn(AmpliAlsTableModel.columnNames[5]);
        tableColumn.setPreferredWidth(250);
        tableColumn = this.table.getColumn(AmpliAlsTableModel.columnNames[6]);
        tableColumn.setPreferredWidth(250);
        this.table.setAutoResizeMode(0);
    }

    protected void init() throws Exception {
        int n = this.model.getALSInterfaces().length;
        if (n > 0) {
            this.lineModels = new AbstractOpticsLineModel[n];
            for (int i = 0; i < n; ++i) {
                this.lineModels[i] = this.model.getALSInterfaces()[i];
            }
        }
        this.registerWithModel();
        this.initAlsPane();
        this.notInited = false;
    }

    @Override
    protected void registerWithModel() {
        if (this.model != null) {
            this.model.addObserver((Observer)((Object)this));
        }
        if (this.lineModels != null) {
            for (int i = 0; i < this.lineModels.length; ++i) {
                this.lineModels[i].addObserver((Observer)((Object)this));
            }
        }
    }

    protected JComboBox getComboBoxForALSCommand() {
        JComboBox<String> jComboBox = new JComboBox<String>(this.dataModel.getALSCommandStrings());
        jComboBox.setEditable(false);
        return jComboBox;
    }

    protected JComboBox getComboBoxForOSRICommand() {
        JComboBox<String> jComboBox = new JComboBox<String>(this.dataModel.getOSRICommandStrings());
        jComboBox.setEditable(false);
        return jComboBox;
    }

    @Override
    public void dispose() {
        if (this.lineModels != null) {
            for (int i = 0; i < this.lineModels.length; ++i) {
                this.lineModels[i].deleteObserver((Observer)((Object)this));
            }
        }
        if (this.model != null) {
            this.model.deleteObserver((Observer)((Object)this));
        }
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
        }
    }

    @Override
    public void leavingPage() {
        this.apply();
    }

    @Override
    public void enteringPage() throws Exception {
        if (this.notInited) {
            this.init();
        }
    }

    public void refreshFromModel() throws Exception {
        this.dataModel.refreshFromReset();
    }

    @Override
    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty(true);
        } else {
            this.setDirty(false);
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            this.updateAlsPane();
            if (this.dataModel != null) {
                this.dataModel.fireTableDataChanged();
                this.requestRefresh(observable, this.getRefreshThread(observable));
            }
        }
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            @Override
            public void run() {
                PsmAlsPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        try {
            if (this.dataModel != null) {
                this.dataModel.refreshLineFromModel(0);
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_REFRESH_ROW_PARAM_1, (Object)"1");
        }
    }

    public void applyChangesToModel() throws Exception {
        this.dataModel.applyToModel();
        this.setDirty(false);
    }

    protected AmpliAlsTableModel getDataModel() {
        return new AmpliAlsTableModel(this.model, this.lineModels);
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.PsmAlsPane;
    }

    @Override
    public void refresh() {
    }

    private JPanel getButtonPanel() {
        Dimension dimension = new Dimension(75, 25);
        this.applyButton = new JButton(APPLY);
        this.applyButton.setEnabled(false);
        this.applyButton.setMinimumSize(dimension);
        this.applyButton.setMaximumSize(dimension);
        this.applyButton.addActionListener(this);
        this.resetButton = new JButton(RESET);
        this.resetButton.setMinimumSize(dimension);
        this.resetButton.setMaximumSize(dimension);
        this.resetButton.addActionListener(this);
        JPanel jPanel = PsmAlsPane.createVerticalPanel(null);
        jPanel.add(this.applyButton);
        jPanel.add(Box.createVerticalStrut(this.applyButton.getPreferredSize().height / 3));
        jPanel.add(this.resetButton);
        this.helpButton = new CSHelpButton();
        this.helpButton.setMinimumSize(dimension);
        this.helpButton.setMaximumSize(dimension);
        this.helpButton.addActionListener(this);
        jPanel.add(Box.createVerticalStrut(this.applyButton.getPreferredSize().height / 3));
        jPanel.add(this.helpButton);
        return jPanel;
    }

    public final void setDirty(boolean bl) {
        if (db.on()) {
            db.println("setDirty: " + this.getName() + ": " + this.isDirty + " -> " + bl);
        }
        this.isDirty = bl;
        if (this.applyButton != null) {
            this.applyButton.setEnabled(this.isDirty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void apply() {
        try {
            if (this.isDirty) {
                this.setCursor(3);
                this.stopTableCellEditing();
                this.applyChangesToModel();
                this.setDirty(false);
            }
            EventBus.instance().notifyEvent((Object)this.getFullName(), (Object)APPLY);
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (db.on()) {
                db.println("caught " + (Object)((Object)abstractCmsIOException) + " in Pane.apply");
            }
        }
        catch (EMCProvisionError eMCProvisionError) {
            if (db.on()) {
                db.println("caught " + (Object)((Object)eMCProvisionError) + " in Pane.apply");
            }
            ErrorMsg.displayError((Component)((Object)this), (EID)eMCProvisionError.getEID(), (Object)eMCProvisionError.getEIDMsg());
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_CHANGES, exception.getMessage());
        }
        finally {
            this.setCursor(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        try {
            if (object == this.resetButton) {
                this.dataModel.refreshFromModel();
            } else if (object == this.applyButton) {
                this.apply();
            } else if (object == this.helpButton) {
                this.helpButton.launchHelp(this.getHelpID());
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        finally {
            this.uiToolkit.setCursor(0);
        }
    }

    protected AbstractLeavePageException createLeavePageException(String string) {
        if (db.on()) {
            db.println("createLeavePageException");
        }
        return new LeavePageException(string);
    }
}

