/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.AdminState;
import cerent.cms.model.IEntityModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.EntityComparator;
import cerent.cms.ui.WizardPane;
import cerent.cms.ui.shelf.AbstractTermCreationDialog;
import cerent.util.TDMTerminology;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ListSelectionListener;

public abstract class AbstractTermCreationPane
extends WizardPane
implements ActionListener,
ListSelectionListener {
    private AbstractTermCreationDialog parent;
    protected JList termList;
    protected DefaultListModel termListModel;
    protected JCheckBox donotAdvertiseOspfButton;
    protected JCheckBox farEndForeign;
    protected JRadioButton asIs;
    protected JRadioButton toIS;
    protected JRadioButton OOStoAINS;
    protected JRadioButton OOStoMT;
    protected ButtonGroup adminStateGroup;
    protected JLabel layer2Protocol;
    protected JCheckBox osiCB;
    protected JCheckBox ipCB;
    protected JComboBox gccRateComboBox;
    JPanel termPane;
    protected boolean isSelectionEmpty = true;

    protected AbstractTermCreationPane(String string, AbstractTermCreationDialog abstractTermCreationDialog) {
        this(string, abstractTermCreationDialog, true);
    }

    protected AbstractTermCreationPane(String string, AbstractTermCreationDialog abstractTermCreationDialog, boolean bl) {
        super(string, abstractTermCreationDialog);
        this.parent = abstractTermCreationDialog;
        this.setLayout(new BorderLayout());
        this.add(this.getListPanel(), "Center");
        this.add(this.getButtonPanel(bl), "South");
    }

    protected JComponent getListPanel() {
        this.termListModel = new DefaultListModel();
        IEntityModel[] iEntityModelArray = this.parent.connTable.getTermCandidates();
        Arrays.sort(iEntityModelArray, new EntityComparator());
        this.termListModel.setSize(iEntityModelArray.length);
        for (int i = 0; i < iEntityModelArray.length; ++i) {
            this.termListModel.setElementAt(iEntityModelArray[i], i);
        }
        this.termList = new JList(this.termListModel);
        if (this.parent.connTable.getNodeModelDelegate().isMultishelf()) {
            this.termList.setCellRenderer(new EntityCellRenderer("shelf "));
        } else {
            this.termList.setCellRenderer(new EntityCellRenderer("slot "));
        }
        this.termList.setVisibleRowCount(10);
        this.termList.addListSelectionListener(this);
        this.termList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && AbstractTermCreationPane.this.termList.getSelectedValue() != null) {
                    AbstractTermCreationPane.this.apply();
                }
            }
        });
        return new UScrollPane((Component)this.termList);
    }

    protected JPanel getButtonPanel(boolean bl) {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.termPane = new JPanel(new BorderLayout());
        JPanel jPanel2 = null;
        if (bl) {
            jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        }
        JPanel jPanel3 = new JPanel(new GridLayout(0, 2));
        JPanel jPanel4 = new JPanel(new FlowLayout(0, 5, 5));
        JPanel jPanel5 = new JPanel(new FlowLayout(0, 5, 5));
        JPanel jPanel6 = new JPanel();
        TDMTerminology tDMTerminology = this.parent.connTable.getNodeModelDelegate().getTDMTerminology();
        String string = AdminState.getAdminTermIS(tDMTerminology);
        String string2 = AdminState.getAdminTermDSBLD(tDMTerminology);
        String string3 = AdminState.getAdminTermAINS(tDMTerminology);
        String string4 = AdminState.getAdminTermMT(tDMTerminology);
        this.asIs = new JRadioButton("Leave unchanged", true);
        this.toIS = new JRadioButton("Set to " + string);
        this.OOStoAINS = new JRadioButton("Set " + string2 + " to " + string3);
        this.OOStoMT = new JRadioButton("Set " + string2 + " to " + string4);
        this.asIs.setEnabled(false);
        this.toIS.setEnabled(false);
        this.OOStoAINS.setEnabled(false);
        this.OOStoMT.setEnabled(false);
        this.adminStateGroup = new ButtonGroup();
        this.adminStateGroup.add(this.asIs);
        this.adminStateGroup.add(this.toIS);
        this.adminStateGroup.add(this.OOStoAINS);
        this.adminStateGroup.add(this.OOStoMT);
        jPanel6.setLayout(new GridLayout(2, 0));
        jPanel6.add(this.asIs);
        jPanel6.add(this.toIS);
        jPanel6.add(this.OOStoAINS);
        jPanel6.add(this.OOStoMT);
        jPanel6.setBorder(BorderFactory.createTitledBorder("Port Admin State"));
        if (bl) {
            jPanel2.setBorder(BorderFactory.createTitledBorder(this.parent.terminationType));
            this.termPane.add((Component)jPanel2, "Center");
            this.donotAdvertiseOspfButton = new JCheckBox("Disable OSPF on Link");
            this.donotAdvertiseOspfButton.setEnabled(false);
            jPanel2.add(this.donotAdvertiseOspfButton);
            this.farEndForeign = new JCheckBox("Far End is Foreign");
            this.farEndForeign.setEnabled(false);
            jPanel2.add(this.farEndForeign);
        }
        this.termPane.add((Component)jPanel3, "South");
        this.osiCB = new JCheckBox("OSI");
        this.osiCB.addActionListener(this);
        this.osiCB.setSelected(false);
        this.osiCB.setEnabled(false);
        this.ipCB = new JCheckBox("IP");
        this.ipCB.addActionListener(this);
        this.ipCB.setSelected(true);
        this.ipCB.setEnabled(false);
        jPanel5.add(this.osiCB);
        jPanel5.add(this.ipCB);
        jPanel5.setBorder(BorderFactory.createTitledBorder("Layer 3"));
        this.layer2Protocol = new JLabel("PPP");
        this.layer2Protocol.setEnabled(false);
        jPanel4.setBorder(BorderFactory.createTitledBorder("Layer 2"));
        jPanel4.add(this.layer2Protocol);
        jPanel3.add(jPanel5);
        jPanel3.add(jPanel4);
        jPanel.add((Component)jPanel6, "North");
        jPanel.add((Component)this.termPane, "Center");
        return jPanel;
    }

    @Override
    public void refresh() {
        this.parent.setBackEnabled(false);
        this.parent.setCancelEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.ipCB) {
            if (this.ipCB.isSelected()) {
                this.parent.removeLapdPage();
                if (!this.osiCB.isSelected()) {
                    this.parent.removeSubnetPage();
                }
                this.layer2Protocol.setText("PPP");
            } else {
                this.osiCB.setSelected(true);
                this.parent.addSubnetPage();
                this.parent.addLapdPage();
                this.layer2Protocol.setText("LAPD");
            }
        } else if (object == this.osiCB) {
            if (!this.osiCB.isSelected()) {
                this.ipCB.setSelected(true);
                this.parent.removeSubnetPage();
                this.parent.removeLapdPage();
                this.layer2Protocol.setText("PPP");
            } else {
                this.parent.addSubnetPage();
            }
        }
        if (this.donotAdvertiseOspfButton != null) {
            this.donotAdvertiseOspfButton.setEnabled(!this.isSelectionEmpty && this.ipCB.isSelected());
            this.donotAdvertiseOspfButton.setSelected(!this.donotAdvertiseOspfButton.isEnabled());
        }
        if (this.farEndForeign != null) {
            this.farEndForeign.setEnabled(!this.isSelectionEmpty && this.ipCB.isSelected());
        }
        this.parent.setNextEnabled(!this.isSelectionEmpty && this.parent.hasSubnetPage());
        this.parent.setFinishEnabled(!this.isSelectionEmpty && !this.parent.hasSubnetPage());
    }

    @Override
    public void validatePage() throws Exception {
    }

    @Override
    public void enteringPage() {
        int n = this.parent.connTable.getNodeModelDelegate().isSdh() ? 300 : 0;
        this.parent.setSize(new Dimension(this.parent.WIDTH + n, this.parent.HEIGHT));
        this.parent.validate();
    }

    @Override
    public void dispose() {
        ((DefaultListModel)this.termList.getModel()).removeAllElements();
        super.dispose();
    }

    protected void apply() {
        Object[] objectArray = this.termList.getSelectedValues();
        int n = -1;
        if (!this.asIs.isSelected()) {
            if (this.toIS.isSelected()) {
                n = 0;
            } else if (this.OOStoAINS.isSelected()) {
                n = 3;
            } else if (this.OOStoMT.isSelected()) {
                n = 2;
            }
        }
        this.parent.createTerms(objectArray, n);
        this.dispose();
        this.parent.dispose();
    }
}

