/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.OpticsTopology.sOpticalPatchCord;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.Feature;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OpticalPortType;
import cerent.cms.model.OpticsAmplifiedLineModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.WrongPortType;
import cerent.cms.ui.AbstractCardViewPanel;
import cerent.cms.ui.DwdmSide;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.ViewName;
import cerent.cms.ui.shelf.CardView;
import cerent.cms.ui.shelf.GenericPortGraphic;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class DwdmGenericPortGraphic
extends GenericPortGraphic
implements ActionListener {
    protected AbstractCardViewPanel cardViewPanel;
    protected ViewName[] target;
    private int shelf;
    private int slot;
    protected EntityModel[] fromModel;
    protected String[] menuLabel;
    EntityCellRenderer ecr = new EntityCellRenderer();
    private static String UNCONNECTED = "Unconnected";
    private static String SIDE_PORT = "Side Port";
    private static final SDebug db = new SDebug("DwdmGenericPortGraphic");

    public DwdmGenericPortGraphic(CardView cardView, EntityModel entityModel, int n, boolean bl) {
        super(cardView, entityModel, n, bl);
        this.addMouseListener(new PortMouseAdapter());
    }

    public DwdmGenericPortGraphic(CardView cardView, EntityModel entityModel, int n, boolean bl, AbstractCardViewPanel abstractCardViewPanel) {
        this(cardView, entityModel, n, bl);
        this.cardViewPanel = abstractCardViewPanel;
    }

    protected void createTarget(int n) {
        if (this.model.getNodeModel().provides(Feature.MULTISHELF) && this.model.getNodeModel().isMultishelf()) {
            this.shelf = this.fromModel[n].getParent().getShelfId();
        }
        this.slot = this.fromModel[n].getParent().getSlot();
        this.target[n] = new ViewName(new int[]{this.model.getNodeModel().getNodeId(), this.shelf, this.slot});
    }

    private void createLabelMenu(int n) {
        this.menuLabel[n] = this.fromModel[n].getModuleModel().getEqType() == 330 ? this.ecr.getFullPortString(this.fromModel[n], false) : this.ecr.getFullPortString(this.fromModel[n], false) + ",Side " + DwdmSide.getSideLabelFromOffset(this.fromModel[n].getSide());
    }

    protected void initMenu(EntityModel entityModel, IEntityModel iEntityModel) {
        this.fromModel = (EntityModel[])this.findLinkedPort();
        if (this.fromModel != null) {
            this.menuLabel = new String[this.fromModel.length];
            this.target = new ViewName[this.fromModel.length];
            for (int i = 0; i < this.fromModel.length; ++i) {
                this.createTarget(i);
                this.createLabelMenu(i);
            }
        }
    }

    protected IEntityModel[] findLinkedPort() {
        List<IPortModel> list;
        if (this.model.getModuleModel().getEqType() == 330) {
            Object var4_1 = null;
            int n = 0;
            ArrayList<IPortModel> arrayList = new ArrayList<IPortModel>();
            try {
                int n2 = this.model.getEntityIndex();
                sOpticalPatchCord[] sOpticalPatchCordArray = ((ModuleModel)this.model.getModuleModel()).getDWDMPatchCords();
                for (int i = 0; i < sOpticalPatchCordArray.length; ++i) {
                    boolean bl = false;
                    n = 0;
                    if (sOpticalPatchCordArray[i].to == n2) {
                        bl = true;
                        n = sOpticalPatchCordArray[i].from;
                    } else if (sOpticalPatchCordArray[i].from == n2) {
                        bl = true;
                        n = sOpticalPatchCordArray[i].to;
                    }
                    try {
                        if (!bl) continue;
                        arrayList.add((IPortModel)this.model.getNodeModelDelegate().getEntityTableModel().getEntityModelByIndex(n));
                        continue;
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                }
            }
            catch (FeatureUnsupported featureUnsupported) {
                SDebug.printStackTrace((Throwable)featureUnsupported);
                return new EntityModel[0];
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
                return new EntityModel[0];
            }
            list = arrayList;
        } else {
            try {
                OpticalPortType opticalPortType = ((OpticsPortModel)this.model).getOptPortType();
                boolean bl = ((OpticsPortModel)this.model).isOptPortTypeRX();
                if (opticalPortType == OpticalPortType.IN_LINE || opticalPortType == OpticalPortType.OUT_LINE) {
                    list = bl ? ((OpticsPortModel)this.model).getPrevLogicalPorts() : ((OpticsPortModel)this.model).getNextLogicalPorts();
                    if (list.size() == 0 || list.get(0) == this.model) {
                        return new EntityModel[0];
                    }
                } else if (opticalPortType == OpticalPortType.IN_OSC || opticalPortType == OpticalPortType.OUT_OSC) {
                    sOpticalPatchCord[] sOpticalPatchCordArray = ((OpticsModuleModel)((OpticsPortModel)this.model).getParent()).getDWDMPatchCords();
                    int n = this.model.getIndex();
                    ArrayList<IPortModel> arrayList = new ArrayList<IPortModel>();
                    for (int i = 0; i < sOpticalPatchCordArray.length; ++i) {
                        boolean bl2 = false;
                        int n3 = 0;
                        if (bl) {
                            if (sOpticalPatchCordArray[i].to == n) {
                                bl2 = true;
                                n3 = sOpticalPatchCordArray[i].from;
                            }
                        } else if (sOpticalPatchCordArray[i].from == n) {
                            bl2 = true;
                            n3 = sOpticalPatchCordArray[i].to;
                        }
                        if (!bl2) continue;
                        arrayList.add((IPortModel)this.model.getNodeModelDelegate().getEntityTableModel().getEntityModelByIndex(n3));
                    }
                    list = arrayList;
                } else {
                    list = bl ? ((OpticsPortModel)this.model).getPrevLogicalPorts() : ((OpticsPortModel)this.model).getNextLogicalPorts();
                }
            }
            catch (NoSuchEquipment noSuchEquipment) {
                return new EntityModel[0];
            }
            catch (WrongPortType wrongPortType) {
                return new EntityModel[0];
            }
            catch (NumberFormatException numberFormatException) {
                return new EntityModel[0];
            }
            catch (FeatureUnsupported featureUnsupported) {
                return new EntityModel[0];
            }
            catch (NoSuchInterface noSuchInterface) {
                return new EntityModel[0];
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                return new EntityModel[0];
            }
        }
        return list.toArray(new EntityModel[0]);
    }

    private void createAndShowMenu(Point point) {
        JPopupMenu jPopupMenu = null;
        String string = UNCONNECTED;
        if (this.menuLabel.length == 0) {
            Object object;
            if (this.ifModel instanceof AbstractOpticsLineModel || this.ifModel instanceof OpticsAmplifiedLineModel) {
                try {
                    object = ((AbstractOpticsLineModel)this.ifModel).getOptPortType();
                    if (object == OpticalPortType.IN_LINE || object == OpticalPortType.OUT_LINE) {
                        if (!((OpticsModuleModel)this.ifModel.getModuleModel()).isAmplitWithPreRole()) {
                            string = SIDE_PORT;
                        }
                    } else if (((AbstractOpticsLineModel)this.ifModel).getPortModel().getParent().getEqType() == 128 && (object == OpticalPortType.IN_OSC || object == OpticalPortType.OUT_OSC)) {
                        return;
                    }
                }
                catch (Exception exception) {
                    if (db.on()) {
                        db.println("Error while retrieving port type: " + exception);
                    }
                    KDebug.printStackTrace((Throwable)exception);
                    return;
                }
            }
            object = new JMenuItem(string);
            ((JMenuItem)object).setEnabled(false);
            jPopupMenu = new JPopupMenu();
            jPopupMenu.add((JMenuItem)object);
        } else {
            jPopupMenu = new JPopupMenu();
            for (int i = 0; i < this.menuLabel.length; ++i) {
                GenericMenuAttribute<String, ViewName> genericMenuAttribute = new GenericMenuAttribute<String, ViewName>(this.menuLabel[i], this.target[i]);
                GenericMenuItem genericMenuItem = new GenericMenuItem(new IGenericMenuBehaviour(){

                    @Override
                    public void doAction(GenericMenuAttribute genericMenuAttribute) {
                        DwdmGenericPortGraphic.this.cardViewPanel.tryJumpView((ViewName)genericMenuAttribute.getTarget());
                    }
                }, genericMenuAttribute);
                jPopupMenu.add(genericMenuItem);
                genericMenuItem.addActionListener(this);
            }
        }
        jPopupMenu.show(this, point.x, point.y);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof GenericMenuItem) {
            GenericMenuItem genericMenuItem = (GenericMenuItem)object;
            genericMenuItem.doAction();
        }
    }

    public void addCardViewPane(AbstractCardViewPanel abstractCardViewPanel) {
        this.cardViewPanel = abstractCardViewPanel;
    }

    protected class GenericMenuAttribute<V, T> {
        private V key;
        private T target;

        public GenericMenuAttribute(V v, T t) {
            this.key = v;
            this.target = t;
        }

        public V getKey() {
            return this.key;
        }

        public T getTarget() {
            return this.target;
        }
    }

    protected class GenericMenuItem
    extends JMenuItem {
        private IGenericMenuBehaviour action;
        private GenericMenuAttribute<String, Object> actionParam;

        GenericMenuItem(IGenericMenuBehaviour iGenericMenuBehaviour, GenericMenuAttribute<String, Object> genericMenuAttribute) {
            super(genericMenuAttribute.getKey());
            this.action = iGenericMenuBehaviour;
            this.actionParam = genericMenuAttribute;
        }

        public void doAction() {
            this.action.doAction(this.actionParam);
        }
    }

    protected static interface IGenericMenuBehaviour {
        public void doAction(GenericMenuAttribute var1);
    }

    protected class PortMouseAdapter
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getModifiers() == 4) {
                DwdmGenericPortGraphic.this.initMenu(DwdmGenericPortGraphic.this.model, DwdmGenericPortGraphic.this.model.getParent());
                DwdmGenericPortGraphic.this.createAndShowMenu(mouseEvent.getPoint());
            }
        }
    }
}

