/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Common.sIpAddr;
import cerent.cms.idl.Common.sIpFtpHost;
import cerent.cms.idl.Common.sIpSubnet;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.ui.Pane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import cerent.util.gui.SpinPropertyEditor;
import cerent.util.gui.UDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class FtpHostsDialog
extends UDialog {
    private static final SDebug db = new SDebug("FtpHostsDialog");
    public static final String TITLE = "Add FTP Host";
    private JButton okButton;
    private JButton cancelButton;
    private Pane parent;
    FtpHostAddPane createPane;
    private boolean ok = false;

    public static FtpHostsDialog instance(Pane pane) {
        Frame frame = JOptionPane.getFrameForComponent((Component)pane);
        return new FtpHostsDialog(frame, TITLE, pane);
    }

    private FtpHostsDialog(Frame frame, String string, Object object) {
        super(frame, string, true, object);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        this.ok = false;
        this.parent = (Pane)object;
        jPanel.add((Component)this.getCreatePanel(), "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
    }

    public void dispose() {
        this.parent = null;
        super.dispose();
    }

    private void doOk() {
        if (this.apply()) {
            this.ok = true;
            this.dispose();
        }
    }

    private void doCancel() {
        this.dispose();
    }

    protected boolean apply() {
        return this.validateFields();
    }

    public boolean ok() {
        return this.ok;
    }

    private sIpAddr getIpAddr(String string) {
        return IpAddrFactory.getIpAddr(InetUtil.makeIpAddr(string));
    }

    private sIpSubnet getSourceSubnet() {
        return new sIpSubnet(this.getIpAddr(this.createPane.getSourceAddress()), this.getIpAddr(this.createPane.getSourceMask()));
    }

    public sIpFtpHost getFtpHost() {
        return new sIpFtpHost(this.getSourceSubnet(), this.createPane.getRelayEnable(), this.createPane.getRelayTimer());
    }

    private JPanel getCreatePanel() {
        this.createPane = new FtpHostAddPane();
        return this.createPane;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FtpHostsDialog.this.doOk();
            }
        });
        jPanel.add(this.okButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FtpHostsDialog.this.doCancel();
            }
        });
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private String exceptionMessage(NumberFormatException numberFormatException) {
        String string = numberFormatException.getMessage();
        int n = string.indexOf(58);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        if (Character.isUpperCase(string.charAt(0))) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Character.toLowerCase(string.charAt(0)));
            stringBuffer.append(string.substring(1));
            string = stringBuffer.toString();
        }
        return string;
    }

    private boolean validateFields() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.createPane.getSourceAddress();
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            if (inetAddress.equals(InetAddress.getByName("0:0:0:0:0:0:0:0"))) {
                throw new UnknownHostException();
            }
            InetUtil.parseDottedString(string);
            if (!this.parent.getUiModel().getNodeModel().getIpConfig().getNodeMode() && inetAddress.getAddress().length > 4) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_IPV6_ADDRESS_NOT_ALLOWED, (Object)"FTP Host Address");
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            stringBuffer.append("The value specified for the FTP Host Address is not a valid IP address.");
        }
        catch (UnknownHostException unknownHostException) {
            stringBuffer.append("The value specified for the FTP Host Address is not a valid IP address.");
        }
        int n = -1;
        try {
            n = this.createPane.getRelayTimer();
        }
        catch (NumberFormatException numberFormatException) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append('\n');
            }
            stringBuffer.append("Relay timer accepts only numeric values.");
        }
        if (n > 60 || n < 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append('\n');
            }
            stringBuffer.append("The valid value for FTP Relay Timer is from 0 to 60.");
        }
        try {
            InetUtil.parseDottedString(this.createPane.getSourceMask());
        }
        catch (NumberFormatException numberFormatException) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append('\n');
            }
            stringBuffer.append("The value specified for FTP Host Mask is not valid.");
        }
        if (stringBuffer.length() > 0) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_CANNOT_VALIDATE_DATA_PARAM_1, (Object)stringBuffer.toString());
        }
        return stringBuffer.length() == 0;
    }

    private static class FtpHostAddPane
    extends JPanel {
        private JTextField srcAddress;
        private JTextField srcMask;
        private SpinPropertyEditor srcLength;
        private JCheckBox relayEnable;
        private JTextField relayTimer;
        private String v4v6Mask;

        FtpHostAddPane() {
            BoxLayout boxLayout = new BoxLayout(this, 1);
            this.setLayout(boxLayout);
            Dimension dimension = new Dimension(140, 22);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(0, 5, 5));
            JLabel jLabel = new JLabel("FTP Host Address:");
            jLabel.setPreferredSize(dimension);
            jPanel.add(jLabel);
            this.srcAddress = new JTextField(35);
            jPanel.add(this.srcAddress);
            this.srcLength = new SpinPropertyEditor("Length: ", 1, 0, 128);
            jPanel.add(this.srcLength);
            jPanel.add(new JLabel("  Mask:"));
            this.srcMask = new JTextField(16);
            jPanel.add(this.srcMask);
            this.add(jPanel);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout(0, 5, 5));
            JLabel jLabel2 = new JLabel("FTP Relay Timer:");
            jLabel2.setPreferredSize(dimension);
            jPanel2.add(jLabel2);
            jLabel.setPreferredSize(dimension);
            this.relayTimer = new JTextField(4);
            jPanel2.add(this.relayTimer);
            this.relayTimer.setText("0");
            this.relayTimer.setEditable(false);
            this.relayEnable = new JCheckBox("Enable FTP Relay ");
            jPanel2.add(this.relayEnable);
            this.add(jPanel2);
            this.relayEnable.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (FtpHostAddPane.this.relayEnable.isSelected()) {
                        FtpHostAddPane.this.relayTimer.setEditable(true);
                    } else {
                        FtpHostAddPane.this.relayTimer.setText("0");
                        FtpHostAddPane.this.relayTimer.setEditable(false);
                    }
                }
            });
            this.srcMask.setEditable(false);
            this.srcMask.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.srcLength.setValue("24");
        }

        String getSourceAddress() {
            return this.srcAddress.getText();
        }

        String getSourceMask() {
            try {
                byte[] byArray = InetAddress.getByName(this.getSourceAddress()).getAddress();
                if (byArray.length == 16) {
                    int n;
                    int n2 = Integer.parseInt((String)this.srcLength.getValue());
                    byte[] byArray2 = new byte[16];
                    int n3 = -128;
                    int n4 = n2 / 8;
                    int n5 = n2 % 8;
                    for (n = 0; n < n4; ++n) {
                        byArray2[n] = -1;
                    }
                    if (n < 16) {
                        byArray2[n] = 0;
                        for (int i = 0; i < n5; ++i) {
                            byArray2[n] = (byte)(byArray2[n] | n3);
                            n3 = (byte)(n3 >> 1);
                        }
                    }
                    this.v4v6Mask = InetUtil.toHexString(byArray2);
                } else {
                    this.v4v6Mask = this.getLength(this.srcLength);
                }
            }
            catch (UnknownHostException unknownHostException) {
                db.finer("getSourceMask() failed: " + unknownHostException);
            }
            return this.v4v6Mask;
        }

        Boolean getRelayEnable() {
            return this.relayEnable.isSelected();
        }

        int getRelayTimer() {
            return Integer.parseInt(this.relayTimer.getText());
        }

        private String getLength(SpinPropertyEditor spinPropertyEditor) {
            int n = Integer.parseInt((String)spinPropertyEditor.getValue());
            return InetUtil.makeDottedString(InetUtil.makeNetMask(n));
        }
    }
}

