/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.ChassisModelUpdate;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.OpticsOchTermModel;
import cerent.cms.model.SlotModel;
import cerent.cms.model.TNCModuleModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.RoDataSourceControl;
import cerent.cms.ui.shelf.MaintViewAllFacilitiesPane;
import cerent.cms.ui.shelf.MaintViewCachedFacility;
import cerent.util.BlockingModeController;
import cerent.util.IObservableManager;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class MaintViewAllFacilitiesDataSource
extends AbstractRowDataSource
implements Observer,
BlockingModeController,
RoDataSourceControl,
Runnable {
    private NodeModelDelegate topModel = null;
    private ObservableManager obsMgr;
    private static final SDebug db = new SDebug("MaintViewAllFacilitiesDataSource");
    private ArrayList<MaintViewCachedFacility> surfaceList = new ArrayList();
    private long latestRunningThreadTs = -1L;
    private MaintViewAllFacilitiesPane maintPane;
    private static final int NEEDS_REFRESH = 1;
    private static final int NEEDS_RESET = 2;

    public MaintViewAllFacilitiesDataSource(MaintViewAllFacilitiesPane maintViewAllFacilitiesPane, NodeModelDelegate nodeModelDelegate) {
        this.topModel = nodeModelDelegate;
        this.maintPane = maintViewAllFacilitiesPane;
        this.obsMgr = new ObservableManager(this, true);
        this.obsMgr.setBlockingModeController(this);
    }

    private void observe(Observable observable) {
        this.obsMgr.addObservable(observable);
        if (db.isFinerEnabled()) {
            db.finer("Observing " + observable);
        }
        if ((observable instanceof AbstractDwdmLineModel || observable instanceof AbstractOpticsLineModel || observable instanceof TdmLineModel || observable instanceof EtherLineModel) && !this.facilityInSurfaceList((InterfaceModel)((Object)observable))) {
            this.addToSurfaceList((InterfaceModel)((Object)observable));
        }
    }

    private void deobserve(Observable observable) {
        this.obsMgr.removeObservable(observable);
        if (db.isFinerEnabled()) {
            db.finer("Deobserving " + observable);
        }
        if (observable instanceof InterfaceModel) {
            this.removeFromSurfaceList((InterfaceModel)((Object)observable));
        }
    }

    private void observeFromTheTop() {
        this.observe((Observable)((Object)this.topModel.getChassisModelsInstance()));
        if (db.isFineEnabled()) {
            db.fine("Observing the NMD chassisModels");
        }
        IEntityModel[] iEntityModelArray = this.topModel.getChassisModels();
        for (int i = 0; i < iEntityModelArray.length; ++i) {
            IEntityModel iEntityModel = iEntityModelArray[i];
            List list = iEntityModel.getDescendantsOfClassType(2);
            for (int j = 0; j < list.size(); ++j) {
                Object e = list.get(j);
                if (!(e instanceof SlotModel)) continue;
                this.observe((Observable)((Object)((SlotModel)e)));
                List list2 = ((SlotModel)e).getChildren();
                for (int k = 0; k < list2.size(); ++k) {
                    Object e2 = list2.get(k);
                    if (!(e2 instanceof ModuleModel)) continue;
                    this.maybeObserveModuleModel((ModuleModel)e2);
                }
            }
        }
    }

    private void maybeObserveModuleModel(ModuleModel moduleModel) {
        if (moduleModel instanceof DwdmModuleModel || moduleModel instanceof OpticsModuleModel || moduleModel instanceof TNCModuleModel) {
            this.observe((Observable)((Object)moduleModel));
            this.observeInterfacesModels(moduleModel);
        }
    }

    private void observeInterfacesModels(ModuleModel moduleModel) {
        InterfaceModel[] interfaceModelArray = moduleModel.getLineModels();
        for (int i = 0; i < interfaceModelArray.length; ++i) {
            if (db.isFinerEnabled()) {
                db.finer("line #" + i + "\t" + interfaceModelArray[i]);
            }
            if (!(interfaceModelArray[i] instanceof AbstractDwdmLineModel) && !(interfaceModelArray[i] instanceof AbstractOpticsLineModel) && (!(interfaceModelArray[i] instanceof TdmLineModel) && !(interfaceModelArray[i] instanceof EtherLineModel) || !(moduleModel instanceof TNCModuleModel))) continue;
            this.observe((Observable)((Object)interfaceModelArray[i]));
            if (!db.isFinerEnabled()) continue;
            db.finer("observing DWDM/Optics line: " + interfaceModelArray[i]);
        }
        this.insertOchAllocation(moduleModel);
    }

    @Override
    public void update(Observable observable, Object object) {
        if (db.isFineEnabled()) {
            db.fine("Update, ob=" + observable + ", arg= " + object);
        }
        if (object instanceof Integer) {
            if (((Integer)object).equals(ModelUpdateType.ADDED)) {
                if (db.isFinerEnabled()) {
                    db.finer("\tGot ADDED message from: " + observable);
                }
                if (observable instanceof SlotModel) {
                    if (db.isFinerEnabled()) {
                        db.finer("...a slotmodel");
                    }
                    List list = ((SlotModel)((Object)observable)).getChildren();
                    for (int i = 0; i < list.size(); ++i) {
                        Object e = list.get(i);
                        if (!(e instanceof ModuleModel)) continue;
                        this.maybeObserveModuleModel((ModuleModel)e);
                    }
                } else if (observable instanceof ModuleModel) {
                    List list = ((ModuleModel)((Object)observable)).getChildren();
                    for (int i = 0; i < list.size(); ++i) {
                        Object e = list.get(i);
                        if (!db.isFinerEnabled()) continue;
                        db.finer("MM kid= " + e);
                    }
                    this.observeInterfacesModels((ModuleModel)((Object)observable));
                }
                this.refreshFromModel();
            } else if (((Integer)object).equals(ModelUpdateType.DELETED)) {
                if (db.isFinerEnabled()) {
                    db.finer("\tGot DELETED object message: " + observable);
                }
                if (observable instanceof SlotModel) {
                    SlotModel slotModel = (SlotModel)((Object)observable);
                    this.deobserve((Observable)((Object)slotModel));
                    if (db.isFinerEnabled()) {
                        db.finer("no longer observing SLOT " + slotModel);
                    }
                } else if (observable instanceof ModuleModel) {
                    ModuleModel moduleModel = (ModuleModel)((Object)observable);
                    this.deobserve((Observable)((Object)moduleModel));
                    if (db.isFinerEnabled()) {
                        db.finer("no longer observing MOD " + moduleModel);
                    }
                    List list = moduleModel.getChildren();
                    for (int i = 0; i < list.size(); ++i) {
                        Object e = list.get(i);
                        if (!db.isFinerEnabled()) continue;
                        db.finer("kid #" + i + "\t" + e);
                    }
                } else if (observable instanceof InterfaceModel) {
                    this.deobserve((Observable)((Object)((InterfaceModel)((Object)observable))));
                    if (db.isFinerEnabled()) {
                        db.finer("no longer observing IF " + observable);
                    }
                }
                this.refreshFromModel();
            } else if (((Integer)object).equals(ModelUpdateType.CHANGED) && observable instanceof InterfaceModel) {
                if (db.isFinerEnabled()) {
                    db.finer("\tGot UPDATE on " + observable);
                }
                this.updateOneRow(observable);
            }
        } else if (object instanceof ChassisModelUpdate) {
            if (db.on()) {
                ChassisModelUpdate chassisModelUpdate = (ChassisModelUpdate)object;
                db.println("received a chassismodel update of type: " + chassisModelUpdate.getUpdateType() + " on " + chassisModelUpdate.getChassisModel());
            }
            this.refreshFromModel(2);
        }
    }

    public Object getObjectAtRow(int n) {
        return this.surfaceList.get(n);
    }

    public int getRowCount() {
        return this.surfaceList.size();
    }

    protected void addToSurfaceList(InterfaceModel interfaceModel) {
        this.surfaceList.add(new MaintViewCachedFacility(interfaceModel));
    }

    protected MaintViewCachedFacility getCachedFacility(InterfaceModel interfaceModel) {
        MaintViewCachedFacility maintViewCachedFacility = null;
        for (int i = 0; i < this.surfaceList.size(); ++i) {
            MaintViewCachedFacility maintViewCachedFacility2 = this.surfaceList.get(i);
            if (!maintViewCachedFacility2.ifModel.equals(interfaceModel)) continue;
            maintViewCachedFacility = maintViewCachedFacility2;
            break;
        }
        return maintViewCachedFacility;
    }

    protected boolean facilityInSurfaceList(InterfaceModel interfaceModel) {
        return this.getCachedFacility(interfaceModel) != null;
    }

    protected void removeFromSurfaceList(InterfaceModel interfaceModel) {
        MaintViewCachedFacility maintViewCachedFacility = this.getCachedFacility(interfaceModel);
        if (maintViewCachedFacility == null) {
            if (db.on()) {
                db.println("could not find " + interfaceModel + " to delete!");
            }
        } else {
            this.surfaceList.remove(maintViewCachedFacility);
        }
    }

    public void disposeDataSource() {
        this.deobserveEverything();
        if (this.obsMgr != null) {
            this.obsMgr.reset();
        }
    }

    private void deobserveEverything() {
        if (db.isFineEnabled()) {
            db.fine("deobserving everything.");
        }
        if (this.obsMgr != null) {
            this.obsMgr.setObservable(null);
        }
        if (this.surfaceList != null) {
            this.surfaceList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOneRow(Object object) {
        boolean bl = false;
        for (int i = 0; i < this.getRowCount(); ++i) {
            Object object2 = this.getObjectAtRow(i);
            if (!(object2 instanceof MaintViewCachedFacility)) continue;
            MaintViewCachedFacility maintViewCachedFacility = (MaintViewCachedFacility)object2;
            if (!object.equals(maintViewCachedFacility.ifModel)) continue;
            if (db.isFineEnabled()) {
                db.fine("updateOneRow: " + object + ", row: " + i);
            }
            try {
                this.maintPane.updateRefreshLabel(0);
                maintViewCachedFacility.updateCachedStrings();
                this.fireRowsUpdated(i, i);
                bl = true;
                break;
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                break;
            }
            finally {
                this.maintPane.updateRefreshLabel(100);
            }
        }
        if (!bl) {
            if (db.on()) {
                db.println("updateOneRow() forced to refreshFromModel(), no match for " + object + " found.");
            }
            this.refreshFromModel();
        }
    }

    public IObservableManager getObservableManager() {
        return this.obsMgr;
    }

    public void refreshFromModel(int n) {
        if (n == -1 || n == 2) {
            this.deobserveEverything();
            this.observeFromTheTop();
        }
        this.refreshFromModel();
    }

    public void refreshFromModel() {
        if (db.isFinerEnabled()) {
            db.finer("refreshFromModel()");
        }
        new Thread((Runnable)this, "FacilityRefresh").start();
    }

    public void liteRefresh() {
        this.maintPane.updateRefreshLabel(0);
        this.fireDataSourceChanged();
        this.maintPane.updateRefreshLabel(100);
    }

    private synchronized void setLatestRunningThreadTs(long l) {
        this.latestRunningThreadTs = l;
    }

    private synchronized long getLatestRunningThreadTs() {
        return this.latestRunningThreadTs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long l = new Date().getTime();
        this.setLatestRunningThreadTs(l);
        if (db.isFineEnabled()) {
            db.fine("setting latestThreadTS to: " + l);
        }
        try {
            int n;
            MaintViewCachedFacility maintViewCachedFacility;
            long l2;
            int n2;
            this.maintPane.updateRefreshLabel(0);
            ArrayList<MaintViewCachedFacility> arrayList = new ArrayList<MaintViewCachedFacility>();
            int n3 = this.surfaceList.size();
            int n4 = 0;
            for (n2 = 0; n2 < this.surfaceList.size(); ++n2) {
                l2 = this.getLatestRunningThreadTs();
                if (l != l2) {
                    if (db.isFineEnabled()) {
                        db.fine(l + " interrupted by " + l2 + "!");
                    }
                    return;
                }
                maintViewCachedFacility = this.surfaceList.get(n2);
                if (this.maintPane.isToggled(maintViewCachedFacility.ifModel)) {
                    maintViewCachedFacility.updateCachedStrings();
                    n = (int)((double)(++n4) / (double)n3 * 100.0);
                    this.maintPane.updateRefreshLabel(n);
                    if (!db.isFinerEnabled()) continue;
                    db.finer("Priority update of: " + maintViewCachedFacility.ifModel);
                    continue;
                }
                arrayList.add(maintViewCachedFacility);
            }
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                l2 = this.getLatestRunningThreadTs();
                if (l != l2) {
                    if (db.isFineEnabled()) {
                        db.fine(l + " interrupted by " + l2 + "!");
                    }
                    return;
                }
                maintViewCachedFacility = (MaintViewCachedFacility)arrayList.get(n2);
                maintViewCachedFacility.updateCachedStrings();
                n = (int)((double)(++n4) / (double)n3 * 100.0);
                this.maintPane.updateRefreshLabel(n);
            }
            this.fireDataSourceChanged();
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        finally {
            this.maintPane.updateRefreshLabel(100);
        }
    }

    public int processBlockedEvent(Observable observable, Object object, int n) {
        if (db.isFineEnabled()) {
            db.fine("Asked to processBlockedEvent");
        }
        if (object instanceof ChassisModelUpdate || object == ModelUpdateType.ADDED || object == ModelUpdateType.DELETED) {
            if (db.isFineEnabled()) {
                db.fine("Blocked: ADD or DEL, requires RESET");
            }
            return 2;
        }
        if (n == 0) {
            return 1;
        }
        return n;
    }

    private void insertOchAllocation(ModuleModel moduleModel) {
        if (db.isFineEnabled()) {
            db.fine("insertOchAllocation for " + moduleModel);
        }
        if (moduleModel instanceof OpticsModuleModel) {
            OpticsOchTermModel[] opticsOchTermModelArray = ((OpticsModuleModel)moduleModel).getOchTermWithIngressPort();
            for (int i = 0; i < opticsOchTermModelArray.length; ++i) {
                if (db.isFinerEnabled()) {
                    db.finer("kid #" + i + "\t" + opticsOchTermModelArray);
                }
                this.observe((Observable)((Object)opticsOchTermModelArray[i]));
                if (!db.isFinerEnabled()) continue;
                db.finer("observing DWDM/OCH Term: " + opticsOchTermModelArray);
            }
        }
    }
}

