/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.EntityModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.event.AlarmStatus;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.ui.AbstractCardViewPanel;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardView;
import cerent.cms.ui.shelf.DwdmGenericPortGraphic;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Arrays;
import java.util.List;
import java.util.Observable;
import javax.swing.JLabel;

public class OpticsCardView
extends CardView {
    protected static final SDebug db;
    protected JLabel[] labels;
    private static final String[] AD4_LABELS;
    private static final String[] AD4B_LABELS;
    private static final String[] AD2_LABELS;
    private static final String[] AD1_LABELS;
    private static final String[] MMU_LABELS;
    private static final String[] PSM_LABELS;
    private static final String[] AD1B_LABELS;
    private static final String[] OPT_PRE_LABELS;
    private static final String[] OPT_BST_LABELS;
    private static final String[] OPT_AMP_L_LABELS;
    private static final String[] OPT_AMP_17_C_LABELS;
    private static final String[] OPT_AMP_23_C_LABELS;
    private static final String[] OPT_AMP_C_LABELS;
    private static final String[] MD_4_LABELS;
    private static final String[] OPT_AMP_RAMAN_LABELS;
    private static final String[] SMR_LABELS;
    private static final String[] SMR2_LABELS;
    private static final String[] DCU_LABELS;
    private static JLabel[] AD4Labels;
    private static JLabel[] AD2Labels;
    private static JLabel[] AD1Labels;
    private static JLabel[] AD1BLabels;
    private static JLabel[] AD4BLabels;
    private static JLabel[] OPTPRELabels;
    private static JLabel[] OPTBSTLabels;
    private static JLabel[] OPTAMPLLabels;
    private static JLabel[] OPTAMP17CLabels;
    private static JLabel[] OPTAMP23CLabels;
    private static JLabel[] OPTAMPCLabels;
    private static JLabel[] MD4Labels;
    private static JLabel[] MMULabels;
    private static JLabel[] PSMLabels;
    private static JLabel[] RAMANLabels;
    private static JLabel[] DCULabels;
    private static JLabel[] SMRLabels;
    private static JLabel[] SMR2Labels;
    public static final int[] MMU_PORT_MODEL_ARRAY;
    public static final int[] AMP_C_L_PORT_MODEL_ARRAY;

    public OpticsCardView(ModuleModel moduleModel, AbstractCardViewPanel abstractCardViewPanel) {
        super(moduleModel, abstractCardViewPanel);
    }

    @Override
    protected List getPorts() {
        OpticsModuleModel opticsModuleModel = (OpticsModuleModel)this.model;
        return Arrays.asList(opticsModuleModel.getOpticsChildren());
    }

    @Override
    protected void addLabels() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = new Insets(2, 3, 2, 2);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = insets;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.add((Component)AbstractShelfLayout.formatLabel(new JLabel("RX", 2)), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.add((Component)AbstractShelfLayout.formatLabel(new JLabel("TX", 2)), gridBagConstraints);
        this.labels = this.getLabels(this.model.getEqType());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.insets = insets;
        gridBagConstraints2.fill = 2;
        for (int i = 0; i < this.labels.length; ++i) {
            this.add((Component)this.labels[i], gridBagConstraints2);
            ++gridBagConstraints2.gridy;
            if (this.model.getEqType() == 136) {
                this.labels = AD4Labels;
                continue;
            }
            if (this.model.getEqType() == 138) {
                this.labels = AD4BLabels;
                continue;
            }
            if (this.model.getEqType() == 135) {
                this.labels = AD2Labels;
                continue;
            }
            if (this.model.getEqType() == 134) {
                this.labels = AD1Labels;
                continue;
            }
            if (this.model.getEqType() == 137) {
                this.labels = AD1BLabels;
                continue;
            }
            if (this.model.getEqType() == 129) {
                this.labels = OPTPRELabels;
                continue;
            }
            if (this.model.getEqType() == 130 || this.model.getEqType() == 239) {
                this.labels = OPTBSTLabels;
                continue;
            }
            if (this.model.getEqType() == 240) {
                this.labels = OPTAMPLLabels;
                continue;
            }
            if (this.model.getEqType() == 196) {
                this.labels = OPTBSTLabels;
                continue;
            }
            if (this.model.getEqType() == 277) {
                this.labels = OPTAMP17CLabels;
                continue;
            }
            if (this.model.getEqType() == 278) {
                this.labels = OPTAMP23CLabels;
                continue;
            }
            if (this.model.getEqType() == 281) {
                this.labels = OPTAMPCLabels;
                continue;
            }
            if (this.model.getEqType() == 133) {
                this.labels = MD4Labels;
                continue;
            }
            if (this.model.getEqType() == 249) {
                this.labels = MMULabels;
                continue;
            }
            if (this.model.getEqType() == 286) {
                this.labels = PSMLabels;
                continue;
            }
            if (this.model.getEqType() == 287 || this.model.getEqType() == 321) {
                this.labels = RAMANLabels;
                continue;
            }
            if (this.model.getEqType() == 294 || this.model.getEqType() == 296) {
                this.labels = SMRLabels;
                continue;
            }
            if (this.model.getEqType() != 295) continue;
            this.labels = SMR2Labels;
        }
    }

    private JLabel[] getLabels(int n) {
        JLabel[] jLabelArray = null;
        switch (n) {
            case 136: {
                jLabelArray = AD4Labels;
                break;
            }
            case 138: {
                jLabelArray = AD4BLabels;
                break;
            }
            case 135: {
                jLabelArray = AD2Labels;
                break;
            }
            case 134: {
                jLabelArray = AD1Labels;
                break;
            }
            case 137: {
                jLabelArray = AD1BLabels;
                break;
            }
            case 129: {
                jLabelArray = OPTPRELabels;
                break;
            }
            case 130: 
            case 239: {
                jLabelArray = OPTBSTLabels;
                break;
            }
            case 240: {
                jLabelArray = OPTAMPLLabels;
                break;
            }
            case 196: {
                jLabelArray = OPTBSTLabels;
                break;
            }
            case 277: {
                jLabelArray = OPTAMP17CLabels;
                break;
            }
            case 278: {
                jLabelArray = OPTAMP23CLabels;
                break;
            }
            case 281: {
                jLabelArray = OPTAMPCLabels;
                break;
            }
            case 133: {
                jLabelArray = MD4Labels;
                break;
            }
            case 249: {
                jLabelArray = MMULabels;
                break;
            }
            case 286: {
                jLabelArray = PSMLabels;
                break;
            }
            case 287: 
            case 321: {
                jLabelArray = RAMANLabels;
                break;
            }
            case 298: 
            case 299: {
                jLabelArray = DCULabels;
                break;
            }
            case 294: 
            case 296: {
                jLabelArray = SMRLabels;
                break;
            }
            case 295: {
                jLabelArray = SMR2Labels;
            }
        }
        return jLabelArray;
    }

    public static int getPortGraphicIdx(int n, int n2) {
        int n3 = n2;
        if (n == 249) {
            n3 = MMU_PORT_MODEL_ARRAY[n2];
        }
        if (n == 281 || n == 240) {
            n3 = AMP_C_L_PORT_MODEL_ARRAY[n2];
        }
        return n3;
    }

    @Override
    protected void addPorts(boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = new Insets(2, 3, 2, 2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = insets;
        this.numPorts = this.ports.length;
        for (int i = 0; i < this.numPorts; ++i) {
            Object e = this.portModels.get(i);
            if (!(e instanceof OpticsPortModel)) continue;
            OpticsPortModel opticsPortModel = (OpticsPortModel)e;
            int n = opticsPortModel.getPort();
            int n2 = OpticsCardView.getPortGraphicIdx(this.model.getEqType(), n - 1);
            this.ports[n2] = new DwdmGenericPortGraphic((CardView)this, (EntityModel)opticsPortModel, n, opticsPortModel.isSpecial(), this.cardViewPanel);
            if (db.on()) {
                db.println("port position: " + n2 + ", port: " + this.ports[i].model.getPort() + ", model: " + this.ports[i].model.toString() + ", currentSeverity: " + this.ports[i].currentSeverity);
            }
            if (opticsPortModel.isOptPortTypeRX()) {
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = n2 + 1;
            } else {
                gridBagConstraints.gridy = n2;
                gridBagConstraints.gridx = 2;
            }
            this.add((Component)this.ports[n2], gridBagConstraints);
        }
        this.repaint();
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof AlarmStatus) {
            AlarmStatus alarmStatus = (AlarmStatus)object;
            this.setAlarmColor(alarmStatus.getHighestSeverity());
            for (int i = 0; i < this.numPorts; ++i) {
                Object e = this.portModels.get(i);
                if (!(e instanceof PortModel)) continue;
                PortModel portModel = (PortModel)e;
                IAlarmStatus iAlarmStatus = this.cardAlarmStore.getEntityAlarmStatus(portModel);
                if (iAlarmStatus != null && this.ports[OpticsCardView.getPortGraphicIdx(portModel.getModuleModel().getEqType(), portModel.getPort() - 1)] != null) {
                    this.ports[OpticsCardView.getPortGraphicIdx(portModel.getModuleModel().getEqType(), portModel.getPort() - 1)].setAlarmState(iAlarmStatus.getHighestSeverity());
                    if (!db.on()) continue;
                    db.println("Updated position " + i + " port: " + portModel.getPort() + ", eqType " + portModel.getEqType() + ", model: " + this.ports[portModel.getPort() - 1].getModel().toString());
                    continue;
                }
                if (!db.on()) continue;
                db.println("null portAlarmStatus for position " + (portModel.getPort() - 1) + ", eqType " + portModel.getEqType() + ", port " + portModel.getPort());
            }
        } else if (object.equals(ModelUpdateType.CHANGED)) {
            this.setAlarmColor(this.cardAlarmStore.getAlarmStatus().getHighestSeverity());
        }
    }

    static {
        int n;
        db = new SDebug("OpticsCardView");
        AD4_LABELS = new String[]{"", "CHAN:", "", "CHAN:", "", "CHAN:", "", "CHAN:", "", "EXP:", "", "COM:"};
        AD4B_LABELS = new String[]{"", "BAND:", "", "BAND:", "", "BAND:", "", "BAND:", "", "EXP:", "", "COM:"};
        AD2_LABELS = new String[]{"", "CHAN:", "", "CHAN:", "", "EXP:", "", "COM:"};
        AD1_LABELS = new String[]{"", "CHAN:", "", "EXP:", "", "COM:"};
        MMU_LABELS = new String[]{"", "EXP A:", "", "EXP:", "", "COM:"};
        PSM_LABELS = new String[]{"", "W:", "", "P:", "", "COM:"};
        AD1B_LABELS = new String[]{"", "BAND:", "", "EXP:", "", "COM:"};
        OPT_PRE_LABELS = new String[]{"", "COM:", "", "DC:"};
        OPT_BST_LABELS = new String[]{"", "COM:", "", "OSC:", "", "LINE:"};
        OPT_AMP_L_LABELS = new String[]{"", "COM:", "", "DC:", "", "OSC:", "", "LINE:"};
        OPT_AMP_17_C_LABELS = new String[]{"", "COM:", "", "OSC:", "", "LINE:"};
        OPT_AMP_23_C_LABELS = new String[]{"", "COM:", "", "OSC:", "", "LINE:"};
        OPT_AMP_C_LABELS = new String[]{"", "COM:", "", "DC:", "", "OSC:", "", "LINE:"};
        MD_4_LABELS = new String[]{"", "CHAN:", "", "CHAN:", "", "CHAN:", "", "CHAN:", "", "COM:"};
        OPT_AMP_RAMAN_LABELS = new String[]{"", "COM:", "", "OSC:", "", "LINE:", "", "DC:", "", "RAMAN:"};
        SMR_LABELS = new String[]{"", "EXP:", "", "DC:", "", "OSC:", "", "A/D:", "", "LINE:"};
        SMR2_LABELS = new String[]{"", "DC:", "", "OSC:", "", "A/D", "", "LINE:", "EXP:", "", "EXP:", "EXP:", "EXP:"};
        DCU_LABELS = new String[]{"", "DC:"};
        AD4Labels = new JLabel[AD4_LABELS.length];
        AD2Labels = new JLabel[AD2_LABELS.length];
        AD1Labels = new JLabel[AD1_LABELS.length];
        AD1BLabels = new JLabel[AD1B_LABELS.length];
        AD4BLabels = new JLabel[AD4B_LABELS.length];
        OPTPRELabels = new JLabel[OPT_PRE_LABELS.length];
        OPTBSTLabels = new JLabel[OPT_BST_LABELS.length];
        OPTAMPLLabels = new JLabel[OPT_AMP_L_LABELS.length];
        OPTAMP17CLabels = new JLabel[OPT_AMP_17_C_LABELS.length];
        OPTAMP23CLabels = new JLabel[OPT_AMP_23_C_LABELS.length];
        OPTAMPCLabels = new JLabel[OPT_AMP_C_LABELS.length];
        MD4Labels = new JLabel[MD_4_LABELS.length];
        MMULabels = new JLabel[MMU_LABELS.length];
        PSMLabels = new JLabel[PSM_LABELS.length];
        RAMANLabels = new JLabel[OPT_AMP_RAMAN_LABELS.length];
        DCULabels = new JLabel[DCU_LABELS.length];
        SMRLabels = new JLabel[SMR_LABELS.length];
        SMR2Labels = new JLabel[SMR2_LABELS.length];
        for (n = 0; n < SMR_LABELS.length; ++n) {
            OpticsCardView.SMRLabels[n] = AbstractShelfLayout.formatLabel(new JLabel(SMR_LABELS[n], 2));
        }
        for (n = 0; n < SMR2_LABELS.length; ++n) {
            OpticsCardView.SMR2Labels[n] = AbstractShelfLayout.formatLabel(new JLabel(SMR2_LABELS[n], 2));
        }
        for (n = 0; n < AD4_LABELS.length; ++n) {
            OpticsCardView.AD4Labels[n] = AbstractShelfLayout.formatLabel(new JLabel(AD4_LABELS[n], 2));
        }
        for (n = 0; n < AD4B_LABELS.length; ++n) {
            OpticsCardView.AD4BLabels[n] = AbstractShelfLayout.formatLabel(new JLabel(AD4B_LABELS[n], 2));
        }
        for (n = 0; n < AD2_LABELS.length; ++n) {
            OpticsCardView.AD2Labels[n] = AbstractShelfLayout.formatLabel(new JLabel(AD2_LABELS[n], 2));
        }
        for (n = 0; n < AD1_LABELS.length; ++n) {
            OpticsCardView.AD1Labels[n] = AbstractShelfLayout.formatLabel(new JLabel(AD1_LABELS[n], 2));
        }
        for (n = 0; n < AD1B_LABELS.length; ++n) {
            OpticsCardView.AD1BLabels[n] = AbstractShelfLayout.formatLabel(new JLabel(AD1B_LABELS[n], 2));
        }
        for (n = 0; n < OPT_PRE_LABELS.length; ++n) {
            OpticsCardView.OPTPRELabels[n] = AbstractShelfLayout.formatLabel(new JLabel(OPT_PRE_LABELS[n], 2));
        }
        for (n = 0; n < OPT_BST_LABELS.length; ++n) {
            OpticsCardView.OPTBSTLabels[n] = AbstractShelfLayout.formatLabel(new JLabel(OPT_BST_LABELS[n], 2));
        }
        for (n = 0; n < OPT_AMP_L_LABELS.length; ++n) {
            OpticsCardView.OPTAMPLLabels[n] = AbstractShelfLayout.formatLabel(new JLabel(OPT_AMP_L_LABELS[n], 2));
        }
        for (n = 0; n < OPT_AMP_17_C_LABELS.length; ++n) {
            OpticsCardView.OPTAMP17CLabels[n] = AbstractShelfLayout.formatLabel(new JLabel(OPT_AMP_17_C_LABELS[n], 2));
        }
        for (n = 0; n < OPT_AMP_23_C_LABELS.length; ++n) {
            OpticsCardView.OPTAMP23CLabels[n] = AbstractShelfLayout.formatLabel(new JLabel(OPT_AMP_23_C_LABELS[n], 2));
        }
        for (n = 0; n < OPT_AMP_C_LABELS.length; ++n) {
            OpticsCardView.OPTAMPCLabels[n] = AbstractShelfLayout.formatLabel(new JLabel(OPT_AMP_C_LABELS[n], 2));
        }
        for (n = 0; n < MD_4_LABELS.length; ++n) {
            OpticsCardView.MD4Labels[n] = AbstractShelfLayout.formatLabel(new JLabel(MD_4_LABELS[n], 2));
        }
        for (n = 0; n < MMU_LABELS.length; ++n) {
            OpticsCardView.MMULabels[n] = AbstractShelfLayout.formatLabel(new JLabel(MMU_LABELS[n], 2));
        }
        for (n = 0; n < PSM_LABELS.length; ++n) {
            OpticsCardView.PSMLabels[n] = AbstractShelfLayout.formatLabel(new JLabel(PSM_LABELS[n], 2));
        }
        for (n = 0; n < OPT_AMP_RAMAN_LABELS.length; ++n) {
            OpticsCardView.RAMANLabels[n] = AbstractShelfLayout.formatLabel(new JLabel(OPT_AMP_RAMAN_LABELS[n], 2));
        }
        for (n = 0; n < DCU_LABELS.length; ++n) {
            OpticsCardView.DCULabels[n] = AbstractShelfLayout.formatLabel(new JLabel(DCU_LABELS[n], 2));
        }
        MMU_PORT_MODEL_ARRAY = new int[]{2, 3, 4, 5, 0, 1};
        AMP_C_L_PORT_MODEL_ARRAY = new int[]{0, 1, 4, 5, 6, 7, 2, 3};
    }
}

