/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.ui.shelf.AreaAddressAttributePane;
import cerent.cms.ui.shelf.OsiRouterEditPane;
import cerent.cms.ui.shelf.SppOsiMainPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class OsiAreaAddressDialog
extends JDialog
implements ActionListener {
    private static String title = " Manual Area Address";
    private boolean isAdd = false;
    private JPanel parentPane;
    private JButton okButton;
    private JButton cancelButton;
    AreaAddressAttributePane attributePane;

    protected OsiAreaAddressDialog(JPanel jPanel, boolean bl) {
        super(JOptionPane.getFrameForComponent(jPanel), bl ? "Add" + title : "Edit" + title, true);
        this.parentPane = jPanel;
        this.isAdd = bl;
        this.getContentPane().add((Component)this.createAttributesPanel(), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.setSize(new Dimension(470, 140));
        this.setLocationRelativeTo(JOptionPane.getFrameForComponent(jPanel));
    }

    protected void setAreaAddress(String string) {
        this.attributePane.setAreaAddress(string);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    protected void updateAreaAddr(String string) {
        try {
            if (this.isAdd) {
                ((OsiRouterEditPane)this.parentPane).doAdd(string);
            } else if (this.parentPane instanceof OsiRouterEditPane) {
                ((OsiRouterEditPane)this.parentPane).doEdit(string);
            } else {
                ((SppOsiMainPane)((Object)this.parentPane)).changePAA(string);
            }
        }
        catch (Exception exception) {
            ErrorMsg.displayError((Component)this, (EID)EMC.EID_INVALID_CONFIG_PARAM_1, (Object)exception.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            if (this.attributePane.onValidate()) {
                this.attributePane.applyChanges();
                this.dispose();
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    private JPanel createAttributesPanel() {
        this.attributePane = new AreaAddressAttributePane(this);
        return this.attributePane;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }
}

